/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.cpptasks.os400;

import java.io.File;
import java.util.Vector;
import net.sf.antcontrib.cpptasks.CUtil;
import net.sf.antcontrib.cpptasks.compiler.AbstractCompiler;
import net.sf.antcontrib.cpptasks.compiler.CommandLineCCompiler;
import net.sf.antcontrib.cpptasks.compiler.LinkType;
import net.sf.antcontrib.cpptasks.compiler.Linker;
import net.sf.antcontrib.cpptasks.compiler.Processor;
import net.sf.antcontrib.cpptasks.os400.IccLinker;
import net.sf.antcontrib.cpptasks.os400.IccProcessor;
import org.apache.tools.ant.types.Environment;

public class IccCompiler
extends CommandLineCCompiler {
    private static final AbstractCompiler instance = new IccCompiler(false, null);

    public static AbstractCompiler getInstance() {
        return instance;
    }

    private IccCompiler(boolean newEnvironment, Environment env) {
        super("icc", null, new String[]{".c", ".cc", ".cpp", ".cxx", ".c++", ".s"}, new String[]{".h", ".hpp"}, ".o", false, null, newEnvironment, env);
    }

    protected void addImpliedArgs(Vector args, boolean debug, boolean multithreaded, boolean exceptions, LinkType linkType) {
        args.addElement("-c");
        if (debug) {
            args.addElement("-g");
        }
    }

    protected void addWarningSwitch(Vector args, int level) {
        IccProcessor.addWarningSwitch(args, level);
    }

    public Processor changeEnvironment(boolean newEnvironment, Environment env) {
        if (newEnvironment || env != null) {
            return new IccCompiler(newEnvironment, env);
        }
        return this;
    }

    protected void getDefineSwitch(StringBuffer buffer, String define, String value) {
        buffer.append("-q");
        buffer.append(define);
        if (value != null && value.length() > 0) {
            buffer.append('=');
            buffer.append(value);
        }
    }

    protected File[] getEnvironmentIncludePath() {
        return CUtil.getPathFromEnvironment("INCLUDE", ":");
    }

    protected String getIncludeDirSwitch(String includeDir) {
        return IccProcessor.getIncludeDirSwitch(includeDir);
    }

    public Linker getLinker(LinkType type) {
        return IccLinker.getInstance().getLinker(type);
    }

    public int getMaximumCommandLength() {
        return Integer.MAX_VALUE;
    }

    protected int getMaximumInputFilesPerCommand() {
        return 1;
    }

    protected void getUndefineSwitch(StringBuffer buffer, String define) {
    }
}

