/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.cpptasks.os400;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Vector;
import net.sf.antcontrib.cpptasks.CCTask;
import net.sf.antcontrib.cpptasks.CUtil;
import net.sf.antcontrib.cpptasks.compiler.CommandLineLinker;
import net.sf.antcontrib.cpptasks.compiler.CommandLineLinkerConfiguration;
import net.sf.antcontrib.cpptasks.compiler.LinkType;
import net.sf.antcontrib.cpptasks.compiler.Linker;
import net.sf.antcontrib.cpptasks.os400.IccProcessor;
import net.sf.antcontrib.cpptasks.types.LibrarySet;
import org.apache.tools.ant.BuildException;

public final class IccLinker
extends CommandLineLinker {
    private static final IccLinker datasetLinker = new IccLinker();
    private static final IccLinker dllLinker = new IccLinker("", ".dll");
    private static final IccLinker instance = new IccLinker("", "");
    private boolean isADatasetLinker;
    File outputFile;
    private String outputPrefix;
    CCTask task;

    public static IccLinker getDataSetInstance() {
        return datasetLinker;
    }

    public static IccLinker getInstance() {
        return instance;
    }

    private IccLinker() {
        super("icc", "/bogus", new String[]{".o", ".a", ".lib", ".xds"}, new String[]{".dll", ".x"}, ".xds", false, null);
        this.outputPrefix = "";
        this.isADatasetLinker = true;
    }

    private IccLinker(String outputPrefix, String outputSuffix) {
        super("icc", "/bogus", new String[]{".o", ".a", ".lib", ".x"}, new String[]{".dll"}, outputSuffix, false, null);
        this.outputPrefix = outputPrefix;
        this.isADatasetLinker = false;
    }

    protected void addBase(long base, Vector args) {
    }

    protected void addFixed(Boolean fixed, Vector args) {
    }

    protected void addImpliedArgs(boolean debug, LinkType linkType, Vector args) {
        if (linkType.isSharedLibrary()) {
            args.addElement("-W");
            args.addElement("l,DLL");
        }
    }

    protected void addIncremental(boolean incremental, Vector args) {
    }

    protected String[] addLibrarySets(CCTask task, LibrarySet[] libsets, Vector preargs, Vector midargs, Vector endargs) {
        if (libsets != null) {
            for (int i = 0; i < libsets.length; ++i) {
                String[] libs = libsets[i].getLibs();
                for (int j = 0; j < libs.length; ++j) {
                    if (libs[j].startsWith("//")) {
                        endargs.addElement("-l");
                        endargs.addElement(libs[j]);
                        continue;
                    }
                    if (libsets[i].getDataset() == null) continue;
                    String ds = libsets[i].getDataset();
                    endargs.addElement("//'" + ds + "(" + libs[j] + ")'");
                }
            }
        }
        return super.addLibrarySets(task, libsets, preargs, midargs, endargs);
    }

    protected void addMap(boolean map, Vector args) {
    }

    protected void addStack(int stack, Vector args) {
    }

    public String getCommandFileSwitch(String commandFile) {
        return "@" + commandFile;
    }

    public File[] getLibraryPath() {
        return CUtil.getPathFromEnvironment("LIB", ";");
    }

    public String[] getLibraryPatterns(String[] libnames) {
        return IccProcessor.getLibraryPatterns(libnames);
    }

    public Linker getLinker(LinkType linkType) {
        if (this == datasetLinker) {
            return datasetLinker;
        }
        if (linkType.isSharedLibrary()) {
            return dllLinker;
        }
        return instance;
    }

    public int getMaximumCommandLength() {
        return Integer.MAX_VALUE;
    }

    protected String[] getOutputFileSwitch(CCTask task, String outputFile) {
        if (this.isADatasetLinker && task.getDataset() != null) {
            String ds = task.getDataset();
            outputFile = "//'" + ds + "(" + outputFile + ")'";
        }
        return this.getOutputFileSwitch(outputFile);
    }

    public String[] getOutputFileSwitch(String outputFile) {
        return new String[]{"-o", outputFile};
    }

    public boolean isCaseSensitive() {
        return IccProcessor.isCaseSensitive();
    }

    public void link(CCTask task, File outputFile, String[] sourceFiles, CommandLineLinkerConfiguration config) throws BuildException {
        int p;
        this.task = task;
        this.outputFile = outputFile;
        if (this.isADatasetLinker && (p = outputFile.getName().indexOf(".")) >= 0) {
            String newname = outputFile.getName().substring(0, p);
            outputFile = new File(outputFile.getParent(), newname);
        }
        super.link(task, outputFile, sourceFiles, config);
    }

    protected int runCommand(CCTask task, File workingDir, String[] cmdline) throws BuildException {
        int rc = super.runCommand(task, workingDir, cmdline);
        if (rc == 0) {
            try {
                this.outputFile.delete();
                new FileOutputStream(this.outputFile).close();
            }
            catch (IOException e) {
                throw new BuildException(e.getMessage());
            }
        }
        return rc;
    }

    public String xgetOutputFileName(String baseName) {
        return this.outputPrefix + super.getOutputFileName(baseName);
    }
}

