/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.cpptasks.ti;

import java.io.File;
import java.util.Vector;
import net.sf.antcontrib.cpptasks.CUtil;
import net.sf.antcontrib.cpptasks.compiler.CommandLineCCompiler;
import net.sf.antcontrib.cpptasks.compiler.LinkType;
import net.sf.antcontrib.cpptasks.compiler.Linker;
import net.sf.antcontrib.cpptasks.ti.ClxxLibrarian;
import net.sf.antcontrib.cpptasks.ti.ClxxLinker;
import org.apache.tools.ant.types.Environment;

public class ClxxCCompiler
extends CommandLineCCompiler {
    private static final String[] headerExtensions = new String[]{".h", ".hpp", ".inl"};
    private static final String[] sourceExtensions = new String[]{".c", ".cc", ".cpp", ".cxx", ".c++"};
    private static final ClxxCCompiler cl55 = new ClxxCCompiler("cl55", false, null);
    private static final ClxxCCompiler cl6x = new ClxxCCompiler("cl6x", false, null);

    public static ClxxCCompiler getCl55Instance() {
        return cl55;
    }

    public static ClxxCCompiler getCl6xInstance() {
        return cl6x;
    }

    private ClxxCCompiler(String command, boolean newEnvironment, Environment env) {
        super(command, "-h", sourceExtensions, headerExtensions, ".o", false, null, newEnvironment, env);
    }

    protected void addImpliedArgs(Vector args, boolean debug, boolean multithreaded, boolean exceptions, LinkType linkType) {
        if (debug) {
            args.addElement("-gw");
        }
    }

    protected void addWarningSwitch(Vector args, int warnings) {
    }

    protected void getDefineSwitch(StringBuffer buffer, String define, String value) {
        buffer.append("-d");
        buffer.append(define);
        if (value != null) {
            buffer.append('=');
            buffer.append(value);
        }
    }

    protected File[] getEnvironmentIncludePath() {
        int i;
        File[] c_dir = CUtil.getPathFromEnvironment("C_DIR", ";");
        File[] cx_dir = CUtil.getPathFromEnvironment("C6X_C_DIR", ";");
        if (c_dir.length == 0) {
            return cx_dir;
        }
        if (cx_dir.length == 0) {
            return c_dir;
        }
        File[] combo = new File[c_dir.length + cx_dir.length];
        for (i = 0; i < cx_dir.length; ++i) {
            combo[i] = cx_dir[i];
        }
        for (i = 0; i < c_dir.length; ++i) {
            combo[i + cx_dir.length] = c_dir[i];
        }
        return combo;
    }

    protected String getIncludeDirSwitch(String source) {
        return "-I" + source;
    }

    public Linker getLinker(LinkType type) {
        if (type.isStaticLibrary()) {
            if (this == cl6x) {
                return ClxxLibrarian.getCl6xInstance();
            }
            return ClxxLibrarian.getCl55Instance();
        }
        if (type.isSharedLibrary()) {
            if (this == cl6x) {
                return ClxxLinker.getCl6xDllInstance();
            }
            return ClxxLinker.getCl55DllInstance();
        }
        if (this == cl6x) {
            return ClxxLinker.getCl6xInstance();
        }
        return ClxxLinker.getCl55Instance();
    }

    public int getMaximumCommandLength() {
        return 1024;
    }

    protected void getUndefineSwitch(StringBuffer buffer, String define) {
        buffer.append("-u");
        buffer.append(define);
    }
}

