/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.cpptasks.types;

import java.io.File;
import net.sf.antcontrib.cpptasks.CUtil;
import net.sf.antcontrib.cpptasks.FileVisitor;
import net.sf.antcontrib.cpptasks.compiler.Linker;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.PatternSet;

public class LibrarySet
extends ProjectComponent {
    private String dataset;
    private boolean explicitCaseSensitive;
    private String ifCond;
    private String[] libnames;
    private final FileSet set = new FileSet();
    private String unlessCond;

    public LibrarySet() {
        this.libnames = new String[0];
    }

    public void execute() throws BuildException {
        throw new BuildException("Not an actual task, but looks like one for documentation purposes");
    }

    public String getDataset() {
        return this.dataset;
    }

    public File getDir(Project project) {
        return this.set.getDir(project);
    }

    protected FileSet getFileSet() {
        return this.set;
    }

    public String[] getLibs() {
        String[] retval = (String[])this.libnames.clone();
        return retval;
    }

    public boolean isActive(Project p) {
        String unlessValue;
        if (p == null) {
            throw new NullPointerException("p");
        }
        if (this.ifCond != null) {
            String ifValue = p.getProperty(this.ifCond);
            if (ifValue != null) {
                if (ifValue.equals("no") || ifValue.equals("false")) {
                    throw new BuildException("property " + this.ifCond + " used as if condition has value " + ifValue + " which suggests a misunderstanding of if attributes");
                }
            } else {
                return false;
            }
        }
        if (this.unlessCond != null && (unlessValue = p.getProperty(this.unlessCond)) != null) {
            if (unlessValue.equals("no") || unlessValue.equals("false")) {
                throw new BuildException("property " + this.unlessCond + " used as unless condition has value " + unlessValue + " which suggests a misunderstanding of unless attributes");
            }
            return false;
        }
        if (this.libnames.length == 0) {
            p.log("libnames not specified or empty.", 1);
            return false;
        }
        return true;
    }

    public void setCaseSensitive(boolean isCaseSensitive) {
        this.explicitCaseSensitive = true;
        this.set.setCaseSensitive(isCaseSensitive);
    }

    public void setDataset(String dataset) {
        this.dataset = dataset;
    }

    public void setDir(File dir) throws BuildException {
        this.set.setDir(dir);
    }

    public void setIf(String propName) {
        this.ifCond = propName;
    }

    public void setLibs(CUtil.StringArrayBuilder libs) throws BuildException {
        this.libnames = libs.getValue();
        if (!this.isActive(this.getProject())) {
            return;
        }
        for (int i = 0; i < this.libnames.length; ++i) {
            String extension;
            int lastDot = this.libnames[i].lastIndexOf(46);
            if (lastDot >= 0 && ((extension = this.libnames[i].substring(lastDot)).equalsIgnoreCase(".lib") || extension.equalsIgnoreCase(".so") || extension.equalsIgnoreCase(".a"))) {
                this.getProject().log("Suspicious library name ending with \"" + extension + "\": " + this.libnames[i]);
            }
            if (this.libnames[i].length() < 3 || !this.libnames[i].substring(0, 3).equalsIgnoreCase("lib")) continue;
            this.getProject().log("Suspicious library name starting with \"lib\": " + this.libnames[i]);
        }
    }

    public void setProject(Project project) {
        this.set.setProject(project);
        super.setProject(project);
    }

    public void setUnless(String propName) {
        this.unlessCond = propName;
    }

    public void visitLibraries(Project project, Linker linker, File[] libpath, FileVisitor visitor) throws BuildException {
        FileSet localSet = (FileSet)this.set.clone();
        if (!this.explicitCaseSensitive) {
            boolean linkerCaseSensitive = linker.isCaseSensitive();
            localSet.setCaseSensitive(linkerCaseSensitive);
        }
        if (this.libnames != null && this.libnames.length > 0) {
            String[] patterns = linker.getLibraryPatterns(this.libnames);
            for (int i = 0; i < patterns.length; ++i) {
                PatternSet.NameEntry entry = localSet.createInclude();
                entry.setName(patterns[i]);
            }
        }
        if (localSet.getDir(project) == null) {
            for (int j = libpath.length - 1; j >= 0; --j) {
                FileSet clone = (FileSet)localSet.clone();
                clone.setDir(libpath[j]);
                DirectoryScanner scanner = clone.getDirectoryScanner(project);
                File basedir = scanner.getBasedir();
                String[] files = scanner.getIncludedFiles();
                for (int k = 0; k < files.length; ++k) {
                    visitor.visit(basedir, files[k]);
                }
            }
        } else {
            DirectoryScanner scanner = localSet.getDirectoryScanner(project);
            File basedir = scanner.getBasedir();
            String[] files = scanner.getIncludedFiles();
            for (int k = 0; k < files.length; ++k) {
                visitor.visit(basedir, files[k]);
            }
        }
    }
}

