/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crimson.jaxp;

import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.crimson.jaxp.DefaultValidationErrorHandler;
import org.apache.crimson.parser.XMLReaderImpl;
import org.apache.crimson.tree.XmlDocument;
import org.apache.crimson.tree.XmlDocumentBuilder;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class DocumentBuilderImpl
extends DocumentBuilder {
    private DocumentBuilderFactory dbf;
    private EntityResolver er = null;
    private ErrorHandler eh = null;
    private XMLReader xmlReader = null;
    private XmlDocumentBuilder builder = null;
    private boolean namespaceAware = false;
    private boolean validating = false;

    DocumentBuilderImpl(DocumentBuilderFactory documentBuilderFactory) throws ParserConfigurationException {
        this.dbf = documentBuilderFactory;
        this.xmlReader = new XMLReaderImpl();
        try {
            this.validating = documentBuilderFactory.isValidating();
            String string = "http://xml.org/sax/features/validation";
            this.xmlReader.setFeature(string, this.validating);
            if (this.validating) {
                this.xmlReader.setErrorHandler(new DefaultValidationErrorHandler());
            }
            String string2 = "http://xml.org/sax/features/namespaces";
            this.xmlReader.setFeature(string2, true);
            String string3 = "http://xml.org/sax/features/namespace-prefixes";
            this.xmlReader.setFeature(string3, true);
            this.builder = new XmlDocumentBuilder();
            this.xmlReader.setContentHandler(this.builder);
            String string4 = "http://xml.org/sax/properties/lexical-handler";
            this.xmlReader.setProperty(string4, this.builder);
            String string5 = "http://xml.org/sax/properties/declaration-handler";
            this.xmlReader.setProperty(string5, this.builder);
            this.xmlReader.setDTDHandler(this.builder);
        }
        catch (SAXException sAXException) {
            throw new ParserConfigurationException(sAXException.getMessage());
        }
        this.namespaceAware = documentBuilderFactory.isNamespaceAware();
        this.builder.setDisableNamespaces(!this.namespaceAware);
        this.builder.setIgnoreWhitespace(documentBuilderFactory.isIgnoringElementContentWhitespace());
        this.builder.setExpandEntityReferences(documentBuilderFactory.isExpandEntityReferences());
        this.builder.setIgnoreComments(documentBuilderFactory.isIgnoringComments());
        this.builder.setPutCDATAIntoText(documentBuilderFactory.isCoalescing());
    }

    public Document newDocument() {
        return new XmlDocument();
    }

    public Document parse(InputSource inputSource) throws SAXException, IOException {
        if (inputSource == null) {
            throw new IllegalArgumentException("InputSource cannot be null");
        }
        if (this.er != null) {
            this.xmlReader.setEntityResolver(this.er);
        }
        if (this.eh != null) {
            this.xmlReader.setErrorHandler(this.eh);
        }
        this.xmlReader.parse(inputSource);
        return this.builder.getDocument();
    }

    public boolean isNamespaceAware() {
        return this.namespaceAware;
    }

    public boolean isValidating() {
        return this.validating;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.er = entityResolver;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.eh = errorHandler;
    }
}

