/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crimson.jaxp;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.crimson.jaxp.DefaultValidationErrorHandler;
import org.apache.crimson.parser.XMLReaderImpl;
import org.xml.sax.HandlerBase;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderAdapter;

public class SAXParserImpl
extends SAXParser {
    private SAXParserFactory spf = null;
    private XMLReader xmlReader;
    private Parser parser = null;
    private boolean validating = false;
    private boolean namespaceAware = false;

    SAXParserImpl(SAXParserFactory sAXParserFactory) throws SAXException, ParserConfigurationException {
        this.spf = sAXParserFactory;
        this.xmlReader = new XMLReaderImpl();
        try {
            this.validating = sAXParserFactory.isValidating();
            String string = "http://xml.org/sax/features/validation";
            this.xmlReader.setFeature(string, this.validating);
            if (this.validating) {
                this.xmlReader.setErrorHandler(new DefaultValidationErrorHandler());
            }
        }
        catch (SAXException sAXException) {
            throw new ParserConfigurationException(sAXException.getMessage());
        }
        if (sAXParserFactory.isNamespaceAware()) {
            this.namespaceAware = true;
        }
    }

    public Parser getParser() throws SAXException {
        if (this.parser == null) {
            this.parser = new XMLReaderAdapter(this.xmlReader);
            this.parser.setDocumentHandler(new HandlerBase());
        }
        return this.parser;
    }

    public XMLReader getXMLReader() throws SAXException {
        return this.xmlReader;
    }

    public boolean isNamespaceAware() {
        return this.namespaceAware;
    }

    public boolean isValidating() {
        return this.validating;
    }

    public void setProperty(String string, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        throw new SAXNotRecognizedException("Feature: " + string);
    }

    public Object getProperty(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        throw new SAXNotRecognizedException("Feature: " + string);
    }
}

