/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crimson.parser;

import java.io.IOException;
import org.apache.crimson.parser.Parser2;
import org.apache.crimson.parser.ValidatingParser;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;

public class XMLReaderImpl
implements XMLReader {
    private static final String FEATURES = "http://xml.org/sax/features/";
    private static final String NAMESPACES = "http://xml.org/sax/features/namespaces";
    private static final String NAMESPACE_PREFIXES = "http://xml.org/sax/features/namespace-prefixes";
    private static final String VALIDATION = "http://xml.org/sax/features/validation";
    private static final String EXTERNAL_GENERAL = "http://xml.org/sax/features/external-general-entities";
    private static final String EXTERNAL_PARAMETER = "http://xml.org/sax/features/external-parameter-entities";
    private static final String LEXICAL_PARAMETER_ENTITIES = "http://xml.org/sax/features/lexical-handler/parameter-entities";
    private static final String PROPERTIES = "http://xml.org/sax/properties/";
    private static final String LEXICAL_HANDLER = "http://xml.org/sax/properties/lexical-handler";
    private static final String DECLARATION_HANDLER = "http://xml.org/sax/properties/declaration-handler";
    private boolean namespaces = true;
    private boolean prefixes = false;
    private boolean validation = false;
    private LexicalHandler lexicalHandler;
    private DeclHandler declHandler;
    private ContentHandler contentHandler;
    private DTDHandler dtdHandler;
    private ErrorHandler errorHandler;
    private EntityResolver entityResolver;
    private Parser2 parser;
    private boolean parsing;

    public boolean getFeature(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string.equals(NAMESPACES)) {
            return this.namespaces;
        }
        if (string.equals(NAMESPACE_PREFIXES)) {
            return this.prefixes;
        }
        if (string.equals(VALIDATION)) {
            return this.validation;
        }
        if (string.equals(EXTERNAL_GENERAL) || string.equals(EXTERNAL_PARAMETER)) {
            return true;
        }
        if (string.equals(LEXICAL_PARAMETER_ENTITIES)) {
            return false;
        }
        throw new SAXNotRecognizedException("Feature: " + string);
    }

    public void setFeature(String string, boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string.equals(NAMESPACES)) {
            this.checkNotParsing("feature", string);
            this.namespaces = bl;
            if (!this.namespaces && !this.prefixes) {
                this.prefixes = true;
            }
        } else if (string.equals(NAMESPACE_PREFIXES)) {
            this.checkNotParsing("feature", string);
            this.prefixes = bl;
            if (!this.prefixes && !this.namespaces) {
                this.namespaces = true;
            }
        } else if (string.equals(VALIDATION)) {
            this.checkNotParsing("feature", string);
            if (this.validation != bl) {
                this.parser = null;
            }
            this.validation = bl;
        } else {
            if (string.equals(EXTERNAL_GENERAL) || string.equals(EXTERNAL_PARAMETER) || string.equals(LEXICAL_PARAMETER_ENTITIES)) {
                throw new SAXNotSupportedException("Feature: " + string);
            }
            throw new SAXNotRecognizedException("Feature: " + string);
        }
    }

    public Object getProperty(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string.equals(LEXICAL_HANDLER)) {
            return this.lexicalHandler;
        }
        if (string.equals(DECLARATION_HANDLER)) {
            return this.declHandler;
        }
        throw new SAXNotRecognizedException("Property: " + string);
    }

    public void setProperty(String string, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        String string2 = "Property: " + string;
        if (string.equals(LEXICAL_HANDLER)) {
            if (!(object instanceof LexicalHandler)) {
                throw new SAXNotSupportedException(string2);
            }
            this.lexicalHandler = (LexicalHandler)object;
        } else if (string.equals(DECLARATION_HANDLER)) {
            if (!(object instanceof DeclHandler)) {
                throw new SAXNotSupportedException(string2);
            }
            this.declHandler = (DeclHandler)object;
        } else {
            throw new SAXNotRecognizedException("Property: " + string);
        }
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        if (entityResolver == null) {
            throw new NullPointerException("Null entity resolver");
        }
        this.entityResolver = entityResolver;
        if (this.parser != null) {
            this.parser.setEntityResolver(entityResolver);
        }
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public void setDTDHandler(DTDHandler dTDHandler) {
        if (dTDHandler == null) {
            throw new NullPointerException("Null DTD handler");
        }
        this.dtdHandler = dTDHandler;
        if (this.parser != null) {
            this.parser.setDTDHandler(this.dtdHandler);
        }
    }

    public DTDHandler getDTDHandler() {
        return this.dtdHandler;
    }

    public void setContentHandler(ContentHandler contentHandler) {
        if (contentHandler == null) {
            throw new NullPointerException("Null content handler");
        }
        this.contentHandler = contentHandler;
        if (this.parser != null) {
            this.parser.setContentHandler(contentHandler);
        }
    }

    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        if (errorHandler == null) {
            throw new NullPointerException("Null error handler");
        }
        this.errorHandler = errorHandler;
        if (this.parser != null) {
            this.parser.setErrorHandler(this.errorHandler);
        }
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void parse(String string) throws IOException, SAXException {
        this.parse(new InputSource(string));
    }

    public void parse(InputSource inputSource) throws IOException, SAXException {
        if (this.parsing) {
            throw new SAXException("Parser is already in use");
        }
        this.parsing = true;
        if (this.parser == null) {
            this.parser = this.validation ? new ValidatingParser() : new Parser2();
        }
        this.parser.setNamespaceFeatures(this.namespaces, this.prefixes);
        this.parser.setContentHandler(this.contentHandler);
        this.parser.setDTDHandler(this.dtdHandler);
        this.parser.setErrorHandler(this.errorHandler);
        this.parser.setEntityResolver(this.entityResolver);
        this.parser.setLexicalHandler(this.lexicalHandler);
        this.parser.setDeclHandler(this.declHandler);
        try {
            this.parser.parse(inputSource);
            Object var3_2 = null;
            this.parsing = false;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.parsing = false;
            throw throwable;
        }
    }

    private void checkNotParsing(String string, String string2) throws SAXNotSupportedException {
        if (this.parsing) {
            throw new SAXNotSupportedException("Cannot change " + string + ' ' + string2 + " while parsing");
        }
    }
}

