/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crimson.tree;

import java.io.IOException;
import java.io.Writer;
import org.apache.crimson.tree.DomEx;
import org.apache.crimson.tree.ElementNode;
import org.apache.crimson.tree.NamespacedNode;
import org.apache.crimson.tree.XmlDocument;
import org.apache.crimson.tree.XmlWriteContext;
import org.apache.crimson.util.XmlNames;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

final class AttributeNode
extends NamespacedNode
implements Attr {
    private String value;
    private boolean specified;
    private String defaultValue;
    private Element ownerElement;
    private static final String SPEC_XML_URI = "http://www.w3.org/XML/1998/namespace";
    private static final String SPEC_XMLNS_URI = "http://www.w3.org/XML/2000/xmlns/";

    public AttributeNode(String string, String string2, boolean bl, String string3) throws DOMException {
        if (!XmlNames.isName(string)) {
            throw new DomEx(5);
        }
        this.name = string;
        this.value = string2;
        this.specified = bl;
        this.defaultValue = string3;
    }

    public AttributeNode(String string, String string2, String string3, boolean bl, String string4) throws DOMException {
        this.name = string2;
        this.namespaceURI = string;
        this.value = string3;
        this.specified = bl;
        this.defaultValue = string4;
    }

    static void checkArguments(String string, String string2) throws DomEx {
        if (string2 == null) {
            throw new DomEx(14);
        }
        int n = string2.indexOf(58);
        if (n <= 0) {
            if (!XmlNames.isUnqualifiedName(string2)) {
                throw new DomEx(5);
            }
            return;
        }
        int n2 = string2.lastIndexOf(58);
        if (n2 != n) {
            throw new DomEx(14);
        }
        String string3 = string2.substring(0, n);
        String string4 = string2.substring(n + 1);
        if (!XmlNames.isUnqualifiedName(string3) || !XmlNames.isUnqualifiedName(string4)) {
            throw new DomEx(5);
        }
        if (string == null || "".equals(string) || "xml".equals(string3) && !string.equals(SPEC_XML_URI) || "xmlns".equals(string3) && !string.equals(SPEC_XMLNS_URI)) {
            throw new DomEx(14);
        }
    }

    String getDefaultValue() {
        return this.defaultValue;
    }

    public Element getOwnerElement() {
        return this.ownerElement;
    }

    void setOwnerElement(ElementNode elementNode) {
        if (elementNode != null && this.ownerElement != null) {
            throw new IllegalStateException(this.getMessage("A-000", new Object[]{elementNode.getTagName()}));
        }
        this.ownerElement = elementNode;
    }

    public short getNodeType() {
        return 2;
    }

    public String getName() {
        return this.name;
    }

    public String getNodeName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String string) {
        this.setNodeValue(string);
    }

    public String getNodeValue() {
        return this.value;
    }

    public boolean getSpecified() {
        return this.specified;
    }

    public void setNodeValue(String string) {
        if (this.isReadonly()) {
            throw new DomEx(7);
        }
        this.value = string;
        this.specified = true;
    }

    void setSpecified(boolean bl) {
        this.specified = bl;
    }

    public Node getParentNode() {
        return null;
    }

    public Node getNextSibling() {
        return null;
    }

    public Node getPreviousSibling() {
        return null;
    }

    public void writeXml(XmlWriteContext xmlWriteContext) throws IOException {
        Writer writer = xmlWriteContext.getWriter();
        writer.write(this.name);
        writer.write("=\"");
        this.writeChildrenXml(xmlWriteContext);
        writer.write(34);
    }

    public void writeChildrenXml(XmlWriteContext xmlWriteContext) throws IOException {
        Writer writer = xmlWriteContext.getWriter();
        int n = 0;
        while (n < this.value.length()) {
            char c = this.value.charAt(n);
            switch (c) {
                case '<': {
                    writer.write("&lt;");
                    break;
                }
                case '>': {
                    writer.write("&gt;");
                    break;
                }
                case '&': {
                    writer.write("&amp;");
                    break;
                }
                case '\'': {
                    writer.write("&apos;");
                    break;
                }
                case '\"': {
                    writer.write("&quot;");
                    break;
                }
                default: {
                    writer.write(c);
                }
            }
            ++n;
        }
    }

    public Node cloneNode(boolean bl) {
        AttributeNode attributeNode = this.cloneAttributeNode(bl);
        attributeNode.specified = true;
        return attributeNode;
    }

    AttributeNode cloneAttributeNode(boolean bl) {
        try {
            AttributeNode attributeNode = new AttributeNode(this.name, this.value, this.specified, this.defaultValue);
            attributeNode.ownerElement = this.ownerElement;
            attributeNode.setOwnerDocument((XmlDocument)this.getOwnerDocument());
            if (bl) {
                Node node;
                int n = 0;
                while ((node = this.item(n)) != null) {
                    node = node.cloneNode(true);
                    attributeNode.appendChild(node);
                    ++n;
                }
            }
            return attributeNode;
        }
        catch (DOMException dOMException) {
            throw new RuntimeException(this.getMessage("A-002"));
        }
    }

    void checkChildType(int n) throws DOMException {
        switch (n) {
            case 3: 
            case 5: {
                return;
            }
        }
        throw new DomEx(3);
    }
}

