/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crimson.tree;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Vector;
import org.apache.crimson.parser.AttributeListEx;
import org.apache.crimson.tree.AttributeNode;
import org.apache.crimson.tree.DomEx;
import org.apache.crimson.tree.ElementNode;
import org.apache.crimson.tree.NodeBase;
import org.apache.crimson.tree.XmlWritable;
import org.apache.crimson.tree.XmlWriteContext;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;

final class AttributeSet
implements NamedNodeMap,
XmlWritable {
    private boolean readonly;
    private Vector list;
    private ElementNode ownerElement;

    AttributeSet(ElementNode elementNode) {
        this.list = new Vector(5);
        this.ownerElement = elementNode;
    }

    AttributeSet(AttributeSet attributeSet, boolean bl) {
        int n = attributeSet.getLength();
        this.list = new Vector(n);
        int n2 = 0;
        while (n2 < n) {
            Node node = attributeSet.item(n2);
            if (!(node instanceof AttributeNode)) {
                throw new IllegalArgumentException(((NodeBase)node).getMessage("A-003"));
            }
            AttributeNode attributeNode = (AttributeNode)node;
            node = attributeNode.cloneAttributeNode(bl);
            attributeNode.setOwnerElement(null);
            this.list.addElement(node);
            ++n2;
        }
    }

    AttributeSet(Attributes attributes) throws DOMException {
        int n = attributes.getLength();
        AttributeListEx attributeListEx = null;
        this.list = new Vector(n);
        if (attributes instanceof AttributeListEx) {
            attributeListEx = (AttributeListEx)((Object)attributes);
        }
        int n2 = 0;
        while (n2 < n) {
            String string = attributes.getURI(n2);
            if (string.equals("")) {
                string = null;
            }
            AttributeNode attributeNode = new AttributeNode(string, attributes.getQName(n2), attributes.getValue(n2), attributeListEx == null ? true : attributeListEx.isSpecified(n2), attributeListEx == null ? null : attributeListEx.getDefault(n2));
            this.list.addElement(attributeNode);
            ++n2;
        }
        this.list.trimToSize();
    }

    void trimToSize() {
        this.list.trimToSize();
    }

    public void setReadonly() {
        this.readonly = true;
        int n = 0;
        while (n < this.list.size()) {
            ((AttributeNode)this.list.elementAt(n)).setReadonly(true);
            ++n;
        }
    }

    public boolean isReadonly() {
        if (this.readonly) {
            return true;
        }
        int n = 0;
        while (n < this.list.size()) {
            if (((AttributeNode)this.list.elementAt(n)).isReadonly()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    void setOwnerElement(ElementNode elementNode) {
        if (elementNode != null && this.ownerElement != null) {
            throw new IllegalStateException(elementNode.getMessage("A-004"));
        }
        this.ownerElement = elementNode;
        int n = this.list.size();
        int n2 = 0;
        while (n2 < n) {
            AttributeNode attributeNode = (AttributeNode)this.list.elementAt(n2);
            attributeNode.setOwnerElement(null);
            attributeNode.setOwnerElement(elementNode);
            ++n2;
        }
    }

    String getValue(String string) {
        Attr attr = (Attr)this.getNamedItem(string);
        if (attr == null) {
            return "";
        }
        return attr.getValue();
    }

    public Node getNamedItem(String string) {
        int n = this.list.size();
        int n2 = 0;
        while (n2 < n) {
            Node node = this.item(n2);
            if (node.getNodeName().equals(string)) {
                return node;
            }
            ++n2;
        }
        return null;
    }

    public Node getNamedItemNS(String string, String string2) {
        int n = 0;
        while (n < this.list.size()) {
            String string3;
            Node node = this.item(n);
            String string4 = node.getLocalName();
            if (string4 != null && string4.equals(string2) && (string3 = node.getNamespaceURI()) != null && string3.equals(string)) {
                return node;
            }
            ++n;
        }
        return null;
    }

    public int getLength() {
        return this.list.size();
    }

    public Node item(int n) {
        if (n < 0 || n >= this.list.size()) {
            return null;
        }
        return (Node)this.list.elementAt(n);
    }

    public Node removeNamedItem(String string) throws DOMException {
        if (this.readonly) {
            throw new DomEx(7);
        }
        int n = 0;
        while (n < this.list.size()) {
            Node node = (Node)this.list.elementAt(n);
            if (node.getNodeName().equals(string)) {
                AttributeNode attributeNode = (AttributeNode)node;
                String string2 = attributeNode.getDefaultValue();
                if (string2 != null) {
                    attributeNode.setValue(string2);
                    attributeNode.setSpecified(false);
                } else {
                    this.list.removeElementAt(n);
                }
                return node;
            }
            ++n;
        }
        throw new DomEx(8);
    }

    public Node removeNamedItemNS(String string, String string2) throws DOMException {
        if (this.readonly) {
            throw new DomEx(7);
        }
        int n = 0;
        while (n < this.list.size()) {
            String string3;
            Node node = (Node)this.list.elementAt(n);
            String string4 = node.getLocalName();
            if (string4 != null && string4.equals(string2) && (string3 = node.getNamespaceURI()) != null && string3.equals(string)) {
                AttributeNode attributeNode = (AttributeNode)node;
                String string5 = attributeNode.getDefaultValue();
                if (string5 != null) {
                    attributeNode.setValue(string5);
                    attributeNode.setSpecified(false);
                } else {
                    this.list.removeElementAt(n);
                }
                return node;
            }
            ++n;
        }
        throw new DomEx(8);
    }

    public Node setNamedItem(Node node) throws DOMException {
        if (this.readonly) {
            throw new DomEx(7);
        }
        if (!(node instanceof AttributeNode) || node.getOwnerDocument() != this.ownerElement.getOwnerDocument()) {
            throw new DomEx(4);
        }
        AttributeNode attributeNode = (AttributeNode)node;
        if (attributeNode.getOwnerElement() != null) {
            throw new DomEx(10);
        }
        int n = this.list.size();
        int n2 = 0;
        while (n2 < n) {
            AttributeNode attributeNode2 = (AttributeNode)this.item(n2);
            if (attributeNode2.getNodeName().equals(node.getNodeName())) {
                if (attributeNode2.isReadonly()) {
                    throw new DomEx(7);
                }
                attributeNode.setOwnerElement(this.ownerElement);
                this.list.setElementAt(attributeNode, n2);
                attributeNode2.setOwnerElement(null);
                return attributeNode2;
            }
            ++n2;
        }
        attributeNode.setOwnerElement(this.ownerElement);
        this.list.addElement(node);
        return null;
    }

    public Node setNamedItemNS(Node node) throws DOMException {
        if (this.readonly) {
            throw new DomEx(7);
        }
        AttributeNode attributeNode = (AttributeNode)node;
        if (attributeNode.getOwnerElement() != null) {
            throw new DomEx(10);
        }
        int n = 0;
        while (n < this.list.size()) {
            AttributeNode attributeNode2 = (AttributeNode)this.item(n);
            String string = attributeNode2.getLocalName();
            String string2 = attributeNode2.getNamespaceURI();
            if (attributeNode.getLocalName().equals(string) && attributeNode.getNamespaceURI().equals(string2)) {
                this.list.setElementAt(attributeNode, n);
                return attributeNode2;
            }
            ++n;
        }
        this.list.addElement(attributeNode);
        return null;
    }

    public void writeXml(XmlWriteContext xmlWriteContext) throws IOException {
        Writer writer = xmlWriteContext.getWriter();
        int n = this.list.size();
        int n2 = 0;
        while (n2 < n) {
            AttributeNode attributeNode = (AttributeNode)this.list.elementAt(n2);
            if (attributeNode.getSpecified()) {
                writer.write(32);
                attributeNode.writeXml(xmlWriteContext);
            }
            ++n2;
        }
    }

    public void writeChildrenXml(XmlWriteContext xmlWriteContext) throws IOException {
    }

    public String toString() {
        try {
            CharArrayWriter charArrayWriter = new CharArrayWriter();
            XmlWriteContext xmlWriteContext = new XmlWriteContext(charArrayWriter);
            this.writeXml(xmlWriteContext);
            return charArrayWriter.toString();
        }
        catch (IOException iOException) {
            return super.toString();
        }
    }
}

