/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crimson.tree;

import java.io.IOException;
import java.io.Writer;
import java.util.Vector;
import org.apache.crimson.tree.DomEx;
import org.apache.crimson.tree.NodeBase;
import org.apache.crimson.tree.XmlDocument;
import org.apache.crimson.tree.XmlWriteContext;
import org.w3c.dom.DOMException;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Entity;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Notation;

final class Doctype
extends NodeBase
implements DocumentType {
    private String name;
    private Nodemap entities;
    private Nodemap notations;
    private String publicId;
    private String systemId;
    private String internalSubset;

    Doctype(String string) {
        this.name = string;
        this.entities = new Nodemap();
        this.notations = new Nodemap();
    }

    Doctype(String string, String string2, String string3) {
        this.publicId = string;
        this.systemId = string2;
        this.internalSubset = string3;
    }

    Doctype(String string, String string2, String string3, String string4) {
        this.name = string;
        this.publicId = string2;
        this.systemId = string3;
        this.internalSubset = string4;
        this.entities = new Nodemap();
        this.notations = new Nodemap();
    }

    void setPrintInfo(String string, String string2, String string3) {
        this.publicId = string;
        this.systemId = string2;
        this.internalSubset = string3;
    }

    public void writeXml(XmlWriteContext xmlWriteContext) throws IOException {
        Writer writer = xmlWriteContext.getWriter();
        Element element = this.getOwnerDocument().getDocumentElement();
        writer.write("<!DOCTYPE ");
        writer.write(element == null ? "UNKNOWN-ROOT" : element.getNodeName());
        if (this.systemId != null) {
            if (this.publicId != null) {
                writer.write(" PUBLIC '");
                writer.write(this.publicId);
                writer.write("' '");
            } else {
                writer.write(" SYSTEM '");
            }
            writer.write(this.systemId);
            writer.write("'");
        }
        if (this.internalSubset != null) {
            writer.write(XmlDocument.eol);
            writer.write("[");
            writer.write(this.internalSubset);
            writer.write("]");
        }
        writer.write(">");
        writer.write(XmlDocument.eol);
    }

    public short getNodeType() {
        return 10;
    }

    public String getName() {
        return this.name;
    }

    public String getNodeName() {
        return this.name;
    }

    public Node cloneNode(boolean bl) {
        throw new RuntimeException(this.getMessage("DT-000"));
    }

    public NamedNodeMap getEntities() {
        return this.entities;
    }

    public NamedNodeMap getNotations() {
        return this.notations;
    }

    public String getPublicId() {
        return this.publicId;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public String getInternalSubset() {
        return this.internalSubset;
    }

    void setOwnerDocument(XmlDocument xmlDocument) {
        super.setOwnerDocument(xmlDocument);
        if (this.entities != null) {
            int n = 0;
            while (this.entities.item(n) != null) {
                ((NodeBase)this.entities.item(n)).setOwnerDocument(xmlDocument);
                ++n;
            }
        }
        if (this.notations != null) {
            int n = 0;
            while (this.notations.item(n) != null) {
                ((NodeBase)this.notations.item(n)).setOwnerDocument(xmlDocument);
                ++n;
            }
        }
    }

    void addNotation(String string, String string2, String string3) {
        NotationNode notationNode = new NotationNode(string, string2, string3);
        notationNode.setOwnerDocument((XmlDocument)this.getOwnerDocument());
        this.notations.setNamedItem(notationNode);
    }

    void addEntityNode(String string, String string2, String string3, String string4) {
        EntityNode entityNode = new EntityNode(string, string2, string3, string4);
        entityNode.setOwnerDocument((XmlDocument)this.getOwnerDocument());
        this.entities.setNamedItem(entityNode);
    }

    void addEntityNode(String string, String string2) {
        if ("lt".equals(string) || "gt".equals(string) || "apos".equals(string) || "quot".equals(string) || "amp".equals(string)) {
            return;
        }
        EntityNode entityNode = new EntityNode(string, string2);
        entityNode.setOwnerDocument((XmlDocument)this.getOwnerDocument());
        this.entities.setNamedItem(entityNode);
    }

    void setReadonly() {
        this.entities.readonly = true;
        this.notations.readonly = true;
    }

    static class Nodemap
    implements NamedNodeMap {
        boolean readonly;
        Vector list = new Vector();

        Nodemap() {
        }

        public Node getNamedItem(String string) {
            int n = this.list.size();
            int n2 = 0;
            while (n2 < n) {
                Node node = this.item(n2);
                if (node.getNodeName().equals(string)) {
                    return node;
                }
                ++n2;
            }
            return null;
        }

        public Node getNamedItemNS(String string, String string2) {
            return null;
        }

        public int getLength() {
            return this.list.size();
        }

        public Node item(int n) {
            if (n < 0 || n >= this.list.size()) {
                return null;
            }
            return (Node)this.list.elementAt(n);
        }

        public Node removeNamedItem(String string) throws DOMException {
            throw new DomEx(7);
        }

        public Node removeNamedItemNS(String string, String string2) throws DOMException {
            throw new DomEx(7);
        }

        public Node setNamedItem(Node node) throws DOMException {
            if (this.readonly) {
                throw new DomEx(7);
            }
            this.list.addElement(node);
            return null;
        }

        public Node setNamedItemNS(Node node) throws DOMException {
            if (this.readonly) {
                throw new DomEx(7);
            }
            this.list.addElement(node);
            return null;
        }
    }

    static class EntityNode
    extends NodeBase
    implements Entity {
        private String entityName;
        private String publicId;
        private String systemId;
        private String notation;
        private String value;

        EntityNode(String string, String string2, String string3, String string4) {
            this.entityName = string;
            this.publicId = string2;
            this.systemId = string3;
            this.notation = string4;
        }

        EntityNode(String string, String string2) {
            this.entityName = string;
            this.value = string2;
        }

        public String getNodeName() {
            return this.entityName;
        }

        public short getNodeType() {
            return 6;
        }

        public String getPublicId() {
            return this.publicId;
        }

        public String getSystemId() {
            return this.systemId;
        }

        public String getNotationName() {
            return this.notation;
        }

        public Node cloneNode(boolean bl) {
            EntityNode entityNode = new EntityNode(this.entityName, this.publicId, this.systemId, this.notation);
            entityNode.setOwnerDocument((XmlDocument)this.getOwnerDocument());
            return entityNode;
        }

        public void writeXml(XmlWriteContext xmlWriteContext) throws IOException {
            Writer writer = xmlWriteContext.getWriter();
            writer.write("<!ENTITY ");
            writer.write(this.entityName);
            if (this.value == null) {
                if (this.publicId != null) {
                    writer.write(" PUBLIC '");
                    writer.write(this.publicId);
                    writer.write("' '");
                } else {
                    writer.write(" SYSTEM '");
                }
                writer.write(this.systemId);
                writer.write("'");
                if (this.notation != null) {
                    writer.write(" NDATA ");
                    writer.write(this.notation);
                }
            } else {
                writer.write(" \"");
                int n = this.value.length();
                int n2 = 0;
                while (n2 < n) {
                    char c = this.value.charAt(n2);
                    if (c == '\"') {
                        writer.write("&quot;");
                    } else {
                        writer.write(c);
                    }
                    ++n2;
                }
                writer.write(34);
            }
            writer.write(">");
        }
    }

    static class NotationNode
    extends NodeBase
    implements Notation {
        private String notation;
        private String publicId;
        private String systemId;

        NotationNode(String string, String string2, String string3) {
            this.notation = string;
            this.publicId = string2;
            this.systemId = string3;
        }

        public String getPublicId() {
            return this.publicId;
        }

        public String getSystemId() {
            return this.systemId;
        }

        public short getNodeType() {
            return 12;
        }

        public String getNodeName() {
            return this.notation;
        }

        public Node cloneNode(boolean bl) {
            NotationNode notationNode = new NotationNode(this.notation, this.publicId, this.systemId);
            notationNode.setOwnerDocument((XmlDocument)this.getOwnerDocument());
            return notationNode;
        }

        public void writeXml(XmlWriteContext xmlWriteContext) throws IOException {
            Writer writer = xmlWriteContext.getWriter();
            writer.write("<!NOTATION ");
            writer.write(this.notation);
            if (this.publicId != null) {
                writer.write(" PUBLIC '");
                writer.write(this.publicId);
                if (this.systemId != null) {
                    writer.write("' '");
                    writer.write(this.systemId);
                }
            } else {
                writer.write(" SYSTEM '");
                writer.write(this.systemId);
            }
            writer.write("'>");
        }
    }
}

