/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crimson.tree;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Writer;
import org.apache.crimson.tree.AttributeNode;
import org.apache.crimson.tree.AttributeSet;
import org.apache.crimson.tree.DomEx;
import org.apache.crimson.tree.ElementEx;
import org.apache.crimson.tree.NamespacedNode;
import org.apache.crimson.tree.XmlDocument;
import org.apache.crimson.tree.XmlWriteContext;
import org.apache.crimson.util.XmlNames;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ElementNode
extends NamespacedNode
implements ElementEx {
    private AttributeSet attributes;
    private String idAttributeName;
    private Object userObject;
    private static final char[] tagStart = new char[]{'<', '/'};
    private static final char[] tagEnd = new char[]{' ', '/', '>'};
    private static final String SPEC_XML_URI = "http://www.w3.org/XML/1998/namespace";

    public ElementNode() {
    }

    public ElementNode(String string) {
        this.name = string;
    }

    public ElementNode(String string, String string2) throws DomEx {
        this.checkArguments(string, string2);
        this.name = string2;
        this.namespaceURI = string;
    }

    private void checkArguments(String string, String string2) throws DomEx {
        if (string2 == null) {
            throw new DomEx(14);
        }
        int n = string2.indexOf(58);
        if (n <= 0) {
            if (!XmlNames.isUnqualifiedName(string2)) {
                throw new DomEx(5);
            }
            return;
        }
        int n2 = string2.lastIndexOf(58);
        if (n2 != n) {
            throw new DomEx(14);
        }
        String string3 = string2.substring(0, n);
        String string4 = string2.substring(n + 1);
        if (!XmlNames.isUnqualifiedName(string3) || !XmlNames.isUnqualifiedName(string4)) {
            throw new DomEx(5);
        }
        if (string == null || string.equals("") || string3.equals("xml") && !string.equals(SPEC_XML_URI)) {
            throw new DomEx(14);
        }
    }

    public void trimToSize() {
        super.trimToSize();
        if (this.attributes != null) {
            this.attributes.trimToSize();
        }
    }

    protected void setTag(String string) {
        this.name = string;
    }

    void setAttributes(AttributeSet attributeSet) {
        AttributeSet attributeSet2 = this.attributes;
        if (attributeSet2 != null && attributeSet2.isReadonly()) {
            throw new DomEx(7);
        }
        if (attributeSet != null) {
            attributeSet.setOwnerElement(this);
        }
        this.attributes = attributeSet;
        if (attributeSet2 != null) {
            attributeSet2.setOwnerElement(null);
        }
    }

    void checkChildType(int n) throws DOMException {
        switch (n) {
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                return;
            }
        }
        throw new DomEx(3);
    }

    public void setReadonly(boolean bl) {
        if (this.attributes != null) {
            this.attributes.setReadonly();
        }
        super.setReadonly(bl);
    }

    public NamedNodeMap getAttributes() {
        if (this.attributes == null) {
            this.attributes = new AttributeSet(this);
        }
        return this.attributes;
    }

    public boolean hasAttributes() {
        return this.attributes != null;
    }

    public String toString() {
        try {
            CharArrayWriter charArrayWriter = new CharArrayWriter();
            XmlWriteContext xmlWriteContext = new XmlWriteContext(charArrayWriter);
            this.writeXml(xmlWriteContext);
            return charArrayWriter.toString();
        }
        catch (Exception exception) {
            return super.toString();
        }
    }

    public void writeXml(XmlWriteContext xmlWriteContext) throws IOException {
        Writer writer = xmlWriteContext.getWriter();
        if (this.name == null) {
            throw new IllegalStateException(this.getMessage("EN-002"));
        }
        writer.write(tagStart, 0, 1);
        writer.write(this.name);
        if (this.attributes != null) {
            this.attributes.writeXml(xmlWriteContext);
        }
        if (!this.hasChildNodes()) {
            writer.write(tagEnd, 0, 3);
        } else {
            writer.write(tagEnd, 2, 1);
            this.writeChildrenXml(xmlWriteContext);
            writer.write(tagStart, 0, 2);
            writer.write(this.name);
            writer.write(tagEnd, 2, 1);
        }
    }

    public void setIdAttributeName(String string) {
        if (this.readonly) {
            throw new DomEx(7);
        }
        this.idAttributeName = string;
    }

    public String getIdAttributeName() {
        return this.idAttributeName;
    }

    public void setUserObject(Object object) {
        this.userObject = object;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public short getNodeType() {
        return 1;
    }

    public String getTagName() {
        return this.name;
    }

    public String getNodeName() {
        return this.name;
    }

    public boolean hasAttribute(String string) {
        return this.getAttributeNode(string) != null;
    }

    public boolean hasAttributeNS(String string, String string2) {
        return this.getAttributeNodeNS(string, string2) != null;
    }

    public String getAttribute(String string) {
        return this.attributes == null ? "" : this.attributes.getValue(string);
    }

    public String getAttributeNS(String string, String string2) {
        if (this.attributes == null) {
            return "";
        }
        Attr attr = this.getAttributeNodeNS(string, string2);
        if (attr == null) {
            return "";
        }
        return attr.getValue();
    }

    public Attr getAttributeNodeNS(String string, String string2) {
        if (string2 == null) {
            return null;
        }
        if (this.attributes == null) {
            return null;
        }
        int n = 0;
        AttributeNode attributeNode;
        while ((attributeNode = (AttributeNode)this.attributes.item(n)) != null) {
            if (attributeNode.getLocalName().equals(string2) && attributeNode.getNamespaceURI().equals(string)) {
                return attributeNode;
            }
            ++n;
        }
        return null;
    }

    public void setAttribute(String string, String string2) throws DOMException {
        AttributeNode attributeNode;
        if (this.readonly) {
            throw new DomEx(7);
        }
        if (this.attributes == null) {
            this.attributes = new AttributeSet(this);
        }
        if ((attributeNode = (AttributeNode)this.attributes.getNamedItem(string)) != null) {
            attributeNode.setNodeValue(string2);
        } else {
            attributeNode = new AttributeNode(string, string2, true, null);
            attributeNode.setOwnerDocument((XmlDocument)this.getOwnerDocument());
            this.attributes.setNamedItem(attributeNode);
        }
    }

    public void setAttributeNS(String string, String string2, String string3) throws DOMException {
        AttributeNode.checkArguments(string, string2);
        String string4 = XmlNames.getPrefix(string2);
        if (string4 == null) {
            throw new DomEx(14);
        }
        Attr attr = this.getAttributeNodeNS(string, XmlNames.getLocalPart(string2));
        if (attr == null) {
            attr = new AttributeNode(string, string2, string3, true, null);
            this.setAttributeNodeNS(attr);
        } else {
            attr.setValue(string3);
            attr.setPrefix(string4);
        }
    }

    public Attr setAttributeNodeNS(Attr attr) throws DOMException {
        if (this.readonly) {
            throw new DomEx(7);
        }
        if (attr.getOwnerDocument() != this.getOwnerDocument()) {
            throw new DomEx(4);
        }
        if (this.attributes == null) {
            this.attributes = new AttributeSet(this);
        }
        return (Attr)this.attributes.setNamedItem(attr);
    }

    public void removeAttribute(String string) throws DOMException {
        if (this.readonly) {
            throw new DomEx(7);
        }
        if (this.attributes == null) {
            throw new DomEx(8);
        }
        this.attributes.removeNamedItem(string);
    }

    public void removeAttributeNS(String string, String string2) throws DOMException {
        if (this.readonly) {
            throw new DomEx(7);
        }
        this.attributes.removeNamedItemNS(string, string2);
    }

    public Attr getAttributeNode(String string) {
        if (this.attributes != null) {
            return (Attr)this.attributes.getNamedItem(string);
        }
        return null;
    }

    public Attr setAttributeNode(Attr attr) throws DOMException {
        if (this.readonly) {
            throw new DomEx(7);
        }
        if (!(attr instanceof AttributeNode)) {
            throw new DomEx(4);
        }
        if (this.attributes == null) {
            this.attributes = new AttributeSet(this);
        }
        return (Attr)this.attributes.setNamedItem(attr);
    }

    public Attr removeAttributeNode(Attr attr) throws DOMException {
        if (this.isReadonly()) {
            throw new DomEx(7);
        }
        Attr attr2 = this.getAttributeNode(attr.getNodeName());
        if (attr2 == null) {
            throw new DomEx(8);
        }
        this.removeAttribute(attr2.getNodeName());
        return attr2;
    }

    public Node cloneNode(boolean bl) {
        try {
            ElementNode elementNode = (ElementNode)this.getOwnerDocument().createElement(this.name);
            if (this.attributes != null) {
                elementNode.setAttributes(new AttributeSet(this.attributes, true));
            }
            if (bl) {
                Node node;
                int n = 0;
                while ((node = this.item(n)) != null) {
                    elementNode.appendChild(node.cloneNode(true));
                    ++n;
                }
            }
            return elementNode;
        }
        catch (DOMException dOMException) {
            throw new RuntimeException(this.getMessage("EN-001"));
        }
    }

    public void write(Writer writer) throws IOException {
        this.writeXml(new XmlWriteContext(writer));
    }
}

