/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crimson.tree;

import java.io.IOException;
import java.util.Locale;
import org.apache.crimson.tree.DOMImplementationImpl;
import org.apache.crimson.tree.DomEx;
import org.apache.crimson.tree.ElementNode;
import org.apache.crimson.tree.NodeEx;
import org.apache.crimson.tree.ParentNode;
import org.apache.crimson.tree.TreeWalker;
import org.apache.crimson.tree.XmlDocument;
import org.apache.crimson.tree.XmlWritable;
import org.apache.crimson.tree.XmlWriteContext;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

abstract class NodeBase
implements Node,
NodeEx,
NodeList,
XmlWritable {
    private ParentNode parent;
    private int parentIndex = -1;
    XmlDocument ownerDocument;
    boolean readonly;

    NodeBase() {
    }

    ParentNode getParentImpl() {
        return this.parent;
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public void setReadonly(boolean bl) {
        this.readonly = true;
        if (bl) {
            Node node;
            TreeWalker treeWalker = new TreeWalker(this);
            while ((node = treeWalker.getNext()) != null) {
                ((NodeBase)node).setReadonly(false);
            }
        }
    }

    public String getLanguage() {
        return this.getInheritedAttribute("xml:lang");
    }

    public String getInheritedAttribute(String string) {
        ElementNode elementNode;
        NodeBase nodeBase = this;
        Attr attr = null;
        while (!(nodeBase instanceof ElementNode && (attr = (elementNode = (ElementNode)nodeBase).getAttributeNode(string)) != null || (nodeBase = nodeBase.getParentImpl()) == null)) {
        }
        if (attr != null) {
            return attr.getValue();
        }
        return null;
    }

    public void writeChildrenXml(XmlWriteContext xmlWriteContext) throws IOException {
    }

    public Node getParentNode() {
        return this.parent;
    }

    void setParentNode(ParentNode parentNode, int n) throws DOMException {
        if (this.parent != null && parentNode != null) {
            this.parent.removeChild(this);
        }
        this.parent = parentNode;
        this.parentIndex = n;
    }

    void setOwnerDocument(XmlDocument xmlDocument) {
        this.ownerDocument = xmlDocument;
    }

    public Document getOwnerDocument() {
        return this.ownerDocument;
    }

    public boolean hasChildNodes() {
        return false;
    }

    public void setNodeValue(String string) {
        if (this.readonly) {
            throw new DomEx(7);
        }
    }

    public String getNodeValue() {
        return null;
    }

    public Node getFirstChild() {
        return null;
    }

    public int getLength() {
        return 0;
    }

    public Node item(int n) {
        return null;
    }

    public NodeList getChildNodes() {
        return this;
    }

    public Node getLastChild() {
        return null;
    }

    public Node appendChild(Node node) throws DOMException {
        throw new DomEx(3);
    }

    public Node insertBefore(Node node, Node node2) throws DOMException {
        throw new DomEx(3);
    }

    public Node replaceChild(Node node, Node node2) throws DOMException {
        throw new DomEx(3);
    }

    public Node removeChild(Node node) throws DOMException {
        throw new DomEx(3);
    }

    public Node getNextSibling() {
        if (this.parent == null) {
            return null;
        }
        if (this.parentIndex < 0 || this.parent.item(this.parentIndex) != this) {
            this.parentIndex = this.parent.getIndexOf(this);
        }
        return this.parent.item(this.parentIndex + 1);
    }

    public Node getPreviousSibling() {
        if (this.parent == null) {
            return null;
        }
        if (this.parentIndex < 0 || this.parent.item(this.parentIndex) != this) {
            this.parentIndex = this.parent.getIndexOf(this);
        }
        return this.parent.item(this.parentIndex - 1);
    }

    public NamedNodeMap getAttributes() {
        return null;
    }

    public void normalize() {
    }

    public boolean isSupported(String string, String string2) {
        return DOMImplementationImpl.hasFeature0(string, string2);
    }

    public String getNamespaceURI() {
        return null;
    }

    public String getPrefix() {
        return null;
    }

    public void setPrefix(String string) throws DOMException {
        throw new DomEx(14);
    }

    public String getLocalName() {
        return null;
    }

    public boolean hasAttributes() {
        return false;
    }

    public int getIndexOf(Node node) {
        return -1;
    }

    String getMessage(String string) {
        return this.getMessage(string, null);
    }

    String getMessage(String string, Object[] objectArray) {
        Locale locale = this instanceof XmlDocument ? ((XmlDocument)this).getLocale() : (this.ownerDocument == null ? Locale.getDefault() : this.ownerDocument.getLocale());
        return XmlDocument.catalog.getMessage(locale, string, objectArray);
    }

    public abstract Node cloneNode(boolean var1);

    public abstract short getNodeType();

    public abstract String getNodeName();

    public abstract void writeXml(XmlWriteContext var1) throws IOException;
}

