/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crimson.tree;

import java.util.Locale;
import java.util.Vector;
import org.apache.crimson.parser.AttributeListEx;
import org.apache.crimson.tree.AttributeSet;
import org.apache.crimson.tree.Doctype;
import org.apache.crimson.tree.ElementFactory;
import org.apache.crimson.tree.ElementNode;
import org.apache.crimson.tree.NodeBase;
import org.apache.crimson.tree.PINode;
import org.apache.crimson.tree.ParentNode;
import org.apache.crimson.tree.TextNode;
import org.apache.crimson.tree.XmlDocument;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.EntityReference;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;

public class XmlDocumentBuilder
implements ContentHandler,
LexicalHandler,
DeclHandler,
DTDHandler {
    private XmlDocument document;
    private Locator locator;
    private Locale locale = Locale.getDefault();
    private ElementFactory factory;
    private Vector attrTmp = new Vector();
    private ParentNode[] elementStack;
    private int topOfStack;
    private boolean inDTD;
    private boolean inCDataSection;
    private Doctype doctype;
    private boolean disableNamespaces = true;
    private boolean ignoreWhitespace = false;
    private boolean expandEntityRefs = true;
    private boolean ignoreComments = false;
    private boolean putCDATAIntoText = false;

    public boolean isIgnoringLexicalInfo() {
        return this.ignoreWhitespace && this.expandEntityRefs && this.ignoreComments && this.putCDATAIntoText;
    }

    public void setIgnoringLexicalInfo(boolean bl) {
        this.ignoreWhitespace = bl;
        this.expandEntityRefs = bl;
        this.ignoreComments = bl;
        this.putCDATAIntoText = bl;
    }

    public void setIgnoreWhitespace(boolean bl) {
        this.ignoreWhitespace = bl;
    }

    public void setExpandEntityReferences(boolean bl) {
        this.expandEntityRefs = bl;
    }

    public void setIgnoreComments(boolean bl) {
        this.ignoreComments = bl;
    }

    public void setPutCDATAIntoText(boolean bl) {
        this.putCDATAIntoText = bl;
    }

    public boolean getDisableNamespaces() {
        return this.disableNamespaces;
    }

    public void setDisableNamespaces(boolean bl) {
        this.disableNamespaces = bl;
    }

    public XmlDocument getDocument() {
        return this.document;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) throws SAXException {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        this.locale = locale;
    }

    public Locale chooseLocale(String[] stringArray) throws SAXException {
        Locale locale = XmlDocument.catalog.chooseLocale(stringArray);
        if (locale != null) {
            this.setLocale(locale);
        }
        return locale;
    }

    String getMessage(String string) {
        return this.getMessage(string, null);
    }

    String getMessage(String string, Object[] objectArray) {
        if (this.locale == null) {
            this.getLocale();
        }
        return XmlDocument.catalog.getMessage(this.locale, string, objectArray);
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public XmlDocument createDocument() {
        XmlDocument xmlDocument = new XmlDocument();
        if (this.factory != null) {
            xmlDocument.setElementFactory(this.factory);
        }
        return xmlDocument;
    }

    public final void setElementFactory(ElementFactory elementFactory) {
        this.factory = elementFactory;
    }

    public final ElementFactory getElementFactory() {
        return this.factory;
    }

    public void startDocument() throws SAXException {
        this.document = this.createDocument();
        if (this.locator != null) {
            this.document.setSystemId(this.locator.getSystemId());
        }
        this.elementStack = new ParentNode[200];
        this.topOfStack = 0;
        this.elementStack[this.topOfStack] = this.document;
        this.inDTD = false;
    }

    public void endDocument() throws SAXException {
        if (this.topOfStack != 0) {
            throw new IllegalStateException(this.getMessage("XDB-000"));
        }
        this.document.trimToSize();
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
    }

    public void endPrefixMapping(String string) throws SAXException {
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        AttributeSet attributeSet = null;
        int n = attributes.getLength();
        if (n != 0) {
            try {
                attributeSet = new AttributeSet(attributes);
            }
            catch (DOMException dOMException) {
                throw new SAXParseException(this.getMessage("XDB-002", new Object[]{dOMException.getMessage()}), this.locator, dOMException);
            }
        }
        ElementNode elementNode = null;
        try {
            elementNode = string.equals("") ? (ElementNode)this.document.createElementEx(string3) : (ElementNode)this.document.createElementNS(string, string3);
        }
        catch (DOMException dOMException) {
            throw new SAXParseException(this.getMessage("XDB-004", new Object[]{dOMException.getMessage()}), this.locator, dOMException);
        }
        if (attributes instanceof AttributeListEx) {
            elementNode.setIdAttributeName(((AttributeListEx)((Object)attributes)).getIdAttributeName());
        }
        if (n != 0) {
            elementNode.setAttributes(attributeSet);
        }
        this.elementStack[this.topOfStack++].appendChild(elementNode);
        this.elementStack[this.topOfStack] = elementNode;
        if (!this.disableNamespaces) {
            // empty if block
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        ElementNode elementNode = (ElementNode)this.elementStack[this.topOfStack];
        this.elementStack[this.topOfStack--] = null;
        elementNode.reduceWaste();
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        ParentNode parentNode = this.elementStack[this.topOfStack];
        if (this.inCDataSection) {
            String string = new String(cArray, n, n2);
            CDATASection cDATASection = (CDATASection)parentNode.getLastChild();
            cDATASection.appendData(string);
            return;
        }
        try {
            NodeBase nodeBase = (NodeBase)parentNode.getLastChild();
            if (nodeBase instanceof TextNode) {
                String string = new String(cArray, n, n2);
                ((TextNode)nodeBase).appendData(string);
            } else {
                TextNode textNode = this.document.newText(cArray, n, n2);
                parentNode.appendChild(textNode);
            }
        }
        catch (DOMException dOMException) {
            throw new SAXParseException(this.getMessage("XDB-004", new Object[]{dOMException.getMessage()}), this.locator, dOMException);
        }
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        if (this.ignoreWhitespace) {
            return;
        }
        ParentNode parentNode = this.elementStack[this.topOfStack];
        if (this.inCDataSection) {
            String string = new String(cArray, n, n2);
            CDATASection cDATASection = (CDATASection)parentNode.getLastChild();
            cDATASection.appendData(string);
            return;
        }
        TextNode textNode = this.document.newText(cArray, n, n2);
        try {
            parentNode.appendChild(textNode);
        }
        catch (DOMException dOMException) {
            throw new SAXParseException(this.getMessage("XDB-004", new Object[]{dOMException.getMessage()}), this.locator, dOMException);
        }
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        if (!this.disableNamespaces && string.indexOf(58) != -1) {
            throw new SAXParseException(this.getMessage("XDB-010"), this.locator);
        }
        if (this.inDTD) {
            return;
        }
        ParentNode parentNode = this.elementStack[this.topOfStack];
        try {
            PINode pINode = (PINode)this.document.createProcessingInstruction(string, string2);
            parentNode.appendChild(pINode);
        }
        catch (DOMException dOMException) {
            throw new SAXParseException(this.getMessage("XDB-004", new Object[]{dOMException.getMessage()}), this.locator, dOMException);
        }
    }

    public void skippedEntity(String string) throws SAXException {
    }

    public void startDTD(String string, String string2, String string3) throws SAXException {
        DOMImplementation dOMImplementation = this.document.getImplementation();
        this.doctype = (Doctype)dOMImplementation.createDocumentType(string, string2, string3);
        this.doctype.setOwnerDocument(this.document);
        this.inDTD = true;
    }

    public void endDTD() throws SAXException {
        this.document.appendChild(this.doctype);
        this.inDTD = false;
    }

    public void startEntity(String string) throws SAXException {
        if (this.expandEntityRefs || this.inDTD) {
            return;
        }
        EntityReference entityReference = this.document.createEntityReference(string);
        this.elementStack[this.topOfStack++].appendChild(entityReference);
        this.elementStack[this.topOfStack] = (ParentNode)((Object)entityReference);
    }

    public void endEntity(String string) throws SAXException {
        if (this.inDTD) {
            return;
        }
        ParentNode parentNode = this.elementStack[this.topOfStack];
        if (!(parentNode instanceof EntityReference)) {
            return;
        }
        parentNode.setReadonly(true);
        this.elementStack[this.topOfStack--] = null;
        if (!string.equals(parentNode.getNodeName())) {
            throw new SAXParseException(this.getMessage("XDB-011", new Object[]{string, parentNode.getNodeName()}), this.locator);
        }
    }

    public void startCDATA() throws SAXException {
        if (this.putCDATAIntoText) {
            return;
        }
        CDATASection cDATASection = this.document.createCDATASection("");
        ParentNode parentNode = this.elementStack[this.topOfStack];
        try {
            this.inCDataSection = true;
            parentNode.appendChild(cDATASection);
        }
        catch (DOMException dOMException) {
            throw new SAXParseException(this.getMessage("XDB-004", new Object[]{dOMException.getMessage()}), this.locator, dOMException);
        }
    }

    public void endCDATA() throws SAXException {
        this.inCDataSection = false;
    }

    public void comment(char[] cArray, int n, int n2) throws SAXException {
        if (this.ignoreComments || this.inDTD) {
            return;
        }
        String string = new String(cArray, n, n2);
        Comment comment = this.document.createComment(string);
        ParentNode parentNode = this.elementStack[this.topOfStack];
        try {
            parentNode.appendChild(comment);
        }
        catch (DOMException dOMException) {
            throw new SAXParseException(this.getMessage("XDB-004", new Object[]{dOMException.getMessage()}), this.locator, dOMException);
        }
    }

    public void elementDecl(String string, String string2) throws SAXException {
    }

    public void attributeDecl(String string, String string2, String string3, String string4, String string5) throws SAXException {
    }

    public void internalEntityDecl(String string, String string2) throws SAXException {
        if (!this.disableNamespaces && string.indexOf(58) != -1) {
            throw new SAXParseException(this.getMessage("XDB-012"), this.locator);
        }
        if (!string.startsWith("%")) {
            this.doctype.addEntityNode(string, string2);
        }
    }

    public void externalEntityDecl(String string, String string2, String string3) throws SAXException {
        if (!this.disableNamespaces && string.indexOf(58) != -1) {
            throw new SAXParseException(this.getMessage("XDB-012"), this.locator);
        }
        if (!string.startsWith("%")) {
            this.doctype.addEntityNode(string, string2, string3, null);
        }
    }

    public void notationDecl(String string, String string2, String string3) throws SAXException {
        if (!this.disableNamespaces && string.indexOf(58) != -1) {
            throw new SAXParseException(this.getMessage("XDB-013"), this.locator);
        }
        this.doctype.addNotation(string, string2, string3);
    }

    public void unparsedEntityDecl(String string, String string2, String string3, String string4) throws SAXException {
        if (!this.disableNamespaces && string.indexOf(58) != -1) {
            throw new SAXParseException(this.getMessage("XDB-012"), this.locator);
        }
        this.doctype.addEntityNode(string, string2, string3, string4);
    }
}

