/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.dom;

import com.jclark.xsl.dom.AttributeNode;
import com.jclark.xsl.dom.ContainerNode;
import com.jclark.xsl.dom.NullNodeIterator;
import com.jclark.xsl.om.Name;
import com.jclark.xsl.om.Node;
import com.jclark.xsl.om.SafeNodeIterator;
import com.jclark.xsl.om.XSLException;
import org.w3c.dom.NamedNodeMap;

class ElementNode
extends ContainerNode {
    private Name name;
    private AttributeNode[] attributeNodes = null;

    public byte getType() {
        return 0;
    }

    public Name getName() {
        if (this.name == null) {
            String string = this.domNode.getNodeName();
            try {
                this.name = this.prefixMap.expandElementTypeName(string, null);
            }
            catch (XSLException xSLException) {
                this.name = this.root.nameTable.createName(string);
            }
        }
        return this.name;
    }

    public String getAttributeValue(Name name) {
        if (this.attributeNodes == null) {
            return null;
        }
        int n = 0;
        while (n < this.attributeNodes.length) {
            if (this.attributeNodes[n] != null && name.equals(this.attributeNodes[n].name)) {
                return this.attributeNodes[n].getData();
            }
            ++n;
        }
        return null;
    }

    public Node getAttribute(Name name) {
        if (this.attributeNodes == null) {
            return null;
        }
        int n = 0;
        while (n < this.attributeNodes.length) {
            if (this.attributeNodes[n] != null && name.equals(this.attributeNodes[n].name)) {
                return this.attributeNodes[n];
            }
            ++n;
        }
        return null;
    }

    public SafeNodeIterator getAttributes() {
        if (this.attributeNodes == null) {
            return NullNodeIterator.getInstance();
        }
        ElementNode elementNode = this;
        if (elementNode == null) {
            throw null;
        }
        return elementNode.new AttributesIterator();
    }

    public boolean getPreserveSpace() {
        return this.preserveSpace || !this.root.loadContext.getStripSource(this.getName());
    }

    ElementNode(org.w3c.dom.Node node, ContainerNode containerNode, int n) {
        super(node, containerNode, n);
        String string;
        org.w3c.dom.Node node2;
        NamedNodeMap namedNodeMap = node.getAttributes();
        int n2 = namedNodeMap.getLength();
        if (n2 == 0) {
            return;
        }
        this.attributeNodes = new AttributeNode[n2];
        int n3 = -1;
        int n4 = 0;
        while (n4 < n2) {
            node2 = namedNodeMap.item(n4);
            string = node2.getNodeName();
            switch (string.indexOf(58)) {
                case -1: {
                    String string2;
                    if (string.equals("xmlns")) {
                        string2 = node2.getNodeValue();
                        if (string2.length() == 0) {
                            this.prefixMap = this.prefixMap.unbindDefault();
                            break;
                        }
                        this.prefixMap = this.prefixMap.bindDefault(string2);
                        break;
                    }
                    this.attributeNodes[n4] = new AttributeNode(this.root.nameTable.createName(node2.getNodeName()), node2, this, n4 - n2 - 1);
                    break;
                }
                case 3: {
                    String string2;
                    if (string.equals("xml:space")) {
                        string2 = node2.getNodeValue();
                        if ("preserve".equals(string2)) {
                            this.preserveSpace = true;
                        } else if ("default".equals(string2)) {
                            this.preserveSpace = false;
                        }
                    }
                    if (n3 >= 0) break;
                    n3 = n4;
                    break;
                }
                case 5: {
                    if (string.startsWith("xmlns")) {
                        this.prefixMap = this.prefixMap.bind(string.substring(6), node2.getNodeValue());
                        break;
                    }
                }
                default: {
                    if (n3 >= 0) break;
                    n3 = n4;
                    break;
                }
            }
            ++n4;
        }
        if (n3 >= 0) {
            n4 = n3;
            while (n4 < n2) {
                if (this.attributeNodes[n4] == null && (!(string = (node2 = namedNodeMap.item(n4)).getNodeName()).startsWith("xmlns") || string.length() != 5 && string.charAt(5) != ':')) {
                    try {
                        this.attributeNodes[n4] = new AttributeNode(this.prefixMap.expandAttributeName(node2.getNodeName(), null), node2, this, n4 - n2 - 1);
                    }
                    catch (XSLException xSLException) {
                        // empty catch block
                    }
                }
                ++n4;
            }
        }
    }

    class AttributesIterator
    implements SafeNodeIterator {
        int i = 0;

        public Node next() {
            while (this.i < ElementNode.this.attributeNodes.length) {
                AttributeNode attributeNode = ElementNode.this.attributeNodes[this.i++];
                if (attributeNode == null) continue;
                return attributeNode;
            }
            return null;
        }

        AttributesIterator() {
        }
    }
}

