/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.dom;

import com.jclark.xsl.dom.ContainerNode;
import com.jclark.xsl.dom.DOMExtensions;
import com.jclark.xsl.dom.ElementNode;
import com.jclark.xsl.dom.NullNodeIterator;
import com.jclark.xsl.dom.SiblingNodeIterator;
import com.jclark.xsl.om.NameTable;
import com.jclark.xsl.om.Node;
import com.jclark.xsl.om.SafeNodeIterator;
import com.jclark.xsl.tr.LoadContext;
import java.net.MalformedURLException;
import java.net.URL;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Entity;
import org.w3c.dom.NamedNodeMap;

public class RootNode
extends ContainerNode {
    private Document document;
    Document ownerDocument;
    private NamedNodeMap entities;
    private DOMExtensions extend;
    NameTable nameTable;
    int documentIndex;
    URL baseURL;
    LoadContext loadContext;
    boolean includeComments;
    boolean includeProcessingInstructions;

    int compareRootTo(RootNode rootNode) {
        return this.documentIndex - rootNode.documentIndex;
    }

    public byte getType() {
        return 3;
    }

    public URL getURL() {
        return this.baseURL;
    }

    public String getUnparsedEntityURI(String string) {
        if (this.entities == null) {
            return null;
        }
        Entity entity = (Entity)this.entities.getNamedItem(string);
        if (entity == null || entity.getNotationName() == null) {
            return null;
        }
        String string2 = entity.getSystemId();
        try {
            return new URL(this.baseURL, string2).toString();
        }
        catch (MalformedURLException malformedURLException) {
            return string2;
        }
    }

    boolean isId(org.w3c.dom.Node node, String string) {
        if (this.document == null) {
            return false;
        }
        return node.equals(this.extend.getElementById(this.document, string));
    }

    public Node getElementWithId(String string) {
        if (this.document == null) {
            return null;
        }
        Element element = this.extend.getElementById(this.document, string);
        if (element == null) {
            return null;
        }
        return this.createElement(element);
    }

    public ContainerNode createElement(org.w3c.dom.Node node) {
        org.w3c.dom.Node node2 = node.getParentNode();
        while (node2.getNodeType() == 5) {
            node2 = node2.getParentNode();
        }
        ContainerNode containerNode = node2.equals(this.domNode) ? this : this.createElement(node2);
        return new ElementNode(node, containerNode, SiblingNodeIterator.computeChildIndex(containerNode, node));
    }

    public String getGeneratedId() {
        return "N" + Integer.toString(this.documentIndex);
    }

    public SafeNodeIterator getFollowingSiblings() {
        return NullNodeIterator.getInstance();
    }

    public RootNode(org.w3c.dom.Node node, DOMExtensions dOMExtensions, LoadContext loadContext, NameTable nameTable, String string, int n) {
        super(node);
        this.extend = dOMExtensions;
        this.nameTable = nameTable;
        this.parent = null;
        this.root = this;
        this.prefixMap = nameTable.getEmptyNamespacePrefixMap();
        this.loadContext = loadContext;
        this.includeProcessingInstructions = loadContext.getIncludeProcessingInstructions();
        this.includeComments = loadContext.getIncludeComments();
        try {
            this.baseURL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (node.getNodeType() == 9) {
            this.ownerDocument = this.document = (Document)node;
            DocumentType documentType = this.document.getDoctype();
            if (documentType != null) {
                this.entities = documentType.getEntities();
            }
        } else {
            this.ownerDocument = node.getOwnerDocument();
        }
    }
}

