/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.expr;

import com.jclark.xsl.expr.ExprContext;
import com.jclark.xsl.om.Node;
import com.jclark.xsl.om.NodeIterator;
import com.jclark.xsl.om.SafeNodeIterator;
import com.jclark.xsl.om.XSLException;
import java.math.BigDecimal;

final class Converter {
    static double toNumber(String string) {
        try {
            return Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            return Double.NaN;
        }
    }

    static double toNumber(NodeIterator nodeIterator) throws XSLException {
        return Converter.toNumber(Converter.toString(nodeIterator));
    }

    static double toNumber(boolean bl) {
        return bl ? 1.0 : 0.0;
    }

    static boolean toBoolean(String string) {
        return string.length() != 0;
    }

    static boolean toBoolean(double d) {
        return d != 0.0 && d == d;
    }

    static boolean toBoolean(NodeIterator nodeIterator) throws XSLException {
        return nodeIterator.next() != null;
    }

    static String toString(NodeIterator nodeIterator) throws XSLException {
        return Converter.toString(nodeIterator.next());
    }

    static String toString(Node node) throws XSLException {
        if (node == null) {
            return "";
        }
        String string = node.getData();
        if (string != null) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        Converter.addContent(node, stringBuffer);
        return stringBuffer.toString();
    }

    private static void addContent(Node node, StringBuffer stringBuffer) throws XSLException {
        switch (node.getType()) {
            case 1: {
                stringBuffer.append(node.getData());
                break;
            }
            case 0: 
            case 3: {
                SafeNodeIterator safeNodeIterator = node.getChildren();
                while ((node = safeNodeIterator.next()) != null) {
                    Converter.addContent(node, stringBuffer);
                }
                break;
            }
        }
    }

    static String toString(double d) {
        String string;
        int n;
        if (!Double.isInfinite(d) && (d >= 9.007199254740992E15 || -d >= 9.007199254740992E15)) {
            return new BigDecimal(d).toString();
        }
        String string2 = Double.toString(d);
        if (string2.charAt((n = string2.length()) - 2) == '.' && string2.charAt(n - 1) == '0') {
            if ((string2 = string2.substring(0, n - 2)).equals("-0")) {
                return "0";
            }
            return string2;
        }
        int n2 = string2.indexOf(69);
        if (n2 < 0) {
            return string2;
        }
        int n3 = Integer.parseInt(string2.substring(n2 + 1));
        if (string2.charAt(0) == '-') {
            string = "-";
            string2 = string2.substring(1);
            --n2;
        } else {
            string = "";
        }
        int n4 = n2 - 2;
        if (n3 >= n4) {
            return string + string2.substring(0, 1) + string2.substring(2, n2) + Converter.zeros(n3 - n4);
        }
        if (n3 > 0) {
            return string + string2.substring(0, 1) + string2.substring(2, 2 + n3) + "." + string2.substring(2 + n3, n2);
        }
        return string + "0." + Converter.zeros(-1 - n3) + string2.substring(0, 1) + string2.substring(2, n2);
    }

    private static String zeros(int n) {
        char[] cArray = new char[n];
        int n2 = 0;
        while (n2 < n) {
            cArray[n2] = 48;
            ++n2;
        }
        return new String(cArray);
    }

    static String toString(boolean bl) {
        return bl ? "true" : "false";
    }

    static boolean positionToBoolean(double d, ExprContext exprContext) throws XSLException {
        return (double)exprContext.getPosition() == d;
    }

    private Converter() {
    }
}

