/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.sax;

import com.jclark.xsl.expr.ExtensionContext;
import com.jclark.xsl.om.Node;
import com.jclark.xsl.om.XSLException;
import com.jclark.xsl.sax.MultiNamespaceResult;
import com.jclark.xsl.sax.ResultBase;
import com.jclark.xsl.sax.ResultTreeFragment;
import com.jclark.xsl.tr.ExtensionHandler;
import com.jclark.xsl.tr.Result;
import com.jclark.xsl.tr.ResultFragmentVariant;
import com.jclark.xsl.tr.ResultFragmentVariantBase;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.xml.sax.DocumentHandler;
import org.xml.sax.SAXException;

public class ExtensionHandlerImpl
implements ExtensionHandler {
    private static final String JAVA_NS = "http://www.jclark.com/xt/java/";

    public ExtensionContext createContext(String string) throws XSLException {
        if (string.startsWith(JAVA_NS)) {
            try {
                return new ContextImpl(Class.forName(string.substring(JAVA_NS.length())));
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    private static Object wrapResultTreeFragment(ResultTreeFragment resultTreeFragment) {
        return new ResultFragmentVariantBase(resultTreeFragment){
            private final /* synthetic */ ResultTreeFragment val$frag;

            public Object convertToObject() {
                return this.val$frag;
            }

            public void append(Result result) throws XSLException {
                if (!(result instanceof ResultBase)) {
                    throw new XSLException("weird result tree fragment usage not implemented");
                }
                ((ResultBase)result).resultTreeFragment(this.val$frag);
            }
            {
                this.val$frag = resultTreeFragment;
                this.constructor$0();
            }

            private final void constructor$0() {
            }
        };
    }

    public Object wrapResultFragmentVariant(ResultFragmentVariant resultFragmentVariant) {
        ExtensionHandlerImpl extensionHandlerImpl = this;
        if (extensionHandlerImpl == null) {
            throw null;
        }
        return new ResultTreeFragment(extensionHandlerImpl, resultFragmentVariant){
            private final /* synthetic */ ExtensionHandlerImpl this$0;
            private final /* synthetic */ ResultFragmentVariant val$frag;

            public void emit(DocumentHandler documentHandler) throws SAXException {
                MultiNamespaceResult multiNamespaceResult = new MultiNamespaceResult(documentHandler, null);
                try {
                    this.val$frag.append(multiNamespaceResult);
                    multiNamespaceResult.flush();
                }
                catch (XSLException xSLException) {
                    throw new SAXException(xSLException);
                }
            }
            {
                this.val$frag = resultFragmentVariant;
                this.this$0 = extensionHandlerImpl;
                this.constructor$0(extensionHandlerImpl);
            }

            private final void constructor$0(ExtensionHandlerImpl extensionHandlerImpl) {
            }
        };
    }

    private static class ContextImpl
    implements ExtensionContext {
        private final Class cls;

        public boolean available(String string) {
            if (string.equals("new")) {
                return this.cls.getConstructors().length != 0;
            }
            string = this.camelCase(string);
            Method[] methodArray = this.cls.getMethods();
            int n = 0;
            while (n < methodArray.length) {
                if (methodArray[n].getName().equals(string)) {
                    return true;
                }
                ++n;
            }
            return false;
        }

        private Object callMethod(String string, Object[] objectArray) throws XSLException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            Object object;
            string = this.camelCase(string);
            Method[] methodArray = this.cls.getMethods();
            Method method = null;
            boolean bl = true;
            if (objectArray.length > 0 && this.cls.isInstance(objectArray[0])) {
                bl = false;
            }
            int n = 0;
            while (n < methodArray.length) {
                if (methodArray[n].getName().equals(string)) {
                    boolean bl2 = Modifier.isStatic(methodArray[n].getModifiers()) ? methodArray[n].getParameterTypes().length == objectArray.length : !bl && methodArray[n].getParameterTypes().length == objectArray.length - 1;
                    if (bl2) {
                        if (method != null) {
                            throw new XSLException(string + ": overloaded method");
                        }
                        method = methodArray[n];
                    }
                }
                ++n;
            }
            if (method == null) {
                throw new XSLException(string + ": no method with " + objectArray.length + " arguments");
            }
            if (Modifier.isStatic(method.getModifiers())) {
                object = method.invoke(null, objectArray);
            } else {
                Object object2 = objectArray[0];
                Object[] objectArray2 = new Object[objectArray.length - 1];
                System.arraycopy(objectArray, 1, objectArray2, 0, objectArray2.length);
                object = method.invoke(object2, objectArray2);
            }
            if (object instanceof ResultTreeFragment) {
                return ExtensionHandlerImpl.wrapResultTreeFragment((ResultTreeFragment)object);
            }
            return object;
        }

        private Object callConstructor(Object[] objectArray) throws XSLException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            Constructor<?>[] constructorArray = this.cls.getConstructors();
            Constructor<?> constructor = null;
            int n = 0;
            while (n < constructorArray.length) {
                if (constructorArray[n].getParameterTypes().length == objectArray.length) {
                    if (constructor != null) {
                        throw new XSLException("overloaded constructor");
                    }
                    constructor = constructorArray[n];
                }
                ++n;
            }
            if (constructor == null) {
                throw new XSLException("no constructor with " + objectArray.length + " arguments");
            }
            return constructor.newInstance(objectArray);
        }

        public Object call(String string, Node node, Object[] objectArray) throws XSLException {
            try {
                if (string.equals("new")) {
                    return this.callConstructor(objectArray);
                }
                return this.callMethod(string, objectArray);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new XSLException(string + ": illegal access");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new XSLException(string + ": illegal arguments");
            }
            catch (InstantiationException instantiationException) {
                throw new XSLException("cannot instantiate class");
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                if (throwable instanceof Error) {
                    throw (Error)throwable;
                }
                if (throwable instanceof Exception) {
                    throw new XSLException((Exception)throwable);
                }
                throw new XSLException(invocationTargetException);
            }
        }

        private String camelCase(String string) {
            int n = string.indexOf(45);
            if (n < 0 || n + 1 == string.length()) {
                return string;
            }
            return string.substring(0, n) + Character.toUpperCase(string.charAt(n + 1)) + this.camelCase(string.substring(n + 2));
        }

        ContextImpl(Class clazz) {
            this.cls = clazz;
        }
    }
}

