/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.sax;

import com.jclark.xsl.sax.Destination;
import com.jclark.xsl.sax.OutputDocumentHandler;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import org.xml.sax.AttributeList;
import org.xml.sax.DocumentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class NXMLOutputHandler
implements OutputDocumentHandler {
    private Writer writer;
    private boolean keepOpen;
    private final char[] chBuf = new char[1];
    private final String lineSeparator = System.getProperty("line.separator");
    private String[] escapes = new String[128];
    private final EscapeCharacterHandler escapeCharacterHandler;
    private final CharacterHandler ignoreCharacterHandler;
    private final CharacterHandler dataCharacterHandler;
    private CharacterHandler controlCharacterHandler;
    private CharacterHandler characterHandler;
    private int depth;
    private CharacterHandler[] characterHandlers;

    public DocumentHandler init(Destination destination, AttributeList attributeList) throws IOException {
        String string = attributeList.getValue("media-type");
        if (string == null) {
            string = "text/plain";
        }
        this.writer = new BufferedWriter(destination.getWriter(string, attributeList.getValue("encoding")));
        this.keepOpen = destination.keepOpen();
        return this;
    }

    public void startDocument() {
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        try {
            this.characterHandler.characters(cArray, n, n2);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        this.characters(cArray, n, n2);
    }

    public void startElement(String string, AttributeList attributeList) throws SAXException {
        String string2;
        if (string.equals("control")) {
            this.push(this.controlCharacterHandler);
        } else if (string.equals("data")) {
            this.push(this.dataCharacterHandler);
        } else if (string.equals("escape")) {
            this.escapeCharacterHandler.setChar(attributeList.getValue("char"));
            this.push(this.escapeCharacterHandler);
        } else if (string.equals("char") && (string2 = attributeList.getValue("number")) != null) {
            try {
                int n = Integer.parseInt(string2);
                if (n >= 0 && n < 65536) {
                    this.chBuf[0] = (char)n;
                    this.characters(this.chBuf, 0, 1);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public void endElement(String string) throws SAXException {
        if (string.equals("control") || string.equals("data")) {
            this.pop();
        } else if (string.equals("escape")) {
            this.escapeCharacterHandler.endChar();
            this.pop();
        }
    }

    public void pop() {
        this.characterHandler = this.characterHandlers[--this.depth];
    }

    public void push(CharacterHandler characterHandler) {
        if (this.depth >= this.characterHandlers.length) {
            CharacterHandler[] characterHandlerArray = this.characterHandlers;
            this.characterHandlers = new CharacterHandler[characterHandlerArray.length * 2];
            System.arraycopy(characterHandlerArray, 0, this.characterHandlers, 0, characterHandlerArray.length);
        }
        this.characterHandlers[this.depth++] = this.characterHandler;
        this.characterHandler = characterHandler;
    }

    public void processingInstruction(String string, String string2) {
    }

    public void endDocument() throws SAXException {
        try {
            if (this.writer != null) {
                if (this.keepOpen) {
                    this.writer.flush();
                } else {
                    this.writer.close();
                }
                this.writer = null;
            }
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void setDocumentLocator(Locator locator) {
    }

    public NXMLOutputHandler() {
        NXMLOutputHandler nXMLOutputHandler = this;
        if (nXMLOutputHandler == null) {
            throw null;
        }
        this.escapeCharacterHandler = nXMLOutputHandler.new EscapeCharacterHandler();
        NXMLOutputHandler nXMLOutputHandler2 = this;
        if (nXMLOutputHandler2 == null) {
            throw null;
        }
        this.ignoreCharacterHandler = nXMLOutputHandler2.new CharacterHandler();
        NXMLOutputHandler nXMLOutputHandler3 = this;
        if (nXMLOutputHandler3 == null) {
            throw null;
        }
        this.dataCharacterHandler = nXMLOutputHandler3.new DataCharacterHandler();
        this.depth = 0;
        this.characterHandlers = new CharacterHandler[1];
        this.characterHandler = this.ignoreCharacterHandler;
        if (!this.lineSeparator.equals("\n")) {
            this.escapes[10] = this.lineSeparator;
            NXMLOutputHandler nXMLOutputHandler4 = this;
            if (nXMLOutputHandler4 == null) {
                throw null;
            }
            this.controlCharacterHandler = nXMLOutputHandler4.new LineControlCharacterHandler();
        } else {
            NXMLOutputHandler nXMLOutputHandler5 = this;
            if (nXMLOutputHandler5 == null) {
                throw null;
            }
            this.controlCharacterHandler = nXMLOutputHandler5.new ControlCharacterHandler();
        }
    }

    class CharacterHandler {
        void characters(char[] cArray, int n, int n2) throws IOException {
        }

        CharacterHandler() {
        }
    }

    class EscapeCharacterHandler
    extends CharacterHandler {
        private int c;
        private StringBuffer buf = new StringBuffer();

        void characters(char[] cArray, int n, int n2) {
            while (n2 > 0) {
                if (cArray[n] == '\n') {
                    this.buf.append(NXMLOutputHandler.this.lineSeparator);
                } else {
                    this.buf.append(cArray[n]);
                }
                ++n;
                --n2;
            }
        }

        void setChar(String string) {
            this.buf.setLength(0);
            this.c = string.length() == 0 ? -1 : (int)string.charAt(0);
        }

        void endChar() {
            if (this.c >= 0) {
                if (this.c >= NXMLOutputHandler.this.escapes.length) {
                    int n = NXMLOutputHandler.this.escapes.length;
                    while ((n *= 2) <= this.c) {
                    }
                    String[] stringArray = NXMLOutputHandler.this.escapes;
                    NXMLOutputHandler.this.escapes = new String[n];
                    System.arraycopy(stringArray, 0, NXMLOutputHandler.this.escapes, 0, stringArray.length);
                }
                ((NXMLOutputHandler)NXMLOutputHandler.this).escapes[this.c] = this.buf.toString();
            }
        }

        EscapeCharacterHandler() {
        }
    }

    class DataCharacterHandler
    extends CharacterHandler {
        void characters(char[] cArray, int n, int n2) throws IOException {
            String[] stringArray = NXMLOutputHandler.this.escapes;
            int n3 = n;
            while (n2 > 0) {
                String string;
                char c = cArray[n];
                if (c < stringArray.length && (string = stringArray[c]) != null) {
                    if (n3 != n) {
                        NXMLOutputHandler.this.writer.write(cArray, n3, n - n3);
                    }
                    NXMLOutputHandler.this.writer.write(string);
                    n3 = n + 1;
                }
                ++n;
                --n2;
            }
            if (n3 != n) {
                NXMLOutputHandler.this.writer.write(cArray, n3, n - n3);
            }
        }

        DataCharacterHandler() {
        }
    }

    class ControlCharacterHandler
    extends CharacterHandler {
        void characters(char[] cArray, int n, int n2) throws IOException {
            NXMLOutputHandler.this.writer.write(cArray, n, n2);
        }

        ControlCharacterHandler() {
        }
    }

    class LineControlCharacterHandler
    extends CharacterHandler {
        void characters(char[] cArray, int n, int n2) throws IOException {
            int n3 = n;
            while (n2 > 0) {
                if (cArray[n] == '\n') {
                    if (n3 != n) {
                        NXMLOutputHandler.this.writer.write(cArray, n3, n - n3);
                    }
                    NXMLOutputHandler.this.writer.write(NXMLOutputHandler.this.lineSeparator);
                    n3 = n + 1;
                }
                ++n;
                --n2;
            }
            if (n3 != n) {
                NXMLOutputHandler.this.writer.write(cArray, n3, n - n3);
            }
        }

        LineControlCharacterHandler() {
        }
    }
}

