/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.sax;

import com.jclark.xsl.sax.Destination;
import com.jclark.xsl.sax.OutputDocumentHandler;
import java.io.IOException;
import java.io.Writer;
import org.xml.sax.AttributeList;
import org.xml.sax.DocumentHandler;
import org.xml.sax.HandlerBase;
import org.xml.sax.SAXException;

public class TextOutputHandler
extends HandlerBase
implements OutputDocumentHandler {
    private Writer writer;
    private boolean keepOpen;

    public DocumentHandler init(Destination destination, AttributeList attributeList) throws IOException {
        String string = attributeList.getValue("media-type");
        if (string == null) {
            string = "text/plain";
        }
        this.writer = destination.getWriter(string, attributeList.getValue("encoding"));
        this.keepOpen = destination.keepOpen();
        return this;
    }

    public void endDocument() throws SAXException {
        try {
            if (this.writer != null) {
                if (this.keepOpen) {
                    this.writer.flush();
                } else {
                    this.writer.close();
                }
                this.writer = null;
            }
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        try {
            this.writer.write(cArray, n, n2);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public TextOutputHandler() {
    }

    public TextOutputHandler(Writer writer) {
        this.writer = writer;
    }
}

