/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.sax;

import com.jclark.xsl.om.Name;
import com.jclark.xsl.om.NameTable;
import com.jclark.xsl.om.NamespacePrefixMap;
import com.jclark.xsl.om.Node;
import com.jclark.xsl.om.SafeNodeIterator;
import com.jclark.xsl.om.XSLException;
import com.jclark.xsl.sax.CommentHandler;
import com.jclark.xsl.sax.MultiNamespaceResult;
import com.jclark.xsl.sax.XMLProcessorEx;
import com.jclark.xsl.tr.LoadContext;
import com.jclark.xsl.tr.Result;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import org.xml.sax.AttributeList;
import org.xml.sax.DTDHandler;
import org.xml.sax.DocumentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLProcessorImpl
implements XMLProcessorEx {
    private Parser parser;
    private ErrorHandler errorHandler;

    public Node load(InputSource inputSource, int n, LoadContext loadContext, NameTable nameTable) throws IOException, XSLException {
        try {
            BuilderImpl builderImpl = new BuilderImpl(loadContext, inputSource.getSystemId(), n, nameTable.getEmptyNamespacePrefixMap());
            this.parser.setDocumentHandler(builderImpl);
            this.parser.setDTDHandler(builderImpl);
            this.parser.parse(inputSource);
            return builderImpl.getRootNode();
        }
        catch (SAXParseException sAXParseException) {
            throw new XSLException(sAXParseException);
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException.getException();
            if (exception == null) {
                throw new XSLException(sAXException.getMessage());
            }
            if (exception instanceof XSLException) {
                throw (XSLException)sAXException.getException();
            }
            throw new XSLException(exception);
        }
    }

    public Node load(URL uRL, int n, LoadContext loadContext, NameTable nameTable) throws IOException, XSLException {
        return this.load(new InputSource(uRL.toString()), n, loadContext, nameTable);
    }

    public static Builder createBuilder(String string, int n, LoadContext loadContext, NameTable nameTable) {
        return new BuilderImpl(loadContext, string, n, nameTable.getEmptyNamespacePrefixMap());
    }

    public Result createResult(Node node, int n, LoadContext loadContext, Node[] nodeArray) throws XSLException {
        URL uRL = null;
        if (node != null) {
            uRL = node.getURL();
        }
        String string = uRL == null ? null : uRL.toString();
        Builder builder = XMLProcessorImpl.createBuilder(string, n, loadContext, node.getNamespacePrefixMap().getNameTable());
        nodeArray[0] = builder.getRootNode();
        return new MultiNamespaceResult(builder, this.errorHandler);
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public XMLProcessorImpl(Parser parser) {
        this.parser = parser;
    }

    private static abstract class NodeImpl
    implements Node {
        ContainerNodeImpl parent;
        RootNodeImpl root;
        int index;
        NodeImpl nextSibling;

        public Node getParent() {
            return this.parent;
        }

        public SafeNodeIterator getFollowingSiblings() {
            return new NodeIteratorImpl(this.nextSibling);
        }

        public URL getURL() {
            return this.parent.getURL();
        }

        public int getLineNumber() {
            return this.parent.getLineNumber();
        }

        boolean canStrip() {
            return false;
        }

        public Node getAttribute(Name name) {
            return null;
        }

        public String getAttributeValue(Name name) {
            return null;
        }

        public SafeNodeIterator getAttributes() {
            return new NodeIteratorImpl(null);
        }

        public Name getName() {
            return null;
        }

        public NamespacePrefixMap getNamespacePrefixMap() {
            return this.parent.nsMap;
        }

        public int compareTo(Node node) {
            NodeImpl nodeImpl = (NodeImpl)node;
            if (this.root == nodeImpl.root) {
                return this.index - ((NodeImpl)node).index;
            }
            return this.root.compareRootTo(nodeImpl.root);
        }

        public Node getElementWithId(String string) {
            return this.root.getElementWithId(string);
        }

        public String getUnparsedEntityURI(String string) {
            return this.root.getUnparsedEntityURI(string);
        }

        public boolean isId(String string) {
            return false;
        }

        public String getGeneratedId() {
            int n = this.root.getDocumentIndex();
            if (n == 0) {
                return "N" + String.valueOf(this.index);
            }
            return "N" + String.valueOf(n) + "_" + String.valueOf(this.index);
        }

        public Node getRoot() {
            return this.root;
        }

        public abstract String getData();

        public abstract SafeNodeIterator getChildren();

        public abstract byte getType();

        NodeImpl() {
            this.index = 0;
            this.parent = null;
            this.nextSibling = null;
        }

        NodeImpl(int n, ContainerNodeImpl containerNodeImpl) {
            this.index = n;
            this.parent = containerNodeImpl;
            this.root = containerNodeImpl.root;
            this.nextSibling = null;
            if (containerNodeImpl.lastChild == null) {
                containerNodeImpl.firstChild = containerNodeImpl.lastChild = this;
            } else {
                containerNodeImpl.lastChild.nextSibling = this;
                containerNodeImpl.lastChild = this;
            }
        }
    }

    private static class NodeIteratorImpl
    implements SafeNodeIterator {
        private NodeImpl nextNode;

        public Node next() {
            NodeImpl nodeImpl = this.nextNode;
            if (nodeImpl != null) {
                this.nextNode = nodeImpl.nextSibling;
            }
            return nodeImpl;
        }

        NodeIteratorImpl(NodeImpl nodeImpl) {
            this.nextNode = nodeImpl;
        }
    }

    private static abstract class ContainerNodeImpl
    extends NodeImpl {
        NodeImpl firstChild;
        NodeImpl lastChild;
        NamespacePrefixMap nsMap;

        public SafeNodeIterator getChildren() {
            return new NodeIteratorImpl(this.firstChild);
        }

        public String getData() {
            return null;
        }

        boolean preserveSpace() {
            return false;
        }

        public NamespacePrefixMap getNamespacePrefixMap() {
            return this.nsMap;
        }

        void addId(String string, NodeImpl nodeImpl) {
            this.parent.addId(string, nodeImpl);
        }

        public abstract byte getType();

        ContainerNodeImpl(NamespacePrefixMap namespacePrefixMap) {
            this.nsMap = namespacePrefixMap;
        }

        ContainerNodeImpl(int n, ContainerNodeImpl containerNodeImpl) {
            super(n, containerNodeImpl);
            this.nsMap = containerNodeImpl.nsMap;
        }
    }

    private static class RootNodeImpl
    extends ContainerNodeImpl {
        private String systemId;
        private int documentIndex;
        private Hashtable idTable = new Hashtable();
        private Hashtable unparsedEntityURITable = new Hashtable();

        public byte getType() {
            return 3;
        }

        public URL getURL() {
            if (this.systemId != null) {
                try {
                    return new URL(this.systemId);
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            return null;
        }

        public int getLineNumber() {
            return 1;
        }

        public Node getElementWithId(String string) {
            return (Node)this.idTable.get(string);
        }

        void addId(String string, NodeImpl nodeImpl) {
            if (this.idTable.get(string) == null) {
                this.idTable.put(string, nodeImpl);
            }
        }

        public String getUnparsedEntityURI(String string) {
            return (String)this.unparsedEntityURITable.get(string);
        }

        int compareRootTo(RootNodeImpl rootNodeImpl) {
            if (this.systemId == null) {
                if (rootNodeImpl.systemId == null) {
                    return this.documentIndex - rootNodeImpl.documentIndex;
                }
                return -1;
            }
            if (rootNodeImpl.systemId == null) {
                return 1;
            }
            int n = this.systemId.compareTo(rootNodeImpl.systemId);
            if (n != 0) {
                return n;
            }
            return this.documentIndex - rootNodeImpl.documentIndex;
        }

        int getDocumentIndex() {
            return this.documentIndex;
        }

        RootNodeImpl(String string, int n, NamespacePrefixMap namespacePrefixMap) {
            super(namespacePrefixMap);
            this.systemId = string;
            this.documentIndex = n;
            this.root = this;
        }
    }

    private static class NullLocator
    implements Locator {
        public String getPublicId() {
            return null;
        }

        public String getSystemId() {
            return null;
        }

        public int getLineNumber() {
            return -1;
        }

        public int getColumnNumber() {
            return -1;
        }

        NullLocator() {
        }
    }

    private static class ElementNodeImpl
    extends ContainerNodeImpl {
        private Name name;
        private Object[] atts;
        private int lineNumber;
        private String systemId;

        public Name getName() {
            return this.name;
        }

        public byte getType() {
            return 0;
        }

        public SafeNodeIterator getAttributes() {
            ElementNodeImpl elementNodeImpl = this;
            if (elementNodeImpl == null) {
                throw null;
            }
            return new SafeNodeIterator(elementNodeImpl){
                private int i;
                private final /* synthetic */ ElementNodeImpl this$0;

                public Node next() {
                    if (ElementNodeImpl.access$0(this.this$0) == null) {
                        return null;
                    }
                    int n = this.i * 2;
                    if (n == ElementNodeImpl.access$0(this.this$0).length) {
                        return null;
                    }
                    return new AttributeNodeImpl(this.this$0.index + ++this.i, this.this$0, (Name)ElementNodeImpl.access$0(this.this$0)[n], (String)ElementNodeImpl.access$0(this.this$0)[n + 1]);
                }
                {
                    this.this$0 = elementNodeImpl;
                    this.i = 0;
                    this.constructor$0(elementNodeImpl);
                }

                private final void constructor$0(ElementNodeImpl elementNodeImpl) {
                }
            };
        }

        public Node getAttribute(Name name) {
            if (this.atts != null) {
                int n = 0;
                while (n < this.atts.length) {
                    if (this.atts[n].equals(name)) {
                        return new AttributeNodeImpl(this.index + (n >> 1) + 1, this, name, (String)this.atts[n + 1]);
                    }
                    n += 2;
                }
            }
            return null;
        }

        public String getAttributeValue(Name name) {
            if (this.atts != null) {
                int n = 0;
                while (n < this.atts.length) {
                    if (this.atts[n].equals(name)) {
                        return (String)this.atts[n + 1];
                    }
                    n += 2;
                }
            }
            return null;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        public URL getURL() {
            if (this.systemId != null) {
                try {
                    return new URL(this.systemId);
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            return null;
        }

        public boolean isId(String string) {
            return this.equals(this.getElementWithId(string));
        }

        static /* synthetic */ Object[] access$0(ElementNodeImpl elementNodeImpl) {
            return elementNodeImpl.atts;
        }

        ElementNodeImpl(String string, AttributeList attributeList, Locator locator, int n, ContainerNodeImpl containerNodeImpl) throws XSLException {
            super(n, containerNodeImpl);
            this.lineNumber = locator.getLineNumber();
            this.systemId = locator.getSystemId();
            int n2 = attributeList.getLength();
            if (n2 > 0) {
                Object[] objectArray;
                int n3 = 0;
                int n4 = 0;
                while (n4 < n2) {
                    objectArray = attributeList.getName(n4);
                    if (objectArray.startsWith("xmlns")) {
                        ++n3;
                        if (objectArray.length() == 5) {
                            String string2 = attributeList.getValue(n4);
                            this.nsMap = string2.length() == 0 ? this.nsMap.unbindDefault() : this.nsMap.bindDefault(string2);
                        } else if (objectArray.charAt(5) == ':') {
                            this.nsMap = this.nsMap.bind(objectArray.substring(6), attributeList.getValue(n4));
                        }
                    }
                    ++n4;
                }
                n4 = n2 - n3;
                if (n4 > 0) {
                    objectArray = new Object[n4 * 2];
                    int n5 = 0;
                    int n6 = 0;
                    while (n6 < n2) {
                        String string3 = attributeList.getName(n6);
                        if (!string3.startsWith("xmlns")) {
                            objectArray[n5++] = this.nsMap.expandAttributeName(string3, this);
                            objectArray[n5++] = attributeList.getValue(n6);
                        }
                        if (attributeList.getType(n6).length() == 2) {
                            containerNodeImpl.addId(attributeList.getValue(n6), this);
                        }
                        ++n6;
                    }
                    this.atts = objectArray;
                }
            }
            this.name = this.nsMap.expandElementTypeName(string, this);
        }
    }

    private static class PreserveElementNodeImpl
    extends ElementNodeImpl {
        boolean preserveSpace() {
            return true;
        }

        PreserveElementNodeImpl(String string, AttributeList attributeList, Locator locator, int n, ContainerNodeImpl containerNodeImpl) throws XSLException {
            super(string, attributeList, locator, n, containerNodeImpl);
        }
    }

    private static class AttributeNodeImpl
    extends NodeImpl {
        private Name name;
        private String value;

        public byte getType() {
            return 2;
        }

        public String getData() {
            return this.value;
        }

        public Name getName() {
            return this.name;
        }

        public SafeNodeIterator getChildren() {
            return new NodeIteratorImpl(null);
        }

        public int hashCode() {
            return this.index;
        }

        public boolean equals(Object object) {
            return object != null && object instanceof AttributeNodeImpl && ((AttributeNodeImpl)object).index == this.index;
        }

        AttributeNodeImpl(int n, ContainerNodeImpl containerNodeImpl, Name name, String string) {
            this.index = n;
            this.parent = containerNodeImpl;
            this.root = containerNodeImpl.root;
            this.name = name;
            this.value = string;
        }
    }

    private static class TextNodeImpl
    extends NodeImpl {
        private String data;

        public byte getType() {
            return 1;
        }

        public String getData() {
            return this.data;
        }

        public SafeNodeIterator getChildren() {
            return new NodeIteratorImpl(null);
        }

        public TextNodeImpl(char[] cArray, int n, int n2, int n3, ContainerNodeImpl containerNodeImpl) {
            super(n3, containerNodeImpl);
            this.data = new String(cArray, n, n2);
        }
    }

    private static class StripTextNodeImpl
    extends TextNodeImpl {
        boolean canStrip() {
            return true;
        }

        public StripTextNodeImpl(char[] cArray, int n, int n2, int n3, ContainerNodeImpl containerNodeImpl) {
            super(cArray, n, n2, n3, containerNodeImpl);
        }
    }

    private static class CommentNodeImpl
    extends NodeImpl {
        private String data;

        public byte getType() {
            return 5;
        }

        public String getData() {
            return this.data;
        }

        public SafeNodeIterator getChildren() {
            return new NodeIteratorImpl(null);
        }

        public CommentNodeImpl(String string, int n, ContainerNodeImpl containerNodeImpl) {
            super(n, containerNodeImpl);
            this.data = string;
        }
    }

    private static class ProcessingInstructionNodeImpl
    extends NodeImpl {
        private Name name;
        private String data;
        private String systemId;

        public Name getName() {
            return this.name;
        }

        public byte getType() {
            return 4;
        }

        public String getData() {
            return this.data;
        }

        public SafeNodeIterator getChildren() {
            return new NodeIteratorImpl(null);
        }

        public URL getURL() {
            if (this.systemId != null) {
                try {
                    return new URL(this.systemId);
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            return null;
        }

        public ProcessingInstructionNodeImpl(String string, String string2, Locator locator, int n, ContainerNodeImpl containerNodeImpl) {
            super(n, containerNodeImpl);
            this.systemId = locator.getSystemId();
            this.name = containerNodeImpl.getNamespacePrefixMap().getNameTable().createName(string);
            this.data = string2;
        }
    }

    public static interface Builder
    extends DocumentHandler,
    CommentHandler,
    DTDHandler {
        public Node getRootNode();
    }

    private static class BuilderImpl
    implements Builder {
        char[] dataBuf = new char[1024];
        int dataBufUsed = 0;
        RootNodeImpl rootNode;
        ContainerNodeImpl currentNode;
        int currentIndex = 1;
        boolean includeProcessingInstructions;
        boolean includeComments;
        LoadContext context;
        Locator locator = new NullLocator();

        public void startDocument() {
        }

        public void endDocument() {
        }

        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        public void startElement(String string, AttributeList attributeList) throws SAXException {
            ElementNodeImpl elementNodeImpl;
            this.flushData();
            String string2 = attributeList.getValue("xml:space");
            boolean bl = string2 == null ? this.currentNode.preserveSpace() : (string2.equals("default") ? false : (string2.equals("preserve") ? true : this.currentNode.preserveSpace()));
            try {
                elementNodeImpl = bl ? new PreserveElementNodeImpl(string, attributeList, this.locator, this.currentIndex++, this.currentNode) : new ElementNodeImpl(string, attributeList, this.locator, this.currentIndex++, this.currentNode);
            }
            catch (XSLException xSLException) {
                throw new SAXException(xSLException);
            }
            this.currentIndex += attributeList.getLength();
            this.currentNode = elementNodeImpl;
        }

        public void characters(char[] cArray, int n, int n2) {
            int n3 = n2 + this.dataBufUsed;
            if (n3 > this.dataBuf.length) {
                int n4 = this.dataBuf.length << 1;
                while (n3 > n4) {
                    n4 <<= 1;
                }
                char[] cArray2 = this.dataBuf;
                this.dataBuf = new char[n4];
                if (this.dataBufUsed > 0) {
                    System.arraycopy(cArray2, 0, this.dataBuf, 0, this.dataBufUsed);
                }
            }
            while (n2 > 0) {
                this.dataBuf[this.dataBufUsed++] = cArray[n++];
                --n2;
            }
        }

        public void ignorableWhitespace(char[] cArray, int n, int n2) {
            if (this.dataBufUsed > 0 || this.currentNode.preserveSpace() || !this.context.getStripSource(this.currentNode.getName())) {
                this.characters(cArray, n, n2);
            }
        }

        public void endElement(String string) {
            this.flushData();
            this.currentNode = this.currentNode.parent;
        }

        public void processingInstruction(String string, String string2) {
            if (string == null) {
                this.comment(string2);
            } else if (this.includeProcessingInstructions) {
                this.flushData();
                new ProcessingInstructionNodeImpl(string, string2, this.locator, this.currentIndex++, this.currentNode);
            }
        }

        public void comment(String string) {
            if (this.includeComments) {
                this.flushData();
                new CommentNodeImpl(string, this.currentIndex++, this.currentNode);
            }
        }

        public void unparsedEntityDecl(String string, String string2, String string3, String string4) {
            this.rootNode.unparsedEntityURITable.put(string, string3);
        }

        public void notationDecl(String string, String string2, String string3) {
        }

        public Node getRootNode() {
            return this.rootNode;
        }

        private static boolean isWhitespace(char[] cArray, int n) {
            int n2 = 0;
            while (n2 < n) {
                switch (cArray[n2]) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                ++n2;
            }
            return true;
        }

        private final void flushData() {
            if (this.dataBufUsed > 0) {
                if (!BuilderImpl.isWhitespace(this.dataBuf, this.dataBufUsed) || this.currentNode.preserveSpace() || !this.context.getStripSource(this.currentNode.getName())) {
                    new TextNodeImpl(this.dataBuf, 0, this.dataBufUsed, this.currentIndex++, this.currentNode);
                }
                this.dataBufUsed = 0;
            }
        }

        BuilderImpl(LoadContext loadContext, String string, int n, NamespacePrefixMap namespacePrefixMap) {
            this.context = loadContext;
            this.includeProcessingInstructions = loadContext.getIncludeProcessingInstructions();
            this.includeComments = loadContext.getIncludeComments();
            this.rootNode = new RootNodeImpl(string, n, namespacePrefixMap);
            this.currentNode = this.rootNode;
        }
    }
}

