/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.tr;

import com.jclark.xsl.expr.CloneableNodeIterator;
import com.jclark.xsl.expr.CloneableNodeIteratorImpl;
import com.jclark.xsl.expr.ExtensionContext;
import com.jclark.xsl.expr.SingleNodeIterator;
import com.jclark.xsl.expr.StringVariant;
import com.jclark.xsl.expr.Variant;
import com.jclark.xsl.expr.VariantBase;
import com.jclark.xsl.om.Name;
import com.jclark.xsl.om.NameTable;
import com.jclark.xsl.om.NamespacePrefixMap;
import com.jclark.xsl.om.Node;
import com.jclark.xsl.om.NodeIterator;
import com.jclark.xsl.om.XSLException;
import com.jclark.xsl.tr.Action;
import com.jclark.xsl.tr.ParameterSet;
import com.jclark.xsl.tr.ProcessContext;
import com.jclark.xsl.tr.Result;
import com.jclark.xsl.tr.ResultFragmentVariant;
import com.jclark.xsl.tr.SheetDetails;
import com.jclark.xsl.tr.VariableInfo;
import com.jclark.xsl.tr.XMLProcessor;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;

class ProcessContextImpl
implements ProcessContext {
    static final int OPEN_ACTION_INIT_SIZE = 2;
    static StringVariant emptyStringVariant = new StringVariant("");
    private final SheetDetails sheet;
    private final ParameterSet params;
    private Node root;
    private Hashtable variableValueTable = new Hashtable();
    private Name evalGlobalVariableName = null;
    private Name[] actionNames = new Name[2];
    private Node[] actionNodes = new Node[2];
    private int[] actionImportLevels = null;
    private int[] actionForEachLevels = null;
    private int nOpenActions = 0;
    private VariableBindings localVariables;
    private Name[] currentParamNames = null;
    private Variant[] currentParamValues = null;
    private int position = 1;
    private int lastPosition = 1;
    private NodeIterator currentIter = null;
    private Hashtable extensionTable = new Hashtable();
    private Hashtable documentTable = new Hashtable();
    private XMLProcessor parser;
    private Hashtable attributeSetInUseTable = new Hashtable();
    private Hashtable nameAliasTable;
    private Hashtable namespacePrefixMapAliasTable;
    private NameTable nameTable;
    private Hashtable objectTable = new Hashtable();
    private int nResultFragmentNodes = 0;

    public void invoke(NodeIterator nodeIterator, Action action, Result result) throws XSLException {
        int n;
        int n2 = this.position;
        int n3 = this.lastPosition;
        NodeIterator nodeIterator2 = this.currentIter;
        this.currentIter = nodeIterator;
        this.position = 0;
        this.lastPosition = 0;
        if (this.actionForEachLevels == null) {
            this.actionForEachLevels = new int[this.nOpenActions];
        } else if (this.nOpenActions > this.actionForEachLevels.length) {
            int[] nArray = this.actionForEachLevels;
            this.actionForEachLevels = new int[this.nOpenActions];
            System.arraycopy(nArray, 0, this.actionForEachLevels, 0, nArray.length);
        }
        int n4 = this.nOpenActions - 1;
        this.actionForEachLevels[n4] = this.actionForEachLevels[n4] + 1;
        try {
            Node node;
            while ((node = this.currentIter.next()) != null) {
                ++this.position;
                action.invoke(this, node, result);
            }
            Object var8_10 = null;
            n = this.nOpenActions - 1;
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            int n5 = this.nOpenActions - 1;
            this.actionForEachLevels[n5] = this.actionForEachLevels[n5] - 1;
            this.position = n2;
            this.lastPosition = n3;
            this.currentIter = nodeIterator2;
            throw throwable;
        }
        this.actionForEachLevels[n] = this.actionForEachLevels[n] - 1;
        this.position = n2;
        this.lastPosition = n3;
        this.currentIter = nodeIterator2;
    }

    public void process(NodeIterator nodeIterator, Name name, Name[] nameArray, Variant[] variantArray, Result result) throws XSLException {
        int n = this.position;
        int n2 = this.lastPosition;
        NodeIterator nodeIterator2 = this.currentIter;
        this.currentIter = nodeIterator;
        this.position = 0;
        this.lastPosition = 0;
        Name[] nameArray2 = this.currentParamNames;
        this.currentParamNames = nameArray;
        Variant[] variantArray2 = this.currentParamValues;
        this.currentParamValues = variantArray;
        boolean bl = variantArray == null;
        try {
            Node node;
            while ((node = this.currentIter.next()) != null) {
                ++this.position;
                if (bl) {
                    this.processSafe(node, name, result);
                    continue;
                }
                this.processUnsafe(node, name, result);
            }
            Object var13_13 = null;
            this.position = n;
            this.lastPosition = n2;
            this.currentIter = nodeIterator2;
            this.currentParamNames = nameArray2;
            this.currentParamValues = variantArray2;
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            this.position = n;
            this.lastPosition = n2;
            this.currentIter = nodeIterator2;
            this.currentParamNames = nameArray2;
            this.currentParamValues = variantArray2;
            throw throwable;
        }
    }

    private void processUnsafe(Node node, Name name, Result result) throws XSLException {
        this.getAction(name, node).invoke(this, node, result);
    }

    void processSafe(Node node, Name name, Result result) throws XSLException {
        Node[] nodeArray;
        int n;
        if (name == null) {
            n = 0;
            while (n < this.nOpenActions) {
                if (this.actionNames[n] == null && this.actionNodes[n].equals(node)) {
                    return;
                }
                ++n;
            }
        } else {
            n = 0;
            while (n < this.nOpenActions) {
                if (name.equals(this.actionNames[n]) && this.actionNodes[n].equals(node)) {
                    return;
                }
                ++n;
            }
        }
        if (this.nOpenActions == this.actionNames.length) {
            Name[] nameArray = this.actionNames;
            this.actionNames = new Name[this.nOpenActions * 2];
            System.arraycopy(nameArray, 0, this.actionNames, 0, this.nOpenActions);
            nodeArray = this.actionNodes;
            this.actionNodes = new Node[this.nOpenActions * 2];
            System.arraycopy(nodeArray, 0, this.actionNodes, 0, this.nOpenActions);
        }
        this.actionNames[this.nOpenActions] = name;
        this.actionNodes[this.nOpenActions] = node;
        ++this.nOpenActions;
        try {
            this.getAction(name, node).invoke(this, node, result);
        }
        finally {
            nodeArray = null;
            --this.nOpenActions;
        }
    }

    private final Action getAction(Name name, Node node) throws XSLException {
        return this.sheet.getModeTemplateRuleSet(name).getAction(node, this);
    }

    public void applyImports(Node node, Result result) throws XSLException {
        if (this.actionForEachLevels != null && this.actionForEachLevels[this.nOpenActions - 1] > 0) {
            throw new XSLException("xsl:apply-templates inside xsl:for-each", node);
        }
        if (this.actionImportLevels == null) {
            this.actionImportLevels = new int[this.nOpenActions];
        } else if (this.nOpenActions > this.actionImportLevels.length) {
            int[] nArray = this.actionImportLevels;
            this.actionImportLevels = new int[this.nOpenActions];
            System.arraycopy(nArray, 0, this.actionImportLevels, 0, nArray.length);
        }
        int n = this.nOpenActions - 1;
        int n2 = this.actionImportLevels[n];
        this.actionImportLevels[n] = n2 + 1;
        this.sheet.getModeTemplateRuleSet(this.actionNames[this.nOpenActions - 1]).getImportAction(node, this, n2).invoke(this, node, result);
        int n3 = this.nOpenActions - 1;
        this.actionImportLevels[n3] = this.actionImportLevels[n3] - 1;
    }

    public final boolean hasAttribute(Vector vector, Node node, String string) {
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            if (string.equals(node.getAttributeValue((Name)vector.elementAt(n2)))) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public int getPosition() {
        return this.position;
    }

    public int getLastPosition() throws XSLException {
        if (this.lastPosition == 0) {
            this.lastPosition = this.position;
            NodeIterator nodeIterator = this.cloneCurrentIter();
            while (nodeIterator.next() != null) {
                ++this.lastPosition;
            }
        }
        return this.lastPosition;
    }

    private NodeIterator cloneCurrentIter() {
        if (!(this.currentIter instanceof CloneableNodeIterator)) {
            this.currentIter = new CloneableNodeIteratorImpl(this.currentIter);
        }
        return (NodeIterator)((CloneableNodeIterator)this.currentIter).clone();
    }

    public Variant getGlobalVariableValue(Name name) throws XSLException {
        Variant variant = (Variant)this.variableValueTable.get(name);
        if (variant != null) {
            return variant;
        }
        VariableInfo variableInfo = this.sheet.getGlobalVariableInfo(name);
        if (variableInfo == null) {
            return null;
        }
        Object object = this.params.getParameter(name);
        if (object != null) {
            variant = VariantBase.create(object).makePermanent();
            this.variableValueTable.put(object, variant);
            return variant;
        }
        this.variableValueTable.put(name, emptyStringVariant);
        Name name2 = this.evalGlobalVariableName;
        this.evalGlobalVariableName = name;
        try {
            variant = variableInfo.getExpr().eval(this.root, this).makePermanent();
        }
        finally {
            Object var7_6 = null;
            this.evalGlobalVariableName = name2;
        }
        this.variableValueTable.put(name, variant);
        return variant;
    }

    public Variant getLocalVariableValue(Name name) {
        VariableBindings variableBindings = this.localVariables;
        while (variableBindings != null) {
            if (variableBindings.name.equals(name)) {
                return variableBindings.value;
            }
            variableBindings = variableBindings.next;
        }
        throw new Error("no such local variable");
    }

    public void bindLocalVariable(Name name, Variant variant) throws XSLException {
        this.localVariables = new VariableBindings(name, variant.makePermanent(), this.localVariables);
    }

    public void unbindLocalVariables(int n) {
        while (n > 0) {
            this.localVariables = this.localVariables.next;
            --n;
        }
    }

    public void invokeWithParams(Action action, Name[] nameArray, Variant[] variantArray, Node node, Result result) throws XSLException {
        Name[] nameArray2 = this.currentParamNames;
        this.currentParamNames = nameArray;
        Variant[] variantArray2 = this.currentParamValues;
        this.currentParamValues = variantArray;
        try {
            action.invoke(this, node, result);
        }
        finally {
            Object var9_8 = null;
            this.currentParamNames = nameArray2;
            this.currentParamValues = variantArray2;
        }
    }

    public Variant getParam(Name name) {
        if (this.currentParamNames != null) {
            int n = 0;
            while (n < this.currentParamNames.length) {
                if (name.equals(this.currentParamNames[n])) {
                    return this.currentParamValues[n];
                }
                ++n;
            }
        }
        return null;
    }

    public ProcessContext.Memento createMemento() {
        VariableBindings variableBindings = this.localVariables;
        int n = this.position;
        int n2 = this.lastPosition;
        NodeIterator nodeIterator = this.lastPosition == 0 ? this.cloneCurrentIter() : null;
        Name name = this.evalGlobalVariableName;
        ProcessContextImpl processContextImpl = this;
        if (processContextImpl == null) {
            throw null;
        }
        return new ProcessContext.Memento(processContextImpl, n, n2, nodeIterator, variableBindings, name){
            private final /* synthetic */ ProcessContextImpl this$0;
            private final /* synthetic */ int val$rememberPosition;
            private final /* synthetic */ int val$rememberLastPosition;
            private final /* synthetic */ NodeIterator val$rememberCurrentIter;
            private final /* synthetic */ VariableBindings val$rememberLocalVariables;
            private final /* synthetic */ Name val$rememberEvalGlobalVariableName;

            public void invoke(Action action, Node node, Result result) throws XSLException {
                Name[] nameArray = ProcessContextImpl.access$0(this.this$0);
                ProcessContextImpl.access$1(this.this$0, null);
                Variant[] variantArray = ProcessContextImpl.access$2(this.this$0);
                ProcessContextImpl.access$3(this.this$0, null);
                int n = ProcessContextImpl.access$4(this.this$0);
                ProcessContextImpl.access$5(this.this$0, this.val$rememberPosition);
                int n2 = ProcessContextImpl.access$6(this.this$0);
                ProcessContextImpl.access$7(this.this$0, this.val$rememberLastPosition);
                NodeIterator nodeIterator = ProcessContextImpl.access$8(this.this$0);
                ProcessContextImpl.access$9(this.this$0, this.val$rememberCurrentIter);
                VariableBindings variableBindings = ProcessContextImpl.access$10(this.this$0);
                ProcessContextImpl.access$11(this.this$0, this.val$rememberLocalVariables);
                V v = null;
                if (this.val$rememberEvalGlobalVariableName != null) {
                    v = ProcessContextImpl.access$12(this.this$0).get(this.val$rememberEvalGlobalVariableName);
                    ProcessContextImpl.access$12(this.this$0).put(this.val$rememberEvalGlobalVariableName, emptyStringVariant);
                }
                try {
                    action.invoke(this.this$0, node, result);
                }
                finally {
                    Object var12_11 = null;
                    ProcessContextImpl.access$1(this.this$0, nameArray);
                    ProcessContextImpl.access$3(this.this$0, variantArray);
                    ProcessContextImpl.access$11(this.this$0, variableBindings);
                    ProcessContextImpl.access$5(this.this$0, n);
                    ProcessContextImpl.access$7(this.this$0, n2);
                    ProcessContextImpl.access$9(this.this$0, nodeIterator);
                    if (this.val$rememberEvalGlobalVariableName != null) {
                        ProcessContextImpl.access$12(this.this$0).put(this.val$rememberEvalGlobalVariableName, v);
                    }
                }
            }
            {
                this.val$rememberPosition = n;
                this.val$rememberLastPosition = n2;
                this.val$rememberCurrentIter = nodeIterator;
                this.val$rememberLocalVariables = variableBindings;
                this.val$rememberEvalGlobalVariableName = name;
                this.this$0 = processContextImpl;
                this.constructor$0(processContextImpl);
            }

            private final void constructor$0(ProcessContextImpl processContextImpl) {
            }
        };
    }

    public ExtensionContext getExtensionContext(String string) throws XSLException {
        ExtensionContext extensionContext = (ExtensionContext)this.extensionTable.get(string);
        if (extensionContext == null) {
            extensionContext = this.sheet.createExtensionContext(string);
            if (extensionContext == null) {
                ProcessContextImpl processContextImpl = this;
                if (processContextImpl == null) {
                    throw null;
                }
                extensionContext = new ExtensionContext(processContextImpl){
                    private final /* synthetic */ ProcessContextImpl this$0;

                    public boolean available(String string) {
                        return false;
                    }

                    public Object call(String string, Node node, Object[] objectArray) throws XSLException {
                        throw new XSLException("implementation of extension namespace not available");
                    }
                    {
                        this.this$0 = processContextImpl;
                        this.constructor$0(processContextImpl);
                    }

                    private final void constructor$0(ProcessContextImpl processContextImpl) {
                    }
                };
            }
            this.extensionTable.put(string, extensionContext);
        }
        return extensionContext;
    }

    public Variant getSystemProperty(Name name) {
        return this.sheet.getSystemProperty(name);
    }

    public Node getCurrent(Node node) {
        return node;
    }

    public void useAttributeSet(Name name, Node node, Result result) throws XSLException {
        try {
            Action action = this.sheet.getAttributeSet(name);
            if (action == null) {
                return;
            }
            boolean[] blArray = (boolean[])this.attributeSetInUseTable.get(name);
            if (blArray == null) {
                blArray = new boolean[1];
                this.attributeSetInUseTable.put(name, blArray);
            }
            if (blArray[0]) {
                throw new XSLException("circular attribute set usage", node);
            }
            blArray[0] = true;
            try {
                action.invoke(this, node, result);
            }
            finally {
                Object var7_7 = null;
                blArray[0] = false;
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    public NodeIterator getDocument(URL uRL, String string) throws XSLException {
        int n = string.indexOf(35);
        String string2 = null;
        if (n >= 0) {
            string2 = string.substring(n + 1);
            string = string.substring(0, n);
        }
        try {
            URL uRL2 = string.length() == 0 ? uRL : new URL(uRL, string);
            Node node = (Node)this.documentTable.get(uRL2);
            if (node == null) {
                node = this.parser.load(uRL2, this.documentTable.size() + 1 + this.nResultFragmentNodes, this.sheet.getSourceLoadContext(), this.root.getNamespacePrefixMap().getNameTable());
                this.documentTable.put(uRL2, node);
            }
            return new SingleNodeIterator(node);
        }
        catch (MalformedURLException malformedURLException) {
            throw new XSLException(malformedURLException);
        }
        catch (IOException iOException) {
            throw new XSLException(iOException);
        }
    }

    public Name unaliasName(Name name) {
        if (this.nameAliasTable == null) {
            return name;
        }
        Name name2 = (Name)this.nameAliasTable.get(name);
        if (name2 == null) {
            String string = this.sheet.getNamespaceAlias(name.getNamespace());
            name2 = string == null ? name : this.nameTable.createName(name.toString(), string);
        }
        this.nameAliasTable.put(name, name2);
        return name2;
    }

    public NamespacePrefixMap unaliasNamespacePrefixMap(NamespacePrefixMap namespacePrefixMap) {
        if (this.namespacePrefixMapAliasTable == null) {
            return namespacePrefixMap;
        }
        NamespacePrefixMap namespacePrefixMap2 = (NamespacePrefixMap)this.namespacePrefixMapAliasTable.get(namespacePrefixMap);
        if (namespacePrefixMap2 == null) {
            namespacePrefixMap2 = namespacePrefixMap;
            String string = this.sheet.getNamespaceAlias(namespacePrefixMap.getDefaultNamespace());
            if (string != null) {
                namespacePrefixMap2 = namespacePrefixMap2.bindDefault(string);
            }
            int n = namespacePrefixMap.getSize();
            int n2 = 0;
            while (n2 < n) {
                string = this.sheet.getNamespaceAlias(namespacePrefixMap.getNamespace(n2));
                if (string != null) {
                    namespacePrefixMap2 = namespacePrefixMap2.bind(namespacePrefixMap.getPrefix(n2), string);
                }
                ++n2;
            }
        }
        this.namespacePrefixMapAliasTable.put(namespacePrefixMap, namespacePrefixMap2);
        return namespacePrefixMap2;
    }

    public void put(Object object, Object object2) {
        this.objectTable.put(object, object2);
    }

    public Object get(Object object) {
        return this.objectTable.get(object);
    }

    public Node getTree(Variant variant) throws XSLException {
        if (!(variant instanceof ResultFragmentVariant)) {
            return null;
        }
        return ((ResultFragmentVariant)variant).getTree(this);
    }

    public Result createNodeResult(Node node, Node[] nodeArray) throws XSLException {
        return this.parser.createResult(node, this.documentTable.size() + ++this.nResultFragmentNodes, this.sheet.getSourceLoadContext(), nodeArray);
    }

    static /* synthetic */ Name[] access$0(ProcessContextImpl processContextImpl) {
        return processContextImpl.currentParamNames;
    }

    static /* synthetic */ void access$1(ProcessContextImpl processContextImpl, Name[] nameArray) {
        processContextImpl.currentParamNames = nameArray;
    }

    static /* synthetic */ Variant[] access$2(ProcessContextImpl processContextImpl) {
        return processContextImpl.currentParamValues;
    }

    static /* synthetic */ void access$3(ProcessContextImpl processContextImpl, Variant[] variantArray) {
        processContextImpl.currentParamValues = variantArray;
    }

    static /* synthetic */ int access$4(ProcessContextImpl processContextImpl) {
        return processContextImpl.position;
    }

    static /* synthetic */ void access$5(ProcessContextImpl processContextImpl, int n) {
        processContextImpl.position = n;
    }

    static /* synthetic */ int access$6(ProcessContextImpl processContextImpl) {
        return processContextImpl.lastPosition;
    }

    static /* synthetic */ void access$7(ProcessContextImpl processContextImpl, int n) {
        processContextImpl.lastPosition = n;
    }

    static /* synthetic */ NodeIterator access$8(ProcessContextImpl processContextImpl) {
        return processContextImpl.currentIter;
    }

    static /* synthetic */ void access$9(ProcessContextImpl processContextImpl, NodeIterator nodeIterator) {
        processContextImpl.currentIter = nodeIterator;
    }

    static /* synthetic */ VariableBindings access$10(ProcessContextImpl processContextImpl) {
        return processContextImpl.localVariables;
    }

    static /* synthetic */ void access$11(ProcessContextImpl processContextImpl, VariableBindings variableBindings) {
        processContextImpl.localVariables = variableBindings;
    }

    static /* synthetic */ Hashtable access$12(ProcessContextImpl processContextImpl) {
        return processContextImpl.variableValueTable;
    }

    ProcessContextImpl(SheetDetails sheetDetails, Node node, XMLProcessor xMLProcessor, ParameterSet parameterSet) {
        this.sheet = sheetDetails;
        this.root = node;
        this.parser = xMLProcessor;
        this.params = parameterSet;
        if (sheetDetails.haveNamespaceAliases()) {
            this.nameAliasTable = new Hashtable();
            this.namespacePrefixMapAliasTable = new Hashtable();
        } else {
            this.nameAliasTable = null;
            this.namespacePrefixMapAliasTable = null;
        }
        this.nameTable = node.getNamespacePrefixMap().getNameTable();
    }

    static final class VariableBindings {
        final VariableBindings next;
        final Variant value;
        final Name name;

        VariableBindings(Name name, Variant variant, VariableBindings variableBindings) {
            this.name = name;
            this.value = variant;
            this.next = variableBindings;
        }
    }
}

