/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.tr;

import com.jclark.xsl.expr.BooleanExpr;
import com.jclark.xsl.expr.EmptyVariableSet;
import com.jclark.xsl.expr.ExprParser;
import com.jclark.xsl.expr.ExtensionContext;
import com.jclark.xsl.expr.NodeSetExpr;
import com.jclark.xsl.expr.NumberVariant;
import com.jclark.xsl.expr.StringExpr;
import com.jclark.xsl.expr.StringVariant;
import com.jclark.xsl.expr.TopLevelPattern;
import com.jclark.xsl.expr.VariableSet;
import com.jclark.xsl.expr.Variant;
import com.jclark.xsl.expr.VariantExpr;
import com.jclark.xsl.om.Name;
import com.jclark.xsl.om.NameTable;
import com.jclark.xsl.om.NamespacePrefixMap;
import com.jclark.xsl.om.Node;
import com.jclark.xsl.om.NodeIterator;
import com.jclark.xsl.om.SafeNodeIterator;
import com.jclark.xsl.om.XSLException;
import com.jclark.xsl.tr.Action;
import com.jclark.xsl.tr.AddVariableSet;
import com.jclark.xsl.tr.AnyLevelNumberAction;
import com.jclark.xsl.tr.AppendAction;
import com.jclark.xsl.tr.ApplyImportsAction;
import com.jclark.xsl.tr.AttributeAction;
import com.jclark.xsl.tr.BilevelComparatorTemplate;
import com.jclark.xsl.tr.BindLocalParamAction;
import com.jclark.xsl.tr.BindLocalVariableAction;
import com.jclark.xsl.tr.BuiltinAction;
import com.jclark.xsl.tr.CharsAction;
import com.jclark.xsl.tr.CommentAction;
import com.jclark.xsl.tr.ComparatorTemplate;
import com.jclark.xsl.tr.CopyAction;
import com.jclark.xsl.tr.CopyOfAction;
import com.jclark.xsl.tr.DocumentAction;
import com.jclark.xsl.tr.ElementAction;
import com.jclark.xsl.tr.EmptyAction;
import com.jclark.xsl.tr.ExprNumberAction;
import com.jclark.xsl.tr.ExtensionHandler;
import com.jclark.xsl.tr.ForEachAction;
import com.jclark.xsl.tr.IfAction;
import com.jclark.xsl.tr.Importance;
import com.jclark.xsl.tr.ImportantBoolean;
import com.jclark.xsl.tr.InvokeAction;
import com.jclark.xsl.tr.Lang;
import com.jclark.xsl.tr.LiteralAttributeAction;
import com.jclark.xsl.tr.LiteralElementAction;
import com.jclark.xsl.tr.LoadContext;
import com.jclark.xsl.tr.MessageAction;
import com.jclark.xsl.tr.MultiLevelNumberAction;
import com.jclark.xsl.tr.NodeComparatorTemplate;
import com.jclark.xsl.tr.NumberListFormatTemplate;
import com.jclark.xsl.tr.OutputMethod;
import com.jclark.xsl.tr.ParamAction;
import com.jclark.xsl.tr.ParameterSet;
import com.jclark.xsl.tr.Priority;
import com.jclark.xsl.tr.ProcessAction;
import com.jclark.xsl.tr.ProcessContextImpl;
import com.jclark.xsl.tr.ProcessingInstructionAction;
import com.jclark.xsl.tr.RawCharsAction;
import com.jclark.xsl.tr.RawValueOfAction;
import com.jclark.xsl.tr.Result;
import com.jclark.xsl.tr.ResultFragmentExpr;
import com.jclark.xsl.tr.SheetDetails;
import com.jclark.xsl.tr.SingleLevelNumberAction;
import com.jclark.xsl.tr.SortNodeSetExpr;
import com.jclark.xsl.tr.TemplateAttributeAction;
import com.jclark.xsl.tr.TemplateRuleSet;
import com.jclark.xsl.tr.TerminateMessageAction;
import com.jclark.xsl.tr.UnbindLocalVariablesAction;
import com.jclark.xsl.tr.UseAttributeSetAction;
import com.jclark.xsl.tr.ValueOfAction;
import com.jclark.xsl.tr.VariableInfo;
import com.jclark.xsl.tr.XMLProcessor;
import com.jclark.xsl.util.Comparator;
import com.jclark.xsl.util.NumberComparator;
import com.jclark.xsl.util.ReverseComparator;
import com.jclark.xsl.util.TextComparator;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;

class SheetImpl
implements SheetDetails,
LoadContext {
    private static final Action emptyAction = new EmptyAction();
    static NodeSetExpr childrenExpr = ExprParser.getChildrenExpr();
    static StringVariant emptyStringVariant = new StringVariant("");
    static final String XSL_NAMESPACE = "http://www.w3.org/1999/XSL/Transform";
    static final String XT_NAMESPACE = "http://www.jclark.com/xt";
    private ImportantBoolean stripSource = null;
    private Hashtable stripSourceElementTable = null;
    private Hashtable stripSourceNamespaceTable = null;
    private TemplateRuleSet templateRules = new TemplateRuleSet(new BuiltinAction());
    private Hashtable modeTable = new Hashtable();
    private Hashtable namedTemplateTable = new Hashtable();
    private Hashtable variableInfoTable = new Hashtable();
    private Hashtable attributeSetTable = new Hashtable();
    private Hashtable namespaceAliasTable = new Hashtable();
    private Vector idAttributes = new Vector();
    private Hashtable topLevelTable = new Hashtable();
    private Hashtable actionTable = new Hashtable();
    Importance currentImportance = Importance.create();
    Importance firstImportImportance = Importance.create();
    VariableSet currentLocalVariables = new EmptyVariableSet();
    int nCurrentLocalVariables = 0;
    Vector excludedNamespaces;
    XMLProcessor parser;
    Name XSL_WHEN;
    Name XSL_OTHERWISE;
    Name XSL_STYLESHEET;
    Name XSL_TRANSFORM;
    Name XSL_WITH_PARAM;
    Name XSL_SORT;
    Name XSL_FOR_EACH;
    Name XSL_FALLBACK;
    Name XSL_VERSION;
    Name XSL_VENDOR;
    Name XSL_VENDOR_URL;
    Name XSL_USE_ATTRIBUTE_SETS;
    Name XSL_ATTRIBUTE;
    Name HREF;
    Name MATCH;
    Name PRIORITY;
    Name SELECT;
    Name TEST;
    Name METHOD;
    Name CDATA_SECTION_ELEMENTS;
    Name NAME;
    Name NAMESPACE;
    Name DEFAULT;
    Name VALUE;
    Name ELEMENTS;
    Name ATTRIBUTE;
    Name FROM;
    Name COUNT;
    Name LEVEL;
    Name FORMAT;
    Name LETTER_VALUE;
    Name GROUPING_SIZE;
    Name GROUPING_SEPARATOR;
    Name MODE;
    Name ORDER;
    Name LANG;
    Name CASE_ORDER;
    Name DATA_TYPE;
    Name DISABLE_OUTPUT_ESCAPING;
    Name USE_ATTRIBUTE_SETS;
    Name EXCLUDE_RESULT_PREFIXES;
    Name RESULT_PREFIX;
    Name STYLESHEET_PREFIX;
    Name TERMINATE;
    LoadContext sheetLoadContext;
    NameTable nameTable;
    ExtensionHandler extensionHandler;
    OutputMethodImpl outputMethod;

    public Result process(Node node, XMLProcessor xMLProcessor, ParameterSet parameterSet, Result result) throws XSLException {
        result.start(this.outputMethod);
        new ProcessContextImpl(this, node, xMLProcessor, parameterSet).processSafe(node, null, result);
        result.end();
        return result;
    }

    private void parseSheet(Node node) throws XSLException, IOException {
        Node node2 = node.getChildren().next();
        if (XSL_NAMESPACE.equals(node2.getName().getNamespace())) {
            if (!this.XSL_STYLESHEET.equals(node2.getName()) && !this.XSL_TRANSFORM.equals(node2.getName())) {
                throw new XSLException("bad document element for stylesheet", node2);
            }
            this.parseTopLevel(node2);
        } else {
            this.parseRootTemplate(node);
        }
        this.templateRules.compile();
        Enumeration enumeration = this.modeTable.elements();
        while (enumeration.hasMoreElements()) {
            ((TemplateRuleSet)enumeration.nextElement()).compile();
        }
    }

    private Vector getExcludedNamespaces(Node node) throws XSLException {
        String string = node.getAttributeValue(this.EXCLUDE_RESULT_PREFIXES);
        if (string == null) {
            return null;
        }
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreElements()) {
            String string2 = (String)stringTokenizer.nextElement();
            if (string2 == null) break;
            vector.addElement(this.getPrefixNamespace(node, string2));
        }
        if (vector.size() == 0) {
            return null;
        }
        return vector;
    }

    String getPrefixNamespace(Node node, String string) throws XSLException {
        NamespacePrefixMap namespacePrefixMap = node.getNamespacePrefixMap();
        String string2 = namespacePrefixMap.getNamespace(string);
        if (string2 == null) {
            if (string.equals("#default")) {
                string2 = namespacePrefixMap.getDefaultNamespace();
            }
            if (string2 == null) {
                throw new XSLException("undefined prefix", node);
            }
        }
        return string2;
    }

    void parseTopLevel(Node node) throws XSLException, IOException {
        Node node2;
        Vector vector = this.excludedNamespaces;
        this.excludedNamespaces = this.getExcludedNamespaces(node);
        SafeNodeIterator safeNodeIterator = node.getChildren();
        while ((node2 = safeNodeIterator.next()) != null) {
            TopLevelParser topLevelParser = null;
            try {
                Name name = node2.getName();
                if (name == null) {
                    throw new XSLException("illegal data characters inside xsl:stylesheet", node2);
                }
                topLevelParser = (TopLevelParser)this.topLevelTable.get(name);
                if (topLevelParser == null && name.getNamespace() == null) {
                    throw new XSLException("illegal top-level element", node2);
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            if (topLevelParser == null) continue;
            topLevelParser.parse(node2);
        }
        this.excludedNamespaces = vector;
    }

    void parseRootTemplate(Node node) throws XSLException {
        this.templateRules.add(ExprParser.parsePattern(node, "/"), this.currentImportance, this.firstImportImportance, null, this.parseActions(node, emptyAction));
    }

    Action parseAttributesAndActions(Node node) throws XSLException {
        Node node2;
        AppendAction appendAction = this.parseUseAttributeSets(node, true, null);
        SafeNodeIterator safeNodeIterator = node.getAttributes();
        while ((node2 = safeNodeIterator.next()) != null) {
            if (appendAction == null) {
                appendAction = new AppendAction();
            }
            String string = node2.getData();
            Name name = node2.getName();
            if (XSL_NAMESPACE.equals(name.getNamespace())) continue;
            if (string.indexOf(123) >= 0 || string.indexOf(125) >= 0) {
                appendAction.add(new TemplateAttributeAction(name, ExprParser.parseAttributeValueTemplate(node, string, this.currentLocalVariables)));
                continue;
            }
            appendAction.add(new LiteralAttributeAction(name, string));
        }
        return this.parseActions(node, null, appendAction);
    }

    Action parseUseAttributeSetsAndActions(Node node) throws XSLException {
        return this.parseActions(node, emptyAction, this.parseUseAttributeSets(node, false, null));
    }

    AppendAction parseUseAttributeSets(Node node, boolean bl, AppendAction appendAction) throws XSLException {
        String string = node.getAttributeValue(bl ? this.XSL_USE_ATTRIBUTE_SETS : this.USE_ATTRIBUTE_SETS);
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            while (stringTokenizer.hasMoreElements()) {
                if (appendAction == null) {
                    appendAction = new AppendAction();
                }
                appendAction.add(new UseAttributeSetAction(SheetImpl.expandSourceElementTypeName((String)stringTokenizer.nextElement(), node)));
            }
        }
        return appendAction;
    }

    Action parseActions(Node node, Action action) throws XSLException {
        return this.parseActions(node, action, null);
    }

    Action parseActions(Node node, Action action, AppendAction appendAction) throws XSLException {
        VariableSet variableSet = this.currentLocalVariables;
        int n = this.nCurrentLocalVariables;
        SafeNodeIterator safeNodeIterator = node.getChildren();
        if ((node = safeNodeIterator.next()) == null) {
            if (appendAction == null) {
                return action;
            }
            return appendAction;
        }
        if (appendAction == null) {
            appendAction = new AppendAction();
        }
        block6: do {
            switch (node.getType()) {
                case 1: {
                    appendAction.add(new CharsAction(node.getData()));
                    break;
                }
                case 0: {
                    Name name = node.getName();
                    String string = name.getNamespace();
                    if (!XSL_NAMESPACE.equals(string) && !XT_NAMESPACE.equals(string)) {
                        appendAction.add(new LiteralElementAction(node.getName(), this.literalNamespacePrefixMap(node), this.parseAttributesAndActions(node)));
                        break;
                    }
                    ActionParser actionParser = null;
                    try {
                        actionParser = (ActionParser)this.actionTable.get(name);
                    }
                    catch (ClassCastException classCastException) {
                        // empty catch block
                    }
                    if (actionParser == null) {
                        if (name.equals(this.XSL_SORT) && this.XSL_FOR_EACH.equals(node.getParent().getName()) || name.equals(this.XSL_FALLBACK)) continue block6;
                        throw new XSLException("expected action not " + name, node);
                    }
                    appendAction.add(actionParser.parse(node));
                }
            }
        } while ((node = safeNodeIterator.next()) != null);
        if (n != this.nCurrentLocalVariables) {
            appendAction.add(new UnbindLocalVariablesAction(this.nCurrentLocalVariables - n));
            this.nCurrentLocalVariables = n;
            this.currentLocalVariables = variableSet;
        }
        return appendAction;
    }

    String getRequiredAttribute(Node node, Name name) throws XSLException {
        String string = node.getAttributeValue(name);
        if (string == null) {
            throw new XSLException("missing attribute \"" + name + "\"", node);
        }
        return string;
    }

    String getOptionalAttribute(Node node, Name name, String string) {
        String string2 = node.getAttributeValue(name);
        return string2 == null ? string : string2;
    }

    String getData(Node node) throws XSLException {
        if ((node = node.getChildren().next()) == null) {
            return "";
        }
        String string = node.getData();
        if (string == null) {
            throw new XSLException("only character data allowed", node);
        }
        return string;
    }

    NumberListFormatTemplate getNumberListFormatTemplate(Node node) throws XSLException {
        NumberListFormatTemplate numberListFormatTemplate = new NumberListFormatTemplate();
        String string = node.getAttributeValue(this.FORMAT);
        if (string != null) {
            StringExpr stringExpr = ExprParser.parseAttributeValueTemplate(node, string, this.currentLocalVariables);
            String string2 = stringExpr.constantValue();
            if (string2 != null) {
                numberListFormatTemplate.setFormat(string2);
            } else {
                numberListFormatTemplate.setFormat(stringExpr);
            }
        }
        if ((string = node.getAttributeValue(this.LANG)) != null) {
            numberListFormatTemplate.setLang(string);
        }
        if ((string = node.getAttributeValue(this.LETTER_VALUE)) != null) {
            numberListFormatTemplate.setLetterValue(string);
        }
        if ((string = node.getAttributeValue(this.GROUPING_SIZE)) != null) {
            try {
                numberListFormatTemplate.setGroupingSize(Integer.parseInt(string));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((string = node.getAttributeValue(this.GROUPING_SEPARATOR)) != null) {
            numberListFormatTemplate.setGroupingSeparator(string);
        }
        return numberListFormatTemplate;
    }

    Action addParams(ParamAction paramAction, Node node) throws XSLException {
        SafeNodeIterator safeNodeIterator = node.getChildren();
        while ((node = safeNodeIterator.next()) != null) {
            if (!this.XSL_WITH_PARAM.equals(node.getName())) continue;
            paramAction.addParam(SheetImpl.expandSourceElementTypeName(this.getRequiredAttribute(node, this.NAME), node), this.getVariantExpr(node));
        }
        return paramAction;
    }

    NodeSetExpr getSortNodeSetExpr(Node node, NodeSetExpr nodeSetExpr) throws XSLException {
        ComparatorTemplate comparatorTemplate = null;
        SafeNodeIterator safeNodeIterator = node.getChildren();
        while ((node = safeNodeIterator.next()) != null) {
            Comparator comparator;
            if (!this.XSL_SORT.equals(node.getName())) continue;
            Locale locale = Lang.getLocale(node.getAttributeValue(this.LANG));
            String string = node.getAttributeValue(this.DATA_TYPE);
            if ("number".equals(string)) {
                comparator = new NumberComparator();
            } else {
                int n = 0;
                String string2 = node.getAttributeValue(this.CASE_ORDER);
                if ("upper-first".equals(string2)) {
                    n = 1;
                } else if ("lower-first".equals(string2)) {
                    n = 2;
                }
                comparator = TextComparator.create(locale, n);
            }
            if ("descending".equals(node.getAttributeValue(this.ORDER))) {
                comparator = new ReverseComparator(comparator);
            }
            NodeComparatorTemplate nodeComparatorTemplate = new NodeComparatorTemplate(comparator, ExprParser.parseStringExpr(node, this.getOptionalAttribute(node, this.SELECT, "."), this.currentLocalVariables));
            if (comparatorTemplate == null) {
                comparatorTemplate = nodeComparatorTemplate;
                continue;
            }
            comparatorTemplate = new BilevelComparatorTemplate(comparatorTemplate, nodeComparatorTemplate);
        }
        if (comparatorTemplate == null) {
            return nodeSetExpr;
        }
        return new SortNodeSetExpr(nodeSetExpr, comparatorTemplate);
    }

    VariantExpr getVariantExpr(Node node) throws XSLException {
        String string = node.getAttributeValue(this.SELECT);
        if (node.getChildren().next() == null) {
            if (string == null) {
                string = "\"\"";
            }
        } else {
            if (string != null) {
                throw new XSLException("non-empty content with select attribute", node);
            }
            return new ResultFragmentExpr(this.parseActions(node, emptyAction), node, this.extensionHandler);
        }
        return ExprParser.parseVariantExpr(node, string, this.currentLocalVariables);
    }

    public TemplateRuleSet getModeTemplateRuleSet(Name name) {
        if (name == null) {
            return this.templateRules;
        }
        TemplateRuleSet templateRuleSet = (TemplateRuleSet)this.modeTable.get(name);
        if (templateRuleSet == null) {
            templateRuleSet = new TemplateRuleSet(new BuiltinAction(name));
            this.modeTable.put(name, templateRuleSet);
        }
        return templateRuleSet;
    }

    private Name xsl(String string) {
        return this.nameTable.createName("xsl:" + string, XSL_NAMESPACE);
    }

    private Name xt(String string) {
        return this.nameTable.createName("xt:" + string, XT_NAMESPACE);
    }

    private boolean namespaceExcluded(String string) {
        if (string == null) {
            return false;
        }
        if (string.equals(XSL_NAMESPACE) || string.equals(XT_NAMESPACE)) {
            return true;
        }
        if (this.excludedNamespaces == null) {
            return false;
        }
        int n = this.excludedNamespaces.size();
        int n2 = 0;
        while (n2 < n) {
            if (this.excludedNamespaces.elementAt(n2).equals(string)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private NamespacePrefixMap literalNamespacePrefixMap(Node node) {
        NamespacePrefixMap namespacePrefixMap;
        NamespacePrefixMap namespacePrefixMap2 = namespacePrefixMap = node.getNamespacePrefixMap();
        String string = namespacePrefixMap.getDefaultNamespace();
        if (this.namespaceExcluded(string)) {
            namespacePrefixMap2 = namespacePrefixMap2.unbindDefault();
        }
        int n = namespacePrefixMap.getSize();
        int n2 = 0;
        while (n2 < n) {
            string = namespacePrefixMap.getNamespace(n2);
            if (this.namespaceExcluded(string)) {
                namespacePrefixMap2 = namespacePrefixMap2.unbind(namespacePrefixMap.getPrefix(n2));
            }
            ++n2;
        }
        return namespacePrefixMap2;
    }

    static Name expandSourceElementTypeName(String string, Node node) throws XSLException {
        return node.getNamespacePrefixMap().expandAttributeName(string, node);
    }

    public LoadContext getSourceLoadContext() {
        return this;
    }

    public boolean getStripSource(Name name) {
        ImportantBoolean importantBoolean;
        Object object;
        Object object2 = this.stripSource;
        if (this.stripSourceNamespaceTable != null && (object = name.getNamespace()) != null && (importantBoolean = (ImportantBoolean)this.stripSourceNamespaceTable.get(object)) != null && (object2 == null || importantBoolean.getImportance().compareTo(((ImportantBoolean)object2).getImportance()) >= 0)) {
            object2 = importantBoolean;
        }
        if (this.stripSourceElementTable != null && (object = (ImportantBoolean)this.stripSourceElementTable.get(name)) != null && (object2 == null || ((ImportantBoolean)object).getImportance().compareTo(((ImportantBoolean)object2).getImportance()) >= 0)) {
            object2 = object;
        }
        return object2 != null ? ((ImportantBoolean)object2).getBoolean() : false;
    }

    public boolean getIncludeComments() {
        return true;
    }

    public boolean getIncludeProcessingInstructions() {
        return true;
    }

    public VariableInfo getGlobalVariableInfo(Name name) {
        return (VariableInfo)this.variableInfoTable.get(name);
    }

    public Variant getSystemProperty(Name name) {
        if (name.equals(this.XSL_VERSION)) {
            return new NumberVariant(1.0);
        }
        if (name.equals(this.XSL_VENDOR)) {
            return new StringVariant("James Clark");
        }
        if (name.equals(this.XSL_VENDOR_URL)) {
            return new StringVariant("http://www.jclark.com/");
        }
        return emptyStringVariant;
    }

    public ExtensionContext createExtensionContext(String string) throws XSLException {
        return this.extensionHandler.createContext(string);
    }

    public Action getAttributeSet(Name name) {
        return (Action)this.attributeSetTable.get(name);
    }

    public boolean haveNamespaceAliases() {
        return this.namespaceAliasTable.size() != 0;
    }

    public String getNamespaceAlias(String string) {
        if (string == null) {
            return null;
        }
        return (String)this.namespaceAliasTable.get(string);
    }

    static /* synthetic */ ImportantBoolean access$5(SheetImpl sheetImpl) {
        return sheetImpl.stripSource;
    }

    SheetImpl(Node node, XMLProcessor xMLProcessor, ExtensionHandler extensionHandler, LoadContext loadContext, NameTable nameTable) throws IOException, XSLException {
        SheetImpl sheetImpl = this;
        if (sheetImpl == null) {
            throw null;
        }
        this.outputMethod = sheetImpl.new OutputMethodImpl();
        this.sheetLoadContext = loadContext;
        this.nameTable = nameTable;
        this.parser = xMLProcessor;
        this.extensionHandler = extensionHandler;
        this.XSL_WHEN = this.xsl("when");
        this.XSL_OTHERWISE = this.xsl("otherwise");
        this.XSL_STYLESHEET = this.xsl("stylesheet");
        this.XSL_TRANSFORM = this.xsl("transform");
        this.XSL_WITH_PARAM = this.xsl("with-param");
        this.XSL_SORT = this.xsl("sort");
        this.XSL_FOR_EACH = this.xsl("for-each");
        this.XSL_FALLBACK = this.xsl("fallback");
        this.XSL_VERSION = this.xsl("version");
        this.XSL_VENDOR = this.xsl("vendor");
        this.XSL_VENDOR_URL = this.xsl("vendor-url");
        this.XSL_USE_ATTRIBUTE_SETS = this.xsl("use-attribute-sets");
        this.XSL_ATTRIBUTE = this.xsl("attribute");
        this.HREF = nameTable.createName("href");
        this.SELECT = nameTable.createName("select");
        this.TEST = nameTable.createName("test");
        this.MATCH = nameTable.createName("match");
        this.PRIORITY = nameTable.createName("priority");
        this.METHOD = nameTable.createName("method");
        this.CDATA_SECTION_ELEMENTS = nameTable.createName("cdata-section-elements");
        this.NAME = nameTable.createName("name");
        this.NAMESPACE = nameTable.createName("namespace");
        this.DEFAULT = nameTable.createName("default");
        this.VALUE = nameTable.createName("value");
        this.ELEMENTS = nameTable.createName("elements");
        this.ATTRIBUTE = nameTable.createName("attribute");
        this.COUNT = nameTable.createName("count");
        this.LEVEL = nameTable.createName("level");
        this.FROM = nameTable.createName("from");
        this.FORMAT = nameTable.createName("format");
        this.LETTER_VALUE = nameTable.createName("letter-value");
        this.GROUPING_SIZE = nameTable.createName("grouping-size");
        this.GROUPING_SEPARATOR = nameTable.createName("grouping-separator");
        this.MODE = nameTable.createName("mode");
        this.ORDER = nameTable.createName("order");
        this.LANG = nameTable.createName("lang");
        this.DATA_TYPE = nameTable.createName("data-type");
        this.CASE_ORDER = nameTable.createName("case-order");
        this.DISABLE_OUTPUT_ESCAPING = nameTable.createName("disable-output-escaping");
        this.USE_ATTRIBUTE_SETS = nameTable.createName("use-attribute-sets");
        this.EXCLUDE_RESULT_PREFIXES = nameTable.createName("exclude-result-prefixes");
        this.STYLESHEET_PREFIX = nameTable.createName("stylesheet-prefix");
        this.RESULT_PREFIX = nameTable.createName("result-prefix");
        this.TERMINATE = nameTable.createName("terminate");
        SheetImpl sheetImpl2 = this;
        if (sheetImpl2 == null) {
            throw null;
        }
        this.topLevelTable.put(this.xsl("include"), sheetImpl2.new IncludeParser());
        SheetImpl sheetImpl3 = this;
        if (sheetImpl3 == null) {
            throw null;
        }
        this.topLevelTable.put(this.xsl("import"), sheetImpl3.new ImportParser());
        SheetImpl sheetImpl4 = this;
        if (sheetImpl4 == null) {
            throw null;
        }
        this.topLevelTable.put(this.xsl("template"), sheetImpl4.new TemplateParser());
        SheetImpl sheetImpl5 = this;
        if (sheetImpl5 == null) {
            throw null;
        }
        this.topLevelTable.put(this.xsl("attribute-set"), sheetImpl5.new AttributeSetParser());
        SheetImpl sheetImpl6 = this;
        if (sheetImpl6 == null) {
            throw null;
        }
        this.topLevelTable.put(this.xsl("decimal-format"), sheetImpl6.new DecimalFormatParser());
        SheetImpl sheetImpl7 = this;
        if (sheetImpl7 == null) {
            throw null;
        }
        this.topLevelTable.put(this.xsl("key"), sheetImpl7.new KeyParser());
        SheetImpl sheetImpl8 = this;
        if (sheetImpl8 == null) {
            throw null;
        }
        this.topLevelTable.put(this.xsl("variable"), sheetImpl8.new VariableTopLevelParser());
        SheetImpl sheetImpl9 = this;
        if (sheetImpl9 == null) {
            throw null;
        }
        this.topLevelTable.put(this.xsl("param"), sheetImpl9.new ParamTopLevelParser());
        SheetImpl sheetImpl10 = this;
        if (sheetImpl10 == null) {
            throw null;
        }
        this.topLevelTable.put(this.xsl("strip-space"), sheetImpl10.new StripSpaceParser());
        SheetImpl sheetImpl11 = this;
        if (sheetImpl11 == null) {
            throw null;
        }
        this.topLevelTable.put(this.xsl("preserve-space"), sheetImpl11.new PreserveSpaceParser());
        SheetImpl sheetImpl12 = this;
        if (sheetImpl12 == null) {
            throw null;
        }
        this.topLevelTable.put(this.xsl("output"), sheetImpl12.new OutputParser());
        SheetImpl sheetImpl13 = this;
        if (sheetImpl13 == null) {
            throw null;
        }
        this.topLevelTable.put(this.xsl("namespace-alias"), sheetImpl13.new NamespaceAliasParser());
        SheetImpl sheetImpl14 = this;
        if (sheetImpl14 == null) {
            throw null;
        }
        this.actionTable.put(this.xsl("text"), sheetImpl14.new TextParser());
        SheetImpl sheetImpl15 = this;
        if (sheetImpl15 == null) {
            throw null;
        }
        this.actionTable.put(this.xsl("apply-templates"), sheetImpl15.new ApplyTemplatesParser());
        SheetImpl sheetImpl16 = this;
        if (sheetImpl16 == null) {
            throw null;
        }
        this.actionTable.put(this.xsl("call-template"), sheetImpl16.new CallTemplateParser());
        SheetImpl sheetImpl17 = this;
        if (sheetImpl17 == null) {
            throw null;
        }
        this.actionTable.put(this.xsl("for-each"), sheetImpl17.new ForEachParser());
        SheetImpl sheetImpl18 = this;
        if (sheetImpl18 == null) {
            throw null;
        }
        this.actionTable.put(this.xsl("value-of"), sheetImpl18.new ValueOfParser());
        SheetImpl sheetImpl19 = this;
        if (sheetImpl19 == null) {
            throw null;
        }
        this.actionTable.put(this.xsl("number"), sheetImpl19.new NumberParser());
        SheetImpl sheetImpl20 = this;
        if (sheetImpl20 == null) {
            throw null;
        }
        this.actionTable.put(this.xsl("if"), sheetImpl20.new IfParser());
        SheetImpl sheetImpl21 = this;
        if (sheetImpl21 == null) {
            throw null;
        }
        this.actionTable.put(this.xsl("choose"), sheetImpl21.new ChooseParser());
        SheetImpl sheetImpl22 = this;
        if (sheetImpl22 == null) {
            throw null;
        }
        this.actionTable.put(this.xsl("copy"), sheetImpl22.new CopyParser());
        SheetImpl sheetImpl23 = this;
        if (sheetImpl23 == null) {
            throw null;
        }
        this.actionTable.put(this.xsl("copy-of"), sheetImpl23.new CopyOfParser());
        SheetImpl sheetImpl24 = this;
        if (sheetImpl24 == null) {
            throw null;
        }
        this.actionTable.put(this.xsl("comment"), sheetImpl24.new CommentParser());
        SheetImpl sheetImpl25 = this;
        if (sheetImpl25 == null) {
            throw null;
        }
        this.actionTable.put(this.xsl("processing-instruction"), sheetImpl25.new ProcessingInstructionParser());
        SheetImpl sheetImpl26 = this;
        if (sheetImpl26 == null) {
            throw null;
        }
        this.actionTable.put(this.xsl("element"), sheetImpl26.new ElementParser());
        SheetImpl sheetImpl27 = this;
        if (sheetImpl27 == null) {
            throw null;
        }
        this.actionTable.put(this.xsl("attribute"), sheetImpl27.new AttributeParser());
        SheetImpl sheetImpl28 = this;
        if (sheetImpl28 == null) {
            throw null;
        }
        this.actionTable.put(this.xsl("apply-imports"), sheetImpl28.new ApplyImportsParser());
        SheetImpl sheetImpl29 = this;
        if (sheetImpl29 == null) {
            throw null;
        }
        this.actionTable.put(this.xsl("variable"), sheetImpl29.new VariableActionParser());
        SheetImpl sheetImpl30 = this;
        if (sheetImpl30 == null) {
            throw null;
        }
        this.actionTable.put(this.xsl("param"), sheetImpl30.new ParamActionParser());
        SheetImpl sheetImpl31 = this;
        if (sheetImpl31 == null) {
            throw null;
        }
        this.actionTable.put(this.xsl("message"), sheetImpl31.new MessageParser());
        SheetImpl sheetImpl32 = this;
        if (sheetImpl32 == null) {
            throw null;
        }
        this.actionTable.put(this.xt("document"), sheetImpl32.new DocumentParser());
        this.parseSheet(node);
    }

    private static interface TopLevelParser {
        public void parse(Node var1) throws XSLException, IOException;
    }

    private class IncludeParser
    implements TopLevelParser {
        public void parse(Node node) throws XSLException, IOException {
            Node node2 = SheetImpl.this.parser.load(new URL(node.getURL(), SheetImpl.this.getRequiredAttribute(node, SheetImpl.this.HREF)), 0, SheetImpl.this.sheetLoadContext, SheetImpl.this.nameTable).getChildren().next();
            if (SheetImpl.XSL_NAMESPACE.equals(node2.getName().getNamespace())) {
                if (!SheetImpl.this.XSL_STYLESHEET.equals(node2.getName()) && !SheetImpl.this.XSL_TRANSFORM.equals(node2.getName())) {
                    throw new XSLException("bad document element for stylesheet", node2);
                }
                SheetImpl.this.parseTopLevel(node2);
            } else {
                SheetImpl.this.parseRootTemplate(node2);
            }
        }

        IncludeParser() {
        }
    }

    private class ImportParser
    extends IncludeParser {
        public void parse(Node node) throws XSLException, IOException {
            Importance importance = SheetImpl.this.firstImportImportance;
            SheetImpl.this.firstImportImportance = SheetImpl.this.currentImportance;
            super.parse(node);
            SheetImpl.this.currentImportance = SheetImpl.this.currentImportance.createHigher();
            SheetImpl.this.firstImportImportance = importance;
        }

        ImportParser() {
        }
    }

    private class TemplateParser
    implements TopLevelParser {
        public void parse(Node node) throws XSLException {
            String string;
            String string2 = node.getAttributeValue(SheetImpl.this.NAME);
            Action action = SheetImpl.this.parseActions(node, emptyAction);
            if (string2 != null) {
                SheetImpl.this.namedTemplateTable.put(SheetImpl.expandSourceElementTypeName(string2, node), action);
            }
            if ((string = node.getAttributeValue(SheetImpl.this.MATCH)) == null) {
                return;
            }
            String string3 = node.getAttributeValue(SheetImpl.this.MODE);
            TemplateRuleSet templateRuleSet = string3 != null ? SheetImpl.this.getModeTemplateRuleSet(SheetImpl.expandSourceElementTypeName(string3, node)) : SheetImpl.this.templateRules;
            try {
                templateRuleSet.add(ExprParser.parsePattern(node, string), SheetImpl.this.currentImportance, SheetImpl.this.firstImportImportance, Priority.create(node.getAttributeValue(SheetImpl.this.PRIORITY)), action);
            }
            catch (NumberFormatException numberFormatException) {
                throw new XSLException("invalid priority", node);
            }
        }

        TemplateParser() {
        }
    }

    private class AttributeSetParser
    implements TopLevelParser {
        public void parse(Node node) throws XSLException {
            Node node2;
            Name name = SheetImpl.expandSourceElementTypeName(SheetImpl.this.getRequiredAttribute(node, SheetImpl.this.NAME), node);
            AppendAction appendAction = (AppendAction)SheetImpl.this.attributeSetTable.get(name);
            if (appendAction == null) {
                appendAction = new AppendAction();
                SheetImpl.this.attributeSetTable.put(name, appendAction);
            }
            SheetImpl.this.parseUseAttributeSets(node, false, appendAction);
            SafeNodeIterator safeNodeIterator = node.getChildren();
            while ((node2 = safeNodeIterator.next()) != null) {
                if (SheetImpl.this.XSL_ATTRIBUTE.equals(node2.getName())) continue;
                throw new XSLException("only xsl:attribute allowed inside xsl:attribute-set", node2);
            }
            SheetImpl.this.parseActions(node, null, appendAction);
        }

        AttributeSetParser() {
        }
    }

    private class KeyParser
    implements TopLevelParser {
        public void parse(Node node) throws XSLException {
        }

        KeyParser() {
        }
    }

    private class DecimalFormatParser
    implements TopLevelParser {
        public void parse(Node node) throws XSLException {
        }

        DecimalFormatParser() {
        }
    }

    private class VariableTopLevelParser
    implements TopLevelParser {
        public void parse(Node node) throws XSLException {
            this.parse(node, false);
        }

        void parse(Node node, boolean bl) throws XSLException {
            SheetImpl.this.variableInfoTable.put(SheetImpl.expandSourceElementTypeName(SheetImpl.this.getRequiredAttribute(node, SheetImpl.this.NAME), node), new VariableInfo(SheetImpl.this.getVariantExpr(node), bl));
        }

        VariableTopLevelParser() {
        }
    }

    private class ParamTopLevelParser
    extends VariableTopLevelParser {
        public void parse(Node node) throws XSLException {
            this.parse(node, true);
        }

        ParamTopLevelParser() {
        }
    }

    private class StripSpaceParser
    implements TopLevelParser {
        public void parse(Node node) throws XSLException {
            this.parse(node, true);
        }

        void parse(Node node, boolean bl) throws XSLException {
            StringTokenizer stringTokenizer = new StringTokenizer(SheetImpl.this.getRequiredAttribute(node, SheetImpl.this.ELEMENTS));
            ImportantBoolean importantBoolean = new ImportantBoolean(bl, SheetImpl.this.currentImportance);
            while (stringTokenizer.hasMoreElements()) {
                String string = (String)stringTokenizer.nextElement();
                Name name = SheetImpl.expandSourceElementTypeName(string, node);
                if (name.getLocalPart().equals("*")) {
                    String string2 = name.getNamespace();
                    if (string2 == null) {
                        SheetImpl.this.stripSource = importantBoolean;
                        continue;
                    }
                    if (SheetImpl.this.stripSourceNamespaceTable == null) {
                        SheetImpl.this.stripSourceNamespaceTable = new Hashtable();
                    }
                    SheetImpl.this.stripSourceNamespaceTable.put(string2, importantBoolean);
                    continue;
                }
                if (SheetImpl.this.stripSourceElementTable == null) {
                    SheetImpl.this.stripSourceElementTable = new Hashtable();
                }
                SheetImpl.this.stripSourceElementTable.put(name, importantBoolean);
            }
        }

        StripSpaceParser() {
        }
    }

    private class PreserveSpaceParser
    extends StripSpaceParser {
        public void parse(Node node) throws XSLException {
            this.parse(node, false);
        }

        PreserveSpaceParser() {
        }
    }

    private class OutputParser
    implements TopLevelParser {
        public void parse(Node node) throws XSLException {
            SheetImpl.this.outputMethod.merge(node);
        }

        OutputParser() {
        }
    }

    private class NamespaceAliasParser
    implements TopLevelParser {
        public void parse(Node node) throws XSLException {
            SheetImpl.this.namespaceAliasTable.put(SheetImpl.this.getPrefixNamespace(node, SheetImpl.this.getRequiredAttribute(node, SheetImpl.this.STYLESHEET_PREFIX)), SheetImpl.this.getPrefixNamespace(node, SheetImpl.this.getRequiredAttribute(node, SheetImpl.this.RESULT_PREFIX)));
        }

        NamespaceAliasParser() {
        }
    }

    private static interface ActionParser {
        public Action parse(Node var1) throws XSLException;
    }

    private class ApplyTemplatesParser
    implements ActionParser {
        public Action parse(Node node) throws XSLException {
            NodeSetExpr nodeSetExpr = SheetImpl.this.getSortNodeSetExpr(node, this.getNodeSetExpr(node));
            String string = node.getAttributeValue(SheetImpl.this.MODE);
            Name name = null;
            if (string != null) {
                name = SheetImpl.expandSourceElementTypeName(string, node);
            }
            return SheetImpl.this.addParams(new ProcessAction(nodeSetExpr, name), node);
        }

        NodeSetExpr getNodeSetExpr(Node node) throws XSLException {
            String string = node.getAttributeValue(SheetImpl.this.SELECT);
            if (string == null) {
                return childrenExpr;
            }
            return ExprParser.parseNodeSetExpr(node, string, SheetImpl.this.currentLocalVariables);
        }

        ApplyTemplatesParser() {
        }
    }

    private class ForEachParser
    implements ActionParser {
        public Action parse(Node node) throws XSLException {
            return new ForEachAction(SheetImpl.this.getSortNodeSetExpr(node, ExprParser.parseNodeSetExpr(node, SheetImpl.this.getRequiredAttribute(node, SheetImpl.this.SELECT), SheetImpl.this.currentLocalVariables)), SheetImpl.this.parseActions(node, emptyAction));
        }

        ForEachParser() {
        }
    }

    private class IfParser
    implements ActionParser {
        public Action parse(Node node) throws XSLException {
            return new IfAction(this.makeCondition(node), SheetImpl.this.parseActions(node, emptyAction), emptyAction);
        }

        BooleanExpr makeCondition(Node node) throws XSLException {
            return ExprParser.parseBooleanExpr(node, SheetImpl.this.getRequiredAttribute(node, SheetImpl.this.TEST), SheetImpl.this.currentLocalVariables);
        }

        IfParser() {
        }
    }

    private class CopyParser
    implements ActionParser {
        public Action parse(Node node) throws XSLException {
            return new CopyAction(SheetImpl.this.parseUseAttributeSetsAndActions(node));
        }

        CopyParser() {
        }
    }

    private class CopyOfParser
    implements ActionParser {
        public Action parse(Node node) throws XSLException {
            return new CopyOfAction(ExprParser.parseVariantExpr(node, SheetImpl.this.getRequiredAttribute(node, SheetImpl.this.SELECT), SheetImpl.this.currentLocalVariables));
        }

        CopyOfParser() {
        }
    }

    private class CommentParser
    implements ActionParser {
        public Action parse(Node node) throws XSLException {
            return new CommentAction(SheetImpl.this.parseActions(node, emptyAction));
        }

        CommentParser() {
        }
    }

    private class ProcessingInstructionParser
    implements ActionParser {
        public Action parse(Node node) throws XSLException {
            return new ProcessingInstructionAction(ExprParser.parseAttributeValueTemplate(node, SheetImpl.this.getRequiredAttribute(node, SheetImpl.this.NAME), SheetImpl.this.currentLocalVariables), SheetImpl.this.parseActions(node, emptyAction));
        }

        ProcessingInstructionParser() {
        }
    }

    private class ElementParser
    implements ActionParser {
        public Action parse(Node node) throws XSLException {
            return new ElementAction(ExprParser.parseAttributeValueTemplate(node, SheetImpl.this.getRequiredAttribute(node, SheetImpl.this.NAME), SheetImpl.this.currentLocalVariables), this.getNamespaceExpr(node), node.getNamespacePrefixMap(), SheetImpl.this.parseUseAttributeSetsAndActions(node));
        }

        StringExpr getNamespaceExpr(Node node) throws XSLException {
            String string = node.getAttributeValue(SheetImpl.this.NAMESPACE);
            if (string == null) {
                return null;
            }
            return ExprParser.parseAttributeValueTemplate(node, string, SheetImpl.this.currentLocalVariables);
        }

        ElementParser() {
        }
    }

    private class AttributeParser
    extends ElementParser {
        public Action parse(Node node) throws XSLException {
            return new AttributeAction(ExprParser.parseAttributeValueTemplate(node, SheetImpl.this.getRequiredAttribute(node, SheetImpl.this.NAME), SheetImpl.this.currentLocalVariables), this.getNamespaceExpr(node), node.getNamespacePrefixMap(), SheetImpl.this.parseActions(node, emptyAction));
        }

        AttributeParser() {
        }
    }

    private class DocumentParser
    implements ActionParser {
        public Action parse(Node node) throws XSLException {
            return new DocumentAction(ExprParser.parseAttributeValueTemplate(node, SheetImpl.this.getRequiredAttribute(node, SheetImpl.this.HREF), SheetImpl.this.currentLocalVariables), SheetImpl.this.outputMethod.mergeCopy(node), SheetImpl.this.parseActions(node, emptyAction));
        }

        DocumentParser() {
        }
    }

    private class CallTemplateParser
    implements ActionParser {
        public Action parse(Node node) throws XSLException {
            return SheetImpl.this.addParams(new InvokeAction(SheetImpl.expandSourceElementTypeName(SheetImpl.this.getRequiredAttribute(node, SheetImpl.this.NAME), node), SheetImpl.this.namedTemplateTable), node);
        }

        CallTemplateParser() {
        }
    }

    private class ChooseParser
    extends IfParser {
        public Action parse(Node node) throws XSLException {
            return this.parseChoices(node.getChildren());
        }

        public Action parseChoices(NodeIterator nodeIterator) throws XSLException {
            Node node = nodeIterator.next();
            if (node == null) {
                return emptyAction;
            }
            Name name = node.getName();
            if (SheetImpl.this.XSL_WHEN.equals(name)) {
                return new IfAction(this.makeCondition(node), SheetImpl.this.parseActions(node, emptyAction), this.parseChoices(nodeIterator));
            }
            if (SheetImpl.this.XSL_OTHERWISE.equals(name)) {
                Node node2 = nodeIterator.next();
                if (node2 != null) {
                    throw new XSLException("unexpected element after otherwise", node2);
                }
                return SheetImpl.this.parseActions(node, emptyAction);
            }
            throw new XSLException("expected when or otherwise", node);
        }

        ChooseParser() {
        }
    }

    private class TextParser
    implements ActionParser {
        public Action parse(Node node) throws XSLException {
            Node node2 = node.getChildren().next();
            if (node2 != null) {
                String string = node2.getData();
                if (string == null || node2.getFollowingSiblings().next() != null) {
                    throw new XSLException("xsl:text must not contain elements", node);
                }
                if ("yes".equals(node.getAttributeValue(SheetImpl.this.DISABLE_OUTPUT_ESCAPING))) {
                    return new RawCharsAction(string);
                }
                return new CharsAction(string);
            }
            return emptyAction;
        }

        TextParser() {
        }
    }

    private class ValueOfParser
    implements ActionParser {
        public Action parse(Node node) throws XSLException {
            StringExpr stringExpr = ExprParser.parseStringExpr(node, SheetImpl.this.getRequiredAttribute(node, SheetImpl.this.SELECT), SheetImpl.this.currentLocalVariables);
            if ("yes".equals(node.getAttributeValue(SheetImpl.this.DISABLE_OUTPUT_ESCAPING))) {
                return new RawValueOfAction(stringExpr);
            }
            return new ValueOfAction(stringExpr);
        }

        ValueOfParser() {
        }
    }

    private class NumberParser
    implements ActionParser {
        public Action parse(Node node) throws XSLException {
            NumberListFormatTemplate numberListFormatTemplate = SheetImpl.this.getNumberListFormatTemplate(node);
            String string = node.getAttributeValue(SheetImpl.this.VALUE);
            if (string != null) {
                return new ExprNumberAction(ExprParser.parseNumberExpr(node, string, SheetImpl.this.currentLocalVariables), numberListFormatTemplate);
            }
            String string2 = SheetImpl.this.getOptionalAttribute(node, SheetImpl.this.LEVEL, "single");
            String string3 = node.getAttributeValue(SheetImpl.this.COUNT);
            TopLevelPattern topLevelPattern = string3 == null ? null : ExprParser.parsePattern(node, string3, SheetImpl.this.currentLocalVariables);
            String string4 = node.getAttributeValue(SheetImpl.this.FROM);
            TopLevelPattern topLevelPattern2 = string4 == null ? null : ExprParser.parsePattern(node, string4, SheetImpl.this.currentLocalVariables);
            if (string2.equals("any")) {
                return new AnyLevelNumberAction(topLevelPattern, topLevelPattern2, numberListFormatTemplate);
            }
            if (string2.equals("multiple")) {
                return new MultiLevelNumberAction(topLevelPattern, topLevelPattern2, numberListFormatTemplate);
            }
            if (string2.equals("single")) {
                return new SingleLevelNumberAction(topLevelPattern, topLevelPattern2, numberListFormatTemplate);
            }
            throw new XSLException("bad level", node);
        }

        NumberParser() {
        }
    }

    private class ApplyImportsParser
    implements ActionParser {
        public Action parse(Node node) throws XSLException {
            return new ApplyImportsAction();
        }

        ApplyImportsParser() {
        }
    }

    private class VariableActionParser
    implements ActionParser {
        public Action parse(Node node) throws XSLException {
            Name name = SheetImpl.expandSourceElementTypeName(SheetImpl.this.getRequiredAttribute(node, SheetImpl.this.NAME), node);
            VariantExpr variantExpr = SheetImpl.this.getVariantExpr(node);
            SheetImpl.this.currentLocalVariables = new AddVariableSet(name, SheetImpl.this.currentLocalVariables);
            ++SheetImpl.this.nCurrentLocalVariables;
            return this.makeAction(name, variantExpr);
        }

        Action makeAction(Name name, VariantExpr variantExpr) {
            return new BindLocalVariableAction(name, variantExpr);
        }

        VariableActionParser() {
        }
    }

    private class ParamActionParser
    extends VariableActionParser {
        Action makeAction(Name name, VariantExpr variantExpr) {
            return new BindLocalParamAction(name, variantExpr);
        }

        ParamActionParser() {
        }
    }

    private class MessageParser
    implements ActionParser {
        public Action parse(Node node) throws XSLException {
            boolean bl = "yes".equals(node.getAttributeValue(SheetImpl.this.TERMINATE));
            Action action = SheetImpl.this.parseActions(node, emptyAction);
            if (bl) {
                return new TerminateMessageAction(action);
            }
            return new MessageAction(action);
        }

        MessageParser() {
        }
    }

    private class OutputMethodImpl
    implements OutputMethod,
    Cloneable {
        private Name outputMethodName = null;
        private Vector outputMethodAttributes = new Vector();
        private Vector outputCdataSectionElements = new Vector();

        OutputMethod mergeCopy(Node node) throws XSLException {
            SafeNodeIterator safeNodeIterator = node.getAttributes();
            if (safeNodeIterator.next() != null && safeNodeIterator.next() == null) {
                return this;
            }
            OutputMethodImpl outputMethodImpl = (OutputMethodImpl)this.clone();
            outputMethodImpl.merge(node);
            return outputMethodImpl;
        }

        public Object clone() {
            try {
                OutputMethodImpl outputMethodImpl = (OutputMethodImpl)super.clone();
                outputMethodImpl.outputCdataSectionElements = (Vector)this.outputCdataSectionElements.clone();
                outputMethodImpl.outputMethodAttributes = (Vector)this.outputMethodAttributes.clone();
                return outputMethodImpl;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new Error("unexpected CloneNotSupportedException");
            }
        }

        void merge(Node node) throws XSLException {
            Node node2;
            String string = node.getAttributeValue(SheetImpl.this.METHOD);
            if (string != null) {
                this.outputMethodName = node.getNamespacePrefixMap().expandAttributeName(string, node);
            }
            SafeNodeIterator safeNodeIterator = node.getAttributes();
            while ((node2 = safeNodeIterator.next()) != null) {
                Name name = node2.getName();
                String string2 = node2.getData();
                int n = this.outputMethodAttributes.indexOf(name);
                if (n >= 0) {
                    this.outputMethodAttributes.setElementAt(node2.getData(), n + 1);
                    continue;
                }
                if (name.equals(SheetImpl.this.CDATA_SECTION_ELEMENTS)) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string2);
                    while (stringTokenizer.hasMoreElements()) {
                        this.outputCdataSectionElements.addElement(node.getNamespacePrefixMap().expandAttributeName((String)stringTokenizer.nextElement(), node));
                    }
                    continue;
                }
                if (name.equals(SheetImpl.this.METHOD) || name.equals(SheetImpl.this.HREF)) continue;
                this.outputMethodAttributes.addElement(name);
                this.outputMethodAttributes.addElement(string2);
            }
        }

        public Name getName() {
            return this.outputMethodName;
        }

        public String getAttributeValue(Name name) {
            int n = this.outputMethodAttributes.size();
            int n2 = 0;
            while (n2 < n) {
                if (name.equals(this.outputMethodAttributes.elementAt(n2))) {
                    return (String)this.outputMethodAttributes.elementAt(n2 + 1);
                }
                n2 += 2;
            }
            return null;
        }

        public Name[] getAttributeNames() {
            Name[] nameArray = new Name[this.outputMethodAttributes.size() / 2];
            int n = 0;
            while (n < nameArray.length) {
                nameArray[n] = (Name)this.outputMethodAttributes.elementAt(n * 2);
                ++n;
            }
            return nameArray;
        }

        public Name[] getCdataSectionElements() {
            Name[] nameArray = new Name[this.outputCdataSectionElements.size()];
            int n = 0;
            while (n < nameArray.length) {
                nameArray[n] = (Name)this.outputCdataSectionElements.elementAt(n);
                ++n;
            }
            return nameArray;
        }

        public NameTable getNameTable() {
            return SheetImpl.this.nameTable;
        }

        OutputMethodImpl() {
        }
    }
}

