/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.Dimension;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import org.apache.batik.bridge.AbstractGraphicsNodeBridge;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.SVGGElementBridge;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.bridge.UnitProcessor;
import org.apache.batik.bridge.ViewBox;
import org.apache.batik.bridge.Viewport;
import org.apache.batik.ext.awt.image.renderable.ClipRable8Bit;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.gvt.CanvasGraphicsNode;
import org.apache.batik.gvt.CompositeGraphicsNode;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.parser.UnitProcessor;
import org.w3c.dom.Element;
import org.w3c.dom.events.MutationEvent;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGSVGElement;

public class SVGSVGElementBridge
extends SVGGElementBridge {
    public String getLocalName() {
        return "svg";
    }

    public Bridge getInstance() {
        return new SVGSVGElementBridge();
    }

    public GraphicsNode createGraphicsNode(BridgeContext bridgeContext, Element element) {
        Object object;
        AffineTransform affineTransform;
        String string;
        if (!SVGUtilities.matchUserAgent(element, bridgeContext.getUserAgent())) {
            return null;
        }
        CanvasGraphicsNode canvasGraphicsNode = new CanvasGraphicsNode();
        UnitProcessor.Context context = UnitProcessor.createContext(bridgeContext, element);
        SVGDocument sVGDocument = (SVGDocument)element.getOwnerDocument();
        boolean bl = sVGDocument.getRootElement() == element;
        float f = 0.0f;
        float f2 = 0.0f;
        if (!bl) {
            string = element.getAttributeNS(null, "x");
            if (string.length() != 0) {
                f = UnitProcessor.svgHorizontalCoordinateToUserSpace(string, "x", context);
            }
            if ((string = element.getAttributeNS(null, "y")).length() != 0) {
                f2 = UnitProcessor.svgVerticalCoordinateToUserSpace(string, "y", context);
            }
        }
        if ((string = element.getAttributeNS(null, "width")).length() == 0) {
            string = "100%";
        }
        float f3 = UnitProcessor.svgHorizontalLengthToUserSpace(string, "width", context);
        string = element.getAttributeNS(null, "height");
        if (string.length() == 0) {
            string = "100%";
        }
        float f4 = UnitProcessor.svgVerticalLengthToUserSpace(string, "height", context);
        canvasGraphicsNode.setVisible(CSSUtilities.convertVisibility(element));
        AffineTransform affineTransform2 = ViewBox.getPreserveAspectRatioTransform(element, f3, f4);
        float f5 = f3;
        float f6 = f4;
        try {
            affineTransform = affineTransform2.createInverse();
            f5 = (float)((double)f3 * affineTransform.getScaleX());
            f6 = (float)((double)f4 * affineTransform.getScaleY());
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            // empty catch block
        }
        affineTransform = AffineTransform.getTranslateInstance(f, f2);
        Shape shape = null;
        if (!bl) {
            canvasGraphicsNode.setPositionTransform(affineTransform);
        } else if (bridgeContext.getDocumentSize() == null) {
            bridgeContext.setDocumentSize(new Dimension((int)f3, (int)f4));
        }
        canvasGraphicsNode.setViewingTransform(affineTransform2);
        if (CSSUtilities.convertOverflow(element)) {
            object = CSSUtilities.convertClip(element);
            shape = object == null ? new Rectangle2D.Float(f, f2, f3, f4) : new Rectangle2D.Float(f + object[3], f2 + object[0], f3 - object[1] - object[3], f4 - object[2] - object[0]);
        }
        if (shape != null) {
            try {
                object = new AffineTransform(affineTransform);
                object.concatenate(affineTransform2);
                object = object.createInverse();
                shape = object.createTransformedShape(shape);
                Filter filter = canvasGraphicsNode.getGraphicsNodeRable(true);
                canvasGraphicsNode.setClip(new ClipRable8Bit(filter, shape));
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                // empty catch block
            }
        }
        if ((object = (Object)CSSUtilities.convertEnableBackground(element)) != null) {
            canvasGraphicsNode.setBackgroundEnable((Rectangle2D)object);
        }
        bridgeContext.openViewport(element, new SVGSVGElementViewport((SVGSVGElement)element, f5, f6));
        return canvasGraphicsNode;
    }

    public void buildGraphicsNode(BridgeContext bridgeContext, Element element, GraphicsNode graphicsNode) {
        this.initializeDynamicSupport(bridgeContext, element, graphicsNode);
        bridgeContext.closeViewport(element);
    }

    public void dispose() {
        this.ctx.removeViewport(this.e);
        super.dispose();
    }

    public void handleDOMAttrModifiedEvent(MutationEvent mutationEvent) {
        String string = mutationEvent.getAttrName();
        if (string.equals("x") || string.equals("y") || string.equals("width") || string.equals("height") || string.equals("viewBox") || string.equals("preserveAspectRatio")) {
            CompositeGraphicsNode compositeGraphicsNode = this.node.getParent();
            compositeGraphicsNode.remove(this.node);
            AbstractGraphicsNodeBridge.disposeTree(this.e);
            this.handleElementAdded(compositeGraphicsNode, this.e.getParentNode(), this.e);
        }
    }

    public static class SVGSVGElementViewport
    implements Viewport {
        private SVGSVGElement e;
        private float width;
        private float height;

        public SVGSVGElementViewport(SVGSVGElement sVGSVGElement, float f, float f2) {
            this.e = sVGSVGElement;
            this.width = f;
            this.height = f2;
        }

        public float getWidth() {
            return this.width;
        }

        public float getHeight() {
            return this.height;
        }
    }
}

