/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.swing.svg;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JOptionPane;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.BridgeExtension;
import org.apache.batik.bridge.DefaultScriptSecurity;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.bridge.ExternalResourceSecurity;
import org.apache.batik.bridge.RelaxedExternalResourceSecurity;
import org.apache.batik.bridge.ScriptSecurity;
import org.apache.batik.bridge.UpdateManager;
import org.apache.batik.bridge.UpdateManagerEvent;
import org.apache.batik.bridge.UpdateManagerListener;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.bridge.ViewBox;
import org.apache.batik.dom.svg.SVGDOMImplementation;
import org.apache.batik.dom.util.DOMUtilities;
import org.apache.batik.dom.util.XLinkSupport;
import org.apache.batik.ext.awt.image.spi.ImageTagRegistry;
import org.apache.batik.gvt.CanvasGraphicsNode;
import org.apache.batik.gvt.CompositeGraphicsNode;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.event.AWTEventDispatcher;
import org.apache.batik.gvt.event.EventDispatcher;
import org.apache.batik.gvt.renderer.ImageRenderer;
import org.apache.batik.swing.gvt.GVTTreeRenderer;
import org.apache.batik.swing.gvt.GVTTreeRendererAdapter;
import org.apache.batik.swing.gvt.GVTTreeRendererEvent;
import org.apache.batik.swing.gvt.JGVTComponent;
import org.apache.batik.swing.gvt.JGVTComponentListener;
import org.apache.batik.swing.svg.GVTTreeBuilder;
import org.apache.batik.swing.svg.GVTTreeBuilderAdapter;
import org.apache.batik.swing.svg.GVTTreeBuilderEvent;
import org.apache.batik.swing.svg.GVTTreeBuilderListener;
import org.apache.batik.swing.svg.JSVGComponent;
import org.apache.batik.swing.svg.LinkActivationEvent;
import org.apache.batik.swing.svg.LinkActivationListener;
import org.apache.batik.swing.svg.Messages;
import org.apache.batik.swing.svg.SVGDocumentLoader;
import org.apache.batik.swing.svg.SVGDocumentLoaderAdapter;
import org.apache.batik.swing.svg.SVGDocumentLoaderEvent;
import org.apache.batik.swing.svg.SVGDocumentLoaderListener;
import org.apache.batik.swing.svg.SVGLoadEventDispatcher;
import org.apache.batik.swing.svg.SVGLoadEventDispatcherAdapter;
import org.apache.batik.swing.svg.SVGLoadEventDispatcherEvent;
import org.apache.batik.swing.svg.SVGLoadEventDispatcherListener;
import org.apache.batik.swing.svg.SVGUserAgent;
import org.apache.batik.util.ParsedURL;
import org.apache.batik.util.RunnableQueue;
import org.apache.batik.util.XMLResourceDescriptor;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGAElement;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGSVGElement;

public class JSVGComponent
extends JGVTComponent {
    public static final int AUTODETECT = 0;
    public static final int ALWAYS_DYNAMIC = 1;
    public static final int ALWAYS_STATIC = 2;
    public static final int ALWAYS_INTERACTIVE = 3;
    protected SVGDocumentLoader documentLoader;
    protected SVGDocumentLoader nextDocumentLoader;
    protected DocumentLoader loader;
    protected GVTTreeBuilder gvtTreeBuilder;
    protected GVTTreeBuilder nextGVTTreeBuilder;
    protected SVGLoadEventDispatcher svgLoadEventDispatcher;
    protected UpdateManager updateManager;
    protected UpdateManager nextUpdateManager;
    protected SVGDocument svgDocument;
    protected List svgDocumentLoaderListeners = new LinkedList();
    protected List gvtTreeBuilderListeners = new LinkedList();
    protected List svgLoadEventDispatcherListeners = new LinkedList();
    protected List linkActivationListeners = new LinkedList();
    protected List updateManagerListeners = new LinkedList();
    protected UserAgent userAgent;
    protected SVGUserAgent svgUserAgent;
    protected BridgeContext bridgeContext;
    protected String fragmentIdentifier;
    protected boolean isDynamicDocument;
    protected boolean isInteractiveDocument;
    protected int documentState;
    protected Dimension prevComponentSize;
    protected JSVGComponentListener jsvgComponentListener = new JSVGComponentListener();
    protected static final Set FEATURES = new HashSet();
    private static final int SPLIT_THRESHOLD = 128;

    public JSVGComponent() {
        this(null, false, false);
    }

    public JSVGComponent(SVGUserAgent sVGUserAgent, boolean bl, boolean bl2) {
        super(bl, bl2);
        this.svgUserAgent = sVGUserAgent;
        this.userAgent = new BridgeUserAgentWrapper(this.createUserAgent());
        this.addSVGDocumentLoaderListener((SVGListener)this.listener);
        this.addGVTTreeBuilderListener((SVGListener)this.listener);
        this.addSVGLoadEventDispatcherListener((SVGListener)this.listener);
    }

    public void removeNotify() {
        this.setSVGDocument(null);
        super.removeNotify();
    }

    public boolean isDynamic() {
        return this.isDynamicDocument;
    }

    public boolean isInteractive() {
        return this.isInteractiveDocument;
    }

    public void setDocumentState(int n) {
        this.documentState = n;
    }

    public UpdateManager getUpdateManager() {
        if (this.svgLoadEventDispatcher != null) {
            return this.svgLoadEventDispatcher.getUpdateManager();
        }
        if (this.nextUpdateManager != null) {
            return this.nextUpdateManager;
        }
        return this.updateManager;
    }

    public void resumeProcessing() {
        if (this.updateManager != null) {
            this.updateManager.resume();
        }
    }

    public void suspendProcessing() {
        if (this.updateManager != null) {
            this.updateManager.suspend();
        }
    }

    public void stopProcessing() {
        this.nextDocumentLoader = null;
        this.nextGVTTreeBuilder = null;
        if (this.documentLoader != null) {
            this.documentLoader.interrupt();
        } else if (this.gvtTreeBuilder != null) {
            this.gvtTreeBuilder.interrupt();
        } else if (this.svgLoadEventDispatcher != null) {
            this.svgLoadEventDispatcher.interrupt();
        } else if (this.nextUpdateManager != null) {
            this.nextUpdateManager.interrupt();
            this.nextUpdateManager = null;
        } else if (this.updateManager != null) {
            this.updateManager.interrupt();
        } else {
            super.stopProcessing();
        }
    }

    public void loadSVGDocument(String string) {
        String string2 = null;
        if (this.svgDocument != null) {
            string2 = this.svgDocument.getURL();
        }
        final ParsedURL parsedURL = new ParsedURL(string2, string);
        this.stopThenRun(new Runnable(){

            public void run() {
                String string = parsedURL.toString();
                JSVGComponent.this.fragmentIdentifier = parsedURL.getRef();
                JSVGComponent.this.loader = new DocumentLoader(JSVGComponent.this.userAgent);
                JSVGComponent.this.nextDocumentLoader = new SVGDocumentLoader(string, JSVGComponent.this.loader);
                JSVGComponent.this.nextDocumentLoader.setPriority(1);
                Iterator iterator = JSVGComponent.this.svgDocumentLoaderListeners.iterator();
                while (iterator.hasNext()) {
                    JSVGComponent.this.nextDocumentLoader.addSVGDocumentLoaderListener((SVGDocumentLoaderListener)iterator.next());
                }
                JSVGComponent.this.startDocumentLoader();
            }
        });
    }

    private void startDocumentLoader() {
        this.documentLoader = this.nextDocumentLoader;
        this.nextDocumentLoader = null;
        this.documentLoader.start();
    }

    public void setDocument(Document document) {
        if (document != null && !(document.getImplementation() instanceof SVGDOMImplementation)) {
            Document document2;
            DOMImplementation dOMImplementation = SVGDOMImplementation.getDOMImplementation();
            document = document2 = DOMUtilities.deepCloneDocument(document, dOMImplementation);
        }
        this.setSVGDocument((SVGDocument)document);
    }

    public void setSVGDocument(SVGDocument sVGDocument) {
        Object object;
        if (sVGDocument != null && !(sVGDocument.getImplementation() instanceof SVGDOMImplementation)) {
            object = SVGDOMImplementation.getDOMImplementation();
            Document document = DOMUtilities.deepCloneDocument(sVGDocument, (DOMImplementation)object);
            sVGDocument = (SVGDocument)document;
        }
        object = sVGDocument;
        this.stopThenRun(new Runnable((SVGDocument)object){
            private final /* synthetic */ SVGDocument val$svgdoc;
            {
                this.val$svgdoc = sVGDocument;
            }

            public void run() {
                JSVGComponent.this.installSVGDocument(this.val$svgdoc);
            }
        });
    }

    protected void stopThenRun(final Runnable runnable) {
        if (this.documentLoader != null) {
            this.documentLoader.addSVGDocumentLoaderListener(new SVGDocumentLoaderAdapter(){
                SVGDocumentLoader sdl;
                {
                    this.sdl = JSVGComponent.this.documentLoader;
                }

                public void documentLoadingCompleted(SVGDocumentLoaderEvent sVGDocumentLoaderEvent) {
                    this.install();
                }

                public void documentLoadingCancelled(SVGDocumentLoaderEvent sVGDocumentLoaderEvent) {
                    this.install();
                }

                public void documentLoadingFailed(SVGDocumentLoaderEvent sVGDocumentLoaderEvent) {
                    this.install();
                }

                public void install() {
                    this.sdl.removeSVGDocumentLoaderListener(this);
                    EventQueue.invokeLater(runnable);
                }
            });
            this.stopProcessing();
        } else if (this.gvtTreeBuilder != null) {
            this.gvtTreeBuilder.addGVTTreeBuilderListener(new GVTTreeBuilderAdapter(){
                GVTTreeBuilder gtb;
                {
                    this.gtb = JSVGComponent.this.gvtTreeBuilder;
                }

                public void gvtBuildCompleted(GVTTreeBuilderEvent gVTTreeBuilderEvent) {
                    this.install();
                }

                public void gvtBuildCancelled(GVTTreeBuilderEvent gVTTreeBuilderEvent) {
                    this.install();
                }

                public void gvtBuildFailed(GVTTreeBuilderEvent gVTTreeBuilderEvent) {
                    this.install();
                }

                public void install() {
                    this.gtb.removeGVTTreeBuilderListener(this);
                    EventQueue.invokeLater(runnable);
                }
            });
            this.stopProcessing();
        } else if (this.updateManager != null) {
            this.updateManager.addUpdateManagerListener(new UpdateManagerListener(){
                UpdateManager um;
                {
                    this.um = JSVGComponent.this.updateManager;
                }

                public void managerStopped(UpdateManagerEvent updateManagerEvent) {
                    this.um.removeUpdateManagerListener(this);
                    EventQueue.invokeLater(runnable);
                }

                public void managerStarted(UpdateManagerEvent updateManagerEvent) {
                }

                public void managerSuspended(UpdateManagerEvent updateManagerEvent) {
                }

                public void managerResumed(UpdateManagerEvent updateManagerEvent) {
                }

                public void updateStarted(UpdateManagerEvent updateManagerEvent) {
                }

                public void updateCompleted(UpdateManagerEvent updateManagerEvent) {
                }

                public void updateFailed(UpdateManagerEvent updateManagerEvent) {
                }
            });
            this.stopProcessing();
        } else if (this.nextUpdateManager != null) {
            this.gvtTreeRenderer.addGVTTreeRendererListener(new GVTTreeRendererAdapter(){
                GVTTreeRenderer gtr;
                {
                    this.gtr = JSVGComponent.this.gvtTreeRenderer;
                }

                public void gvtRenderingCompleted(GVTTreeRendererEvent gVTTreeRendererEvent) {
                    this.install();
                }

                public void gvtRenderingCancelled(GVTTreeRendererEvent gVTTreeRendererEvent) {
                    this.install();
                }

                public void gvtRenderingFailed(GVTTreeRendererEvent gVTTreeRendererEvent) {
                    this.install();
                }

                public void install() {
                    this.gtr.removeGVTTreeRendererListener(this);
                    EventQueue.invokeLater(runnable);
                }
            });
            this.stopProcessing();
        } else if (this.svgLoadEventDispatcher != null) {
            this.svgLoadEventDispatcher.addSVGLoadEventDispatcherListener(new SVGLoadEventDispatcherAdapter(){
                SVGLoadEventDispatcher sled;
                {
                    this.sled = JSVGComponent.this.svgLoadEventDispatcher;
                }

                public void svgLoadEventDispatchCompleted(SVGLoadEventDispatcherEvent sVGLoadEventDispatcherEvent) {
                    this.install();
                }

                public void svgLoadEventDispatchCancelled(SVGLoadEventDispatcherEvent sVGLoadEventDispatcherEvent) {
                    this.install();
                }

                public void svgLoadEventDispatchFailed(SVGLoadEventDispatcherEvent sVGLoadEventDispatcherEvent) {
                    this.install();
                }

                public void install() {
                    this.sled.removeSVGLoadEventDispatcherListener(this);
                    EventQueue.invokeLater(runnable);
                }
            });
            this.stopProcessing();
        } else {
            this.stopProcessing();
            runnable.run();
        }
    }

    protected void installSVGDocument(SVGDocument sVGDocument) {
        this.svgDocument = sVGDocument;
        if (this.bridgeContext != null) {
            this.bridgeContext.dispose();
            this.bridgeContext = null;
        }
        this.releaseRenderingReferences();
        if (sVGDocument == null) {
            this.isDynamicDocument = false;
            this.isInteractiveDocument = false;
            this.disableInteractions = true;
            this.initialTransform = new AffineTransform();
            this.setRenderingTransform(this.initialTransform, false);
            Dimension dimension = this.getSize();
            this.repaint(0, 0, dimension.width, dimension.height);
            return;
        }
        switch (this.documentState) {
            case 2: {
                this.isDynamicDocument = false;
                this.isInteractiveDocument = false;
                break;
            }
            case 3: {
                this.isDynamicDocument = false;
                this.isInteractiveDocument = true;
                break;
            }
            case 1: {
                this.isDynamicDocument = true;
                this.isInteractiveDocument = true;
                break;
            }
            case 0: {
                this.isDynamicDocument = BridgeContext.isDynamicDocument(sVGDocument);
                this.isInteractiveDocument = this.isDynamicDocument ? true : BridgeContext.isInteractiveDocument(sVGDocument);
            }
        }
        Element element = sVGDocument.getDocumentElement();
        String string = element.getAttributeNS(null, "zoomAndPan");
        this.disableInteractions = !string.equals("magnify");
        this.bridgeContext = this.createBridgeContext();
        this.nextGVTTreeBuilder = new GVTTreeBuilder(sVGDocument, this.bridgeContext);
        this.nextGVTTreeBuilder.setPriority(1);
        Iterator iterator = this.gvtTreeBuilderListeners.iterator();
        while (iterator.hasNext()) {
            this.nextGVTTreeBuilder.addGVTTreeBuilderListener((GVTTreeBuilderListener)iterator.next());
        }
        this.initializeEventHandling();
        if (this.gvtTreeBuilder == null && this.documentLoader == null && this.gvtTreeRenderer == null && this.svgLoadEventDispatcher == null && this.updateManager == null) {
            this.startGVTTreeBuilder();
        }
    }

    private void startGVTTreeBuilder() {
        this.gvtTreeBuilder = this.nextGVTTreeBuilder;
        this.nextGVTTreeBuilder = null;
        this.gvtTreeBuilder.start();
    }

    public SVGDocument getSVGDocument() {
        return this.svgDocument;
    }

    public Dimension2D getSVGDocumentSize() {
        return this.bridgeContext.getDocumentSize();
    }

    public String getFragmentIdentifier() {
        return this.fragmentIdentifier;
    }

    public void setFragmentIdentifier(String string) {
        this.fragmentIdentifier = string;
        if (this.computeRenderingTransform()) {
            this.scheduleGVTRendering();
        }
    }

    public void flushImageCache() {
        ImageTagRegistry imageTagRegistry = ImageTagRegistry.getRegistry();
        imageTagRegistry.flushCache();
    }

    protected BridgeContext createBridgeContext() {
        if (this.loader == null) {
            this.loader = new DocumentLoader(this.userAgent);
        }
        BridgeContext bridgeContext = new BridgeContext(this.userAgent, this.loader);
        if (this.isInteractiveDocument) {
            if (this.isDynamicDocument) {
                bridgeContext.setDynamicState(2);
            } else {
                bridgeContext.setDynamicState(1);
            }
        }
        return bridgeContext;
    }

    protected void startSVGLoadEventDispatcher(GraphicsNode graphicsNode) {
        UpdateManager updateManager = new UpdateManager(this.bridgeContext, graphicsNode, this.svgDocument);
        this.svgLoadEventDispatcher = new SVGLoadEventDispatcher(graphicsNode, this.svgDocument, this.bridgeContext, updateManager);
        Iterator iterator = this.svgLoadEventDispatcherListeners.iterator();
        while (iterator.hasNext()) {
            this.svgLoadEventDispatcher.addSVGLoadEventDispatcherListener((SVGLoadEventDispatcherListener)iterator.next());
        }
        this.svgLoadEventDispatcher.start();
    }

    protected ImageRenderer createImageRenderer() {
        if (this.isDynamicDocument) {
            return this.rendererFactory.createDynamicImageRenderer();
        }
        return this.rendererFactory.createStaticImageRenderer();
    }

    public CanvasGraphicsNode getCanvasGraphicsNode() {
        return this.getCanvasGraphicsNode(this.gvtRoot);
    }

    protected CanvasGraphicsNode getCanvasGraphicsNode(GraphicsNode graphicsNode) {
        if (!(graphicsNode instanceof CompositeGraphicsNode)) {
            return null;
        }
        CompositeGraphicsNode compositeGraphicsNode = (CompositeGraphicsNode)graphicsNode;
        if (!((graphicsNode = (GraphicsNode)compositeGraphicsNode.getChildren().get(0)) instanceof CanvasGraphicsNode)) {
            return null;
        }
        return (CanvasGraphicsNode)graphicsNode;
    }

    public AffineTransform getViewBoxTransform() {
        AffineTransform affineTransform;
        AffineTransform affineTransform2 = this.getRenderingTransform();
        affineTransform2 = affineTransform2 == null ? new AffineTransform() : new AffineTransform(affineTransform2);
        CanvasGraphicsNode canvasGraphicsNode = this.getCanvasGraphicsNode();
        if (canvasGraphicsNode != null && (affineTransform = canvasGraphicsNode.getViewingTransform()) != null) {
            affineTransform2.concatenate(affineTransform);
        }
        return affineTransform2;
    }

    protected boolean computeRenderingTransform() {
        if (this.svgDocument == null || this.gvtRoot == null) {
            return false;
        }
        boolean bl = this.updateRenderingTransform();
        this.initialTransform = new AffineTransform();
        if (!this.initialTransform.equals(this.getRenderingTransform())) {
            this.setRenderingTransform(this.initialTransform, false);
            bl = true;
        }
        return bl;
    }

    protected boolean updateRenderingTransform() {
        if (this.svgDocument == null || this.gvtRoot == null) {
            return false;
        }
        try {
            AffineTransform affineTransform;
            CanvasGraphicsNode canvasGraphicsNode;
            AffineTransform affineTransform2;
            AffineTransform affineTransform3;
            SVGSVGElement sVGSVGElement = this.svgDocument.getRootElement();
            Dimension dimension = this.getSize();
            Dimension dimension2 = this.prevComponentSize;
            if (dimension2 == null) {
                dimension2 = dimension;
            }
            this.prevComponentSize = dimension;
            if (dimension.width < 1) {
                dimension.width = 1;
            }
            if (dimension.height < 1) {
                dimension.height = 1;
            }
            if ((affineTransform3 = ViewBox.getViewTransform(this.fragmentIdentifier, sVGSVGElement, dimension.width, dimension.height)).equals(affineTransform2 = (canvasGraphicsNode = this.getCanvasGraphicsNode()).getViewingTransform())) {
                return dimension2.width != dimension.width || dimension2.height != dimension.height;
            }
            Point2D point2D = new Point2D.Float((float)dimension2.width / 2.0f, (float)dimension2.height / 2.0f);
            AffineTransform affineTransform4 = this.getRenderingTransform();
            if (affineTransform4 != null) {
                try {
                    affineTransform = affineTransform4.createInverse();
                    point2D = affineTransform.transform(point2D, null);
                }
                catch (NoninvertibleTransformException noninvertibleTransformException) {
                    // empty catch block
                }
            }
            if (affineTransform2 != null) {
                try {
                    affineTransform = affineTransform2.createInverse();
                    point2D = affineTransform.transform(point2D, null);
                }
                catch (NoninvertibleTransformException noninvertibleTransformException) {
                    // empty catch block
                }
            }
            if (affineTransform3 != null) {
                point2D = affineTransform3.transform(point2D, null);
            }
            if (affineTransform4 != null) {
                point2D = affineTransform4.transform(point2D, null);
            }
            float f = (float)((double)((float)dimension.width / 2.0f) - point2D.getX());
            float f2 = (float)((double)((float)dimension.height / 2.0f) - point2D.getY());
            f = f < 0.0f ? (int)((double)f - 0.5) : (int)((double)f + 0.5);
            f2 = f2 < 0.0f ? (int)((double)f2 - 0.5) : (int)((double)f2 + 0.5);
            if (f != 0.0f || f2 != 0.0f) {
                affineTransform4.preConcatenate(AffineTransform.getTranslateInstance(f, f2));
                this.setRenderingTransform(affineTransform4, false);
            }
            canvasGraphicsNode.setViewingTransform(affineTransform3);
        }
        catch (BridgeException bridgeException) {
            this.userAgent.displayError(bridgeException);
        }
        return true;
    }

    protected void renderGVTTree() {
        AffineTransform affineTransform;
        if (!this.isInteractiveDocument || this.updateManager == null || !this.updateManager.isRunning()) {
            super.renderGVTTree();
            return;
        }
        final Dimension dimension = this.getSize();
        if (this.gvtRoot == null || dimension.width <= 0 || dimension.height <= 0) {
            return;
        }
        try {
            affineTransform = this.renderingTransform.createInverse();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            throw new InternalError(noninvertibleTransformException.getMessage());
        }
        final Shape shape = affineTransform.createTransformedShape(new Rectangle(0, 0, dimension.width, dimension.height));
        this.updateManager.getUpdateRunnableQueue().invokeLater(new Runnable(){

            public void run() {
                JSVGComponent.this.paintingTransform = null;
                JSVGComponent.this.updateManager.updateRendering(JSVGComponent.this.renderingTransform, JSVGComponent.this.doubleBufferedRendering, shape, dimension.width, dimension.height);
            }
        });
    }

    protected void handleException(Exception exception) {
        this.userAgent.displayError(exception);
    }

    public void addSVGDocumentLoaderListener(SVGDocumentLoaderListener sVGDocumentLoaderListener) {
        this.svgDocumentLoaderListeners.add(sVGDocumentLoaderListener);
    }

    public void removeSVGDocumentLoaderListener(SVGDocumentLoaderListener sVGDocumentLoaderListener) {
        this.svgDocumentLoaderListeners.remove(sVGDocumentLoaderListener);
    }

    public void addGVTTreeBuilderListener(GVTTreeBuilderListener gVTTreeBuilderListener) {
        this.gvtTreeBuilderListeners.add(gVTTreeBuilderListener);
    }

    public void removeGVTTreeBuilderListener(GVTTreeBuilderListener gVTTreeBuilderListener) {
        this.gvtTreeBuilderListeners.remove(gVTTreeBuilderListener);
    }

    public void addSVGLoadEventDispatcherListener(SVGLoadEventDispatcherListener sVGLoadEventDispatcherListener) {
        this.svgLoadEventDispatcherListeners.add(sVGLoadEventDispatcherListener);
    }

    public void removeSVGLoadEventDispatcherListener(SVGLoadEventDispatcherListener sVGLoadEventDispatcherListener) {
        this.svgLoadEventDispatcherListeners.remove(sVGLoadEventDispatcherListener);
    }

    public void addLinkActivationListener(LinkActivationListener linkActivationListener) {
        this.linkActivationListeners.add(linkActivationListener);
    }

    public void removeLinkActivationListener(LinkActivationListener linkActivationListener) {
        this.linkActivationListeners.remove(linkActivationListener);
    }

    public void addUpdateManagerListener(UpdateManagerListener updateManagerListener) {
        this.updateManagerListeners.add(updateManagerListener);
    }

    public void removeUpdateManagerListener(UpdateManagerListener updateManagerListener) {
        this.updateManagerListeners.remove(updateManagerListener);
    }

    public void showAlert(String string) {
        JOptionPane.showMessageDialog(this, Messages.formatMessage("script.alert", new Object[]{string}));
    }

    public String showPrompt(String string) {
        return JOptionPane.showInputDialog(this, (Object)Messages.formatMessage("script.prompt", new Object[]{string}));
    }

    public String showPrompt(String string, String string2) {
        return (String)JOptionPane.showInputDialog(this, Messages.formatMessage("script.prompt", new Object[]{string}), null, -1, null, null, string2);
    }

    public boolean showConfirm(String string) {
        return JOptionPane.showConfirmDialog(this, Messages.formatMessage("script.confirm", new Object[]{string}), "Confirm", 0) == 0;
    }

    public void setMySize(Dimension dimension) {
        this.setPreferredSize(dimension);
        this.invalidate();
    }

    protected JGVTComponent.Listener createListener() {
        return new SVGListener();
    }

    protected UserAgent createUserAgent() {
        return new BridgeUserAgent();
    }

    protected List mergeRectangles(List list, int n, int n2, int n3, int n4) {
        if (list.size() <= 1) {
            return list;
        }
        int n5 = n3 - n;
        int n6 = n4 - n2;
        if (n5 < 128 && n6 < 128) {
            ArrayList<Rectangle> arrayList = new ArrayList<Rectangle>();
            Iterator iterator = list.iterator();
            Rectangle rectangle = (Rectangle)iterator.next();
            while (iterator.hasNext()) {
                Rectangle rectangle2 = (Rectangle)iterator.next();
                rectangle.add(rectangle2);
            }
            arrayList.add(rectangle);
            return arrayList;
        }
        if (n5 < 128) {
            List<Rectangle> list2 = new ArrayList();
            List<Rectangle> list3 = new ArrayList<Rectangle>();
            int n7 = n6 / 2;
            int n8 = n2 + n7;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Rectangle rectangle = (Rectangle)iterator.next();
                if (rectangle.y < n8) {
                    if (rectangle.y + rectangle.height > n8) {
                        list3.add(new Rectangle(rectangle.x, n8, rectangle.width, rectangle.height + rectangle.y - n8));
                        rectangle = new Rectangle(rectangle.x, rectangle.y, rectangle.width, n8 - rectangle.y);
                    }
                    list2.add(rectangle);
                    continue;
                }
                list3.add(rectangle);
            }
            list2 = this.mergeRectangles(list2, n, n2, n3, n8 - 1);
            list3 = this.mergeRectangles(list3, n, n8, n3, n4);
            list2.addAll(list3);
            return list2;
        }
        if (n6 < 128) {
            List<Rectangle> list4 = new ArrayList();
            List<Rectangle> list5 = new ArrayList<Rectangle>();
            int n9 = n5 / 2;
            int n10 = n + n9;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Rectangle rectangle = (Rectangle)iterator.next();
                if (rectangle.x < n10) {
                    if (rectangle.x + rectangle.width > n10) {
                        list5.add(new Rectangle(n10, rectangle.y, rectangle.width + rectangle.x - n10, rectangle.height));
                        rectangle = new Rectangle(rectangle.x, rectangle.y, n10 - rectangle.x, rectangle.height);
                    }
                    list4.add(rectangle);
                    continue;
                }
                list5.add(rectangle);
            }
            list4 = this.mergeRectangles(list4, n, n2, n10 - 1, n4);
            list5 = this.mergeRectangles(list5, n10, n2, n3, n4);
            list4.addAll(list5);
            return list4;
        }
        List<Rectangle> list6 = new ArrayList();
        List<Rectangle> list7 = new ArrayList();
        List<Rectangle> list8 = new ArrayList<Rectangle>();
        List<Rectangle> list9 = new ArrayList<Rectangle>();
        int n11 = n5 / 2;
        int n12 = n6 / 2;
        int n13 = n + n11;
        int n14 = n2 + n12;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Rectangle rectangle = (Rectangle)iterator.next();
            if (rectangle.x < n13) {
                if (rectangle.y < n14) {
                    boolean bl;
                    boolean bl2 = rectangle.x + rectangle.width > n13;
                    boolean bl3 = bl = rectangle.y + rectangle.height > n14;
                    if (bl2 && bl) {
                        list7.add(new Rectangle(n13, rectangle.y, rectangle.width + rectangle.x - n13, n14 - rectangle.y));
                        list8.add(new Rectangle(rectangle.x, n14, n13 - rectangle.x, rectangle.height + rectangle.y - n14));
                        list9.add(new Rectangle(n13, n14, rectangle.width + rectangle.x - n13, rectangle.height + rectangle.y - n14));
                        rectangle = new Rectangle(rectangle.x, rectangle.y, n13 - rectangle.x, n14 - rectangle.y);
                    } else if (bl2) {
                        list7.add(new Rectangle(n13, rectangle.y, rectangle.width + rectangle.x - n13, rectangle.height));
                        rectangle = new Rectangle(rectangle.x, rectangle.y, n13 - rectangle.x, rectangle.height);
                    } else if (bl) {
                        list8.add(new Rectangle(rectangle.x, n14, rectangle.width, rectangle.height + rectangle.y - n14));
                        rectangle = new Rectangle(rectangle.x, rectangle.y, rectangle.width, n14 - rectangle.y);
                    }
                    list6.add(rectangle);
                    continue;
                }
                if (rectangle.x + rectangle.width > n13) {
                    list9.add(new Rectangle(n13, rectangle.y, rectangle.width + rectangle.x - n13, rectangle.height));
                    rectangle = new Rectangle(rectangle.x, rectangle.y, n13 - rectangle.x, rectangle.height);
                }
                list8.add(rectangle);
                continue;
            }
            if (rectangle.y < n14) {
                if (rectangle.y + rectangle.height > n14) {
                    list9.add(new Rectangle(rectangle.x, n14, rectangle.width, rectangle.height + rectangle.y - n14));
                    rectangle = new Rectangle(rectangle.x, rectangle.y, rectangle.width, n14 - rectangle.y);
                }
                list7.add(rectangle);
                continue;
            }
            list9.add(rectangle);
        }
        list6 = this.mergeRectangles(list6, n, n2, n13 - 1, n14 - 1);
        list7 = this.mergeRectangles(list7, n13, n2, n3, n4);
        list8 = this.mergeRectangles(list8, n, n14, n13 - 1, n4);
        list9 = this.mergeRectangles(list9, n13, n14, n3, n4);
        list6.addAll(list7);
        list6.addAll(list8);
        list6.addAll(list9);
        return list6;
    }

    static /* synthetic */ boolean access$2303(JSVGComponent jSVGComponent, boolean bl) {
        jSVGComponent.suspendInteractions = bl;
        return jSVGComponent.suspendInteractions;
    }

    static /* synthetic */ boolean access$2401(JSVGComponent jSVGComponent) {
        return jSVGComponent.doubleBufferedRendering;
    }

    static /* synthetic */ BufferedImage access$2503(JSVGComponent jSVGComponent, BufferedImage bufferedImage) {
        jSVGComponent.image = bufferedImage;
        return jSVGComponent.image;
    }

    static /* synthetic */ BufferedImage access$2603(JSVGComponent jSVGComponent, BufferedImage bufferedImage) {
        jSVGComponent.image = bufferedImage;
        return jSVGComponent.image;
    }

    static /* synthetic */ boolean access$2701(JSVGComponent jSVGComponent) {
        return jSVGComponent.doubleBufferedRendering;
    }

    static /* synthetic */ boolean access$2803(JSVGComponent jSVGComponent, boolean bl) {
        jSVGComponent.suspendInteractions = bl;
        return jSVGComponent.suspendInteractions;
    }

    static /* synthetic */ AWTEventDispatcher access$2901(JSVGComponent jSVGComponent) {
        return jSVGComponent.eventDispatcher;
    }

    static /* synthetic */ AWTEventDispatcher access$3001(JSVGComponent jSVGComponent) {
        return jSVGComponent.eventDispatcher;
    }

    static /* synthetic */ AWTEventDispatcher access$3101(JSVGComponent jSVGComponent) {
        return jSVGComponent.eventDispatcher;
    }

    static /* synthetic */ AWTEventDispatcher access$3201(JSVGComponent jSVGComponent) {
        return jSVGComponent.eventDispatcher;
    }

    static /* synthetic */ AWTEventDispatcher access$3301(JSVGComponent jSVGComponent) {
        return jSVGComponent.eventDispatcher;
    }

    static /* synthetic */ AWTEventDispatcher access$3401(JSVGComponent jSVGComponent) {
        return jSVGComponent.eventDispatcher;
    }

    static /* synthetic */ AWTEventDispatcher access$3501(JSVGComponent jSVGComponent) {
        return jSVGComponent.eventDispatcher;
    }

    static /* synthetic */ AWTEventDispatcher access$3601(JSVGComponent jSVGComponent) {
        return jSVGComponent.eventDispatcher;
    }

    static /* synthetic */ AWTEventDispatcher access$3701(JSVGComponent jSVGComponent) {
        return jSVGComponent.eventDispatcher;
    }

    static /* synthetic */ AWTEventDispatcher access$3801(JSVGComponent jSVGComponent) {
        return jSVGComponent.eventDispatcher;
    }

    static {
        FEATURES.add("org.w3c.svg");
        FEATURES.add("org.w3c.svg.lang");
        FEATURES.add("org.w3c.svg.static");
    }

    protected class BridgeUserAgent
    implements UserAgent {
        protected Map extensions = new HashMap();

        protected BridgeUserAgent() {
        }

        public Dimension2D getViewportSize() {
            return JSVGComponent.this.getSize();
        }

        public EventDispatcher getEventDispatcher() {
            return JSVGComponent.this.eventDispatcher;
        }

        public void displayError(String string) {
            if (JSVGComponent.this.svgUserAgent != null) {
                JSVGComponent.this.svgUserAgent.displayError(string);
            }
        }

        public void displayError(Exception exception) {
            if (JSVGComponent.this.svgUserAgent != null) {
                JSVGComponent.this.svgUserAgent.displayError(exception);
            }
        }

        public void displayMessage(String string) {
            if (JSVGComponent.this.svgUserAgent != null) {
                JSVGComponent.this.svgUserAgent.displayMessage(string);
            }
        }

        public void showAlert(String string) {
            if (JSVGComponent.this.svgUserAgent != null) {
                JSVGComponent.this.svgUserAgent.showAlert(string);
                return;
            }
            JSVGComponent.this.showAlert(string);
        }

        public String showPrompt(String string) {
            if (JSVGComponent.this.svgUserAgent != null) {
                return JSVGComponent.this.svgUserAgent.showPrompt(string);
            }
            return JSVGComponent.this.showPrompt(string);
        }

        public String showPrompt(String string, String string2) {
            if (JSVGComponent.this.svgUserAgent != null) {
                return JSVGComponent.this.svgUserAgent.showPrompt(string, string2);
            }
            return JSVGComponent.this.showPrompt(string, string2);
        }

        public boolean showConfirm(String string) {
            if (JSVGComponent.this.svgUserAgent != null) {
                return JSVGComponent.this.svgUserAgent.showConfirm(string);
            }
            return JSVGComponent.this.showConfirm(string);
        }

        public float getPixelUnitToMillimeter() {
            if (JSVGComponent.this.svgUserAgent != null) {
                return JSVGComponent.this.svgUserAgent.getPixelUnitToMillimeter();
            }
            return 0.26458332f;
        }

        public float getPixelToMM() {
            return this.getPixelUnitToMillimeter();
        }

        public String getDefaultFontFamily() {
            if (JSVGComponent.this.svgUserAgent != null) {
                return JSVGComponent.this.svgUserAgent.getDefaultFontFamily();
            }
            return "Arial, Helvetica, sans-serif";
        }

        public float getMediumFontSize() {
            if (JSVGComponent.this.svgUserAgent != null) {
                return JSVGComponent.this.svgUserAgent.getMediumFontSize();
            }
            return 228.59999f / (72.0f * this.getPixelUnitToMillimeter());
        }

        public float getLighterFontWeight(float f) {
            if (JSVGComponent.this.svgUserAgent != null) {
                return JSVGComponent.this.svgUserAgent.getLighterFontWeight(f);
            }
            int n = (int)((f + 50.0f) / 100.0f) * 100;
            switch (n) {
                case 100: {
                    return 100.0f;
                }
                case 200: {
                    return 100.0f;
                }
                case 300: {
                    return 200.0f;
                }
                case 400: {
                    return 300.0f;
                }
                case 500: {
                    return 400.0f;
                }
                case 600: {
                    return 400.0f;
                }
                case 700: {
                    return 400.0f;
                }
                case 800: {
                    return 400.0f;
                }
                case 900: {
                    return 400.0f;
                }
            }
            throw new IllegalArgumentException("Bad Font Weight: " + f);
        }

        public float getBolderFontWeight(float f) {
            if (JSVGComponent.this.svgUserAgent != null) {
                return JSVGComponent.this.svgUserAgent.getBolderFontWeight(f);
            }
            int n = (int)((f + 50.0f) / 100.0f) * 100;
            switch (n) {
                case 100: {
                    return 600.0f;
                }
                case 200: {
                    return 600.0f;
                }
                case 300: {
                    return 600.0f;
                }
                case 400: {
                    return 600.0f;
                }
                case 500: {
                    return 600.0f;
                }
                case 600: {
                    return 700.0f;
                }
                case 700: {
                    return 800.0f;
                }
                case 800: {
                    return 900.0f;
                }
                case 900: {
                    return 900.0f;
                }
            }
            throw new IllegalArgumentException("Bad Font Weight: " + f);
        }

        public String getLanguages() {
            if (JSVGComponent.this.svgUserAgent != null) {
                return JSVGComponent.this.svgUserAgent.getLanguages();
            }
            return "en";
        }

        public String getUserStyleSheetURI() {
            if (JSVGComponent.this.svgUserAgent != null) {
                return JSVGComponent.this.svgUserAgent.getUserStyleSheetURI();
            }
            return null;
        }

        public void openLink(SVGAElement sVGAElement) {
            ParsedURL parsedURL;
            String string = XLinkSupport.getXLinkShow(sVGAElement);
            String string2 = XLinkSupport.getXLinkHref(sVGAElement);
            if (string.equals("new")) {
                this.fireLinkActivatedEvent(sVGAElement, string2);
                if (JSVGComponent.this.svgUserAgent != null) {
                    String string3 = JSVGComponent.this.svgDocument.getURL();
                    ParsedURL parsedURL2 = null;
                    if (sVGAElement.getOwnerDocument() != JSVGComponent.this.svgDocument) {
                        SVGDocument sVGDocument = (SVGDocument)sVGAElement.getOwnerDocument();
                        string2 = new ParsedURL(sVGDocument.getURL(), string2).toString();
                    }
                    parsedURL2 = new ParsedURL(string3, string2);
                    string2 = parsedURL2.toString();
                    JSVGComponent.this.svgUserAgent.openLink(string2, true);
                } else {
                    JSVGComponent.this.loadSVGDocument(string2);
                }
                return;
            }
            ParsedURL parsedURL3 = new ParsedURL(((SVGDocument)sVGAElement.getOwnerDocument()).getURL(), string2);
            string2 = parsedURL3.toString();
            if (JSVGComponent.this.svgDocument != null && parsedURL3.sameFile(parsedURL = new ParsedURL(JSVGComponent.this.svgDocument.getURL()))) {
                String string4 = parsedURL3.getRef();
                if (!(JSVGComponent.this.fragmentIdentifier == string4 || string4 != null && string4.equals(JSVGComponent.this.fragmentIdentifier))) {
                    JSVGComponent.this.fragmentIdentifier = string4;
                    if (JSVGComponent.this.computeRenderingTransform()) {
                        JSVGComponent.super.scheduleGVTRendering();
                    }
                }
                this.fireLinkActivatedEvent(sVGAElement, string2);
                return;
            }
            this.fireLinkActivatedEvent(sVGAElement, string2);
            if (JSVGComponent.this.svgUserAgent != null) {
                JSVGComponent.this.svgUserAgent.openLink(string2, false);
            } else {
                JSVGComponent.this.loadSVGDocument(string2);
            }
        }

        protected void fireLinkActivatedEvent(SVGAElement sVGAElement, String string) {
            Object[] objectArray = JSVGComponent.this.linkActivationListeners.toArray();
            if (objectArray.length > 0) {
                LinkActivationEvent linkActivationEvent = new LinkActivationEvent(JSVGComponent.this, sVGAElement, string);
                int n = 0;
                while (n < objectArray.length) {
                    LinkActivationListener linkActivationListener = (LinkActivationListener)objectArray[n];
                    linkActivationListener.linkActivated(linkActivationEvent);
                    ++n;
                }
            }
        }

        public void setSVGCursor(Cursor cursor) {
            if (cursor != JSVGComponent.this.getCursor()) {
                JSVGComponent.this.setCursor(cursor);
            }
        }

        public String getXMLParserClassName() {
            if (JSVGComponent.this.svgUserAgent != null) {
                return JSVGComponent.this.svgUserAgent.getXMLParserClassName();
            }
            return XMLResourceDescriptor.getXMLParserClassName();
        }

        public boolean isXMLParserValidating() {
            if (JSVGComponent.this.svgUserAgent != null) {
                return JSVGComponent.this.svgUserAgent.isXMLParserValidating();
            }
            return false;
        }

        public AffineTransform getTransform() {
            return JSVGComponent.this.renderingTransform;
        }

        public void setTransform(AffineTransform affineTransform) {
            JSVGComponent.this.setRenderingTransform(affineTransform);
        }

        public String getMedia() {
            if (JSVGComponent.this.svgUserAgent != null) {
                return JSVGComponent.this.svgUserAgent.getMedia();
            }
            return "screen";
        }

        public String getAlternateStyleSheet() {
            if (JSVGComponent.this.svgUserAgent != null) {
                return JSVGComponent.this.svgUserAgent.getAlternateStyleSheet();
            }
            return null;
        }

        public Point getClientAreaLocationOnScreen() {
            return JSVGComponent.this.getLocationOnScreen();
        }

        public boolean hasFeature(String string) {
            return FEATURES.contains(string);
        }

        public boolean supportExtension(String string) {
            boolean bl = false;
            if (JSVGComponent.this.svgUserAgent != null && JSVGComponent.this.svgUserAgent.supportExtension(string)) {
                return true;
            }
            return this.extensions.containsKey(string);
        }

        public void registerExtension(BridgeExtension bridgeExtension) {
            Iterator iterator = bridgeExtension.getImplementedExtensions();
            while (iterator.hasNext()) {
                this.extensions.put(iterator.next(), bridgeExtension);
            }
        }

        public void handleElement(Element element, Object object) {
            if (JSVGComponent.this.svgUserAgent != null) {
                JSVGComponent.this.svgUserAgent.handleElement(element, object);
            }
        }

        public ScriptSecurity getScriptSecurity(String string, ParsedURL parsedURL, ParsedURL parsedURL2) {
            if (JSVGComponent.this.svgUserAgent != null) {
                return JSVGComponent.this.svgUserAgent.getScriptSecurity(string, parsedURL, parsedURL2);
            }
            return new DefaultScriptSecurity(string, parsedURL, parsedURL2);
        }

        public void checkLoadScript(String string, ParsedURL parsedURL, ParsedURL parsedURL2) throws SecurityException {
            if (JSVGComponent.this.svgUserAgent != null) {
                JSVGComponent.this.svgUserAgent.checkLoadScript(string, parsedURL, parsedURL2);
            } else {
                ScriptSecurity scriptSecurity = this.getScriptSecurity(string, parsedURL, parsedURL2);
                if (scriptSecurity != null) {
                    scriptSecurity.checkLoadScript();
                }
            }
        }

        public ExternalResourceSecurity getExternalResourceSecurity(ParsedURL parsedURL, ParsedURL parsedURL2) {
            if (JSVGComponent.this.svgUserAgent != null) {
                return JSVGComponent.this.svgUserAgent.getExternalResourceSecurity(parsedURL, parsedURL2);
            }
            return new RelaxedExternalResourceSecurity(parsedURL, parsedURL2);
        }

        public void checkLoadExternalResource(ParsedURL parsedURL, ParsedURL parsedURL2) throws SecurityException {
            if (JSVGComponent.this.svgUserAgent != null) {
                JSVGComponent.this.svgUserAgent.checkLoadExternalResource(parsedURL, parsedURL2);
            } else {
                ExternalResourceSecurity externalResourceSecurity = this.getExternalResourceSecurity(parsedURL, parsedURL2);
                if (externalResourceSecurity != null) {
                    externalResourceSecurity.checkLoadExternalResource();
                }
            }
        }
    }

    protected static class BridgeUserAgentWrapper
    implements UserAgent {
        protected UserAgent userAgent;

        public BridgeUserAgentWrapper(UserAgent userAgent) {
            this.userAgent = userAgent;
        }

        public EventDispatcher getEventDispatcher() {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.getEventDispatcher();
            }
            class Query
            implements Runnable {
                EventDispatcher result;
                private final /* synthetic */ BridgeUserAgentWrapper this$0;

                Query(BridgeUserAgentWrapper bridgeUserAgentWrapper) {
                    this.this$0 = bridgeUserAgentWrapper;
                }

                public void run() {
                    this.result = this.this$0.userAgent.getEventDispatcher();
                }
            }
            Query query = new Query(this);
            this.invokeAndWait(query);
            return query.result;
        }

        public Dimension2D getViewportSize() {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.getViewportSize();
            }
            class Query
            implements Runnable {
                Dimension2D result;
                private final /* synthetic */ BridgeUserAgentWrapper this$0;

                Query(BridgeUserAgentWrapper bridgeUserAgentWrapper) {
                    this.this$0 = bridgeUserAgentWrapper;
                }

                public void run() {
                    this.result = this.this$0.userAgent.getViewportSize();
                }
            }
            Query query = new Query(this);
            this.invokeAndWait(query);
            return query.result;
        }

        public void displayError(Exception exception) {
            if (EventQueue.isDispatchThread()) {
                this.userAgent.displayError(exception);
            } else {
                EventQueue.invokeLater(new Runnable(this, exception){
                    private final /* synthetic */ Exception val$ex;
                    private final /* synthetic */ BridgeUserAgentWrapper this$0;
                    {
                        this.this$0 = bridgeUserAgentWrapper;
                        this.val$ex = exception;
                    }

                    public void run() {
                        this.this$0.userAgent.displayError(this.val$ex);
                    }
                });
            }
        }

        public void displayMessage(String string) {
            if (EventQueue.isDispatchThread()) {
                this.userAgent.displayMessage(string);
            } else {
                EventQueue.invokeLater(new Runnable(this, string){
                    private final /* synthetic */ String val$message;
                    private final /* synthetic */ BridgeUserAgentWrapper this$0;
                    {
                        this.this$0 = bridgeUserAgentWrapper;
                        this.val$message = string;
                    }

                    public void run() {
                        this.this$0.userAgent.displayMessage(this.val$message);
                    }
                });
            }
        }

        public void showAlert(String string) {
            if (EventQueue.isDispatchThread()) {
                this.userAgent.showAlert(string);
            } else {
                this.invokeAndWait(new Runnable(this, string){
                    private final /* synthetic */ String val$message;
                    private final /* synthetic */ BridgeUserAgentWrapper this$0;
                    {
                        this.this$0 = bridgeUserAgentWrapper;
                        this.val$message = string;
                    }

                    public void run() {
                        this.this$0.userAgent.showAlert(this.val$message);
                    }
                });
            }
        }

        public String showPrompt(String string) {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.showPrompt(string);
            }
            class Query
            implements Runnable {
                String result;
                private final /* synthetic */ String val$message;
                private final /* synthetic */ BridgeUserAgentWrapper this$0;

                Query(BridgeUserAgentWrapper bridgeUserAgentWrapper, String string) {
                    this.this$0 = bridgeUserAgentWrapper;
                    this.val$message = string;
                }

                public void run() {
                    this.result = this.this$0.userAgent.showPrompt(this.val$message);
                }
            }
            Query query = new Query(this, string);
            this.invokeAndWait(query);
            return query.result;
        }

        public String showPrompt(String string, String string2) {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.showPrompt(string, string2);
            }
            class Query
            implements Runnable {
                String result;
                private final /* synthetic */ String val$message;
                private final /* synthetic */ String val$defaultValue;
                private final /* synthetic */ BridgeUserAgentWrapper this$0;

                Query(BridgeUserAgentWrapper bridgeUserAgentWrapper, String string, String string2) {
                    this.this$0 = bridgeUserAgentWrapper;
                    this.val$message = string;
                    this.val$defaultValue = string2;
                }

                public void run() {
                    this.result = this.this$0.userAgent.showPrompt(this.val$message, this.val$defaultValue);
                }
            }
            Query query = new Query(this, string, string2);
            this.invokeAndWait(query);
            return query.result;
        }

        public boolean showConfirm(String string) {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.showConfirm(string);
            }
            class Query
            implements Runnable {
                boolean result;
                private final /* synthetic */ String val$message;
                private final /* synthetic */ BridgeUserAgentWrapper this$0;

                Query(BridgeUserAgentWrapper bridgeUserAgentWrapper, String string) {
                    this.this$0 = bridgeUserAgentWrapper;
                    this.val$message = string;
                }

                public void run() {
                    this.result = this.this$0.userAgent.showConfirm(this.val$message);
                }
            }
            Query query = new Query(this, string);
            this.invokeAndWait(query);
            return query.result;
        }

        public float getPixelUnitToMillimeter() {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.getPixelUnitToMillimeter();
            }
            class Query
            implements Runnable {
                float result;
                private final /* synthetic */ BridgeUserAgentWrapper this$0;

                Query(BridgeUserAgentWrapper bridgeUserAgentWrapper) {
                    this.this$0 = bridgeUserAgentWrapper;
                }

                public void run() {
                    this.result = this.this$0.userAgent.getPixelUnitToMillimeter();
                }
            }
            Query query = new Query(this);
            this.invokeAndWait(query);
            return query.result;
        }

        public float getPixelToMM() {
            return this.getPixelUnitToMillimeter();
        }

        public String getDefaultFontFamily() {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.getDefaultFontFamily();
            }
            class Query
            implements Runnable {
                String result;
                private final /* synthetic */ BridgeUserAgentWrapper this$0;

                Query(BridgeUserAgentWrapper bridgeUserAgentWrapper) {
                    this.this$0 = bridgeUserAgentWrapper;
                }

                public void run() {
                    this.result = this.this$0.userAgent.getDefaultFontFamily();
                }
            }
            Query query = new Query(this);
            this.invokeAndWait(query);
            return query.result;
        }

        public float getMediumFontSize() {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.getMediumFontSize();
            }
            class Query
            implements Runnable {
                float result;
                private final /* synthetic */ BridgeUserAgentWrapper this$0;

                Query(BridgeUserAgentWrapper bridgeUserAgentWrapper) {
                    this.this$0 = bridgeUserAgentWrapper;
                }

                public void run() {
                    this.result = this.this$0.userAgent.getMediumFontSize();
                }
            }
            Query query = new Query(this);
            this.invokeAndWait(query);
            return query.result;
        }

        public float getLighterFontWeight(float f) {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.getLighterFontWeight(f);
            }
            float f2 = f;
            class Query
            implements Runnable {
                float result;
                private final /* synthetic */ float val$ff;
                private final /* synthetic */ BridgeUserAgentWrapper this$0;

                Query(BridgeUserAgentWrapper bridgeUserAgentWrapper, float f) {
                    this.this$0 = bridgeUserAgentWrapper;
                    this.val$ff = f;
                }

                public void run() {
                    this.result = this.this$0.userAgent.getLighterFontWeight(this.val$ff);
                }
            }
            Query query = new Query(this, f2);
            this.invokeAndWait(query);
            return query.result;
        }

        public float getBolderFontWeight(float f) {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.getBolderFontWeight(f);
            }
            float f2 = f;
            class Query
            implements Runnable {
                float result;
                private final /* synthetic */ float val$ff;
                private final /* synthetic */ BridgeUserAgentWrapper this$0;

                Query(BridgeUserAgentWrapper bridgeUserAgentWrapper, float f) {
                    this.this$0 = bridgeUserAgentWrapper;
                    this.val$ff = f;
                }

                public void run() {
                    this.result = this.this$0.userAgent.getBolderFontWeight(this.val$ff);
                }
            }
            Query query = new Query(this, f2);
            this.invokeAndWait(query);
            return query.result;
        }

        public String getLanguages() {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.getLanguages();
            }
            class Query
            implements Runnable {
                String result;
                private final /* synthetic */ BridgeUserAgentWrapper this$0;

                Query(BridgeUserAgentWrapper bridgeUserAgentWrapper) {
                    this.this$0 = bridgeUserAgentWrapper;
                }

                public void run() {
                    this.result = this.this$0.userAgent.getLanguages();
                }
            }
            Query query = new Query(this);
            this.invokeAndWait(query);
            return query.result;
        }

        public String getUserStyleSheetURI() {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.getUserStyleSheetURI();
            }
            class Query
            implements Runnable {
                String result;
                private final /* synthetic */ BridgeUserAgentWrapper this$0;

                Query(BridgeUserAgentWrapper bridgeUserAgentWrapper) {
                    this.this$0 = bridgeUserAgentWrapper;
                }

                public void run() {
                    this.result = this.this$0.userAgent.getUserStyleSheetURI();
                }
            }
            Query query = new Query(this);
            this.invokeAndWait(query);
            return query.result;
        }

        public void openLink(SVGAElement sVGAElement) {
            if (EventQueue.isDispatchThread()) {
                this.userAgent.openLink(sVGAElement);
            } else {
                EventQueue.invokeLater(new Runnable(this, sVGAElement){
                    private final /* synthetic */ SVGAElement val$elt;
                    private final /* synthetic */ BridgeUserAgentWrapper this$0;
                    {
                        this.this$0 = bridgeUserAgentWrapper;
                        this.val$elt = sVGAElement;
                    }

                    public void run() {
                        this.this$0.userAgent.openLink(this.val$elt);
                    }
                });
            }
        }

        public void setSVGCursor(Cursor cursor) {
            if (EventQueue.isDispatchThread()) {
                this.userAgent.setSVGCursor(cursor);
            } else {
                EventQueue.invokeLater(new Runnable(this, cursor){
                    private final /* synthetic */ Cursor val$cursor;
                    private final /* synthetic */ BridgeUserAgentWrapper this$0;
                    {
                        this.this$0 = bridgeUserAgentWrapper;
                        this.val$cursor = cursor;
                    }

                    public void run() {
                        this.this$0.userAgent.setSVGCursor(this.val$cursor);
                    }
                });
            }
        }

        public String getXMLParserClassName() {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.getXMLParserClassName();
            }
            class Query
            implements Runnable {
                String result;
                private final /* synthetic */ BridgeUserAgentWrapper this$0;

                Query(BridgeUserAgentWrapper bridgeUserAgentWrapper) {
                    this.this$0 = bridgeUserAgentWrapper;
                }

                public void run() {
                    this.result = this.this$0.userAgent.getXMLParserClassName();
                }
            }
            Query query = new Query(this);
            this.invokeAndWait(query);
            return query.result;
        }

        public boolean isXMLParserValidating() {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.isXMLParserValidating();
            }
            class Query
            implements Runnable {
                boolean result;
                private final /* synthetic */ BridgeUserAgentWrapper this$0;

                Query(BridgeUserAgentWrapper bridgeUserAgentWrapper) {
                    this.this$0 = bridgeUserAgentWrapper;
                }

                public void run() {
                    this.result = this.this$0.userAgent.isXMLParserValidating();
                }
            }
            Query query = new Query(this);
            this.invokeAndWait(query);
            return query.result;
        }

        public AffineTransform getTransform() {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.getTransform();
            }
            class Query
            implements Runnable {
                AffineTransform result;
                private final /* synthetic */ BridgeUserAgentWrapper this$0;

                Query(BridgeUserAgentWrapper bridgeUserAgentWrapper) {
                    this.this$0 = bridgeUserAgentWrapper;
                }

                public void run() {
                    this.result = this.this$0.userAgent.getTransform();
                }
            }
            Query query = new Query(this);
            this.invokeAndWait(query);
            return query.result;
        }

        public void setTransform(AffineTransform affineTransform) {
            if (EventQueue.isDispatchThread()) {
                this.userAgent.setTransform(affineTransform);
            } else {
                AffineTransform affineTransform2 = affineTransform;
                class Query
                implements Runnable {
                    private final /* synthetic */ AffineTransform val$affine;
                    private final /* synthetic */ BridgeUserAgentWrapper this$0;

                    Query(BridgeUserAgentWrapper bridgeUserAgentWrapper, AffineTransform affineTransform) {
                        this.this$0 = bridgeUserAgentWrapper;
                        this.val$affine = affineTransform;
                    }

                    public void run() {
                        this.this$0.userAgent.setTransform(this.val$affine);
                    }
                }
                Query query = new Query(this, affineTransform2);
                this.invokeAndWait(query);
            }
        }

        public String getMedia() {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.getMedia();
            }
            class Query
            implements Runnable {
                String result;
                private final /* synthetic */ BridgeUserAgentWrapper this$0;

                Query(BridgeUserAgentWrapper bridgeUserAgentWrapper) {
                    this.this$0 = bridgeUserAgentWrapper;
                }

                public void run() {
                    this.result = this.this$0.userAgent.getMedia();
                }
            }
            Query query = new Query(this);
            this.invokeAndWait(query);
            return query.result;
        }

        public String getAlternateStyleSheet() {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.getAlternateStyleSheet();
            }
            class Query
            implements Runnable {
                String result;
                private final /* synthetic */ BridgeUserAgentWrapper this$0;

                Query(BridgeUserAgentWrapper bridgeUserAgentWrapper) {
                    this.this$0 = bridgeUserAgentWrapper;
                }

                public void run() {
                    this.result = this.this$0.userAgent.getAlternateStyleSheet();
                }
            }
            Query query = new Query(this);
            this.invokeAndWait(query);
            return query.result;
        }

        public Point getClientAreaLocationOnScreen() {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.getClientAreaLocationOnScreen();
            }
            class Query
            implements Runnable {
                Point result;
                private final /* synthetic */ BridgeUserAgentWrapper this$0;

                Query(BridgeUserAgentWrapper bridgeUserAgentWrapper) {
                    this.this$0 = bridgeUserAgentWrapper;
                }

                public void run() {
                    this.result = this.this$0.userAgent.getClientAreaLocationOnScreen();
                }
            }
            Query query = new Query(this);
            this.invokeAndWait(query);
            return query.result;
        }

        public boolean hasFeature(String string) {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.hasFeature(string);
            }
            class Query
            implements Runnable {
                boolean result;
                private final /* synthetic */ String val$s;
                private final /* synthetic */ BridgeUserAgentWrapper this$0;

                Query(BridgeUserAgentWrapper bridgeUserAgentWrapper, String string) {
                    this.this$0 = bridgeUserAgentWrapper;
                    this.val$s = string;
                }

                public void run() {
                    this.result = this.this$0.userAgent.hasFeature(this.val$s);
                }
            }
            Query query = new Query(this, string);
            this.invokeAndWait(query);
            return query.result;
        }

        public boolean supportExtension(String string) {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.supportExtension(string);
            }
            class Query
            implements Runnable {
                boolean result;
                private final /* synthetic */ String val$s;
                private final /* synthetic */ BridgeUserAgentWrapper this$0;

                Query(BridgeUserAgentWrapper bridgeUserAgentWrapper, String string) {
                    this.this$0 = bridgeUserAgentWrapper;
                    this.val$s = string;
                }

                public void run() {
                    this.result = this.this$0.userAgent.supportExtension(this.val$s);
                }
            }
            Query query = new Query(this, string);
            this.invokeAndWait(query);
            return query.result;
        }

        public void registerExtension(BridgeExtension bridgeExtension) {
            if (EventQueue.isDispatchThread()) {
                this.userAgent.registerExtension(bridgeExtension);
            } else {
                EventQueue.invokeLater(new Runnable(this, bridgeExtension){
                    private final /* synthetic */ BridgeExtension val$ext;
                    private final /* synthetic */ BridgeUserAgentWrapper this$0;
                    {
                        this.this$0 = bridgeUserAgentWrapper;
                        this.val$ext = bridgeExtension;
                    }

                    public void run() {
                        this.this$0.userAgent.registerExtension(this.val$ext);
                    }
                });
            }
        }

        public void handleElement(Element element, Object object) {
            if (EventQueue.isDispatchThread()) {
                this.userAgent.handleElement(element, object);
            } else {
                EventQueue.invokeLater(new Runnable(this, element, object){
                    private final /* synthetic */ Element val$elt;
                    private final /* synthetic */ Object val$data;
                    private final /* synthetic */ BridgeUserAgentWrapper this$0;
                    {
                        this.this$0 = bridgeUserAgentWrapper;
                        this.val$elt = element;
                        this.val$data = object;
                    }

                    public void run() {
                        this.this$0.userAgent.handleElement(this.val$elt, this.val$data);
                    }
                });
            }
        }

        public ScriptSecurity getScriptSecurity(String string, ParsedURL parsedURL, ParsedURL parsedURL2) {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.getScriptSecurity(string, parsedURL, parsedURL2);
            }
            String string2 = string;
            ParsedURL parsedURL3 = parsedURL;
            ParsedURL parsedURL4 = parsedURL2;
            class Query
            implements Runnable {
                ScriptSecurity result;
                private final /* synthetic */ String val$st;
                private final /* synthetic */ ParsedURL val$sPURL;
                private final /* synthetic */ ParsedURL val$dPURL;
                private final /* synthetic */ BridgeUserAgentWrapper this$0;

                Query(BridgeUserAgentWrapper bridgeUserAgentWrapper, String string, ParsedURL parsedURL, ParsedURL parsedURL2) {
                    this.this$0 = bridgeUserAgentWrapper;
                    this.val$st = string;
                    this.val$sPURL = parsedURL;
                    this.val$dPURL = parsedURL2;
                }

                public void run() {
                    this.result = this.this$0.userAgent.getScriptSecurity(this.val$st, this.val$sPURL, this.val$dPURL);
                }
            }
            Query query = new Query(this, string2, parsedURL3, parsedURL4);
            this.invokeAndWait(query);
            return query.result;
        }

        public void checkLoadScript(String string, ParsedURL parsedURL, ParsedURL parsedURL2) throws SecurityException {
            if (EventQueue.isDispatchThread()) {
                this.userAgent.checkLoadScript(string, parsedURL, parsedURL2);
            } else {
                String string2 = string;
                ParsedURL parsedURL3 = parsedURL;
                ParsedURL parsedURL4 = parsedURL2;
                class Query
                implements Runnable {
                    SecurityException se;
                    private final /* synthetic */ String val$st;
                    private final /* synthetic */ ParsedURL val$sPURL;
                    private final /* synthetic */ ParsedURL val$dPURL;
                    private final /* synthetic */ BridgeUserAgentWrapper this$0;

                    Query(BridgeUserAgentWrapper bridgeUserAgentWrapper, String string, ParsedURL parsedURL, ParsedURL parsedURL2) {
                        this.this$0 = bridgeUserAgentWrapper;
                        this.val$st = string;
                        this.val$sPURL = parsedURL;
                        this.val$dPURL = parsedURL2;
                        this.se = null;
                    }

                    public void run() {
                        try {
                            this.this$0.userAgent.checkLoadScript(this.val$st, this.val$sPURL, this.val$dPURL);
                        }
                        catch (SecurityException securityException) {
                            this.se = securityException;
                        }
                    }
                }
                Query query = new Query(this, string2, parsedURL3, parsedURL4);
                this.invokeAndWait(query);
                if (query.se != null) {
                    query.se.fillInStackTrace();
                    throw query.se;
                }
            }
        }

        public ExternalResourceSecurity getExternalResourceSecurity(ParsedURL parsedURL, ParsedURL parsedURL2) {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.getExternalResourceSecurity(parsedURL, parsedURL2);
            }
            ParsedURL parsedURL3 = parsedURL;
            ParsedURL parsedURL4 = parsedURL2;
            class Query
            implements Runnable {
                ExternalResourceSecurity result;
                private final /* synthetic */ ParsedURL val$rPURL;
                private final /* synthetic */ ParsedURL val$dPURL;
                private final /* synthetic */ BridgeUserAgentWrapper this$0;

                Query(BridgeUserAgentWrapper bridgeUserAgentWrapper, ParsedURL parsedURL, ParsedURL parsedURL2) {
                    this.this$0 = bridgeUserAgentWrapper;
                    this.val$rPURL = parsedURL;
                    this.val$dPURL = parsedURL2;
                }

                public void run() {
                    this.result = this.this$0.userAgent.getExternalResourceSecurity(this.val$rPURL, this.val$dPURL);
                }
            }
            Query query = new Query(this, parsedURL3, parsedURL4);
            this.invokeAndWait(query);
            return query.result;
        }

        public void checkLoadExternalResource(ParsedURL parsedURL, ParsedURL parsedURL2) throws SecurityException {
            if (EventQueue.isDispatchThread()) {
                this.userAgent.checkLoadExternalResource(parsedURL, parsedURL2);
            } else {
                ParsedURL parsedURL3 = parsedURL;
                ParsedURL parsedURL4 = parsedURL2;
                class Query
                implements Runnable {
                    SecurityException se;
                    private final /* synthetic */ ParsedURL val$rPURL;
                    private final /* synthetic */ ParsedURL val$dPURL;
                    private final /* synthetic */ BridgeUserAgentWrapper this$0;

                    Query(BridgeUserAgentWrapper bridgeUserAgentWrapper, ParsedURL parsedURL, ParsedURL parsedURL2) {
                        this.this$0 = bridgeUserAgentWrapper;
                        this.val$rPURL = parsedURL;
                        this.val$dPURL = parsedURL2;
                    }

                    public void run() {
                        try {
                            this.this$0.userAgent.checkLoadExternalResource(this.val$rPURL, this.val$dPURL);
                        }
                        catch (SecurityException securityException) {
                            this.se = securityException;
                        }
                    }
                }
                Query query = new Query(this, parsedURL3, parsedURL4);
                this.invokeAndWait(query);
                if (query.se != null) {
                    query.se.fillInStackTrace();
                    throw query.se;
                }
            }
        }

        protected void invokeAndWait(Runnable runnable) {
            try {
                EventQueue.invokeAndWait(runnable);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected class SVGListener
    extends JGVTComponent.Listener
    implements SVGDocumentLoaderListener,
    GVTTreeBuilderListener,
    SVGLoadEventDispatcherListener,
    UpdateManagerListener {
        protected SVGListener() {
        }

        public void documentLoadingStarted(SVGDocumentLoaderEvent sVGDocumentLoaderEvent) {
        }

        public void documentLoadingCompleted(SVGDocumentLoaderEvent sVGDocumentLoaderEvent) {
            if (JSVGComponent.this.nextDocumentLoader != null) {
                JSVGComponent.this.startDocumentLoader();
                return;
            }
            JSVGComponent.this.documentLoader = null;
            JSVGComponent.this.setSVGDocument(sVGDocumentLoaderEvent.getSVGDocument());
        }

        public void documentLoadingCancelled(SVGDocumentLoaderEvent sVGDocumentLoaderEvent) {
            if (JSVGComponent.this.nextDocumentLoader != null) {
                JSVGComponent.this.startDocumentLoader();
                return;
            }
            JSVGComponent.this.documentLoader = null;
            if (JSVGComponent.this.nextGVTTreeBuilder != null) {
                JSVGComponent.this.startGVTTreeBuilder();
                return;
            }
        }

        public void documentLoadingFailed(SVGDocumentLoaderEvent sVGDocumentLoaderEvent) {
            if (JSVGComponent.this.nextDocumentLoader != null) {
                JSVGComponent.this.startDocumentLoader();
                return;
            }
            JSVGComponent.this.documentLoader = null;
            JSVGComponent.this.userAgent.displayError(((SVGDocumentLoader)sVGDocumentLoaderEvent.getSource()).getException());
            if (JSVGComponent.this.nextGVTTreeBuilder != null) {
                JSVGComponent.this.startGVTTreeBuilder();
                return;
            }
        }

        public void gvtBuildStarted(GVTTreeBuilderEvent gVTTreeBuilderEvent) {
            JSVGComponent.this.removeJGVTComponentListener(JSVGComponent.this.jsvgComponentListener);
            JSVGComponent.this.removeComponentListener(JSVGComponent.this.jsvgComponentListener);
        }

        public void gvtBuildCompleted(GVTTreeBuilderEvent gVTTreeBuilderEvent) {
            Dimension dimension;
            if (JSVGComponent.this.nextGVTTreeBuilder != null) {
                JSVGComponent.this.startGVTTreeBuilder();
                return;
            }
            JSVGComponent.this.loader = null;
            JSVGComponent.this.gvtTreeBuilder = null;
            if (JSVGComponent.this.nextDocumentLoader != null) {
                JSVGComponent.this.startDocumentLoader();
                return;
            }
            Dimension2D dimension2D = JSVGComponent.this.bridgeContext.getDocumentSize();
            Dimension dimension2 = new Dimension((int)dimension2D.getWidth(), (int)dimension2D.getHeight());
            JSVGComponent.this.setMySize(dimension2);
            SVGSVGElement sVGSVGElement = JSVGComponent.this.svgDocument.getRootElement();
            JSVGComponent.this.prevComponentSize = dimension = JSVGComponent.this.getSize();
            if (dimension.width < 1) {
                dimension.width = 1;
            }
            if (dimension.height < 1) {
                dimension.height = 1;
            }
            AffineTransform affineTransform = ViewBox.getViewTransform(JSVGComponent.this.fragmentIdentifier, sVGSVGElement, dimension.width, dimension.height);
            CanvasGraphicsNode canvasGraphicsNode = JSVGComponent.this.getCanvasGraphicsNode(gVTTreeBuilderEvent.getGVTRoot());
            canvasGraphicsNode.setViewingTransform(affineTransform);
            JSVGComponent.this.initialTransform = new AffineTransform();
            JSVGComponent.this.setRenderingTransform(JSVGComponent.this.initialTransform, false);
            JSVGComponent.this.jsvgComponentListener.updateMatrix(JSVGComponent.this.initialTransform);
            JSVGComponent.this.addJGVTComponentListener(JSVGComponent.this.jsvgComponentListener);
            JSVGComponent.this.addComponentListener(JSVGComponent.this.jsvgComponentListener);
            JSVGComponent.this.gvtRoot = null;
            if (JSVGComponent.this.isDynamicDocument && JSVGComponent.this.eventsEnabled) {
                JSVGComponent.this.startSVGLoadEventDispatcher(gVTTreeBuilderEvent.getGVTRoot());
            } else {
                if (JSVGComponent.this.isInteractiveDocument) {
                    JSVGComponent.this.nextUpdateManager = new UpdateManager(JSVGComponent.this.bridgeContext, gVTTreeBuilderEvent.getGVTRoot(), JSVGComponent.this.svgDocument);
                }
                JSVGComponent.super.setGraphicsNode(gVTTreeBuilderEvent.getGVTRoot(), false);
                JSVGComponent.super.scheduleGVTRendering();
            }
        }

        public void gvtBuildCancelled(GVTTreeBuilderEvent gVTTreeBuilderEvent) {
            if (JSVGComponent.this.nextGVTTreeBuilder != null) {
                JSVGComponent.this.startGVTTreeBuilder();
                return;
            }
            JSVGComponent.this.loader = null;
            JSVGComponent.this.gvtTreeBuilder = null;
            if (JSVGComponent.this.nextDocumentLoader != null) {
                JSVGComponent.this.startDocumentLoader();
                return;
            }
            JSVGComponent.this.image = null;
            JSVGComponent.this.repaint();
        }

        public void gvtBuildFailed(GVTTreeBuilderEvent gVTTreeBuilderEvent) {
            if (JSVGComponent.this.nextGVTTreeBuilder != null) {
                JSVGComponent.this.startGVTTreeBuilder();
                return;
            }
            JSVGComponent.this.loader = null;
            JSVGComponent.this.gvtTreeBuilder = null;
            if (JSVGComponent.this.nextDocumentLoader != null) {
                JSVGComponent.this.startDocumentLoader();
                return;
            }
            GraphicsNode graphicsNode = gVTTreeBuilderEvent.getGVTRoot();
            Dimension2D dimension2D = JSVGComponent.this.bridgeContext.getDocumentSize();
            if (graphicsNode == null || dimension2D == null) {
                JSVGComponent.this.image = null;
                JSVGComponent.this.repaint();
            } else {
                Dimension dimension = new Dimension((int)dimension2D.getWidth(), (int)dimension2D.getHeight());
                JSVGComponent.this.setMySize(dimension);
                JSVGComponent.super.setGraphicsNode(graphicsNode, false);
                JSVGComponent.this.computeRenderingTransform();
            }
            JSVGComponent.this.userAgent.displayError(((GVTTreeBuilder)gVTTreeBuilderEvent.getSource()).getException());
        }

        public void svgLoadEventDispatchStarted(SVGLoadEventDispatcherEvent sVGLoadEventDispatcherEvent) {
        }

        public void svgLoadEventDispatchCompleted(SVGLoadEventDispatcherEvent sVGLoadEventDispatcherEvent) {
            JSVGComponent.this.nextUpdateManager = JSVGComponent.this.svgLoadEventDispatcher.getUpdateManager();
            JSVGComponent.this.svgLoadEventDispatcher = null;
            if (JSVGComponent.this.nextGVTTreeBuilder != null) {
                JSVGComponent.this.nextUpdateManager.interrupt();
                JSVGComponent.this.nextUpdateManager = null;
                JSVGComponent.this.startGVTTreeBuilder();
                return;
            }
            if (JSVGComponent.this.nextDocumentLoader != null) {
                JSVGComponent.this.nextUpdateManager.interrupt();
                JSVGComponent.this.nextUpdateManager = null;
                JSVGComponent.this.startDocumentLoader();
                return;
            }
            JSVGComponent.super.setGraphicsNode(sVGLoadEventDispatcherEvent.getGVTRoot(), false);
            JSVGComponent.super.scheduleGVTRendering();
        }

        public void svgLoadEventDispatchCancelled(SVGLoadEventDispatcherEvent sVGLoadEventDispatcherEvent) {
            JSVGComponent.this.nextUpdateManager = JSVGComponent.this.svgLoadEventDispatcher.getUpdateManager();
            JSVGComponent.this.svgLoadEventDispatcher = null;
            JSVGComponent.this.nextUpdateManager.interrupt();
            JSVGComponent.this.nextUpdateManager = null;
            if (JSVGComponent.this.nextGVTTreeBuilder != null) {
                JSVGComponent.this.startGVTTreeBuilder();
                return;
            }
            if (JSVGComponent.this.nextDocumentLoader != null) {
                JSVGComponent.this.startDocumentLoader();
                return;
            }
        }

        public void svgLoadEventDispatchFailed(SVGLoadEventDispatcherEvent sVGLoadEventDispatcherEvent) {
            JSVGComponent.this.nextUpdateManager = JSVGComponent.this.svgLoadEventDispatcher.getUpdateManager();
            JSVGComponent.this.svgLoadEventDispatcher = null;
            JSVGComponent.this.nextUpdateManager.interrupt();
            JSVGComponent.this.nextUpdateManager = null;
            if (JSVGComponent.this.nextGVTTreeBuilder != null) {
                JSVGComponent.this.startGVTTreeBuilder();
                return;
            }
            if (JSVGComponent.this.nextDocumentLoader != null) {
                JSVGComponent.this.startDocumentLoader();
                return;
            }
            GraphicsNode graphicsNode = sVGLoadEventDispatcherEvent.getGVTRoot();
            Dimension2D dimension2D = JSVGComponent.this.bridgeContext.getDocumentSize();
            if (graphicsNode == null || dimension2D == null) {
                JSVGComponent.this.image = null;
                JSVGComponent.this.repaint();
            } else {
                JSVGComponent.super.setGraphicsNode(graphicsNode, false);
                JSVGComponent.this.computeRenderingTransform();
            }
            JSVGComponent.this.userAgent.displayError(((SVGLoadEventDispatcher)sVGLoadEventDispatcherEvent.getSource()).getException());
        }

        public void gvtRenderingCompleted(GVTTreeRendererEvent gVTTreeRendererEvent) {
            super.gvtRenderingCompleted(gVTTreeRendererEvent);
            if (JSVGComponent.this.nextGVTTreeBuilder != null) {
                if (JSVGComponent.this.nextUpdateManager != null) {
                    JSVGComponent.this.nextUpdateManager.interrupt();
                    JSVGComponent.this.nextUpdateManager = null;
                }
                JSVGComponent.this.startGVTTreeBuilder();
                return;
            }
            if (JSVGComponent.this.nextDocumentLoader != null) {
                if (JSVGComponent.this.nextUpdateManager != null) {
                    JSVGComponent.this.nextUpdateManager.interrupt();
                    JSVGComponent.this.nextUpdateManager = null;
                }
                JSVGComponent.this.startDocumentLoader();
                return;
            }
            if (JSVGComponent.this.nextUpdateManager != null) {
                JSVGComponent.this.updateManager = JSVGComponent.this.nextUpdateManager;
                JSVGComponent.this.nextUpdateManager = null;
                JSVGComponent.this.updateManager.addUpdateManagerListener(this);
                JSVGComponent.this.updateManager.manageUpdates(JSVGComponent.this.renderer);
            }
        }

        public void gvtRenderingCancelled(GVTTreeRendererEvent gVTTreeRendererEvent) {
            super.gvtRenderingCancelled(gVTTreeRendererEvent);
            if (JSVGComponent.this.nextGVTTreeBuilder != null) {
                if (JSVGComponent.this.nextUpdateManager != null) {
                    JSVGComponent.this.nextUpdateManager.interrupt();
                    JSVGComponent.this.nextUpdateManager = null;
                }
                JSVGComponent.this.startGVTTreeBuilder();
                return;
            }
            if (JSVGComponent.this.nextDocumentLoader != null) {
                if (JSVGComponent.this.nextUpdateManager != null) {
                    JSVGComponent.this.nextUpdateManager.interrupt();
                    JSVGComponent.this.nextUpdateManager = null;
                }
                JSVGComponent.this.startDocumentLoader();
                return;
            }
        }

        public void gvtRenderingFailed(GVTTreeRendererEvent gVTTreeRendererEvent) {
            super.gvtRenderingFailed(gVTTreeRendererEvent);
            if (JSVGComponent.this.nextGVTTreeBuilder != null) {
                if (JSVGComponent.this.nextUpdateManager != null) {
                    JSVGComponent.this.nextUpdateManager.interrupt();
                    JSVGComponent.this.nextUpdateManager = null;
                }
                JSVGComponent.this.startGVTTreeBuilder();
                return;
            }
            if (JSVGComponent.this.nextDocumentLoader != null) {
                if (JSVGComponent.this.nextUpdateManager != null) {
                    JSVGComponent.this.nextUpdateManager.interrupt();
                    JSVGComponent.this.nextUpdateManager = null;
                }
                JSVGComponent.this.startDocumentLoader();
                return;
            }
        }

        public void managerStarted(UpdateManagerEvent updateManagerEvent) {
            EventQueue.invokeLater(new Runnable(this, updateManagerEvent){
                private final /* synthetic */ UpdateManagerEvent val$e;
                private final /* synthetic */ SVGListener this$1;
                {
                    this.this$1 = sVGListener;
                    this.val$e = updateManagerEvent;
                }

                public void run() {
                    JSVGComponent.access$2303(SVGListener.access$2200(this.this$1), false);
                    Object[] objectArray = SVGListener.access$2200((SVGListener)this.this$1).updateManagerListeners.toArray();
                    if (objectArray.length > 0) {
                        int n = 0;
                        while (n < objectArray.length) {
                            ((UpdateManagerListener)objectArray[n]).managerStarted(this.val$e);
                            ++n;
                        }
                    }
                }
            });
        }

        public void managerSuspended(UpdateManagerEvent updateManagerEvent) {
            EventQueue.invokeLater(new Runnable(this, updateManagerEvent){
                private final /* synthetic */ UpdateManagerEvent val$e;
                private final /* synthetic */ SVGListener this$1;
                {
                    this.this$1 = sVGListener;
                    this.val$e = updateManagerEvent;
                }

                public void run() {
                    Object[] objectArray = SVGListener.access$2200((SVGListener)this.this$1).updateManagerListeners.toArray();
                    if (objectArray.length > 0) {
                        int n = 0;
                        while (n < objectArray.length) {
                            ((UpdateManagerListener)objectArray[n]).managerSuspended(this.val$e);
                            ++n;
                        }
                    }
                }
            });
        }

        public void managerResumed(UpdateManagerEvent updateManagerEvent) {
            EventQueue.invokeLater(new Runnable(this, updateManagerEvent){
                private final /* synthetic */ UpdateManagerEvent val$e;
                private final /* synthetic */ SVGListener this$1;
                {
                    this.this$1 = sVGListener;
                    this.val$e = updateManagerEvent;
                }

                public void run() {
                    Object[] objectArray = SVGListener.access$2200((SVGListener)this.this$1).updateManagerListeners.toArray();
                    if (objectArray.length > 0) {
                        int n = 0;
                        while (n < objectArray.length) {
                            ((UpdateManagerListener)objectArray[n]).managerResumed(this.val$e);
                            ++n;
                        }
                    }
                }
            });
        }

        public void managerStopped(UpdateManagerEvent updateManagerEvent) {
            EventQueue.invokeLater(new Runnable(this, updateManagerEvent){
                private final /* synthetic */ UpdateManagerEvent val$e;
                private final /* synthetic */ SVGListener this$1;
                {
                    this.this$1 = sVGListener;
                    this.val$e = updateManagerEvent;
                }

                public void run() {
                    SVGListener.access$2200((SVGListener)this.this$1).updateManager = null;
                    Object[] objectArray = SVGListener.access$2200((SVGListener)this.this$1).updateManagerListeners.toArray();
                    if (objectArray.length > 0) {
                        int n = 0;
                        while (n < objectArray.length) {
                            ((UpdateManagerListener)objectArray[n]).managerStopped(this.val$e);
                            ++n;
                        }
                    }
                    if (SVGListener.access$2200((SVGListener)this.this$1).nextGVTTreeBuilder != null) {
                        JSVGComponent.access$600(SVGListener.access$2200(this.this$1));
                        return;
                    }
                    if (SVGListener.access$2200((SVGListener)this.this$1).nextDocumentLoader != null) {
                        JSVGComponent.access$000(SVGListener.access$2200(this.this$1));
                        return;
                    }
                }
            });
        }

        public void updateStarted(UpdateManagerEvent updateManagerEvent) {
            EventQueue.invokeLater(new Runnable(this, updateManagerEvent){
                private final /* synthetic */ UpdateManagerEvent val$e;
                private final /* synthetic */ SVGListener this$1;
                {
                    this.this$1 = sVGListener;
                    this.val$e = updateManagerEvent;
                }

                public void run() {
                    Object[] objectArray;
                    if (!JSVGComponent.access$2401(SVGListener.access$2200(this.this$1))) {
                        JSVGComponent.access$2503(SVGListener.access$2200(this.this$1), this.val$e.getImage());
                    }
                    if ((objectArray = SVGListener.access$2200((SVGListener)this.this$1).updateManagerListeners.toArray()).length > 0) {
                        int n = 0;
                        while (n < objectArray.length) {
                            ((UpdateManagerListener)objectArray[n]).updateStarted(this.val$e);
                            ++n;
                        }
                    }
                }
            });
        }

        public void updateCompleted(UpdateManagerEvent updateManagerEvent) {
            try {
                EventQueue.invokeAndWait(new Runnable(this, updateManagerEvent){
                    private final /* synthetic */ UpdateManagerEvent val$e;
                    private final /* synthetic */ SVGListener this$1;
                    {
                        this.this$1 = sVGListener;
                        this.val$e = updateManagerEvent;
                    }

                    public void run() {
                        JSVGComponent.access$2603(SVGListener.access$2200(this.this$1), this.val$e.getImage());
                        List list = this.val$e.getDirtyAreas();
                        if (list != null) {
                            Dimension dimension = SVGListener.access$2200(this.this$1).getSize();
                            List list2 = SVGListener.access$2200(this.this$1).mergeRectangles(list, 0, 0, dimension.width - 1, dimension.height - 1);
                            if (list2.size() < list.size()) {
                                list = list2;
                            }
                            Iterator<E> iterator = list.iterator();
                            while (iterator.hasNext()) {
                                Rectangle rectangle = (Rectangle)iterator.next();
                                if (JSVGComponent.access$2701(SVGListener.access$2200(this.this$1))) {
                                    SVGListener.access$2200(this.this$1).repaint(rectangle);
                                    continue;
                                }
                                SVGListener.access$2200(this.this$1).paintImmediately(rectangle);
                            }
                        }
                        JSVGComponent.access$2803(SVGListener.access$2200(this.this$1), false);
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
            EventQueue.invokeLater(new Runnable(this, updateManagerEvent){
                private final /* synthetic */ UpdateManagerEvent val$e;
                private final /* synthetic */ SVGListener this$1;
                {
                    this.this$1 = sVGListener;
                    this.val$e = updateManagerEvent;
                }

                public void run() {
                    Object[] objectArray = SVGListener.access$2200((SVGListener)this.this$1).updateManagerListeners.toArray();
                    if (objectArray.length > 0) {
                        int n = 0;
                        while (n < objectArray.length) {
                            ((UpdateManagerListener)objectArray[n]).updateCompleted(this.val$e);
                            ++n;
                        }
                    }
                }
            });
        }

        public void updateFailed(UpdateManagerEvent updateManagerEvent) {
            EventQueue.invokeLater(new Runnable(this, updateManagerEvent){
                private final /* synthetic */ UpdateManagerEvent val$e;
                private final /* synthetic */ SVGListener this$1;
                {
                    this.this$1 = sVGListener;
                    this.val$e = updateManagerEvent;
                }

                public void run() {
                    Object[] objectArray = SVGListener.access$2200((SVGListener)this.this$1).updateManagerListeners.toArray();
                    if (objectArray.length > 0) {
                        int n = 0;
                        while (n < objectArray.length) {
                            ((UpdateManagerListener)objectArray[n]).updateFailed(this.val$e);
                            ++n;
                        }
                    }
                }
            });
        }

        protected void dispatchKeyTyped(KeyEvent keyEvent) {
            if (!JSVGComponent.this.isDynamicDocument) {
                super.dispatchKeyTyped(keyEvent);
                return;
            }
            if (JSVGComponent.this.updateManager != null && JSVGComponent.this.updateManager.isRunning()) {
                JSVGComponent.this.updateManager.getUpdateRunnableQueue().invokeLater(new Runnable(this, keyEvent){
                    private final /* synthetic */ KeyEvent val$e;
                    private final /* synthetic */ SVGListener this$1;
                    {
                        this.this$1 = sVGListener;
                        this.val$e = keyEvent;
                    }

                    public void run() {
                        JSVGComponent.access$2901(SVGListener.access$2200(this.this$1)).keyTyped(this.val$e);
                    }
                });
            }
        }

        protected void dispatchKeyPressed(KeyEvent keyEvent) {
            if (!JSVGComponent.this.isDynamicDocument) {
                super.dispatchKeyPressed(keyEvent);
                return;
            }
            if (JSVGComponent.this.updateManager != null && JSVGComponent.this.updateManager.isRunning()) {
                JSVGComponent.this.updateManager.getUpdateRunnableQueue().invokeLater(new Runnable(this, keyEvent){
                    private final /* synthetic */ KeyEvent val$e;
                    private final /* synthetic */ SVGListener this$1;
                    {
                        this.this$1 = sVGListener;
                        this.val$e = keyEvent;
                    }

                    public void run() {
                        JSVGComponent.access$3001(SVGListener.access$2200(this.this$1)).keyPressed(this.val$e);
                    }
                });
            }
        }

        protected void dispatchKeyReleased(KeyEvent keyEvent) {
            if (!JSVGComponent.this.isDynamicDocument) {
                super.dispatchKeyReleased(keyEvent);
                return;
            }
            if (JSVGComponent.this.updateManager != null && JSVGComponent.this.updateManager.isRunning()) {
                JSVGComponent.this.updateManager.getUpdateRunnableQueue().invokeLater(new Runnable(this, keyEvent){
                    private final /* synthetic */ KeyEvent val$e;
                    private final /* synthetic */ SVGListener this$1;
                    {
                        this.this$1 = sVGListener;
                        this.val$e = keyEvent;
                    }

                    public void run() {
                        JSVGComponent.access$3101(SVGListener.access$2200(this.this$1)).keyReleased(this.val$e);
                    }
                });
            }
        }

        protected void dispatchMouseClicked(MouseEvent mouseEvent) {
            if (!JSVGComponent.this.isInteractiveDocument) {
                super.dispatchMouseClicked(mouseEvent);
                return;
            }
            if (JSVGComponent.this.updateManager != null && JSVGComponent.this.updateManager.isRunning()) {
                JSVGComponent.this.updateManager.getUpdateRunnableQueue().invokeLater(new Runnable(this, mouseEvent){
                    private final /* synthetic */ MouseEvent val$e;
                    private final /* synthetic */ SVGListener this$1;
                    {
                        this.this$1 = sVGListener;
                        this.val$e = mouseEvent;
                    }

                    public void run() {
                        JSVGComponent.access$3201(SVGListener.access$2200(this.this$1)).mouseClicked(this.val$e);
                    }
                });
            }
        }

        protected void dispatchMousePressed(MouseEvent mouseEvent) {
            if (!JSVGComponent.this.isDynamicDocument) {
                super.dispatchMousePressed(mouseEvent);
                return;
            }
            if (JSVGComponent.this.updateManager != null && JSVGComponent.this.updateManager.isRunning()) {
                JSVGComponent.this.updateManager.getUpdateRunnableQueue().invokeLater(new Runnable(this, mouseEvent){
                    private final /* synthetic */ MouseEvent val$e;
                    private final /* synthetic */ SVGListener this$1;
                    {
                        this.this$1 = sVGListener;
                        this.val$e = mouseEvent;
                    }

                    public void run() {
                        JSVGComponent.access$3301(SVGListener.access$2200(this.this$1)).mousePressed(this.val$e);
                    }
                });
            }
        }

        protected void dispatchMouseReleased(MouseEvent mouseEvent) {
            if (!JSVGComponent.this.isDynamicDocument) {
                super.dispatchMouseReleased(mouseEvent);
                return;
            }
            if (JSVGComponent.this.updateManager != null && JSVGComponent.this.updateManager.isRunning()) {
                JSVGComponent.this.updateManager.getUpdateRunnableQueue().invokeLater(new Runnable(this, mouseEvent){
                    private final /* synthetic */ MouseEvent val$e;
                    private final /* synthetic */ SVGListener this$1;
                    {
                        this.this$1 = sVGListener;
                        this.val$e = mouseEvent;
                    }

                    public void run() {
                        JSVGComponent.access$3401(SVGListener.access$2200(this.this$1)).mouseReleased(this.val$e);
                    }
                });
            }
        }

        protected void dispatchMouseEntered(MouseEvent mouseEvent) {
            if (!JSVGComponent.this.isInteractiveDocument) {
                super.dispatchMouseEntered(mouseEvent);
                return;
            }
            if (JSVGComponent.this.updateManager != null && JSVGComponent.this.updateManager.isRunning()) {
                JSVGComponent.this.updateManager.getUpdateRunnableQueue().invokeLater(new Runnable(this, mouseEvent){
                    private final /* synthetic */ MouseEvent val$e;
                    private final /* synthetic */ SVGListener this$1;
                    {
                        this.this$1 = sVGListener;
                        this.val$e = mouseEvent;
                    }

                    public void run() {
                        JSVGComponent.access$3501(SVGListener.access$2200(this.this$1)).mouseEntered(this.val$e);
                    }
                });
            }
        }

        protected void dispatchMouseExited(MouseEvent mouseEvent) {
            if (!JSVGComponent.this.isInteractiveDocument) {
                super.dispatchMouseExited(mouseEvent);
                return;
            }
            if (JSVGComponent.this.updateManager != null && JSVGComponent.this.updateManager.isRunning()) {
                JSVGComponent.this.updateManager.getUpdateRunnableQueue().invokeLater(new Runnable(this, mouseEvent){
                    private final /* synthetic */ MouseEvent val$e;
                    private final /* synthetic */ SVGListener this$1;
                    {
                        this.this$1 = sVGListener;
                        this.val$e = mouseEvent;
                    }

                    public void run() {
                        JSVGComponent.access$3601(SVGListener.access$2200(this.this$1)).mouseExited(this.val$e);
                    }
                });
            }
        }

        protected void dispatchMouseDragged(MouseEvent mouseEvent) {
            if (!JSVGComponent.this.isDynamicDocument) {
                super.dispatchMouseDragged(mouseEvent);
                return;
            }
            if (JSVGComponent.this.updateManager != null && JSVGComponent.this.updateManager.isRunning()) {
                class MouseDraggedRunnable
                implements Runnable {
                    MouseEvent event;
                    private final /* synthetic */ SVGListener this$1;

                    MouseDraggedRunnable(SVGListener sVGListener, MouseEvent mouseEvent) {
                        this.this$1 = sVGListener;
                        this.event = mouseEvent;
                    }

                    public void run() {
                        JSVGComponent.access$3701(SVGListener.access$2200(this.this$1)).mouseDragged(this.event);
                    }
                }
                RunnableQueue runnableQueue = JSVGComponent.this.updateManager.getUpdateRunnableQueue();
                Object object = runnableQueue.getIteratorLock();
                synchronized (object) {
                    Iterator iterator = runnableQueue.iterator();
                    while (iterator.hasNext()) {
                        Object e = iterator.next();
                        if (!(e instanceof MouseDraggedRunnable)) continue;
                        MouseDraggedRunnable mouseDraggedRunnable = (MouseDraggedRunnable)e;
                        MouseEvent mouseEvent2 = mouseDraggedRunnable.event;
                        if (mouseEvent2.getModifiers() == mouseEvent.getModifiers()) {
                            mouseDraggedRunnable.event = mouseEvent;
                        }
                        return;
                    }
                }
                runnableQueue.invokeLater(new MouseDraggedRunnable(this, mouseEvent));
            }
        }

        protected void dispatchMouseMoved(MouseEvent mouseEvent) {
            if (!JSVGComponent.this.isInteractiveDocument) {
                super.dispatchMouseMoved(mouseEvent);
                return;
            }
            if (JSVGComponent.this.updateManager != null && JSVGComponent.this.updateManager.isRunning()) {
                class MouseMovedRunnable
                implements Runnable {
                    MouseEvent event;
                    private final /* synthetic */ SVGListener this$1;

                    MouseMovedRunnable(SVGListener sVGListener, MouseEvent mouseEvent) {
                        this.this$1 = sVGListener;
                        this.event = mouseEvent;
                    }

                    public void run() {
                        JSVGComponent.access$3801(SVGListener.access$2200(this.this$1)).mouseMoved(this.event);
                    }
                }
                RunnableQueue runnableQueue = JSVGComponent.this.updateManager.getUpdateRunnableQueue();
                int n = 0;
                Object object = runnableQueue.getIteratorLock();
                synchronized (object) {
                    Iterator iterator = runnableQueue.iterator();
                    while (iterator.hasNext()) {
                        Object e = iterator.next();
                        if (e instanceof MouseMovedRunnable) {
                            MouseMovedRunnable mouseMovedRunnable = (MouseMovedRunnable)e;
                            MouseEvent mouseEvent2 = mouseMovedRunnable.event;
                            if (mouseEvent2.getModifiers() == mouseEvent.getModifiers()) {
                                mouseMovedRunnable.event = mouseEvent;
                            }
                            return;
                        }
                        ++n;
                    }
                }
                runnableQueue.invokeLater(new MouseMovedRunnable(this, mouseEvent));
            }
        }

        static /* synthetic */ JSVGComponent access$2200(SVGListener sVGListener) {
            return sVGListener.JSVGComponent.this;
        }
    }

    class JSVGComponentListener
    extends ComponentAdapter
    implements JGVTComponentListener {
        float prevScale = 0.0f;
        float prevTransX = 0.0f;
        float prevTransY = 0.0f;

        JSVGComponentListener() {
        }

        public void componentResized(ComponentEvent componentEvent) {
            if (JSVGComponent.this.isDynamicDocument && JSVGComponent.this.updateManager != null && JSVGComponent.this.updateManager.isRunning()) {
                JSVGComponent.this.updateManager.getUpdateRunnableQueue().invokeLater(new Runnable(this){
                    private final /* synthetic */ JSVGComponentListener this$1;
                    {
                        this.this$1 = jSVGComponentListener;
                    }

                    public void run() {
                        try {
                            JSVGComponentListener.access$500((JSVGComponentListener)this.this$1).updateManager.dispatchSVGResizeEvent();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                });
            }
        }

        public void componentTransformChanged(ComponentEvent componentEvent) {
            boolean bl;
            AffineTransform affineTransform = JSVGComponent.this.getRenderingTransform();
            float f = (float)Math.sqrt(affineTransform.getDeterminant());
            float f2 = (float)affineTransform.getTranslateX();
            float f3 = (float)affineTransform.getTranslateY();
            boolean bl2 = f != this.prevScale;
            boolean bl3 = bl = f2 != this.prevTransX || f2 != this.prevTransX;
            if (JSVGComponent.this.isDynamicDocument && JSVGComponent.this.updateManager != null && JSVGComponent.this.updateManager.isRunning()) {
                JSVGComponent.this.updateManager.getUpdateRunnableQueue().invokeLater(new Runnable(this, bl2, bl){
                    private final /* synthetic */ boolean val$dispatchZoom;
                    private final /* synthetic */ boolean val$dispatchScroll;
                    private final /* synthetic */ JSVGComponentListener this$1;
                    {
                        this.this$1 = jSVGComponentListener;
                        this.val$dispatchZoom = bl;
                        this.val$dispatchScroll = bl2;
                    }

                    public void run() {
                        try {
                            if (this.val$dispatchZoom) {
                                JSVGComponentListener.access$500((JSVGComponentListener)this.this$1).updateManager.dispatchSVGZoomEvent();
                            }
                            if (this.val$dispatchScroll) {
                                JSVGComponentListener.access$500((JSVGComponentListener)this.this$1).updateManager.dispatchSVGScrollEvent();
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                });
            }
            this.prevScale = f;
            this.prevTransX = f2;
            this.prevTransY = f3;
        }

        public void updateMatrix(AffineTransform affineTransform) {
            this.prevScale = (float)Math.sqrt(affineTransform.getDeterminant());
            this.prevTransX = (float)affineTransform.getTranslateX();
            this.prevTransY = (float)affineTransform.getTranslateY();
        }

        static /* synthetic */ JSVGComponent access$500(JSVGComponentListener jSVGComponentListener) {
            return jSVGComponentListener.JSVGComponent.this;
        }
    }
}

