/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.swing.svg;

import java.io.InterruptedIOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.swing.svg.SVGDocumentLoaderEvent;
import org.apache.batik.swing.svg.SVGDocumentLoaderListener;
import org.apache.batik.util.EventDispatcher;
import org.w3c.dom.svg.SVGDocument;

public class SVGDocumentLoader
extends Thread {
    protected String url;
    protected DocumentLoader loader;
    protected Exception exception;
    protected List listeners = Collections.synchronizedList(new LinkedList());
    protected boolean beenInterrupted;
    static EventDispatcher.Dispatcher startedDispatcher = new EventDispatcher.Dispatcher(){

        public void dispatch(Object object, Object object2) {
            ((SVGDocumentLoaderListener)object).documentLoadingStarted((SVGDocumentLoaderEvent)object2);
        }
    };
    static EventDispatcher.Dispatcher completedDispatcher = new EventDispatcher.Dispatcher(){

        public void dispatch(Object object, Object object2) {
            ((SVGDocumentLoaderListener)object).documentLoadingCompleted((SVGDocumentLoaderEvent)object2);
        }
    };
    static EventDispatcher.Dispatcher cancelledDispatcher = new EventDispatcher.Dispatcher(){

        public void dispatch(Object object, Object object2) {
            ((SVGDocumentLoaderListener)object).documentLoadingCancelled((SVGDocumentLoaderEvent)object2);
        }
    };
    static EventDispatcher.Dispatcher failedDispatcher = new EventDispatcher.Dispatcher(){

        public void dispatch(Object object, Object object2) {
            ((SVGDocumentLoaderListener)object).documentLoadingFailed((SVGDocumentLoaderEvent)object2);
        }
    };

    public SVGDocumentLoader(String string, DocumentLoader documentLoader) {
        this.url = string;
        this.loader = documentLoader;
        this.beenInterrupted = false;
    }

    public boolean getBeenInterrupted() {
        SVGDocumentLoader sVGDocumentLoader = this;
        synchronized (sVGDocumentLoader) {
            boolean bl = this.beenInterrupted;
            return bl;
        }
    }

    public void run() {
        SVGDocumentLoaderEvent sVGDocumentLoaderEvent = new SVGDocumentLoaderEvent(this, null);
        try {
            this.fireEvent(startedDispatcher, sVGDocumentLoaderEvent);
            if (this.getBeenInterrupted()) {
                this.fireEvent(cancelledDispatcher, sVGDocumentLoaderEvent);
                return;
            }
            SVGDocument sVGDocument = (SVGDocument)this.loader.loadDocument(this.url);
            if (this.getBeenInterrupted()) {
                this.fireEvent(cancelledDispatcher, sVGDocumentLoaderEvent);
                return;
            }
            sVGDocumentLoaderEvent = new SVGDocumentLoaderEvent(this, sVGDocument);
            this.fireEvent(completedDispatcher, sVGDocumentLoaderEvent);
        }
        catch (InterruptedIOException interruptedIOException) {
            this.fireEvent(cancelledDispatcher, sVGDocumentLoaderEvent);
        }
        catch (Exception exception) {
            this.exception = exception;
            this.fireEvent(failedDispatcher, sVGDocumentLoaderEvent);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            this.exception = new Exception(throwable.getMessage());
            this.fireEvent(failedDispatcher, sVGDocumentLoaderEvent);
        }
    }

    public void interrupt() {
        super.interrupt();
        SVGDocumentLoader sVGDocumentLoader = this;
        synchronized (sVGDocumentLoader) {
            this.beenInterrupted = true;
        }
    }

    public Exception getException() {
        return this.exception;
    }

    public void addSVGDocumentLoaderListener(SVGDocumentLoaderListener sVGDocumentLoaderListener) {
        this.listeners.add(sVGDocumentLoaderListener);
    }

    public void removeSVGDocumentLoaderListener(SVGDocumentLoaderListener sVGDocumentLoaderListener) {
        this.listeners.remove(sVGDocumentLoaderListener);
    }

    public void fireEvent(EventDispatcher.Dispatcher dispatcher, Object object) {
        EventDispatcher.fireEvent(dispatcher, this.listeners, object, true);
    }
}

