/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.events;

import java.util.Enumeration;
import java.util.Vector;
import org.jacorb.events.JacORBEventChannelPOA;
import org.jacorb.events.ProxyPullConsumerImpl;
import org.jacorb.events.ProxyPullSupplierImpl;
import org.jacorb.events.ProxyPushConsumerImpl;
import org.jacorb.events.ProxyPushSupplierImpl;
import org.omg.CORBA.Any;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.TCKind;
import org.omg.CosEventChannelAdmin.ConsumerAdmin;
import org.omg.CosEventChannelAdmin.ConsumerAdminHelper;
import org.omg.CosEventChannelAdmin.ProxyPullConsumer;
import org.omg.CosEventChannelAdmin.ProxyPullSupplier;
import org.omg.CosEventChannelAdmin.ProxyPushConsumer;
import org.omg.CosEventChannelAdmin.ProxyPushSupplier;
import org.omg.CosEventChannelAdmin.SupplierAdmin;
import org.omg.CosEventChannelAdmin.SupplierAdminHelper;
import org.omg.CosNaming.NamingContextExt;
import org.omg.CosNaming.NamingContextExtHelper;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.POAPackage.ObjectNotActive;
import org.omg.PortableServer.POAPackage.WrongPolicy;
import org.omg.PortableServer.Servant;

public class EventChannelImpl
extends JacORBEventChannelPOA {
    private Vector pullSuppliers = new Vector();
    private Vector pullConsumers = new Vector();
    private Vector pushSuppliers = new Vector();
    private Vector pushConsumers = new Vector();
    private Vector pendingEvents = new Vector();
    private Any nullAny = null;
    private ORB myOrb = null;
    private POA myPoa = null;

    private final void consumerAdminDestroy() {
        this.releaseList(this.pullSuppliers);
        this.releaseList(this.pushSuppliers);
    }

    private final void supplierAdminDestroy() {
        this.releaseList(this.pullConsumers);
        this.releaseList(this.pushConsumers);
    }

    private final void releaseList(Vector vector) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Servant servant = (Servant)enumeration.nextElement();
            this.releaseServant(servant);
        }
    }

    private final void releaseServant(Servant servant) {
        try {
            servant._poa().deactivate_object(servant._object_id());
        }
        catch (WrongPolicy wrongPolicy) {
            wrongPolicy.printStackTrace();
        }
        catch (ObjectNotActive objectNotActive) {
            objectNotActive.printStackTrace();
        }
    }

    public void destroy() {
        this.consumerAdminDestroy();
        this.supplierAdminDestroy();
        this.releaseServant(this);
    }

    public ConsumerAdmin for_consumers() {
        try {
            return ConsumerAdminHelper.narrow(this.myPoa.servant_to_reference(this));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public SupplierAdmin for_suppliers() {
        try {
            return SupplierAdminHelper.narrow(this.myPoa.servant_to_reference(this));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public ProxyPullConsumer obtain_pull_consumer() {
        Vector vector = this.pullConsumers;
        synchronized (vector) {
            ProxyPullConsumerImpl proxyPullConsumerImpl = new ProxyPullConsumerImpl(this, this._orb(), this.myPoa);
            this.pullConsumers.addElement(proxyPullConsumerImpl);
            return proxyPullConsumerImpl._this(this.myOrb);
        }
    }

    public ProxyPullSupplier obtain_pull_supplier() {
        Vector vector = this.pullSuppliers;
        synchronized (vector) {
            ProxyPullSupplierImpl proxyPullSupplierImpl = new ProxyPullSupplierImpl(this, this._orb(), this.myPoa);
            this.pullSuppliers.addElement(proxyPullSupplierImpl);
            return proxyPullSupplierImpl._this(this.myOrb);
        }
    }

    public ProxyPushConsumer obtain_push_consumer() {
        Vector vector = this.pushConsumers;
        synchronized (vector) {
            ProxyPushConsumerImpl proxyPushConsumerImpl = new ProxyPushConsumerImpl(this, this._orb(), this.myPoa);
            this.pushConsumers.addElement(proxyPushConsumerImpl);
            return proxyPushConsumerImpl._this(this.myOrb);
        }
    }

    public ProxyPushSupplier obtain_push_supplier() {
        Vector vector = this.pushSuppliers;
        synchronized (vector) {
            ProxyPushSupplierImpl proxyPushSupplierImpl = new ProxyPushSupplierImpl(this, this._orb(), this.myPoa);
            this.pushSuppliers.addElement(proxyPushSupplierImpl);
            return proxyPushSupplierImpl._this(this.myOrb);
        }
    }

    protected void push_event(Any any) {
        int n;
        ProxyPushSupplierImpl proxyPushSupplierImpl = null;
        ProxyPullSupplierImpl proxyPullSupplierImpl = null;
        Vector vector = this.pushSuppliers;
        synchronized (vector) {
            n = this.pushSuppliers.size() - 1;
            while (n >= 0) {
                proxyPushSupplierImpl = (ProxyPushSupplierImpl)this.pushSuppliers.elementAt(n);
                try {
                    proxyPushSupplierImpl.push_to_consumer(any);
                }
                catch (COMM_FAILURE cOMM_FAILURE) {
                    this.pushSuppliers.removeElementAt(n);
                }
                --n;
            }
        }
        vector = this.pullSuppliers;
        synchronized (vector) {
            n = this.pullSuppliers.size() - 1;
            while (n >= 0) {
                proxyPullSupplierImpl = (ProxyPullSupplierImpl)this.pullSuppliers.elementAt(n);
                try {
                    proxyPullSupplierImpl.push_to_supplier(any);
                }
                catch (COMM_FAILURE cOMM_FAILURE) {
                    this.pullSuppliers.removeElementAt(n);
                }
                --n;
            }
        }
    }

    public static void main(String[] stringArray) {
        ORB oRB = ORB.init(stringArray, null);
        try {
            POA pOA = POAHelper.narrow(oRB.resolve_initial_references("RootPOA"));
            EventChannelImpl eventChannelImpl = new EventChannelImpl(oRB, pOA);
            pOA.the_POAManager().activate();
            Object object = pOA.servant_to_reference(eventChannelImpl);
            NamingContextExt namingContextExt = NamingContextExtHelper.narrow(oRB.resolve_initial_references("NameService"));
            String string = stringArray.length > 0 ? stringArray[0] : "Generic.channel";
            namingContextExt.bind(namingContextExt.to_name(string), object);
            oRB.run();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public POA _default_POA() {
        return this.myPoa;
    }

    public EventChannelImpl(ORB oRB, POA pOA) {
        this.myOrb = oRB;
        this.myPoa = pOA;
        this._this_object(this.myOrb);
        this.nullAny = this.myOrb.create_any();
        this.nullAny.type(this.myOrb.get_primitive_tc(TCKind.tk_null));
        try {
            this.myPoa = pOA;
            this.myPoa.the_POAManager().activate();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

