/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.ir;

import org.jacorb.ir.IRObject;
import org.omg.CORBA.DefinitionKind;
import org.omg.CORBA.INTF_REPOS;
import org.omg.CORBA.ORB;
import org.omg.CORBA.PrimitiveDefOperations;
import org.omg.CORBA.PrimitiveKind;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;

public final class PrimitiveDef
extends IRObject
implements PrimitiveDefOperations {
    protected PrimitiveKind kind;
    protected TypeCode type;

    public final TypeCode type() {
        return this.type;
    }

    public final PrimitiveKind kind() {
        return this.kind;
    }

    public final void destroy() {
    }

    final void define() {
    }

    public PrimitiveDef(TypeCode typeCode) {
        this.type = typeCode;
        this.def_kind = DefinitionKind.dk_Primitive;
        int n = typeCode.kind().value();
        switch (n) {
            case 0: {
                this.kind = PrimitiveKind.pk_null;
                break;
            }
            case 1: {
                this.kind = PrimitiveKind.pk_void;
                break;
            }
            case 2: {
                this.kind = PrimitiveKind.pk_short;
                break;
            }
            case 3: {
                this.kind = PrimitiveKind.pk_long;
                break;
            }
            case 4: {
                this.kind = PrimitiveKind.pk_ushort;
                break;
            }
            case 5: {
                this.kind = PrimitiveKind.pk_ulong;
                break;
            }
            case 6: {
                this.kind = PrimitiveKind.pk_float;
                break;
            }
            case 7: {
                this.kind = PrimitiveKind.pk_double;
                break;
            }
            case 8: {
                this.kind = PrimitiveKind.pk_boolean;
                break;
            }
            case 9: {
                this.kind = PrimitiveKind.pk_char;
                break;
            }
            case 23: {
                this.kind = PrimitiveKind.pk_longlong;
                break;
            }
            case 24: {
                this.kind = PrimitiveKind.pk_ulonglong;
                break;
            }
            case 25: {
                this.kind = PrimitiveKind.pk_longdouble;
                break;
            }
            case 26: {
                this.kind = PrimitiveKind.pk_wchar;
                break;
            }
            case 27: {
                this.kind = PrimitiveKind.pk_wstring;
                break;
            }
            case 10: {
                this.kind = PrimitiveKind.pk_octet;
                break;
            }
            case 11: {
                this.kind = PrimitiveKind.pk_any;
                break;
            }
            case 12: {
                this.kind = PrimitiveKind.pk_TypeCode;
                break;
            }
            case 13: {
                this.kind = PrimitiveKind.pk_Principal;
                break;
            }
            case 18: {
                this.kind = PrimitiveKind.pk_string;
                break;
            }
            case 14: {
                this.kind = PrimitiveKind.pk_objref;
                break;
            }
            default: {
                throw new INTF_REPOS("Unrecognized kind: " + this.kind);
            }
        }
    }

    public PrimitiveDef(int n) {
        this.def_kind = DefinitionKind.dk_Primitive;
        this.kind = PrimitiveKind.from_int(n);
        switch (n) {
            case 0: {
                this.type = ORB.init().get_primitive_tc(TCKind.tk_null);
                break;
            }
            case 1: {
                this.type = ORB.init().get_primitive_tc(TCKind.tk_void);
                break;
            }
            case 2: {
                this.type = ORB.init().get_primitive_tc(TCKind.tk_short);
                break;
            }
            case 3: {
                this.type = ORB.init().get_primitive_tc(TCKind.tk_long);
                break;
            }
            case 6: {
                this.type = ORB.init().get_primitive_tc(TCKind.tk_float);
                break;
            }
            case 7: {
                this.type = ORB.init().get_primitive_tc(TCKind.tk_double);
                break;
            }
            case 8: {
                this.type = ORB.init().get_primitive_tc(TCKind.tk_boolean);
                break;
            }
            case 9: {
                this.type = ORB.init().get_primitive_tc(TCKind.tk_char);
                break;
            }
            case 10: {
                this.type = ORB.init().get_primitive_tc(TCKind.tk_octet);
                break;
            }
            case 11: {
                this.type = ORB.init().get_primitive_tc(TCKind.tk_any);
                break;
            }
            case 12: {
                this.type = ORB.init().get_primitive_tc(TCKind.tk_TypeCode);
                break;
            }
            case 13: {
                this.type = ORB.init().get_primitive_tc(TCKind.tk_Principal);
                break;
            }
            case 14: {
                this.type = ORB.init().get_primitive_tc(TCKind.tk_string);
                break;
            }
            case 15: {
                this.type = ORB.init().get_primitive_tc(TCKind.tk_objref);
                break;
            }
            default: {
                throw new INTF_REPOS("Unrecognized kind: " + this.kind);
            }
        }
    }
}

