/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.ir;

import java.util.Hashtable;
import org.jacorb.orb.TypeCode;
import org.jacorb.util.Debug;

public class TypeCodeUtil {
    private static Hashtable cache = new Hashtable();

    public static org.omg.CORBA.TypeCode getTypeCode(Class clazz, Object object) throws ClassNotFoundException {
        return TypeCodeUtil.getTypeCode(clazz, null, object, null);
    }

    public static org.omg.CORBA.TypeCode getTypeCode(Class clazz, ClassLoader classLoader, Object object, String string) throws ClassNotFoundException {
        String string2 = clazz.getName();
        Debug.output(3, "TypeCodes.getTypeCode for class : " + string2 + " idlName: " + string);
        ClassLoader classLoader2 = classLoader != null ? classLoader : clazz.getClassLoader();
        org.omg.CORBA.TypeCode typeCode = (org.omg.CORBA.TypeCode)cache.get(string2);
        if (typeCode != null) {
            return typeCode;
        }
        if (string != null && (typeCode = (org.omg.CORBA.TypeCode)cache.get(string)) != null) {
            return typeCode;
        }
        if (clazz.isPrimitive()) {
            if (string2.equals("void")) {
                return new TypeCode(1);
            }
            if (string2.equals("int")) {
                return new TypeCode(3);
            }
            if (string2.equals("long")) {
                return new TypeCode(23);
            }
            if (string2.equals("short")) {
                return new TypeCode(2);
            }
            if (string2.equals("float")) {
                return new TypeCode(6);
            }
            if (string2.equals("double")) {
                return new TypeCode(7);
            }
            if (string2.equals("boolean")) {
                return new TypeCode(8);
            }
            if (string2.equals("byte")) {
                return new TypeCode(10);
            }
            if (string2.equals("char")) {
                return new TypeCode(9);
            }
            if (string2.equals("wchar")) {
                return new TypeCode(26);
            }
            System.err.println("- TypeCode.getTypeCode, primitive class not found " + string2);
            return null;
        }
        Class<?> clazz2 = null;
        Class<?> clazz3 = null;
        try {
            clazz2 = Class.forName("org.omg.CORBA.TypeCode", true, classLoader2);
            clazz3 = Class.forName("org.omg.CORBA.portable.IDLEntity", true, classLoader2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Debug.output(3, classNotFoundException);
            System.err.println("Serious Error, can't load org.jacorb base classes!");
            throw classNotFoundException;
        }
        boolean bl = false;
        if (clazz2.isAssignableFrom(clazz)) {
            return new TypeCode(12);
        }
        if (string != null && string.length() > 0) {
            try {
                if (string.equals("java.lang.String")) {
                    return new TypeCode(18);
                }
                if (string.equals("org.omg.CORBA.Boolean")) {
                    return new TypeCode(8);
                }
                if (string.equals("org.omg.CORBA.Byte")) {
                    return new TypeCode(10);
                }
                if (string.equals("org.omg.CORBA.Short")) {
                    return new TypeCode(2);
                }
                if (string.equals("org.omg.CORBA.Long")) {
                    return new TypeCode(23);
                }
                if (string.equals("org.omg.CORBA.Int")) {
                    return new TypeCode(3);
                }
                if (string.equals("org.omg.CORBA.String")) {
                    return new TypeCode(18);
                }
                if (string.equals("org.omg.CORBA.Char")) {
                    return new TypeCode(9);
                }
                if (string.equals("org.omg.CORBA.Float")) {
                    return new TypeCode(6);
                }
                if (string.equals("org.omg.CORBA.Double")) {
                    return new TypeCode(7);
                }
                if (string.equals("org.omg.CORBA.Any")) {
                    return new TypeCode(11);
                }
                if (string.equals("org.omg.CORBA.Object")) {
                    return new TypeCode(14);
                }
                if (string.equals("org.omg.CORBA.TypeCode")) {
                    return new TypeCode(12);
                }
                Class<?> clazz4 = Class.forName(string + "Helper", true, classLoader2);
                return (org.omg.CORBA.TypeCode)clazz4.getDeclaredMethod("type", null).invoke(null, null);
            }
            catch (ClassNotFoundException classNotFoundException) {
                Debug.output(3, classNotFoundException);
                throw new RuntimeException("Could not create TypeCode for: " + clazz.getName() + ", no helper class for " + string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (clazz3.isAssignableFrom(clazz)) {
            try {
                Class<?> clazz5 = Class.forName(clazz.getName() + "Helper", true, classLoader2);
                return (org.omg.CORBA.TypeCode)clazz5.getDeclaredMethod("type", null).invoke(null, null);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new RuntimeException("Could not create TypeCode for: " + clazz.getName());
            }
        }
        throw new RuntimeException("Could not create TypeCode for: " + clazz.getName() + ", not an IDLEntity");
    }

    private static final String idToIDL(String string) {
        string = string.startsWith("IDL:") ? string.substring(4, string.lastIndexOf(":")) : string.replace('.', '/') + ":1.0";
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = 0;
        while (n < stringBuffer.length()) {
            if (stringBuffer.charAt(n) == '/') {
                stringBuffer.setCharAt(n, ':');
                stringBuffer.insert(n, ':');
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    static {
        cache.put("java.lang.String", new TypeCode(18));
        cache.put("org.omg.CORBA.String", new TypeCode(18));
        cache.put("java.lang.Void", new TypeCode(1));
        cache.put("java.lang.Long", new TypeCode(23));
        cache.put("java.lang.Integer", new TypeCode(3));
        cache.put("java.lang.Short", new TypeCode(2));
        cache.put("java.lang.Float", new TypeCode(6));
        cache.put("java.lang.Double", new TypeCode(7));
        cache.put("java.lang.Boolean", new TypeCode(8));
        cache.put("java.lang.Byte", new TypeCode(10));
        cache.put("org.omg.CORBA.Any", new TypeCode(11));
        cache.put("java.lang.Character", new TypeCode(9));
        cache.put("org.omg.CORBA.TypeCode", new TypeCode(12));
        cache.put("org.omg.CORBA.Principal", new TypeCode(13));
        cache.put("org.omg.CORBA.Object", new TypeCode(14, "IDL:omg.org/CORBA/Object:1.0", "IDL:omg.org/CORBA/Object:1.0"));
    }
}

