/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.ir.gui.typesystem.remote;

import java.util.Enumeration;
import java.util.Vector;
import org.jacorb.ir.gui.typesystem.Interface;
import org.jacorb.ir.gui.typesystem.ModelParticipant;
import org.jacorb.ir.gui.typesystem.TypeSystemNode;
import org.jacorb.ir.gui.typesystem.remote.IRAttribute;
import org.jacorb.ir.gui.typesystem.remote.IRConstant;
import org.jacorb.ir.gui.typesystem.remote.IRContainer;
import org.jacorb.ir.gui.typesystem.remote.IRException;
import org.jacorb.ir.gui.typesystem.remote.IROperation;
import org.jacorb.ir.gui.typesystem.remote.IRTypedef;
import org.jacorb.ir.gui.typesystem.remote.RemoteTypeSystem;
import org.omg.CORBA.IRObject;
import org.omg.CORBA.InterfaceDef;
import org.omg.CORBA.InterfaceDefHelper;

public class IRInterface
extends IRContainer
implements Interface {
    private IRInterface[] superInterfaces = null;
    private IRAttribute[] allFields = null;
    private IROperation[] allOperations = null;

    public String[] allowedToAdd() {
        String[] stringArray = new String[]{IRAttribute.nodeTypeName(), IROperation.nodeTypeName(), IRConstant.nodeTypeName(), IRTypedef.nodeTypeName(), IRException.nodeTypeName()};
        return stringArray;
    }

    public String description() {
        String string = super.description();
        Interface[] interfaceArray = this.getSuperInterfaces();
        if (interfaceArray.length > 0) {
            string = string + "\nSuper-Interfaces:\t ";
            int n = 0;
            while (n < interfaceArray.length) {
                string = string + ((TypeSystemNode)((Object)interfaceArray[n])).getAbsoluteName();
                if (n != interfaceArray.length - 1) {
                    string = string + ", ";
                }
                ++n;
            }
        } else {
            string = string + "\nSuper-Interfaces:\t:none";
        }
        return string;
    }

    public TypeSystemNode[] getAllFields() {
        if (this.allFields == null) {
            Vector<ModelParticipant> vector = new Vector<ModelParticipant>();
            Interface[] interfaceArray = this.getSuperInterfaces();
            int n = 0;
            while (n < interfaceArray.length) {
                TypeSystemNode[] typeSystemNodeArray = interfaceArray[n].getAllFields();
                int n2 = 0;
                while (n2 < typeSystemNodeArray.length) {
                    vector.addElement(typeSystemNodeArray[n2]);
                    ++n2;
                }
                ++n;
            }
            ModelParticipant[] modelParticipantArray = this.contents();
            int n3 = 0;
            while (n3 < modelParticipantArray.length) {
                if (modelParticipantArray[n3] instanceof IRAttribute) {
                    vector.addElement(modelParticipantArray[n3]);
                }
                ++n3;
            }
            this.allFields = new IRAttribute[vector.size()];
            n3 = 0;
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                this.allFields[n3] = (IRAttribute)enumeration.nextElement();
                ++n3;
            }
        }
        return this.allFields;
    }

    public TypeSystemNode[] getAllOperations() {
        if (this.allOperations == null) {
            Vector<ModelParticipant> vector = new Vector<ModelParticipant>();
            Interface[] interfaceArray = this.getSuperInterfaces();
            int n = 0;
            while (n < interfaceArray.length) {
                TypeSystemNode[] typeSystemNodeArray = interfaceArray[n].getAllOperations();
                int n2 = 0;
                while (n2 < typeSystemNodeArray.length) {
                    vector.addElement(typeSystemNodeArray[n2]);
                    ++n2;
                }
                ++n;
            }
            ModelParticipant[] modelParticipantArray = this.contents();
            int n3 = 0;
            while (n3 < modelParticipantArray.length) {
                if (modelParticipantArray[n3] instanceof IROperation) {
                    vector.addElement(modelParticipantArray[n3]);
                }
                ++n3;
            }
            this.allOperations = new IROperation[vector.size()];
            n3 = 0;
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                this.allOperations[n3] = (IROperation)enumeration.nextElement();
                ++n3;
            }
        }
        return this.allOperations;
    }

    public Interface[] getSuperInterfaces() {
        if (this.superInterfaces == null) {
            InterfaceDef interfaceDef = InterfaceDefHelper.narrow(this.irObject);
            InterfaceDef[] interfaceDefArray = interfaceDef.base_interfaces();
            this.superInterfaces = new IRInterface[interfaceDefArray.length];
            int n = 0;
            while (n < interfaceDefArray.length) {
                IRInterface iRInterface;
                this.superInterfaces[n] = iRInterface = (IRInterface)RemoteTypeSystem.createTypeSystemNode(interfaceDefArray[n]);
                ++n;
            }
        }
        return this.superInterfaces;
    }

    public static String nodeTypeName() {
        return "interface";
    }

    protected void setIRObject(IRObject iRObject) {
        super.setIRObject(iRObject);
    }

    public IRInterface() {
    }

    public IRInterface(IRObject iRObject) {
        super(iRObject);
    }
}

