/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification;

import EDU.oswego.cs.dl.util.concurrent.ReadWriteLock;
import EDU.oswego.cs.dl.util.concurrent.Sync;
import EDU.oswego.cs.dl.util.concurrent.WriterPreferenceReadWriteLock;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.notification.ApplicationContext;
import org.jacorb.notification.ConstraintEntry;
import org.jacorb.notification.EventTypeIdentifier;
import org.jacorb.notification.MessageFactory;
import org.jacorb.notification.filter.DynamicEvaluator;
import org.jacorb.notification.filter.EvaluationContext;
import org.jacorb.notification.filter.EvaluationException;
import org.jacorb.notification.filter.FilterConstraint;
import org.jacorb.notification.interfaces.Disposable;
import org.jacorb.notification.interfaces.Message;
import org.jacorb.notification.util.CachingWildcardMap;
import org.jacorb.notification.util.WildcardMap;
import org.jacorb.util.Debug;
import org.omg.CORBA.Any;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CosNotification.Property;
import org.omg.CosNotification.StructuredEvent;
import org.omg.CosNotifyComm.NotifySubscribe;
import org.omg.CosNotifyFilter.ConstraintExp;
import org.omg.CosNotifyFilter.ConstraintInfo;
import org.omg.CosNotifyFilter.ConstraintNotFound;
import org.omg.CosNotifyFilter.FilterPOA;
import org.omg.CosNotifyFilter.InvalidConstraint;
import org.omg.CosNotifyFilter.UnsupportedFilterableData;
import org.omg.DynamicAny.DynAnyFactory;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAPackage.ObjectNotActive;
import org.omg.PortableServer.POAPackage.WrongPolicy;

public class FilterImpl
extends FilterPOA
implements Disposable {
    static Logger logger_ = Debug.getNamedLogger((class$Lorg$jacorb$notification$FilterImpl != null ? class$Lorg$jacorb$notification$FilterImpl : (class$Lorg$jacorb$notification$FilterImpl = FilterImpl.class$("org.jacorb.notification.FilterImpl"))).getName());
    static final RuntimeException NOT_SUPPORTED = new UnsupportedOperationException();
    public static final int NO_CONSTRAINT = Integer.MIN_VALUE;
    protected Map callbacks_;
    protected Map constraints_;
    protected WildcardMap wildcardMap_;
    protected ReadWriteLock constraintsLock_;
    private String constraintGrammar_;
    protected int constraintIdPool_ = 0;
    protected ApplicationContext applicationContext_;
    protected DynamicEvaluator dynamicEvaluator_;
    protected DynAnyFactory dynAnyFactory_;
    protected MessageFactory messageFactory_;
    private static /* synthetic */ Class class$Lorg$jacorb$notification$FilterImpl;

    public void init() {
    }

    protected int getConstraintId() {
        return ++this.constraintIdPool_;
    }

    protected void releaseConstraintId(int n) {
    }

    public String constraint_grammar() {
        return this.constraintGrammar_;
    }

    public ConstraintInfo[] add_constraints(ConstraintExp[] constraintExpArray) throws InvalidConstraint {
        FilterConstraint[] filterConstraintArray = new FilterConstraint[constraintExpArray.length];
        int n = 0;
        while (n < constraintExpArray.length) {
            filterConstraintArray[n] = new FilterConstraint(constraintExpArray[n]);
            ++n;
        }
        ConstraintInfo[] constraintInfoArray = new ConstraintInfo[constraintExpArray.length];
        try {
            ConstraintInfo[] constraintInfoArray2;
            this.constraintsLock_.writeLock().acquire();
            try {
                int n2 = 0;
                while (n2 < constraintExpArray.length) {
                    int n3 = this.getConstraintId();
                    constraintInfoArray[n2] = new ConstraintInfo(constraintExpArray[n2], n3);
                    ConstraintEntry constraintEntry = new ConstraintEntry(n3, filterConstraintArray[n2], constraintInfoArray[n2]);
                    int n4 = constraintEntry.getEventTypeCount();
                    int n5 = 0;
                    while (n5 < n4) {
                        EventTypeIdentifier eventTypeIdentifier = constraintEntry.getEventTypeIdentifier(n5);
                        LinkedList<ConstraintEntry> linkedList = (LinkedList<ConstraintEntry>)this.wildcardMap_.getNoExpansion(eventTypeIdentifier.getConstraintKey());
                        if (linkedList == null) {
                            linkedList = new LinkedList<ConstraintEntry>();
                            this.wildcardMap_.put(eventTypeIdentifier, linkedList);
                        }
                        linkedList.add(constraintEntry);
                        ++n5;
                    }
                    this.constraints_.put(new Integer(n3), constraintEntry);
                    ++n2;
                }
                constraintInfoArray2 = constraintInfoArray;
                Object var5_13 = null;
            }
            catch (Throwable throwable) {
                Object var5_14 = null;
                this.constraintsLock_.writeLock().release();
                throw throwable;
            }
            this.constraintsLock_.writeLock().release();
            return constraintInfoArray2;
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    public void modify_constraints(int[] nArray, ConstraintInfo[] constraintInfoArray) throws ConstraintNotFound, InvalidConstraint {
        try {
            this.constraintsLock_.writeLock().acquire();
            try {
                List list;
                EventTypeIdentifier eventTypeIdentifier;
                int n;
                int n2;
                Integer[] integerArray = new Integer[nArray.length];
                int n3 = 0;
                while (n3 < nArray.length) {
                    integerArray[n3] = new Integer(nArray[n3]);
                    if (!this.constraints_.containsKey(integerArray[n3])) {
                        throw new ConstraintNotFound(nArray[n3]);
                    }
                    ++n3;
                }
                Integer[] integerArray2 = new Integer[constraintInfoArray.length];
                FilterConstraint[] filterConstraintArray = new FilterConstraint[constraintInfoArray.length];
                int n4 = 0;
                while (n4 < constraintInfoArray.length) {
                    integerArray2[n4] = new Integer(constraintInfoArray[n4].constraint_id);
                    if (!this.constraints_.containsKey(integerArray2[n4])) {
                        throw new ConstraintNotFound(constraintInfoArray[n4].constraint_id);
                    }
                    filterConstraintArray[n4] = new FilterConstraint(constraintInfoArray[n4].constraint_expression);
                    int n5 = constraintInfoArray[n4].constraint_expression.event_types.length;
                    ++n4;
                }
                n4 = 0;
                while (n4 < nArray.length) {
                    ConstraintEntry constraintEntry = (ConstraintEntry)this.constraints_.remove(integerArray[n4]);
                    n2 = constraintEntry.getEventTypeCount();
                    n = 0;
                    while (n < n2) {
                        eventTypeIdentifier = constraintEntry.getEventTypeIdentifier(n);
                        list = (List)this.wildcardMap_.getNoExpansion(eventTypeIdentifier.getConstraintKey());
                        Iterator iterator = list.iterator();
                        while (iterator.hasNext()) {
                            ConstraintEntry constraintEntry2 = (ConstraintEntry)iterator.next();
                            if (constraintEntry2.getConstraintId() != integerArray[n4].intValue()) continue;
                            iterator.remove();
                            break;
                        }
                        ++n;
                    }
                    ++n4;
                }
                n4 = 0;
                while (n4 < constraintInfoArray.length) {
                    ConstraintEntry constraintEntry = new ConstraintEntry(integerArray2[n4], filterConstraintArray[n4], constraintInfoArray[n4]);
                    this.constraints_.put(integerArray2[n4], constraintEntry);
                    n2 = constraintEntry.getEventTypeCount();
                    n = 0;
                    while (n < n2) {
                        eventTypeIdentifier = constraintEntry.getEventTypeIdentifier(n);
                        list = (List)this.wildcardMap_.getNoExpansion(eventTypeIdentifier.getConstraintKey());
                        list.add(constraintEntry);
                        ++n;
                    }
                    ++n4;
                }
                Object var4_17 = null;
            }
            catch (Throwable throwable) {
                Object var4_18 = null;
                this.constraintsLock_.writeLock().release();
                throw throwable;
            }
            this.constraintsLock_.writeLock().release();
            return;
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            return;
        }
    }

    public ConstraintInfo[] get_constraints(int[] nArray) throws ConstraintNotFound {
        ConstraintInfo[] constraintInfoArray = new ConstraintInfo[nArray.length];
        Sync sync = this.constraintsLock_.readLock();
        try {
            ConstraintInfo[] constraintInfoArray2;
            sync.acquire();
            try {
                int n = 0;
                while (n < nArray.length) {
                    Integer n2 = new Integer(nArray[n]);
                    if (!this.constraints_.containsKey(n2)) {
                        throw new ConstraintNotFound(nArray[n]);
                    }
                    constraintInfoArray[n] = ((ConstraintEntry)this.constraints_.get(n2)).getConstraintInfo();
                    ++n;
                }
                constraintInfoArray2 = constraintInfoArray;
                Object var5_7 = null;
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                sync.release();
                throw throwable;
            }
            sync.release();
            return constraintInfoArray2;
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    public ConstraintInfo[] get_all_constraints() {
        try {
            ConstraintInfo[] constraintInfoArray;
            this.constraintsLock_.readLock().acquire();
            try {
                ConstraintInfo[] constraintInfoArray2 = new ConstraintInfo[this.constraints_.size()];
                Iterator iterator = this.constraints_.values().iterator();
                int n = -1;
                while (iterator.hasNext()) {
                    constraintInfoArray2[++n] = ((ConstraintEntry)iterator.next()).getConstraintInfo();
                }
                constraintInfoArray = constraintInfoArray2;
                Object var2_5 = null;
            }
            catch (Throwable throwable) {
                Object var2_6 = null;
                this.constraintsLock_.readLock().release();
                throw throwable;
            }
            this.constraintsLock_.readLock().release();
            return constraintInfoArray;
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    public void remove_all_constraints() {
        try {
            this.constraintsLock_.writeLock().acquire();
            try {
                this.constraints_.clear();
                this.wildcardMap_.clear();
                Object var2_1 = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.constraintsLock_.writeLock().release();
                throw throwable;
            }
            this.constraintsLock_.writeLock().release();
            return;
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            return;
        }
    }

    public void destroy() {
        this.dispose();
    }

    Iterator getConstraintsForEvent(Message message) {
        String string = message.getConstraintKey();
        return this.getIterator(string);
    }

    public Iterator getIterator(Object object) {
        Object[] objectArray = this.wildcardMap_.getWithExpansion(object);
        return new ConstraintIterator(objectArray);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final int match(EvaluationContext evaluationContext, Message message) throws UnsupportedFilterableData {
        try {
            int n;
            this.constraintsLock_.readLock().acquire();
            try {
                if (!this.constraints_.isEmpty()) {
                    Iterator iterator = this.getConstraintsForEvent(message);
                    while (iterator.hasNext()) {
                        int n2;
                        ConstraintEntry constraintEntry = (ConstraintEntry)iterator.next();
                        try {
                            boolean bl = constraintEntry.getFilterConstraint().evaluate(evaluationContext, message).getBool();
                            if (!bl) continue;
                            n2 = constraintEntry.getConstraintId();
                            Object var4_9 = null;
                        }
                        catch (EvaluationException evaluationException) {
                            logger_.fatalError("Error evaluating filter", evaluationException);
                            continue;
                        }
                        this.constraintsLock_.readLock().release();
                        return n2;
                    }
                } else {
                    logger_.info("Filter has no Expressions");
                }
                n = Integer.MIN_VALUE;
            }
            catch (Throwable throwable) {
                Object var4_11 = null;
                this.constraintsLock_.readLock().release();
                throw throwable;
            }
            Object var4_10 = null;
            this.constraintsLock_.readLock().release();
            return n;
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            return Integer.MIN_VALUE;
        }
    }

    public boolean match(Any any) throws UnsupportedFilterableData {
        return this.match_internal(any) != Integer.MIN_VALUE;
    }

    protected int match_internal(Any any) throws UnsupportedFilterableData {
        int n;
        EvaluationContext evaluationContext = null;
        Disposable disposable = null;
        try {
            evaluationContext = this.applicationContext_.newEvaluationContext();
            disposable = this.messageFactory_.newMessage(any);
            n = this.match(evaluationContext, (Message)disposable);
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            try {
                disposable.dispose();
            }
            catch (Exception exception) {
                logger_.fatalError("Error disposing event", exception);
            }
            try {
                evaluationContext.dispose();
            }
            catch (Exception exception) {
                logger_.fatalError("Error disposing EvaluationContext", exception);
            }
            throw throwable;
        }
        try {
            disposable.dispose();
        }
        catch (Exception exception) {
            logger_.fatalError("Error disposing event", exception);
        }
        try {
            evaluationContext.dispose();
        }
        catch (Exception exception) {
            logger_.fatalError("Error disposing EvaluationContext", exception);
        }
        return n;
    }

    public boolean match_structured(StructuredEvent structuredEvent) throws UnsupportedFilterableData {
        return this.match_structured_internal(structuredEvent) != Integer.MIN_VALUE;
    }

    protected int match_structured_internal(StructuredEvent structuredEvent) throws UnsupportedFilterableData {
        int n;
        EvaluationContext evaluationContext = null;
        Disposable disposable = null;
        try {
            evaluationContext = this.applicationContext_.newEvaluationContext();
            disposable = this.messageFactory_.newMessage(structuredEvent);
            n = this.match(evaluationContext, (Message)disposable);
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            try {
                disposable.dispose();
            }
            catch (Exception exception) {
                logger_.fatalError("Error disposing event", exception);
            }
            try {
                evaluationContext.dispose();
            }
            catch (Exception exception) {
                logger_.fatalError("Error releasing EvaluationContext", exception);
            }
            throw throwable;
        }
        try {
            disposable.dispose();
        }
        catch (Exception exception) {
            logger_.fatalError("Error disposing event", exception);
        }
        try {
            evaluationContext.dispose();
        }
        catch (Exception exception) {
            logger_.fatalError("Error releasing EvaluationContext", exception);
        }
        return n;
    }

    public boolean match_typed(Property[] propertyArray) throws UnsupportedFilterableData {
        throw new NO_IMPLEMENT();
    }

    public int attach_callback(NotifySubscribe notifySubscribe) {
        throw new NO_IMPLEMENT();
    }

    public void detach_callback(int n) {
        throw new NO_IMPLEMENT();
    }

    public int[] get_callbacks() {
        throw new NO_IMPLEMENT();
    }

    public POA _default_POA() {
        return this.applicationContext_.getPoa();
    }

    public void dispose() {
        try {
            this._poa().deactivate_object(this._object_id());
        }
        catch (WrongPolicy wrongPolicy) {
            logger_.fatalError("error deactivating object", wrongPolicy);
        }
        catch (ObjectNotActive objectNotActive) {
            logger_.fatalError("error deactivating object", objectNotActive);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public FilterImpl(ApplicationContext applicationContext, String string) {
        if (logger_.isInfoEnabled()) {
            logger_.info("Created filter for Grammar: " + string);
        }
        this.constraintGrammar_ = string;
        this.applicationContext_ = applicationContext;
        this.messageFactory_ = applicationContext.getMessageFactory();
        this.dynAnyFactory_ = applicationContext.getDynAnyFactory();
        this.dynamicEvaluator_ = applicationContext.getDynamicEvaluator();
        this.constraints_ = new HashMap();
        this.constraintsLock_ = new WriterPreferenceReadWriteLock();
        this.wildcardMap_ = new CachingWildcardMap(4);
    }

    private static class ConstraintIterator
    implements Iterator {
        Object[] arrayOfLists_;
        Iterator current_;
        int currentListIdx_ = 0;

        public boolean hasNext() {
            return this.current_.hasNext();
        }

        public Object next() {
            Object e = this.current_.next();
            if (!this.current_.hasNext() && this.currentListIdx_ < this.arrayOfLists_.length - 1) {
                this.current_ = ((List)this.arrayOfLists_[++this.currentListIdx_]).iterator();
            }
            return e;
        }

        public void remove() {
            throw NOT_SUPPORTED;
        }

        ConstraintIterator(Object[] objectArray) {
            this.arrayOfLists_ = objectArray;
            if (logger_.isDebugEnabled()) {
                int n = 0;
                while (n < this.arrayOfLists_.length) {
                    logger_.debug(n + ": " + this.arrayOfLists_[n]);
                    ++n;
                }
            }
            this.current_ = ((List)this.arrayOfLists_[this.currentListIdx_]).iterator();
        }
    }
}

