/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedInt;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.notification.ChannelContext;
import org.jacorb.notification.FilterCallback;
import org.jacorb.notification.SubscriptionChangeListener;
import org.jacorb.util.Debug;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CosNotification.EventType;
import org.omg.CosNotifyFilter.Filter;
import org.omg.CosNotifyFilter.FilterAdminOperations;
import org.omg.CosNotifyFilter.FilterNotFound;

public class FilterManager
implements FilterAdminOperations,
SubscriptionChangeListener {
    public static final FilterManager EMPTY_FILTER_MANAGER = new FilterManager(Collections.EMPTY_MAP);
    private static final Integer[] INTEGER_ARRAY_TEMPLATE = new Integer[0];
    private Logger logger_ = Debug.getNamedLogger(this.getClass().getName());
    private ChannelContext channelContext_;
    private Map filters_;
    private Object filtersLock_;
    private boolean filtersModified_;
    private List filtersReadOnlyView_;
    private SynchronizedInt filterIdPool_ = new SynchronizedInt(0);
    private Map filterId2callbackId_ = new Hashtable();

    private final Integer getFilterId() {
        return new Integer(this.filterIdPool_.increment());
    }

    public int add_filter(Filter filter) {
        Integer n = this.getFilterId();
        if (this.logger_.isWarnEnabled()) {
            try {
                if (!((ObjectImpl)((Object)filter))._is_local()) {
                    this.logger_.warn("filter is not local!");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Object object = this.filtersLock_;
        synchronized (object) {
            this.filters_.put(n, filter);
            this.filtersModified_ = true;
        }
        return n;
    }

    public void remove_filter(int n) throws FilterNotFound {
        Integer n2 = new Integer(n);
        Object object = this.filtersLock_;
        synchronized (object) {
            if (!this.filters_.containsKey(n2)) {
                throw new FilterNotFound("Filter with ID=" + n2 + " does not exist");
            }
            this.filters_.remove(n2);
            this.filtersModified_ = true;
        }
    }

    public Filter get_filter(int n) throws FilterNotFound {
        Filter filter;
        Integer n2 = new Integer(n);
        Object object = this.filtersLock_;
        synchronized (object) {
            filter = (Filter)this.filters_.get(n2);
        }
        if (filter == null) {
            throw new FilterNotFound("Filter with ID=" + n2 + " does not exist");
        }
        return filter;
    }

    public int[] get_all_filters() {
        Integer[] integerArray;
        Object object = this.filtersLock_;
        synchronized (object) {
            integerArray = this.filters_.keySet().toArray(INTEGER_ARRAY_TEMPLATE);
        }
        int[] nArray = new int[integerArray.length];
        int n = 0;
        while (n < integerArray.length) {
            nArray[n] = integerArray[n];
            ++n;
        }
        return nArray;
    }

    public void remove_all_filters() {
        Object object = this.filtersLock_;
        synchronized (object) {
            this.filters_.clear();
            this.filtersModified_ = true;
        }
    }

    public List getFilters() {
        Object object = this.filtersLock_;
        synchronized (object) {
            if (this.filtersModified_) {
                ArrayList arrayList = new ArrayList();
                arrayList.addAll(this.filters_.values());
                this.filtersReadOnlyView_ = Collections.unmodifiableList(arrayList);
                this.filtersModified_ = false;
            }
        }
        return this.filtersReadOnlyView_;
    }

    public void subscriptionChangedForFilter(int n, EventType[] eventTypeArray, EventType[] eventTypeArray2) {
    }

    private final void attachFilterListener(int n, Filter filter) {
        FilterCallback filterCallback = new FilterCallback(this, this.channelContext_.getORB(), n, filter);
        this.filterId2callbackId_.put(new Integer(n), filterCallback);
    }

    private final void detachFilterListener(int n) {
        Integer n2 = new Integer(n);
        if (this.filterId2callbackId_.containsKey(n2)) {
            FilterCallback filterCallback = (FilterCallback)this.filterId2callbackId_.remove(n2);
            filterCallback.dispose();
        }
    }

    protected FilterManager(Map map) {
        this.filters_ = map;
        this.filtersLock_ = map;
        this.filtersModified_ = true;
    }

    public FilterManager(ChannelContext channelContext) {
        this(new HashMap());
        this.channelContext_ = channelContext;
    }
}

