/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification;

import java.util.Hashtable;
import java.util.Map;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.notification.ApplicationContext;
import org.jacorb.notification.FilterImpl;
import org.jacorb.notification.interfaces.Disposable;
import org.jacorb.util.Debug;
import org.omg.CORBA.Any;
import org.omg.CORBA.AnyHolder;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.TypeCode;
import org.omg.CosNotification.Property;
import org.omg.CosNotification.StructuredEvent;
import org.omg.CosNotifyFilter.ConstraintExp;
import org.omg.CosNotifyFilter.ConstraintInfo;
import org.omg.CosNotifyFilter.ConstraintNotFound;
import org.omg.CosNotifyFilter.InvalidConstraint;
import org.omg.CosNotifyFilter.InvalidValue;
import org.omg.CosNotifyFilter.MappingConstraintInfo;
import org.omg.CosNotifyFilter.MappingConstraintPair;
import org.omg.CosNotifyFilter.MappingFilterPOA;
import org.omg.CosNotifyFilter.UnsupportedFilterableData;

public class MappingFilterImpl
extends MappingFilterPOA
implements Disposable {
    Logger logger_ = Debug.getNamedLogger(this.getClass().getName());
    private FilterImpl filterImpl_;
    private Any defaultValue_;
    private ValueMap valueMap_ = new ValueMap();

    public void destroy() {
        this.dispose();
    }

    public void dispose() {
        this.filterImpl_.dispose();
        this.valueMap_.dispose();
        this.defaultValue_ = null;
    }

    public String constraint_grammar() {
        return this.filterImpl_.constraint_grammar();
    }

    public TypeCode value_type() {
        return this.defaultValue_.type();
    }

    public Any default_value() {
        return this.defaultValue_;
    }

    public MappingConstraintInfo[] add_mapping_constraints(MappingConstraintPair[] mappingConstraintPairArray) throws InvalidValue, InvalidConstraint {
        ConstraintExp[] constraintExpArray = new ConstraintExp[mappingConstraintPairArray.length];
        int n = 0;
        while (n < mappingConstraintPairArray.length) {
            constraintExpArray[n] = mappingConstraintPairArray[n].constraint_expression;
            ++n;
        }
        ConstraintInfo[] constraintInfoArray = this.filterImpl_.add_constraints(constraintExpArray);
        MappingConstraintInfo[] mappingConstraintInfoArray = new MappingConstraintInfo[constraintInfoArray.length];
        int n2 = 0;
        while (n2 < constraintInfoArray.length) {
            mappingConstraintInfoArray[n2] = new MappingConstraintInfo(constraintInfoArray[n2].constraint_expression, constraintInfoArray[n2].constraint_id, mappingConstraintPairArray[n2].result_to_set);
            this.valueMap_.put(constraintInfoArray[n2].constraint_id, mappingConstraintPairArray[n2].result_to_set);
            ++n2;
        }
        return mappingConstraintInfoArray;
    }

    public void modify_mapping_constraints(int[] nArray, MappingConstraintInfo[] mappingConstraintInfoArray) throws ConstraintNotFound, InvalidValue, InvalidConstraint {
        ConstraintInfo[] constraintInfoArray = new ConstraintInfo[mappingConstraintInfoArray.length];
        int n = 0;
        while (n < constraintInfoArray.length) {
            constraintInfoArray[n] = new ConstraintInfo(mappingConstraintInfoArray[n].constraint_expression, mappingConstraintInfoArray[n].constraint_id);
            this.valueMap_.remove(mappingConstraintInfoArray[n].constraint_id);
            ++n;
        }
        this.filterImpl_.modify_constraints(nArray, constraintInfoArray);
        n = 0;
        while (n < mappingConstraintInfoArray.length) {
            this.valueMap_.put(mappingConstraintInfoArray[n].constraint_id, mappingConstraintInfoArray[n].value);
            ++n;
        }
    }

    public MappingConstraintInfo[] get_mapping_constraints(int[] nArray) throws ConstraintNotFound {
        ConstraintInfo[] constraintInfoArray = this.filterImpl_.get_constraints(nArray);
        MappingConstraintInfo[] mappingConstraintInfoArray = new MappingConstraintInfo[constraintInfoArray.length];
        int n = 0;
        while (n < constraintInfoArray.length) {
            mappingConstraintInfoArray[n] = new MappingConstraintInfo(constraintInfoArray[n].constraint_expression, constraintInfoArray[n].constraint_id, this.valueMap_.get(constraintInfoArray[n].constraint_id));
            ++n;
        }
        return mappingConstraintInfoArray;
    }

    public MappingConstraintInfo[] get_all_mapping_constraints() {
        ConstraintInfo[] constraintInfoArray = this.filterImpl_.get_all_constraints();
        MappingConstraintInfo[] mappingConstraintInfoArray = new MappingConstraintInfo[constraintInfoArray.length];
        int n = 0;
        while (n < constraintInfoArray.length) {
            mappingConstraintInfoArray[n] = new MappingConstraintInfo(constraintInfoArray[n].constraint_expression, constraintInfoArray[n].constraint_id, this.valueMap_.get(constraintInfoArray[n].constraint_id));
            ++n;
        }
        return mappingConstraintInfoArray;
    }

    public void remove_all_mapping_constraints() {
        this.filterImpl_.remove_all_constraints();
        this.valueMap_.dispose();
    }

    public boolean match(Any any, AnyHolder anyHolder) throws UnsupportedFilterableData {
        int n = this.filterImpl_.match_internal(any);
        if (n != Integer.MIN_VALUE) {
            anyHolder.value = this.valueMap_.get(n);
            return true;
        }
        return false;
    }

    public boolean match_structured(StructuredEvent structuredEvent, AnyHolder anyHolder) throws UnsupportedFilterableData {
        int n = this.filterImpl_.match_structured_internal(structuredEvent);
        if (n != Integer.MIN_VALUE) {
            anyHolder.value = this.valueMap_.get(n);
            return true;
        }
        return false;
    }

    public boolean match_typed(Property[] propertyArray, AnyHolder anyHolder) throws UnsupportedFilterableData {
        throw new NO_IMPLEMENT();
    }

    public MappingFilterImpl(ApplicationContext applicationContext, FilterImpl filterImpl, Any any) {
        this.filterImpl_ = filterImpl;
        this.defaultValue_ = any;
    }

    private static class ValueMap {
        private Map valueMap_ = new Hashtable();

        public void put(int n, Any any) {
            this.valueMap_.put(new Integer(n), any);
        }

        public Any get(int n) {
            return (Any)this.valueMap_.get(new Integer(n));
        }

        public Any remove(int n) {
            return (Any)this.valueMap_.remove(new Integer(n));
        }

        public void dispose() {
            this.valueMap_.clear();
        }

        ValueMap() {
        }
    }
}

