/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.engine;

import org.jacorb.notification.engine.AbstractTask;
import org.jacorb.notification.engine.TaskFactory;
import org.jacorb.notification.engine.TaskProcessor;
import org.jacorb.notification.interfaces.Disposable;
import org.jacorb.notification.interfaces.MessageConsumer;
import org.jacorb.notification.util.TaskExecutor;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CosEventComm.Disconnected;

public abstract class AbstractDeliverTask
extends AbstractTask {
    private MessageConsumer messageConsumer_;

    public static void scheduleTasks(AbstractDeliverTask[] abstractDeliverTaskArray) throws InterruptedException {
        int n = 0;
        while (n < abstractDeliverTaskArray.length) {
            abstractDeliverTaskArray[n].schedule(false);
            ++n;
        }
    }

    public void reset() {
        super.reset();
        this.messageConsumer_ = null;
    }

    protected MessageConsumer getMessageConsumer() {
        return this.messageConsumer_;
    }

    public void setMessageConsumer(MessageConsumer messageConsumer) {
        this.messageConsumer_ = messageConsumer;
    }

    public void handleTaskError(AbstractTask abstractTask, Throwable throwable) {
        Disposable disposable;
        if (this.logger_.isDebugEnabled()) {
            this.logger_.debug("Entering Exceptionhandler for Task:" + abstractTask.getClass().getName(), throwable);
        }
        AbstractDeliverTask abstractDeliverTask = (AbstractDeliverTask)abstractTask;
        if (throwable instanceof OBJECT_NOT_EXIST) {
            if (this.logger_.isWarnEnabled()) {
                this.logger_.warn("push to Consumer failed: Dispose MessageConsumer");
            }
            abstractDeliverTask.getMessageConsumer().dispose();
        } else if (throwable instanceof Disconnected) {
            this.logger_.error("Illegal State: disconnect proxy");
            abstractDeliverTask.getMessageConsumer().dispose();
        } else {
            disposable = abstractDeliverTask.getMessageConsumer();
            if (this.logger_.isInfoEnabled()) {
                this.logger_.info(disposable + "/errorCount: " + disposable.getErrorCounter());
                this.logger_.info(disposable + "/errorThreshold: " + disposable.getErrorThreshold());
            }
            if (disposable.getErrorCounter() > disposable.getErrorThreshold()) {
                if (this.logger_.isWarnEnabled()) {
                    this.logger_.warn("MessageConsumer is repeatingly failing. Error Counter is: " + disposable.getErrorCounter() + ". The MessageConsumer will be disconnected");
                }
                disposable.dispose();
            } else {
                disposable.incErrorCounter();
                if (this.logger_.isInfoEnabled()) {
                    this.logger_.info("Increased the ErrorCount for " + disposable + " to " + disposable.getErrorCounter());
                }
                disposable.disableDelivery();
                try {
                    disposable.deliverMessage(abstractDeliverTask.removeMessage());
                    this.logger_.info("will backoff MessageConsumer for a while");
                    this.taskProcessor_.backoutMessageConsumer((MessageConsumer)disposable);
                }
                catch (Exception exception) {
                    this.logger_.error("a disabled MessageConsumer should not throw  an exception during deliverEvent", exception);
                    try {
                        disposable.dispose();
                    }
                    catch (Exception exception2) {
                        this.logger_.debug("Error disposing misbehaving Consumer", exception2);
                    }
                }
            }
        }
        disposable = abstractDeliverTask.removeMessage();
        if (disposable != null) {
            disposable.dispose();
        }
        abstractDeliverTask.dispose();
    }

    protected void schedule(boolean bl) throws InterruptedException {
        this.schedule(this.getTaskExecutor(), bl);
    }

    public void schedule() throws InterruptedException {
        this.schedule(!this.getTaskExecutor().isTaskQueued());
    }

    protected TaskExecutor getTaskExecutor() {
        return this.getMessageConsumer().getExecutor();
    }

    protected AbstractDeliverTask(TaskProcessor taskProcessor, TaskFactory taskFactory) {
        super(null, taskProcessor, taskFactory);
    }
}

