/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.engine;

import org.apache.avalon.framework.logger.Logger;
import org.jacorb.notification.engine.TaskFactory;
import org.jacorb.notification.engine.TaskProcessor;
import org.jacorb.notification.interfaces.AbstractPoolable;
import org.jacorb.notification.interfaces.Message;
import org.jacorb.notification.util.TaskExecutor;
import org.jacorb.util.Debug;

public abstract class AbstractTask
extends AbstractPoolable
implements Runnable {
    protected Logger logger_ = Debug.getNamedLogger(this.getClass().getName());
    protected Message message_;
    protected TaskProcessor taskProcessor_;
    protected TaskFactory taskFactory_;
    private TaskExecutor executor_;

    protected TaskExecutor getTaskExecutor() {
        return this.executor_;
    }

    public void setMessage(Message message) {
        if (this.message_ != null) {
            throw new RuntimeException("remove old first");
        }
        this.message_ = message;
    }

    public Message removeMessage() {
        Message message = this.message_;
        this.message_ = null;
        return message;
    }

    public Message copyMessage() {
        return (Message)this.message_.clone();
    }

    public abstract void doWork() throws Exception;

    public void run() {
        try {
            if (this.message_ == null || !this.isMessageInvalid()) {
                this.doWork();
            }
            if (this.isMessageInvalid()) {
                this.dispose();
                return;
            }
        }
        catch (Throwable throwable) {
            this.handleTaskError(this, throwable);
        }
    }

    abstract void handleTaskError(AbstractTask var1, Throwable var2);

    public void reset() {
        this.message_ = null;
    }

    private final boolean isMessageInvalid() {
        return this.message_ != null && this.message_.isInvalid();
    }

    protected void checkInterrupt() throws InterruptedException {
        if (Thread.currentThread().isInterrupted() || this.message_.isInvalid()) {
            throw new InterruptedException();
        }
    }

    protected void schedule(boolean bl) throws InterruptedException {
        if (bl) {
            this.run();
        } else {
            this.executor_.execute(this);
        }
    }

    protected void schedule(TaskExecutor taskExecutor, boolean bl) throws InterruptedException {
        if (bl) {
            this.run();
        } else {
            taskExecutor.execute(this);
        }
    }

    public abstract void schedule() throws InterruptedException;

    protected AbstractTask(TaskExecutor taskExecutor, TaskProcessor taskProcessor, TaskFactory taskFactory) {
        this.executor_ = taskExecutor;
        this.taskProcessor_ = taskProcessor;
        this.taskFactory_ = taskFactory;
    }
}

