/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.engine;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jacorb.notification.engine.AbstractDeliverTask;
import org.jacorb.notification.engine.AbstractFilterTask;
import org.jacorb.notification.engine.FilterProxySupplierTask;
import org.jacorb.notification.engine.TaskFactory;
import org.jacorb.notification.engine.TaskProcessor;
import org.jacorb.notification.interfaces.FilterStage;
import org.jacorb.notification.util.TaskExecutor;

public class FilterConsumerAdminTask
extends AbstractFilterTask {
    private static final FilterStage[] NO_CURRENT_FILTER_STAGE = new FilterStage[0];
    private static int COUNT = 0;
    private int id_ = ++COUNT;
    protected List listOfFilterStageWithMessageConsumer_ = new ArrayList();

    public String toString() {
        return "[FilterConsumerAdminTask#" + this.id_ + "]";
    }

    public void setFilterStage(AbstractFilterTask abstractFilterTask) {
        this.arrayCurrentFilterStage_ = abstractFilterTask.getFilterStageToBeProcessed();
    }

    public FilterStage[] getFilterStagesWithMessageConsumer() {
        return this.listOfFilterStageWithMessageConsumer_.toArray(AbstractFilterTask.FILTERSTAGE_ARRAY_TEMPLATE);
    }

    private final void clearFilterStagesWithMessageConsumer() {
        this.listOfFilterStageWithMessageConsumer_.clear();
    }

    public void reset() {
        super.reset();
        this.clearFilterStagesWithMessageConsumer();
        this.arrayCurrentFilterStage_ = NO_CURRENT_FILTER_STAGE;
    }

    public void doWork() throws InterruptedException {
        this.filter();
        FilterStage[] filterStageArray = this.getFilterStagesWithMessageConsumer();
        FilterProxySupplierTask filterProxySupplierTask = null;
        if (filterStageArray.length > 0) {
            AbstractDeliverTask[] abstractDeliverTaskArray = null;
            abstractDeliverTaskArray = this.taskFactory_.newPushToConsumerTask(filterStageArray, this.copyMessage());
            AbstractDeliverTask.scheduleTasks(abstractDeliverTaskArray);
        }
        filterProxySupplierTask = this.taskFactory_.newFilterProxySupplierTask(this);
        filterProxySupplierTask.schedule();
        this.dispose();
    }

    private final void filter() throws InterruptedException {
        int n = 0;
        while (n < this.arrayCurrentFilterStage_.length) {
            this.checkInterrupt();
            boolean bl = false;
            if (!this.arrayCurrentFilterStage_[n].isDisposed()) {
                bl = this.message_.match(this.arrayCurrentFilterStage_[n]);
            }
            if (bl) {
                if (this.arrayCurrentFilterStage_[n].hasInterFilterGroupOperatorOR()) {
                    this.listOfFilterStageWithMessageConsumer_.addAll(this.arrayCurrentFilterStage_[n].getSubsequentFilterStages());
                } else {
                    this.addFilterStage(this.arrayCurrentFilterStage_[n].getSubsequentFilterStages());
                }
            } else {
                Iterator iterator = this.arrayCurrentFilterStage_[n].getSubsequentFilterStages().iterator();
                while (iterator.hasNext()) {
                    FilterStage filterStage = (FilterStage)iterator.next();
                    if (!filterStage.hasInterFilterGroupOperatorOR()) continue;
                    this.addFilterStage(filterStage);
                }
            }
            ++n;
        }
    }

    FilterConsumerAdminTask(TaskExecutor taskExecutor, TaskProcessor taskProcessor, TaskFactory taskFactory) {
        super(taskExecutor, taskProcessor, taskFactory);
    }
}

