/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.engine;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jacorb.notification.engine.AbstractDeliverTask;
import org.jacorb.notification.engine.AbstractFilterTask;
import org.jacorb.notification.engine.FilterProxySupplierTask;
import org.jacorb.notification.engine.TaskFactory;
import org.jacorb.notification.engine.TaskProcessor;
import org.jacorb.notification.interfaces.FilterStage;
import org.jacorb.notification.interfaces.Message;
import org.jacorb.notification.util.TaskExecutor;
import org.omg.CORBA.AnyHolder;
import org.omg.CosNotifyFilter.UnsupportedFilterableData;

public class FilterProxySupplierTask
extends AbstractFilterTask {
    public static final AlternateMessageMap EMPTY_MAP = new 2(Collections.EMPTY_MAP);
    private static int COUNT = 0;
    AlternateMessageMap changedMessages_ = new AlternateMessageMap();
    private int id_ = ++COUNT;

    public String toString() {
        return "[FilterProxySupplierTask#" + this.id_ + "]";
    }

    public void setFilterStage(AbstractFilterTask abstractFilterTask) {
        this.arrayCurrentFilterStage_ = abstractFilterTask.getFilterStageToBeProcessed();
    }

    public void reset() {
        super.reset();
        this.arrayCurrentFilterStage_ = null;
        this.changedMessages_.clear();
    }

    public void doWork() throws InterruptedException {
        this.filter();
        AbstractDeliverTask.scheduleTasks(this.taskFactory_.newPushToConsumerTask(this));
        this.dispose();
    }

    private final Message updatePriority(int n, Message message) {
        AnyHolder anyHolder = new AnyHolder();
        Message message2 = message;
        try {
            boolean bl = message.match(this.arrayCurrentFilterStage_[n].getPriorityFilter(), anyHolder);
            if (bl) {
                message2 = (Message)this.message_.clone();
                message2.setPriority(anyHolder.value.extract_long());
            }
        }
        catch (UnsupportedFilterableData unsupportedFilterableData) {
            this.logger_.error("error evaluating PriorityFilter", unsupportedFilterableData);
        }
        return message2;
    }

    private final Message updateTimeout(int n, Message message) {
        AnyHolder anyHolder = new AnyHolder();
        Message message2 = message;
        try {
            boolean bl = message2.match(this.arrayCurrentFilterStage_[n].getLifetimeFilter(), anyHolder);
            if (bl && message2 == this.message_) {
                message2 = (Message)this.message_.clone();
                message2.setTimeout(anyHolder.value.extract_long());
            }
        }
        catch (UnsupportedFilterableData unsupportedFilterableData) {
            this.logger_.error("error evaluating PriorityFilter", unsupportedFilterableData);
        }
        return message2;
    }

    private final void filter() {
        int n = 0;
        while (n < this.arrayCurrentFilterStage_.length) {
            boolean bl = false;
            if (!this.arrayCurrentFilterStage_[n].isDisposed()) {
                Message message = this.message_;
                if (this.arrayCurrentFilterStage_[n].hasPriorityFilter()) {
                    message = this.updatePriority(n, message);
                }
                if (this.arrayCurrentFilterStage_[n].hasLifetimeFilter()) {
                    message = this.updateTimeout(n, message);
                }
                if (message != this.message_) {
                    this.changedMessages_.putAlternateMessage(this.arrayCurrentFilterStage_[n], message);
                }
                bl = message.match(this.arrayCurrentFilterStage_[n]);
            }
            if (bl) {
                this.addFilterStage(this.arrayCurrentFilterStage_[n].getSubsequentFilterStages());
            }
            ++n;
        }
    }

    FilterProxySupplierTask(TaskExecutor taskExecutor, TaskProcessor taskProcessor, TaskFactory taskFactory) {
        super(taskExecutor, taskProcessor, taskFactory);
    }

    static class AlternateMessageMap {
        private Map alternateMessages_;

        public Message getAlternateMessage(FilterStage filterStage) {
            if (this.alternateMessages_.containsKey(filterStage)) {
                return (Message)this.alternateMessages_.get(filterStage);
            }
            return null;
        }

        public void putAlternateMessage(FilterStage filterStage, Message message) {
            this.alternateMessages_.put(filterStage, message);
        }

        public void clear() {
            this.alternateMessages_.clear();
        }

        public AlternateMessageMap() {
            this(new HashMap());
        }

        AlternateMessageMap(Map map) {
            this.alternateMessages_ = map;
        }
    }
}

