/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.engine;

import org.apache.avalon.framework.logger.Logger;
import org.jacorb.notification.engine.AbstractDeliverTask;
import org.jacorb.notification.engine.AbstractTaskPool;
import org.jacorb.notification.engine.FilterConsumerAdminTask;
import org.jacorb.notification.engine.FilterProxyConsumerTask;
import org.jacorb.notification.engine.FilterProxySupplierTask;
import org.jacorb.notification.engine.FilterSupplierAdminTask;
import org.jacorb.notification.engine.TaskFactory;
import org.jacorb.notification.engine.TaskProcessor;
import org.jacorb.notification.interfaces.Disposable;
import org.jacorb.notification.interfaces.FilterStage;
import org.jacorb.notification.interfaces.Message;
import org.jacorb.util.Debug;

public class TaskFactory
implements Disposable {
    private final Logger logger_ = Debug.getNamedLogger(this.getClass().getName());
    private TaskProcessor taskProcessor_;
    private AbstractTaskPool filterProxyConsumerTaskPool_ = new 1(this, "FilterProxyConsumerTaskPool");
    private AbstractTaskPool filterSupplierAdminTaskPool_ = new 2(this, "FilterSupplierAdminTaskPool");
    private AbstractTaskPool filterConsumerAdminTaskPool_ = new 3(this, "FilterConsumerAdminTaskPool");
    private AbstractTaskPool filterProxySupplierTaskPool_ = new 4(this, "FilterProxySupplierTaskPool");
    private AbstractTaskPool deliverTaskPool_ = new 5(this, "PushToConsumerTaskPool");

    public void init() {
        this.filterProxyConsumerTaskPool_.init();
        this.filterProxySupplierTaskPool_.init();
        this.filterConsumerAdminTaskPool_.init();
        this.filterSupplierAdminTaskPool_.init();
        this.deliverTaskPool_.init();
    }

    public void dispose() {
        this.filterProxyConsumerTaskPool_.dispose();
        this.filterProxySupplierTaskPool_.dispose();
        this.filterConsumerAdminTaskPool_.dispose();
        this.filterSupplierAdminTaskPool_.dispose();
        this.deliverTaskPool_.dispose();
    }

    private final FilterProxyConsumerTask newFilterProxyConsumerTask() {
        return (FilterProxyConsumerTask)this.filterProxyConsumerTaskPool_.lendObject();
    }

    FilterProxyConsumerTask newFilterProxyConsumerTask(Message message) {
        FilterProxyConsumerTask filterProxyConsumerTask = this.newFilterProxyConsumerTask();
        filterProxyConsumerTask.setMessage(message);
        filterProxyConsumerTask.setCurrentFilterStage(new FilterStage[]{message.getInitialFilterStage()});
        return filterProxyConsumerTask;
    }

    private final FilterSupplierAdminTask newFilterSupplierAdminTask() {
        return (FilterSupplierAdminTask)this.filterSupplierAdminTaskPool_.lendObject();
    }

    FilterSupplierAdminTask newFilterSupplierAdminTask(FilterProxyConsumerTask filterProxyConsumerTask) {
        FilterSupplierAdminTask filterSupplierAdminTask = this.newFilterSupplierAdminTask();
        if (filterProxyConsumerTask.getFilterStageToBeProcessed().length != 1) {
            throw new RuntimeException();
        }
        filterSupplierAdminTask.setMessage(filterProxyConsumerTask.removeMessage());
        filterSupplierAdminTask.setCurrentFilterStage(filterProxyConsumerTask.getFilterStageToBeProcessed());
        filterSupplierAdminTask.setSkip(filterProxyConsumerTask.getSkip());
        return filterSupplierAdminTask;
    }

    private final FilterConsumerAdminTask newFilterConsumerAdminTask() {
        return (FilterConsumerAdminTask)this.filterConsumerAdminTaskPool_.lendObject();
    }

    FilterConsumerAdminTask newFilterConsumerAdminTask(FilterSupplierAdminTask filterSupplierAdminTask) {
        FilterConsumerAdminTask filterConsumerAdminTask = this.newFilterConsumerAdminTask();
        filterConsumerAdminTask.setMessage(filterSupplierAdminTask.removeMessage());
        filterConsumerAdminTask.setCurrentFilterStage(filterSupplierAdminTask.getFilterStageToBeProcessed());
        return filterConsumerAdminTask;
    }

    private final FilterProxySupplierTask newFilterProxySupplierTask() {
        return (FilterProxySupplierTask)this.filterProxySupplierTaskPool_.lendObject();
    }

    FilterProxySupplierTask newFilterProxySupplierTask(FilterConsumerAdminTask filterConsumerAdminTask) {
        FilterProxySupplierTask filterProxySupplierTask = this.newFilterProxySupplierTask();
        filterProxySupplierTask.setMessage(filterConsumerAdminTask.removeMessage());
        FilterStage[] filterStageArray = filterConsumerAdminTask.getFilterStageToBeProcessed();
        filterProxySupplierTask.setCurrentFilterStage(filterStageArray);
        return filterProxySupplierTask;
    }

    AbstractDeliverTask[] newPushToConsumerTask(FilterStage[] filterStageArray, Message message) {
        return this.newPushToConsumerTask(filterStageArray, message, FilterProxySupplierTask.EMPTY_MAP);
    }

    private final AbstractDeliverTask[] newPushToConsumerTask(FilterStage[] filterStageArray, Message message, FilterProxySupplierTask.AlternateMessageMap alternateMessageMap) {
        AbstractDeliverTask[] abstractDeliverTaskArray = new AbstractDeliverTask[filterStageArray.length];
        int n = 0;
        while (n < filterStageArray.length) {
            abstractDeliverTaskArray[n] = (AbstractDeliverTask)this.deliverTaskPool_.lendObject();
            abstractDeliverTaskArray[n].setMessageConsumer(filterStageArray[n].getMessageConsumer());
            Message message2 = alternateMessageMap.getAlternateMessage(filterStageArray[n]);
            if (message2 != null) {
                abstractDeliverTaskArray[n].setMessage(message2);
            } else if (n == 0) {
                abstractDeliverTaskArray[n].setMessage(message);
            } else {
                abstractDeliverTaskArray[n].setMessage((Message)message.clone());
            }
            ++n;
        }
        return abstractDeliverTaskArray;
    }

    AbstractDeliverTask[] newPushToConsumerTask(FilterProxySupplierTask filterProxySupplierTask) {
        Message message = filterProxySupplierTask.removeMessage();
        FilterStage[] filterStageArray = filterProxySupplierTask.getFilterStageToBeProcessed();
        AbstractDeliverTask[] abstractDeliverTaskArray = this.newPushToConsumerTask(filterStageArray, message, filterProxySupplierTask.changedMessages_);
        return abstractDeliverTaskArray;
    }

    static /* synthetic */ TaskProcessor access$0(TaskFactory taskFactory) {
        return taskFactory.taskProcessor_;
    }

    public TaskFactory(TaskProcessor taskProcessor) {
        this.taskProcessor_ = taskProcessor;
    }
}

