/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.engine;

import EDU.oswego.cs.dl.util.concurrent.ClockDaemon;
import EDU.oswego.cs.dl.util.concurrent.ThreadFactory;
import java.util.Date;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.notification.engine.AbstractFilterTask;
import org.jacorb.notification.engine.FilterProxyConsumerTask;
import org.jacorb.notification.engine.PullFromSupplierTask;
import org.jacorb.notification.engine.TaskFactory;
import org.jacorb.notification.engine.TimerDeliverTask;
import org.jacorb.notification.interfaces.Disposable;
import org.jacorb.notification.interfaces.Message;
import org.jacorb.notification.interfaces.MessageConsumer;
import org.jacorb.notification.interfaces.TimerEventSupplier;
import org.jacorb.notification.servant.AbstractProxySupplier;
import org.jacorb.notification.util.TaskExecutor;
import org.jacorb.util.Debug;
import org.jacorb.util.Environment;
import org.omg.CORBA.Any;
import org.omg.CosNotification.StructuredEvent;

public class TaskProcessor
implements Disposable {
    private Logger logger_ = Debug.getNamedLogger(this.getClass().getName());
    private TaskExecutor matchTaskExecutor_;
    private TaskExecutor pushTaskExecutor_;
    private TaskExecutor pullTaskExecutor_;
    private ClockDaemon clockDaemon_;
    private TaskFactory taskFactory_;
    private long backoutInterval_;

    private final void configureDeliverTaskExecutor() {
        String string = Environment.getProperty("jacorb.notification.proxysupplier.threadpolicy", "ThreadPool");
        if (this.logger_.isInfoEnabled()) {
            this.logger_.info("use Property: jacorb.notification.proxysupplier.threadpolicy=" + string);
        }
        if ("ThreadPool".equals(string)) {
            this.pushTaskExecutor_ = new TaskExecutor("DeliverThread", Environment.getIntPropertyWithDefault("jacorb.notification.proxysupplier.thread_pool_size", 4));
        } else if ("ThreadPerProxy".equals(string)) {
            this.pushTaskExecutor_ = null;
        } else {
            throw new IllegalArgumentException("The specified value: \"" + string + "\" specified in property: \"" + "jacorb.notification.proxysupplier.threadpolicy" + "\" is invalid");
        }
    }

    public TaskFactory getTaskFactory() {
        return this.taskFactory_;
    }

    public void configureTaskExecutor(AbstractProxySupplier abstractProxySupplier) {
        if (this.pushTaskExecutor_ != null) {
            abstractProxySupplier.setTaskExecutor(this.pushTaskExecutor_);
        } else {
            TaskExecutor taskExecutor = new TaskExecutor("PerProxyDeliverThread", 1);
            Disposable disposable = new Disposable(this, taskExecutor){
                private final /* synthetic */ TaskProcessor this$0;
                private final /* synthetic */ TaskExecutor val$_executor;

                public final void dispose() {
                    this.val$_executor.dispose();
                }
                {
                    this.val$_executor = taskExecutor;
                    this.this$0 = taskProcessor;
                    this.constructor$0(taskProcessor);
                }

                private final void constructor$0(TaskProcessor taskProcessor) {
                }
            };
            abstractProxySupplier.setTaskExecutor(taskExecutor, disposable);
        }
    }

    TaskExecutor getFilterTaskExecutor() {
        return this.matchTaskExecutor_;
    }

    public void dispose() {
        this.logger_.info("shutdown TaskProcessor");
        this.clockDaemon_.shutDown();
        this.matchTaskExecutor_.dispose();
        if (this.pushTaskExecutor_ != null) {
            this.pushTaskExecutor_.dispose();
        }
        this.pullTaskExecutor_.dispose();
        this.taskFactory_.dispose();
        this.logger_.debug("shutdown complete");
    }

    public void processMessage(Message message) {
        if (message.hasStopTime()) {
            this.logger_.debug("Message has StopTime");
            if (message.getStopTime().getTime() <= System.currentTimeMillis()) {
                this.fireEventDiscarded(message);
                message.dispose();
                this.logger_.debug("Message Stoptime is passed already");
                return;
            }
            new DeferedStopTask(message);
        }
        if (message.hasTimeout()) {
            this.logger_.debug("Message has TimeOut");
            new TimeoutTask(message);
        }
        if (message.hasStartTime() && message.getStartTime().getTime() > System.currentTimeMillis()) {
            new DeferedStartTask(message);
        } else {
            this.processMessageInternal(message);
        }
    }

    protected void processMessageInternal(Message message) {
        this.logger_.debug("processMessageInternal");
        FilterProxyConsumerTask filterProxyConsumerTask = this.taskFactory_.newFilterProxyConsumerTask(message);
        try {
            ((AbstractFilterTask)filterProxyConsumerTask).schedule();
        }
        catch (InterruptedException interruptedException) {
            this.logger_.error("Interrupt while scheduling FilterTask", interruptedException);
        }
    }

    public void scheduleTimedPullTask(TimerEventSupplier timerEventSupplier) throws InterruptedException {
        PullFromSupplierTask pullFromSupplierTask = new PullFromSupplierTask(this.pullTaskExecutor_);
        pullFromSupplierTask.setTarget(timerEventSupplier);
        pullFromSupplierTask.schedule();
    }

    public void scheduleTimedPushTask(MessageConsumer messageConsumer) throws InterruptedException {
        TimerDeliverTask timerDeliverTask = new TimerDeliverTask(this, this.taskFactory_);
        timerDeliverTask.setMessageConsumer(messageConsumer);
        timerDeliverTask.schedule();
    }

    private final ClockDaemon getClockDaemon() {
        return this.clockDaemon_;
    }

    public Object executeTaskPeriodically(long l, Runnable runnable, boolean bl) {
        return this.getClockDaemon().executePeriodically(l, runnable, bl);
    }

    public void cancelTask(Object object) {
        ClockDaemon.cancel((Object)object);
    }

    private final Object executeTaskAfterDelay(long l, Runnable runnable) {
        return this.clockDaemon_.executeAfterDelay(l, runnable);
    }

    private final Object executeTaskAt(Date date, Runnable runnable) {
        return this.clockDaemon_.executeAt(date, runnable);
    }

    void backoutMessageConsumer(MessageConsumer messageConsumer) {
        if (this.logger_.isDebugEnabled()) {
            this.logger_.debug("back out MessageConsumer " + messageConsumer);
        }
        EnableMessageConsumer enableMessageConsumer = new EnableMessageConsumer(messageConsumer);
        this.executeTaskAfterDelay(this.backoutInterval_, enableMessageConsumer);
    }

    private final void fireEventDiscarded(Message message) {
        switch (message.getType()) {
            case 0: {
                this.fireEventDiscarded(message.toAny());
                break;
            }
            case 1: {
                this.fireEventDiscarded(message.toStructuredEvent());
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
    }

    private final void fireEventDiscarded(Any any) {
        if (this.logger_.isDebugEnabled()) {
            this.logger_.debug("Any: " + any + " has been discarded");
        }
    }

    private final void fireEventDiscarded(StructuredEvent structuredEvent) {
        if (this.logger_.isDebugEnabled()) {
            this.logger_.debug("StructuredEvent: " + structuredEvent + " has been discarded");
        }
    }

    public TaskProcessor() {
        this.logger_.info("create TaskProcessor");
        this.clockDaemon_ = new ClockDaemon();
        this.clockDaemon_.setThreadFactory(new ThreadFactory(this){
            private final /* synthetic */ TaskProcessor this$0;

            public final Thread newThread(Runnable runnable) {
                Thread thread = new Thread(runnable);
                thread.setName("ClockDaemonThread");
                return thread;
            }
            {
                this.this$0 = taskProcessor;
                this.constructor$0(taskProcessor);
            }

            private final void constructor$0(TaskProcessor taskProcessor) {
            }
        });
        this.pullTaskExecutor_ = new TaskExecutor("PullThread", Environment.getIntPropertyWithDefault("jacorb.notification.proxyconsumer.thread_pool_size", 2));
        this.matchTaskExecutor_ = new TaskExecutor("FilterThread", Environment.getIntPropertyWithDefault("jacorb.notification.filter.thread_pool_size", 2));
        this.configureDeliverTaskExecutor();
        this.backoutInterval_ = Environment.getIntPropertyWithDefault("jacorb.notification.consumer.backout_interval", 2000);
        this.taskFactory_ = new TaskFactory(this);
        this.taskFactory_.init();
    }

    class TimeoutTask
    implements Runnable,
    Message.MessageStateListener {
        Object timerRegistration_;
        Message message_;

        public void actionLifetimeChanged(long l) {
            ClockDaemon.cancel((Object)this.timerRegistration_);
            this.timerRegistration_ = TaskProcessor.this.executeTaskAfterDelay(this.message_.getTimeout(), this);
        }

        public void run() {
            TaskProcessor.this.logger_.debug("run Timeout");
            this.message_.removeMessageStateListener();
            this.message_.actionTimeout();
        }

        TimeoutTask(Message message) {
            this.message_ = message;
            this.message_.setMessageStateListener(this);
            this.timerRegistration_ = TaskProcessor.this.executeTaskAfterDelay(message.getTimeout(), this);
        }
    }

    class DeferedStopTask
    implements Runnable {
        Message event_;

        public void run() {
            this.event_.actionTimeout();
        }

        DeferedStopTask(Message message) {
            this.event_ = message;
            TaskProcessor.this.executeTaskAt(message.getStopTime(), this);
        }
    }

    class DeferedStartTask
    implements Runnable {
        Message message_;

        public void run() {
            if (TaskProcessor.this.logger_.isDebugEnabled()) {
                TaskProcessor.this.logger_.debug("Defered Message " + this.message_ + " will be processed now");
            }
            TaskProcessor.this.processMessageInternal(this.message_);
        }

        DeferedStartTask(Message message) {
            if (TaskProcessor.this.logger_.isDebugEnabled()) {
                TaskProcessor.this.logger_.debug("Message with Option StartTime=" + message.getStartTime() + " will be defered until then");
            }
            this.message_ = message;
            TaskProcessor.this.executeTaskAt(this.message_.getStartTime(), this);
        }
    }

    class EnableMessageConsumer
    implements Runnable {
        MessageConsumer messageConsumer_;

        public void run() {
            try {
                this.messageConsumer_.enableDelivery();
                TaskProcessor.this.scheduleTimedPushTask(this.messageConsumer_);
            }
            catch (InterruptedException interruptedException) {
                TaskProcessor.this.logger_.error("Interrupted", interruptedException);
            }
        }

        EnableMessageConsumer(MessageConsumer messageConsumer) {
            this.messageConsumer_ = messageConsumer;
        }
    }
}

