/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.filter.etcl;

import org.apache.avalon.framework.logger.Logger;
import org.jacorb.notification.filter.etcl.AbstractTCLNode;
import org.jacorb.notification.filter.etcl.AbstractTCLVisitor;
import org.jacorb.notification.filter.etcl.AndOperator;
import org.jacorb.notification.filter.etcl.DivOperator;
import org.jacorb.notification.filter.etcl.GtOperator;
import org.jacorb.notification.filter.etcl.MinusOperator;
import org.jacorb.notification.filter.etcl.MultOperator;
import org.jacorb.notification.filter.etcl.PlusOperator;
import org.jacorb.notification.filter.etcl.StaticTypeException;
import org.jacorb.notification.filter.etcl.SubstrOperator;
import org.jacorb.notification.filter.etcl.TCLParserTokenTypes;
import org.jacorb.notification.filter.etcl.VisitorException;
import org.jacorb.util.Debug;

public class StaticTypeChecker
extends AbstractTCLVisitor
implements TCLParserTokenTypes {
    Logger logger_ = Debug.getNamedLogger(this.getClass().getName());

    public void check(AbstractTCLNode abstractTCLNode) throws StaticTypeException {
        try {
            abstractTCLNode.acceptPostOrder(this);
        }
        catch (VisitorException visitorException) {
            throw new StaticTypeException(visitorException.getMessage());
        }
    }

    static void checkBinaryNumaryOperatorNode(AbstractTCLNode abstractTCLNode) throws StaticTypeException {
        if (abstractTCLNode.isStatic()) {
            if (abstractTCLNode.left().isNumber() && abstractTCLNode.right().isNumber()) {
                return;
            }
            throw new StaticTypeException("num or float or identifier (or bool) excepted)");
        }
    }

    static void checkCMPNode(AbstractTCLNode abstractTCLNode) throws StaticTypeException {
    }

    public void visitGt(GtOperator gtOperator) throws VisitorException {
        StaticTypeChecker.checkCMPNode(gtOperator);
    }

    public void visitPlus(PlusOperator plusOperator) throws VisitorException {
        StaticTypeChecker.checkBinaryNumaryOperatorNode(plusOperator);
    }

    public void visitMinus(MinusOperator minusOperator) throws VisitorException {
        StaticTypeChecker.checkBinaryNumaryOperatorNode(minusOperator);
    }

    public void visitDiv(DivOperator divOperator) throws VisitorException {
        StaticTypeChecker.checkBinaryNumaryOperatorNode(divOperator);
    }

    public void visitMult(MultOperator multOperator) throws VisitorException {
        StaticTypeChecker.checkBinaryNumaryOperatorNode(multOperator);
    }

    public void visitSubstr(SubstrOperator substrOperator) throws VisitorException {
        if (substrOperator.isStatic()) {
            if (substrOperator.left().isString() && substrOperator.right().isString()) {
                return;
            }
            throw new StaticTypeException("~ Operator expects 2 Strings");
        }
    }

    public void visitAnd(AndOperator andOperator) throws VisitorException {
        if (andOperator.isStatic()) {
            if (andOperator.left().isBoolean() && andOperator.right().isBoolean()) {
                return;
            }
            throw new StaticTypeException("bool value expected");
        }
    }
}

