/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.queue;

import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.notification.queue.AbstractBoundedEventQueue;
import org.jacorb.notification.queue.BoundedDeadlineEventQueue;
import org.jacorb.notification.queue.BoundedFifoEventQueue;
import org.jacorb.notification.queue.BoundedPriorityEventQueue;
import org.jacorb.notification.queue.EventQueue;
import org.jacorb.notification.queue.EventQueueOverflowStrategy;
import org.jacorb.notification.servant.QoSPropertySet;
import org.jacorb.util.Debug;
import org.jacorb.util.Environment;
import org.omg.CosNotification.UnsupportedQoS;

public class EventQueueFactory {
    private static final Logger sLogger = Debug.getNamedLogger((class$Lorg$jacorb$notification$queue$EventQueueFactory != null ? class$Lorg$jacorb$notification$queue$EventQueueFactory : (class$Lorg$jacorb$notification$queue$EventQueueFactory = EventQueueFactory.class$("org.jacorb.notification.queue.EventQueueFactory"))).getName());
    private static final short UNKNOWN_POLICY = Short.MIN_VALUE;
    private static final Map mapOrderPolicyNameToValue = new HashMap();
    private static final Map mapDiscardPolicyNameToValue = new HashMap();
    private static final String[] mapOrderPolicyValueToName;
    private static final String[] mapDiscardPolicyValueToName;
    private static /* synthetic */ Class class$Lorg$jacorb$notification$queue$EventQueueFactory;

    public static EventQueue newEventQueue(QoSPropertySet qoSPropertySet) throws UnsupportedQoS {
        AbstractBoundedEventQueue abstractBoundedEventQueue;
        int n = Environment.getIntPropertyWithDefault("jacorb.notification.max_events_per_consumer", 100);
        String string = Environment.getProperty("jacorb.notification.order_policy", "PriorityOrder");
        String string2 = Environment.getProperty("jacorb.notification.discard_policy", "PriorityOrder");
        short s = EventQueueFactory.orderPolicyNameToValue(string);
        short s2 = EventQueueFactory.discardPolicyNameToValue(string2);
        if (qoSPropertySet.containsKey("MaxEventsPerConsumer")) {
            n = qoSPropertySet.get("MaxEventsPerConsumer").extract_long();
        }
        if (qoSPropertySet.containsKey("OrderPolicy")) {
            s = qoSPropertySet.get("OrderPolicy").extract_short();
        }
        if (qoSPropertySet.containsKey("DiscardPolicy")) {
            s2 = qoSPropertySet.get("DiscardPolicy").extract_short();
        }
        if (sLogger.isInfoEnabled()) {
            sLogger.info("Create EventQueue Settings: \n\tMAX_EVENTS_PER_CONSUMER=" + n + "\n\t" + "/ORDER_POLICY=" + mapOrderPolicyValueToName[s] + "\n\t" + "/DISCARD_POLICY=" + mapDiscardPolicyValueToName[s2]);
        }
        switch (s) {
            case 0: 
            case 1: {
                abstractBoundedEventQueue = new BoundedFifoEventQueue(n);
                break;
            }
            case 2: {
                abstractBoundedEventQueue = new BoundedPriorityEventQueue(n);
                break;
            }
            case 3: {
                abstractBoundedEventQueue = new BoundedDeadlineEventQueue(n);
                break;
            }
            default: {
                throw new IllegalArgumentException("Orderpolicy: " + string + " OrderPolicyValue: " + s + " unknown");
            }
        }
        switch (s2) {
            case 0: 
            case 1: {
                abstractBoundedEventQueue.setOverflowStrategy(EventQueueOverflowStrategy.FIFO);
                break;
            }
            case 4: {
                abstractBoundedEventQueue.setOverflowStrategy(EventQueueOverflowStrategy.LIFO);
                break;
            }
            case 2: {
                abstractBoundedEventQueue.setOverflowStrategy(EventQueueOverflowStrategy.LEAST_PRIORITY);
                break;
            }
            case 3: {
                abstractBoundedEventQueue.setOverflowStrategy(EventQueueOverflowStrategy.EARLIEST_TIMEOUT);
                break;
            }
            default: {
                throw new IllegalArgumentException("Discardpolicy: " + string2 + "DiscardPolicyValue: " + s2 + " unknown");
            }
        }
        return abstractBoundedEventQueue;
    }

    public static short orderPolicyNameToValue(String string) {
        if (mapOrderPolicyNameToValue.containsKey(string)) {
            return (Short)mapOrderPolicyNameToValue.get(string);
        }
        return Short.MIN_VALUE;
    }

    public static short discardPolicyNameToValue(String string) {
        if (mapDiscardPolicyNameToValue.containsKey(string)) {
            return (Short)mapDiscardPolicyNameToValue.get(string);
        }
        return Short.MIN_VALUE;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private EventQueueFactory() {
    }

    static {
        mapOrderPolicyNameToValue.put("AnyOrder", new Short(0));
        mapOrderPolicyNameToValue.put("FifoOrder", new Short(1));
        mapOrderPolicyNameToValue.put("PriorityOrder", new Short(2));
        mapOrderPolicyNameToValue.put("DeadlineOrder", new Short(3));
        mapOrderPolicyValueToName = new String[]{"AnyOrder", "FifoOrder", "PriorityOrder", "DeadlineOrder"};
        mapDiscardPolicyNameToValue.put("AnyOrder", new Short(0));
        mapDiscardPolicyNameToValue.put("FifoOrder", new Short(1));
        mapDiscardPolicyNameToValue.put("LifoOrder", new Short(4));
        mapDiscardPolicyNameToValue.put("PriorityOrder", new Short(2));
        mapDiscardPolicyNameToValue.put("DeadlineOrder", new Short(3));
        mapDiscardPolicyValueToName = new String[]{"AnyOrder", "FifoOrder", "PriorityOrder", "DeadlineOrder", "LifoOrder"};
    }
}

