/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.servant;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedBoolean;
import EDU.oswego.cs.dl.util.concurrent.SynchronizedInt;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.notification.ChannelContext;
import org.jacorb.notification.EventChannelImpl;
import org.jacorb.notification.FilterManager;
import org.jacorb.notification.MessageFactory;
import org.jacorb.notification.OfferManager;
import org.jacorb.notification.SubscriptionManager;
import org.jacorb.notification.interfaces.Disposable;
import org.jacorb.notification.interfaces.FilterStage;
import org.jacorb.notification.interfaces.MessageConsumer;
import org.jacorb.notification.interfaces.ProxyCreationRequestEvent;
import org.jacorb.notification.interfaces.ProxyCreationRequestEventListener;
import org.jacorb.notification.interfaces.ProxyEvent;
import org.jacorb.notification.interfaces.ProxyEventListener;
import org.jacorb.notification.servant.AbstractProxy;
import org.jacorb.notification.servant.AdminPropertySet;
import org.jacorb.notification.servant.ManageableServant;
import org.jacorb.notification.servant.QoSPropertySet;
import org.jacorb.util.Debug;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CosNotification.NamedPropertyRangeSeqHolder;
import org.omg.CosNotification.Property;
import org.omg.CosNotification.QoSAdminOperations;
import org.omg.CosNotification.UnsupportedQoS;
import org.omg.CosNotifyChannelAdmin.AdminLimitExceeded;
import org.omg.CosNotifyChannelAdmin.EventChannel;
import org.omg.CosNotifyChannelAdmin.EventChannelHelper;
import org.omg.CosNotifyChannelAdmin.InterFilterGroupOperator;
import org.omg.CosNotifyChannelAdmin.ProxyNotFound;
import org.omg.CosNotifyFilter.Filter;
import org.omg.CosNotifyFilter.FilterAdminOperations;
import org.omg.CosNotifyFilter.FilterNotFound;
import org.omg.CosNotifyFilter.MappingFilter;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;

public abstract class AbstractAdmin
implements QoSAdminOperations,
FilterAdminOperations,
FilterStage,
ManageableServant {
    protected static final InterFilterGroupOperator DEFAULT_FILTER_GROUP_OPERATOR = InterFilterGroupOperator.AND_OP;
    protected Logger logger_ = Debug.getNamedLogger(this.getClass().getName());
    protected OfferManager offerManager_;
    protected SubscriptionManager subscriptionManager_;
    protected final java.lang.Object modifyProxiesLock_ = new java.lang.Object();
    protected final Map pullServants_ = new HashMap();
    protected final Map pushServants_ = new HashMap();
    private ChannelContext channelContext_;
    private Integer id_;
    private boolean isIDPublic_;
    private POA poa_;
    private ORB orb_;
    private InterFilterGroupOperator filterGroupOperator_;
    private FilterManager filterManager_;
    private SynchronizedInt proxyIdPool_ = new SynchronizedInt(0);
    private QoSPropertySet qosSettings_ = new QoSPropertySet(1);
    private AdminPropertySet adminSettings_ = new AdminPropertySet();
    private SynchronizedBoolean disposed_ = new SynchronizedBoolean(false);
    private List proxyCreationRequestEventListeners_ = new ArrayList();
    private List proxyEventListener_ = new ArrayList();
    private Runnable disposeHook_;

    public ChannelContext getChannelContext() {
        return this.channelContext_;
    }

    public void setDisposeHook(Runnable runnable) {
        this.disposeHook_ = runnable;
    }

    public void setInterFilterGroupOperator(InterFilterGroupOperator interFilterGroupOperator) {
        this.filterGroupOperator_ = interFilterGroupOperator;
    }

    public void setID(Integer n) {
        this.id_ = n;
    }

    public void setIsIDPublic(boolean bl) {
        this.isIDPublic_ = bl;
    }

    protected POA getPOA() {
        return this.poa_;
    }

    public void setPOA(POA pOA) {
        this.poa_ = pOA;
    }

    protected ORB getORB() {
        return this.orb_;
    }

    public void setORB(ORB oRB) {
        this.orb_ = oRB;
    }

    protected MessageFactory getMessageFactory() {
        return this.channelContext_.getMessageFactory();
    }

    protected EventChannelImpl getChannelServant() {
        return this.channelContext_.getEventChannelServant();
    }

    private final EventChannel getChannel() {
        return EventChannelHelper.narrow(this.getChannelServant().activate());
    }

    public POA _default_POA() {
        return this.getPOA();
    }

    int getProxyID() {
        return this.proxyIdPool_.increment();
    }

    public List getFilters() {
        return this.filterManager_.getFilters();
    }

    public int add_filter(Filter filter) {
        return this.filterManager_.add_filter(filter);
    }

    public void remove_filter(int n) throws FilterNotFound {
        this.filterManager_.remove_filter(n);
    }

    public Filter get_filter(int n) throws FilterNotFound {
        return this.filterManager_.get_filter(n);
    }

    public int[] get_all_filters() {
        return this.filterManager_.get_all_filters();
    }

    public void remove_all_filters() {
        this.filterManager_.remove_all_filters();
    }

    public InterFilterGroupOperator MyOperator() {
        return this.filterGroupOperator_;
    }

    public EventChannel MyChannel() {
        return this.getChannel();
    }

    public int MyID() {
        return this.getID();
    }

    public Property[] get_qos() {
        return this.qosSettings_.get_qos();
    }

    public void set_qos(Property[] propertyArray) throws UnsupportedQoS {
        this.qosSettings_.validate_qos(propertyArray, new NamedPropertyRangeSeqHolder());
        this.qosSettings_.set_qos(propertyArray);
    }

    public void validate_qos(Property[] propertyArray, NamedPropertyRangeSeqHolder namedPropertyRangeSeqHolder) throws UnsupportedQoS {
        this.qosSettings_.validate_qos(propertyArray, namedPropertyRangeSeqHolder);
    }

    public void destroy() {
        this.dispose();
    }

    private final void checkDisposalStatus() throws OBJECT_NOT_EXIST {
        if (this.disposed_.get()) {
            throw new OBJECT_NOT_EXIST();
        }
        this.disposed_.set(true);
    }

    private final void disposeProxies() {
        java.lang.Object object = this.modifyProxiesLock_;
        synchronized (object) {
            Disposable disposable;
            this.logger_.debug("dispose PushServants");
            Iterator iterator = this.pushServants_.values().iterator();
            while (iterator.hasNext()) {
                try {
                    disposable = (Disposable)iterator.next();
                    iterator.remove();
                    disposable.dispose();
                }
                catch (Exception exception) {
                    this.logger_.warn("Error disposing a PushServant", exception);
                }
            }
            this.pushServants_.clear();
            this.logger_.debug("dispose PullServants");
            iterator = this.pullServants_.values().iterator();
            while (iterator.hasNext()) {
                try {
                    disposable = (Disposable)iterator.next();
                    iterator.remove();
                    disposable.dispose();
                }
                catch (Exception exception) {
                    this.logger_.warn("Error disposing a PullServant", exception);
                }
            }
            this.pullServants_.clear();
        }
    }

    public void dispose() {
        this.checkDisposalStatus();
        this.deactivate();
        this.remove_all_filters();
        this.disposeProxies();
        this.disposeHook_.run();
    }

    public void deactivate() {
        this.logger_.debug("deactivate Admin");
        try {
            byte[] byArray = this.getPOA().servant_to_id(this.getServant());
            this.getPOA().deactivate_object(byArray);
        }
        catch (Exception exception) {
            this.logger_.fatalError("Couldn't deactivate Admin", exception);
        }
    }

    abstract Servant getServant();

    public Integer getID() {
        return this.id_;
    }

    public boolean isDisposed() {
        return this.disposed_.get();
    }

    public void addProxyCreationEventListener(ProxyCreationRequestEventListener proxyCreationRequestEventListener) {
        List list = this.proxyCreationRequestEventListeners_;
        synchronized (list) {
            this.proxyCreationRequestEventListeners_.add(proxyCreationRequestEventListener);
        }
    }

    public void removeProxyCreationEventListener(ProxyCreationRequestEventListener proxyCreationRequestEventListener) {
        List list = this.proxyCreationRequestEventListeners_;
        synchronized (list) {
            this.proxyCreationRequestEventListeners_.remove(proxyCreationRequestEventListener);
        }
    }

    protected void fireCreateProxyRequestEvent() throws AdminLimitExceeded {
        List list = this.proxyCreationRequestEventListeners_;
        synchronized (list) {
            ProxyCreationRequestEvent proxyCreationRequestEvent = new ProxyCreationRequestEvent(this);
            Iterator iterator = this.proxyCreationRequestEventListeners_.iterator();
            while (iterator.hasNext()) {
                ProxyCreationRequestEventListener proxyCreationRequestEventListener = (ProxyCreationRequestEventListener)iterator.next();
                proxyCreationRequestEventListener.actionProxyCreationRequest(proxyCreationRequestEvent);
            }
        }
    }

    public boolean hasLifetimeFilter() {
        return false;
    }

    public boolean hasPriorityFilter() {
        return false;
    }

    public MappingFilter getLifetimeFilter() {
        throw new UnsupportedOperationException();
    }

    public MappingFilter getPriorityFilter() {
        throw new UnsupportedOperationException();
    }

    public void setOfferManager(OfferManager offerManager) {
        this.offerManager_ = offerManager;
    }

    public void setSubscriptionManager(SubscriptionManager subscriptionManager) {
        this.subscriptionManager_ = subscriptionManager;
    }

    public boolean hasInterFilterGroupOperatorOR() {
        return this.filterGroupOperator_ != null && this.filterGroupOperator_.value() == 1;
    }

    protected AbstractProxy getProxy(int n) throws ProxyNotFound {
        Integer n2 = new Integer(n);
        AbstractProxy abstractProxy = null;
        java.lang.Object object = this.modifyProxiesLock_;
        synchronized (object) {
            abstractProxy = (AbstractProxy)this.pullServants_.get(n2);
            if (abstractProxy == null) {
                abstractProxy = (AbstractProxy)this.pullServants_.get(n2);
            }
        }
        if (abstractProxy == null) {
            throw new ProxyNotFound("The proxy with ID=" + n + " does not exist");
        }
        if (!abstractProxy.isKeyPublic()) {
            throw new ProxyNotFound("The proxy with ID=" + n + " is a EventStyle proxy and therefor not accessible");
        }
        return abstractProxy;
    }

    protected int[] get_all_notify_proxies(Map map, java.lang.Object object) {
        java.lang.Object object2;
        ArrayList arrayList = new ArrayList();
        java.lang.Object object3 = object;
        synchronized (object3) {
            object2 = map.entrySet().iterator();
            while (object2.hasNext()) {
                Map.Entry entry = object2.next();
                if (!((AbstractProxy)entry.getValue()).isKeyPublic()) continue;
                arrayList.add(entry.getKey());
            }
        }
        object2 = new int[arrayList.size()];
        int n = 0;
        while (n < ((java.lang.Object)object2).length) {
            object2[n] = (Integer)arrayList.get(n);
            ++n;
        }
        return object2;
    }

    protected void configureEventStyleID(AbstractProxy abstractProxy) {
        abstractProxy.setKey(new Integer(this.getProxyID()), false);
        abstractProxy.setFilterManager(FilterManager.EMPTY_FILTER_MANAGER);
    }

    protected void configureNotifyStyleID(AbstractProxy abstractProxy) {
        abstractProxy.setKey(new Integer(this.getProxyID()), true);
    }

    protected void configureQoS(AbstractProxy abstractProxy) {
        try {
            abstractProxy.set_qos(this.qosSettings_.get_qos());
        }
        catch (UnsupportedQoS unsupportedQoS) {
            this.logger_.fatalError("unexpected exception", unsupportedQoS);
            throw new RuntimeException(unsupportedQoS.getMessage());
        }
    }

    protected void configureInterFilterGroupOperator(AbstractProxy abstractProxy) {
        if (this.filterGroupOperator_ != null && this.filterGroupOperator_.value() == 1) {
            abstractProxy.setInterFilterGroupOperatorOR(true);
        }
    }

    protected void configureManagers(AbstractProxy abstractProxy) {
        abstractProxy.setOfferManager(this.offerManager_);
        abstractProxy.setSubscriptionManager(this.subscriptionManager_);
    }

    public void preActivate() {
    }

    public void addProxyEventListener(ProxyEventListener proxyEventListener) {
        List list = this.proxyEventListener_;
        synchronized (list) {
            this.proxyEventListener_.add(proxyEventListener);
        }
    }

    public void removeProxyEventListener(ProxyEventListener proxyEventListener) {
        List list = this.proxyEventListener_;
        synchronized (list) {
            this.proxyEventListener_.remove(proxyEventListener);
        }
    }

    private final void fireProxyRemoved(AbstractProxy abstractProxy) {
        List list = this.proxyEventListener_;
        synchronized (list) {
            Iterator iterator = this.proxyEventListener_.iterator();
            ProxyEvent proxyEvent = new ProxyEvent(abstractProxy);
            while (iterator.hasNext()) {
                ((ProxyEventListener)iterator.next()).actionProxyDisposed(proxyEvent);
            }
        }
    }

    private final void fireProxyCreated(AbstractProxy abstractProxy) {
        List list = this.proxyEventListener_;
        synchronized (list) {
            Iterator iterator = this.proxyEventListener_.iterator();
            ProxyEvent proxyEvent = new ProxyEvent(abstractProxy);
            while (iterator.hasNext()) {
                ((ProxyEventListener)iterator.next()).actionProxyCreated(proxyEvent);
            }
        }
    }

    protected void addProxyToMap(AbstractProxy abstractProxy, Map map, java.lang.Object object) {
        java.lang.Object object2 = object;
        synchronized (object2) {
            map.put(abstractProxy.getKey(), abstractProxy);
            this.fireProxyCreated(abstractProxy);
        }
        abstractProxy.setDisposeHook(new Runnable(this, object, abstractProxy, map){
            private final /* synthetic */ AbstractAdmin this$0;
            private final /* synthetic */ java.lang.Object val$lock;
            private final /* synthetic */ AbstractProxy val$proxy;
            private final /* synthetic */ Map val$map;

            public final void run() {
                java.lang.Object object = this.val$lock;
                synchronized (object) {
                    this.val$map.remove(this.val$proxy.getKey());
                    AbstractAdmin.access$0(this.this$0, this.val$proxy);
                }
            }
            {
                this.val$lock = object;
                this.val$proxy = abstractProxy;
                this.val$map = map;
                this.this$0 = abstractAdmin;
                this.constructor$0(abstractAdmin);
            }

            private final void constructor$0(AbstractAdmin abstractAdmin) {
            }
        });
    }

    public abstract List getSubsequentFilterStages();

    public abstract boolean hasMessageConsumer();

    public abstract MessageConsumer getMessageConsumer();

    public abstract Object activate();

    static /* synthetic */ void access$0(AbstractAdmin abstractAdmin, AbstractProxy abstractProxy) {
        abstractAdmin.fireProxyRemoved(abstractProxy);
    }

    protected AbstractAdmin(ChannelContext channelContext) {
        this.channelContext_ = channelContext;
        this.filterManager_ = new FilterManager(this.channelContext_);
        this.setPOA(this.channelContext_.getPOA());
        this.setORB(this.channelContext_.getORB());
    }
}

