/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.servant;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedBoolean;
import java.util.List;
import org.jacorb.notification.ChannelContext;
import org.jacorb.notification.CollectionsWrapper;
import org.jacorb.notification.engine.TaskProcessor;
import org.jacorb.notification.interfaces.FilterStage;
import org.jacorb.notification.interfaces.Message;
import org.jacorb.notification.interfaces.MessageConsumer;
import org.jacorb.notification.interfaces.TimerEventSupplier;
import org.jacorb.notification.servant.AbstractAdmin;
import org.jacorb.notification.servant.AbstractProxy;
import org.jacorb.notification.servant.AbstractProxyConsumer;
import org.jacorb.notification.servant.AbstractProxyConsumerI;
import org.jacorb.notification.servant.PropertySetListener;
import org.jacorb.notification.servant.ProxyPullConsumerImpl;
import org.jacorb.notification.servant.ProxyPushConsumerImpl;
import org.jacorb.notification.servant.SequenceProxyPullConsumerImpl;
import org.jacorb.notification.servant.SequenceProxyPushConsumerImpl;
import org.jacorb.notification.servant.StructuredProxyPullConsumerImpl;
import org.jacorb.notification.servant.StructuredProxyPushConsumerImpl;
import org.jacorb.util.Environment;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.BAD_QOS;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.Object;
import org.omg.CosNotification.EventType;
import org.omg.CosNotifyChannelAdmin.ClientType;
import org.omg.CosNotifyChannelAdmin.ObtainInfoMode;
import org.omg.CosNotifyChannelAdmin.SupplierAdmin;
import org.omg.CosNotifyComm.InvalidEventType;
import org.omg.CosNotifyComm.NotifyPublishOperations;
import org.omg.CosNotifyComm.NotifySubscribeOperations;

abstract class AbstractProxyConsumer
extends AbstractProxy
implements AbstractProxyConsumerI,
NotifyPublishOperations {
    private static final EventType[] EMPTY_EVENT_TYPE_ARRAY = new EventType[0];
    private TaskProcessor taskProcessor_;
    private SynchronizedBoolean isStartTimeSupported_ = new SynchronizedBoolean(true);
    private SynchronizedBoolean isStopTimeSupported_ = new SynchronizedBoolean(true);
    private List subsequentDestinations_;
    private NotifySubscribeOperations subscriptionListener_;
    private PropertySetListener reconfigureCB = new 1(this);

    public final List getSubsequentFilterStages() {
        return this.subsequentDestinations_;
    }

    public void preActivate() {
        this.logger_.debug("AbstractProxyConsumer.initialize");
        this.configureStartTimeSupported();
        this.configureStopTimeSupported();
        this.qosSettings_.addPropertySetListener(new String[]{"Priority", "Timeout", "StartTimeSupported", "StopTimeSupported"}, this.reconfigureCB);
    }

    private final void configureStartTimeSupported() {
        if (this.qosSettings_.containsKey("StartTimeSupported")) {
            this.isStartTimeSupported_.set(this.qosSettings_.get("StartTimeSupported").extract_boolean());
        } else {
            this.isStartTimeSupported_.set(Environment.isPropertyOn("jacorb.notification.start_time_supported", "on"));
        }
        if (this.logger_.isInfoEnabled()) {
            this.logger_.info("set QoS: StartTimeSupported=" + this.isStartTimeSupported_);
        }
    }

    private final void configureStopTimeSupported() {
        if (this.qosSettings_.containsKey("StopTimeSupported")) {
            this.isStopTimeSupported_.set(this.qosSettings_.get("StopTimeSupported").extract_boolean());
        } else {
            this.isStopTimeSupported_.set(Environment.isPropertyOn("jacorb.notification.stop_time_supported", "on"));
        }
        if (this.logger_.isInfoEnabled()) {
            this.logger_.info("set QoS: StopTimeSupported=" + this.isStopTimeSupported_);
        }
    }

    public void scheduleTimedPullTask(TimerEventSupplier timerEventSupplier) {
        try {
            this.taskProcessor_.scheduleTimedPullTask(timerEventSupplier);
        }
        catch (InterruptedException interruptedException) {
            this.logger_.fatalError("interrupted", interruptedException);
        }
    }

    protected void checkMessageProperties(Message message) {
        if (message.hasStartTime() && !this.isStartTimeSupported_.get()) {
            this.logger_.error("StartTime NOT allowed");
            throw new BAD_QOS("property StartTime is not allowed");
        }
        if (message.hasStopTime() && !this.isStopTimeSupported_.get()) {
            this.logger_.error("StopTime NOT allowed");
            throw new BAD_QOS("property StopTime is not allowed");
        }
    }

    public FilterStage getFirstStage() {
        return this;
    }

    public boolean isTimeOutSupported() {
        return this.isStopTimeSupported_.get();
    }

    public boolean isStartTimeSupported() {
        return this.isStartTimeSupported_.get();
    }

    public final SupplierAdmin MyAdmin() {
        return (SupplierAdmin)this.admin_.activate();
    }

    public final MessageConsumer getMessageConsumer() {
        throw new UnsupportedOperationException();
    }

    public final boolean hasMessageConsumer() {
        return false;
    }

    public void offer_change(EventType[] eventTypeArray, EventType[] eventTypeArray2) throws InvalidEventType {
        this.offerManager_.offer_change(eventTypeArray, eventTypeArray2);
    }

    public EventType[] obtain_subscription_types(ObtainInfoMode obtainInfoMode) {
        EventType[] eventTypeArray = EMPTY_EVENT_TYPE_ARRAY;
        switch (obtainInfoMode.value()) {
            case 1: {
                this.registerListener();
                eventTypeArray = this.subscriptionManager_.obtain_subscription_types();
                break;
            }
            case 0: {
                eventTypeArray = this.subscriptionManager_.obtain_subscription_types();
                this.removeListener();
                break;
            }
            case 3: {
                this.registerListener();
                break;
            }
            case 2: {
                this.removeListener();
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal ObtainInfoMode " + obtainInfoMode.value());
            }
        }
        return eventTypeArray;
    }

    private final void registerListener() {
        NotifySubscribeOperations notifySubscribeOperations;
        if (this.subscriptionListener_ == null && (notifySubscribeOperations = this.getSubscriptionListener()) != null) {
            this.subscriptionListener_ = new NotifySubscribeOperations(this, notifySubscribeOperations){
                private final /* synthetic */ AbstractProxyConsumer this$0;
                private final /* synthetic */ NotifySubscribeOperations val$_listener;

                public final void subscription_change(EventType[] eventTypeArray, EventType[] eventTypeArray2) {
                    try {
                        this.val$_listener.subscription_change(eventTypeArray, eventTypeArray2);
                    }
                    catch (NO_IMPLEMENT nO_IMPLEMENT) {
                        this.this$0.logger_.info("disable subscription_change for Supplier", nO_IMPLEMENT);
                        AbstractProxyConsumer.access$2(this.this$0);
                    }
                    catch (InvalidEventType invalidEventType) {
                        this.this$0.logger_.error("invalid event type", invalidEventType);
                    }
                }
                {
                    this.val$_listener = notifySubscribeOperations;
                    this.this$0 = abstractProxyConsumer;
                    this.constructor$0(abstractProxyConsumer);
                }

                private final void constructor$0(AbstractProxyConsumer abstractProxyConsumer) {
                }
            };
            this.subscriptionManager_.addListener(this.subscriptionListener_);
        }
    }

    private final void removeListener() {
        if (this.subscriptionListener_ != null) {
            this.subscriptionManager_.removeListener(this.subscriptionListener_);
            this.subscriptionListener_ = null;
        }
    }

    abstract NotifySubscribeOperations getSubscriptionListener();

    static AbstractProxy newProxyPushConsumer(AbstractAdmin abstractAdmin, ClientType clientType) {
        AbstractProxyConsumer abstractProxyConsumer;
        switch (clientType.value()) {
            case 0: {
                abstractProxyConsumer = new ProxyPushConsumerImpl(abstractAdmin, abstractAdmin.getChannelContext());
                break;
            }
            case 1: {
                abstractProxyConsumer = new StructuredProxyPushConsumerImpl(abstractAdmin, abstractAdmin.getChannelContext());
                break;
            }
            case 2: {
                abstractProxyConsumer = new SequenceProxyPushConsumerImpl(abstractAdmin, abstractAdmin.getChannelContext());
                break;
            }
            default: {
                throw new BAD_PARAM();
            }
        }
        return abstractProxyConsumer;
    }

    static AbstractProxy newProxyPullConsumer(AbstractAdmin abstractAdmin, ClientType clientType) {
        AbstractProxyConsumer abstractProxyConsumer;
        switch (clientType.value()) {
            case 0: {
                abstractProxyConsumer = new ProxyPullConsumerImpl(abstractAdmin, abstractAdmin.getChannelContext());
                break;
            }
            case 1: {
                abstractProxyConsumer = new StructuredProxyPullConsumerImpl(abstractAdmin, abstractAdmin.getChannelContext());
                break;
            }
            case 2: {
                abstractProxyConsumer = new SequenceProxyPullConsumerImpl(abstractAdmin, abstractAdmin.getChannelContext());
                break;
            }
            default: {
                throw new BAD_PARAM("ClientType: " + clientType.value() + " unknown");
            }
        }
        return abstractProxyConsumer;
    }

    public abstract Object activate();

    static /* synthetic */ void access$0(AbstractProxyConsumer abstractProxyConsumer) {
        abstractProxyConsumer.configureStartTimeSupported();
    }

    static /* synthetic */ void access$1(AbstractProxyConsumer abstractProxyConsumer) {
        abstractProxyConsumer.configureStopTimeSupported();
    }

    static /* synthetic */ void access$2(AbstractProxyConsumer abstractProxyConsumer) {
        abstractProxyConsumer.removeListener();
    }

    AbstractProxyConsumer(AbstractAdmin abstractAdmin, ChannelContext channelContext) {
        super(abstractAdmin, channelContext);
        this.subsequentDestinations_ = CollectionsWrapper.singletonList(this.admin_);
        this.taskProcessor_ = channelContext.getTaskProcessor();
    }
}

