/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.servant;

import java.util.List;
import org.jacorb.notification.ChannelContext;
import org.jacorb.notification.interfaces.Disposable;
import org.jacorb.notification.interfaces.Message;
import org.jacorb.notification.interfaces.MessageConsumer;
import org.jacorb.notification.queue.EventQueue;
import org.jacorb.notification.queue.EventQueueFactory;
import org.jacorb.notification.servant.AbstractAdmin;
import org.jacorb.notification.servant.AbstractProxy;
import org.jacorb.notification.servant.AbstractProxySupplier;
import org.jacorb.notification.servant.PropertySetListener;
import org.jacorb.notification.servant.ProxyPullSupplierImpl;
import org.jacorb.notification.servant.ProxyPushSupplierImpl;
import org.jacorb.notification.servant.SequenceProxyPullSupplierImpl;
import org.jacorb.notification.servant.SequenceProxyPushSupplierImpl;
import org.jacorb.notification.servant.StructuredProxyPullSupplierImpl;
import org.jacorb.notification.servant.StructuredProxyPushSupplierImpl;
import org.jacorb.notification.util.TaskExecutor;
import org.jacorb.util.Environment;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.Object;
import org.omg.CosEventComm.Disconnected;
import org.omg.CosNotification.EventType;
import org.omg.CosNotification.UnsupportedQoS;
import org.omg.CosNotifyChannelAdmin.ClientType;
import org.omg.CosNotifyChannelAdmin.ConsumerAdmin;
import org.omg.CosNotifyChannelAdmin.ConsumerAdminHelper;
import org.omg.CosNotifyChannelAdmin.ObtainInfoMode;
import org.omg.CosNotifyComm.InvalidEventType;
import org.omg.CosNotifyComm.NotifyPublishOperations;
import org.omg.CosNotifyComm.NotifySubscribeOperations;

public abstract class AbstractProxySupplier
extends AbstractProxy
implements MessageConsumer,
NotifySubscribeOperations {
    private static final EventType[] EMPTY_EVENT_TYPE_ARRAY = new EventType[0];
    private TaskExecutor taskExecutor_;
    private Disposable disposeTaskExecutor_;
    private EventQueue pendingMessages_;
    private int errorThreshold_;
    private java.lang.Object pendingMessagesRefLock_ = new java.lang.Object();
    private NotifyPublishOperations offerListener_;
    private PropertySetListener eventQueueConfigurationChangedCB = new 1(this);

    public void preActivate() throws UnsupportedQoS {
        java.lang.Object object = this.pendingMessagesRefLock_;
        synchronized (object) {
            this.pendingMessages_ = EventQueueFactory.newEventQueue(this.qosSettings_);
        }
        this.errorThreshold_ = Environment.getIntPropertyWithDefault("jacorb.notification.consumer.error_threshold", 3);
        if (this.logger_.isInfoEnabled()) {
            this.logger_.info("set Error Threshold to : " + this.errorThreshold_);
        }
        this.qosSettings_.addPropertySetListener(new String[]{"OrderPolicy", "DiscardPolicy"}, this.eventQueueConfigurationChangedCB);
    }

    private final void configureEventQueue() throws UnsupportedQoS {
        EventQueue eventQueue = EventQueueFactory.newEventQueue(this.qosSettings_);
        try {
            java.lang.Object object = this.pendingMessagesRefLock_;
            synchronized (object) {
                if (!this.pendingMessages_.isEmpty()) {
                    Message[] messageArray = this.pendingMessages_.getAllEvents(true);
                    int n = 0;
                    while (n < messageArray.length) {
                        eventQueue.put(messageArray[n]);
                        ++n;
                    }
                }
                this.pendingMessages_ = eventQueue;
            }
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException.getMessage());
        }
    }

    public TaskExecutor getExecutor() {
        return this.taskExecutor_;
    }

    public void setTaskExecutor(TaskExecutor taskExecutor) {
        if (this.taskExecutor_ != null) {
            throw new IllegalArgumentException("set only once");
        }
        this.taskExecutor_ = taskExecutor;
    }

    public void setTaskExecutor(TaskExecutor taskExecutor, Disposable disposable) {
        this.setTaskExecutor(taskExecutor);
        this.disposeTaskExecutor_ = disposable;
    }

    public boolean hasPendingMessages() {
        java.lang.Object object = this.pendingMessagesRefLock_;
        synchronized (object) {
            return !this.pendingMessages_.isEmpty();
        }
    }

    protected void enqueue(Message message) {
        java.lang.Object object = this.pendingMessagesRefLock_;
        synchronized (object) {
            this.pendingMessages_.put(message);
        }
        if (this.logger_.isDebugEnabled()) {
            this.logger_.debug("added " + message + " to pending Messages.");
        }
    }

    protected Message getMessageBlocking() throws InterruptedException {
        java.lang.Object object = this.pendingMessagesRefLock_;
        synchronized (object) {
            return this.pendingMessages_.getEvent(true);
        }
    }

    protected Message getMessageNoBlock() {
        java.lang.Object object = this.pendingMessagesRefLock_;
        synchronized (object) {
            try {
                return this.pendingMessages_.getEvent(false);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return null;
            }
        }
    }

    protected Message[] getAllMessages() {
        java.lang.Object object = this.pendingMessagesRefLock_;
        synchronized (object) {
            try {
                return this.pendingMessages_.getAllEvents(false);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return null;
            }
        }
    }

    protected Message[] getUpToMessages(int n) {
        try {
            java.lang.Object object = this.pendingMessagesRefLock_;
            synchronized (object) {
                return this.pendingMessages_.getEvents(n, false);
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    protected Message[] getAtLeastMessages(int n) {
        try {
            java.lang.Object object = this.pendingMessagesRefLock_;
            synchronized (object) {
                if (this.pendingMessages_.getSize() >= n) {
                    return this.pendingMessages_.getAllEvents(true);
                }
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        return null;
    }

    public int getErrorThreshold() {
        return this.errorThreshold_;
    }

    public final void dispose() {
        super.dispose();
        if (this.disposeTaskExecutor_ != null) {
            this.disposeTaskExecutor_.dispose();
        }
    }

    public final ConsumerAdmin MyAdmin() {
        return ConsumerAdminHelper.narrow(this.admin_.activate());
    }

    public final void subscription_change(EventType[] eventTypeArray, EventType[] eventTypeArray2) throws InvalidEventType {
        this.subscriptionManager_.subscription_change(eventTypeArray, eventTypeArray2);
    }

    public final EventType[] obtain_offered_types(ObtainInfoMode obtainInfoMode) {
        this.logger_.debug("obtain_offered_types " + obtainInfoMode.value());
        EventType[] eventTypeArray = EMPTY_EVENT_TYPE_ARRAY;
        switch (obtainInfoMode.value()) {
            case 1: {
                this.registerListener();
                eventTypeArray = this.offerManager_.obtain_offered_types();
                break;
            }
            case 0: {
                eventTypeArray = this.offerManager_.obtain_offered_types();
                this.removeListener();
                break;
            }
            case 3: {
                this.registerListener();
                break;
            }
            case 2: {
                this.removeListener();
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal ObtainInfoMode");
            }
        }
        return eventTypeArray;
    }

    private final void registerListener() {
        NotifyPublishOperations notifyPublishOperations;
        if (this.offerListener_ == null && (notifyPublishOperations = this.getOfferListener()) != null) {
            this.offerListener_ = new NotifyPublishOperations(this, notifyPublishOperations){
                private final /* synthetic */ AbstractProxySupplier this$0;
                private final /* synthetic */ NotifyPublishOperations val$_listener;

                public final void offer_change(EventType[] eventTypeArray, EventType[] eventTypeArray2) {
                    try {
                        this.val$_listener.offer_change(eventTypeArray, eventTypeArray2);
                    }
                    catch (NO_IMPLEMENT nO_IMPLEMENT) {
                        this.this$0.logger_.info("disable offer_change for Consumer.", nO_IMPLEMENT);
                        AbstractProxySupplier.access$1(this.this$0);
                    }
                    catch (InvalidEventType invalidEventType) {
                        this.this$0.logger_.error("invalid event type", invalidEventType);
                    }
                }
                {
                    this.val$_listener = notifyPublishOperations;
                    this.this$0 = abstractProxySupplier;
                    this.constructor$0(abstractProxySupplier);
                }

                private final void constructor$0(AbstractProxySupplier abstractProxySupplier) {
                }
            };
            this.offerManager_.addListener(this.offerListener_);
        }
    }

    private final void removeListener() {
        if (this.offerListener_ != null) {
            this.offerManager_.removeListener(this.offerListener_);
            this.offerListener_ = null;
        }
    }

    abstract NotifyPublishOperations getOfferListener();

    static AbstractProxySupplier newProxyPullSupplier(AbstractAdmin abstractAdmin, ClientType clientType) {
        AbstractProxySupplier abstractProxySupplier;
        switch (clientType.value()) {
            case 0: {
                abstractProxySupplier = new ProxyPullSupplierImpl(abstractAdmin, abstractAdmin.getChannelContext());
                break;
            }
            case 1: {
                abstractProxySupplier = new StructuredProxyPullSupplierImpl(abstractAdmin, abstractAdmin.getChannelContext());
                break;
            }
            case 2: {
                abstractProxySupplier = new SequenceProxyPullSupplierImpl(abstractAdmin, abstractAdmin.getChannelContext());
                break;
            }
            default: {
                throw new BAD_PARAM();
            }
        }
        return abstractProxySupplier;
    }

    static AbstractProxySupplier newProxyPushSupplier(AbstractAdmin abstractAdmin, ClientType clientType) {
        AbstractProxySupplier abstractProxySupplier;
        switch (clientType.value()) {
            case 0: {
                abstractProxySupplier = new ProxyPushSupplierImpl(abstractAdmin, abstractAdmin.getChannelContext());
                break;
            }
            case 1: {
                abstractProxySupplier = new StructuredProxyPushSupplierImpl(abstractAdmin, abstractAdmin.getChannelContext());
                break;
            }
            case 2: {
                abstractProxySupplier = new SequenceProxyPushSupplierImpl(abstractAdmin, abstractAdmin.getChannelContext());
                break;
            }
            default: {
                throw new BAD_PARAM("The ClientType: " + clientType.value() + " is unknown");
            }
        }
        return abstractProxySupplier;
    }

    public abstract List getSubsequentFilterStages();

    public abstract boolean hasMessageConsumer();

    public abstract MessageConsumer getMessageConsumer();

    public abstract Object activate();

    public abstract void deliverPendingMessages() throws Disconnected;

    public abstract void enableDelivery();

    public abstract void disableDelivery();

    public abstract void deliverMessage(Message var1) throws Disconnected;

    static /* synthetic */ void access$0(AbstractProxySupplier abstractProxySupplier) throws UnsupportedQoS {
        abstractProxySupplier.configureEventQueue();
    }

    static /* synthetic */ void access$1(AbstractProxySupplier abstractProxySupplier) {
        abstractProxySupplier.removeListener();
    }

    protected AbstractProxySupplier(AbstractAdmin abstractAdmin, ChannelContext channelContext) {
        super(abstractAdmin, channelContext);
    }
}

