/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.servant;

import org.jacorb.notification.ChannelContext;
import org.jacorb.notification.engine.TaskProcessor;
import org.jacorb.notification.interfaces.Message;
import org.jacorb.notification.servant.AbstractAdmin;
import org.jacorb.notification.servant.StructuredProxyPushSupplierImpl;
import org.jacorb.util.Environment;
import org.omg.CosEventChannelAdmin.AlreadyConnected;
import org.omg.CosEventChannelAdmin.TypeError;
import org.omg.CosEventComm.Disconnected;
import org.omg.CosNotification.StructuredEvent;
import org.omg.CosNotification.UnsupportedQoS;
import org.omg.CosNotifyChannelAdmin.ConnectionAlreadyActive;
import org.omg.CosNotifyChannelAdmin.ConnectionAlreadyInactive;
import org.omg.CosNotifyChannelAdmin.NotConnected;
import org.omg.CosNotifyChannelAdmin.ProxyType;
import org.omg.CosNotifyChannelAdmin.SequenceProxyPushSupplierOperations;
import org.omg.CosNotifyChannelAdmin.SequenceProxyPushSupplierPOATie;
import org.omg.CosNotifyComm.NotifyPublishHelper;
import org.omg.CosNotifyComm.NotifyPublishOperations;
import org.omg.CosNotifyComm.SequencePushConsumer;
import org.omg.PortableServer.Servant;
import org.omg.TimeBase.TimeTHelper;

public class SequenceProxyPushSupplierImpl
extends StructuredProxyPushSupplierImpl
implements SequenceProxyPushSupplierOperations {
    static final StructuredEvent[] STRUCTURED_EVENT_ARRAY_TEMPLATE = new StructuredEvent[0];
    private SequencePushConsumer sequencePushConsumer_;
    private NotifyPublishOperations offerListener_;
    private int maxBatchSize_;
    private long pacingInterval_;
    private Object taskId_;
    private Runnable timerCallback_;
    final TaskProcessor engine_;

    public void preActivate() throws UnsupportedQoS {
        super.preActivate();
        this.configureMaxBatchSize();
        this.configurePacingInterval();
    }

    public void deliverMessage(Message message) throws Disconnected {
        if (this.logger_.isDebugEnabled()) {
            this.logger_.debug("deliverEvent connected=" + this.isConnected() + " active=" + this.active_ + " enabled=" + this.enabled_);
        }
        if (this.isConnected()) {
            this.enqueue(message);
            if (this.active_ && this.enabled_) {
                this.deliverPendingEvents(false);
            }
        } else {
            this.logger_.debug("Not connected");
        }
    }

    public void deliverPendingMessages() throws Disconnected {
        this.deliverPendingEvents(true);
    }

    private final void deliverPendingEvents(boolean bl) throws Disconnected {
        this.logger_.debug("deliverPendingEvents()");
        Message[] messageArray = bl ? this.getAllMessages() : this.getAtLeastMessages(this.maxBatchSize_);
        if (messageArray != null && messageArray.length != 0) {
            StructuredEvent[] structuredEventArray = new StructuredEvent[messageArray.length];
            int n = 0;
            while (n < messageArray.length) {
                structuredEventArray[n] = messageArray[n].toStructuredEvent();
                messageArray[n].dispose();
                messageArray[n] = null;
                ++n;
            }
            this.sequencePushConsumer_.push_structured_events(structuredEventArray);
        }
    }

    public void connect_sequence_push_consumer(SequencePushConsumer sequencePushConsumer) throws AlreadyConnected, TypeError {
        this.logger_.debug("connect_sequence_push_consumer");
        this.assertNotConnected();
        this.sequencePushConsumer_ = sequencePushConsumer;
        this.connectClient(sequencePushConsumer);
        this.active_ = true;
        try {
            this.offerListener_ = NotifyPublishHelper.narrow(sequencePushConsumer);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.startCronJob();
    }

    public void resume_connection() throws NotConnected, ConnectionAlreadyActive {
        this.assertConnected();
        if (this.active_) {
            throw new ConnectionAlreadyActive();
        }
        try {
            this.deliverPendingMessages();
            this.active_ = true;
            this.startCronJob();
        }
        catch (Disconnected disconnected) {
            this.logger_.error("Illegal State: PushConsumer thinks it is disconnected. SequenceProxyPushSupplier thinks it is connected", disconnected);
            this.dispose();
        }
    }

    public void suspend_connection() throws NotConnected, ConnectionAlreadyInactive {
        super.suspend_connection();
        this.stopCronJob();
    }

    public void disconnect_sequence_push_supplier() {
        this.dispose();
    }

    protected void disconnectClient() {
        this.stopCronJob();
        this.sequencePushConsumer_.disconnect_sequence_push_consumer();
        this.sequencePushConsumer_ = null;
    }

    private final void startCronJob() {
        if (this.pacingInterval_ > 0L) {
            this.taskId_ = this.getTaskProcessor().executeTaskPeriodically(this.pacingInterval_, this.timerCallback_, true);
        }
    }

    private final synchronized void stopCronJob() {
        if (this.taskId_ != null) {
            this.getTaskProcessor().cancelTask(this.taskId_);
            this.taskId_ = null;
        }
    }

    private final boolean configurePacingInterval() {
        long l;
        if (this.qosSettings_.containsKey("PacingInterval") && this.pacingInterval_ != (l = TimeTHelper.extract(this.qosSettings_.get("PacingInterval")))) {
            this.pacingInterval_ = l;
            return true;
        }
        return false;
    }

    private final boolean configureMaxBatchSize() {
        int n = this.qosSettings_.containsKey("MaximumBatchSize") ? this.qosSettings_.get("MaximumBatchSize").extract_long() : Environment.getIntPropertyWithDefault("jacorb.notification.max_batch_size", 1);
        if (this.maxBatchSize_ != n) {
            if (this.logger_.isInfoEnabled()) {
                this.logger_.info("set MaxBatchSize=" + n);
            }
            this.maxBatchSize_ = n;
            return true;
        }
        return false;
    }

    public void enableDelivery() {
        this.enabled_ = true;
    }

    public void disableDelivery() {
        this.enabled_ = false;
    }

    public synchronized Servant getServant() {
        if (this.thisServant_ == null) {
            this.thisServant_ = new SequenceProxyPushSupplierPOATie(this);
        }
        return this.thisServant_;
    }

    NotifyPublishOperations getOfferListener() {
        return this.offerListener_;
    }

    public SequenceProxyPushSupplierImpl(AbstractAdmin abstractAdmin, ChannelContext channelContext) {
        super(abstractAdmin, channelContext);
        this.setProxyType(ProxyType.PUSH_SEQUENCE);
        this.engine_ = channelContext.getTaskProcessor();
        this.timerCallback_ = new Runnable(this){
            private final /* synthetic */ SequenceProxyPushSupplierImpl this$0;

            public final void run() {
                try {
                    this.this$0.engine_.scheduleTimedPushTask(this.this$0);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            {
                this.this$0 = sequenceProxyPushSupplierImpl;
                this.constructor$0(sequenceProxyPushSupplierImpl);
            }

            private final void constructor$0(SequenceProxyPushSupplierImpl sequenceProxyPushSupplierImpl) {
            }
        };
    }
}

