/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.servant;

import EDU.oswego.cs.dl.util.concurrent.Semaphore;
import EDU.oswego.cs.dl.util.concurrent.Sync;
import org.jacorb.notification.ChannelContext;
import org.jacorb.notification.engine.TaskProcessor;
import org.jacorb.notification.interfaces.Message;
import org.jacorb.notification.interfaces.TimerEventSupplier;
import org.jacorb.notification.servant.AbstractAdmin;
import org.jacorb.notification.servant.AbstractProxyConsumer;
import org.jacorb.notification.servant.AbstractProxyConsumerI;
import org.jacorb.util.Environment;
import org.omg.CORBA.BooleanHolder;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.Object;
import org.omg.CosEventChannelAdmin.AlreadyConnected;
import org.omg.CosEventComm.Disconnected;
import org.omg.CosNotification.EventType;
import org.omg.CosNotification.StructuredEvent;
import org.omg.CosNotifyChannelAdmin.ConnectionAlreadyActive;
import org.omg.CosNotifyChannelAdmin.ConnectionAlreadyInactive;
import org.omg.CosNotifyChannelAdmin.NotConnected;
import org.omg.CosNotifyChannelAdmin.ObtainInfoMode;
import org.omg.CosNotifyChannelAdmin.ProxyConsumerHelper;
import org.omg.CosNotifyChannelAdmin.ProxyType;
import org.omg.CosNotifyChannelAdmin.StructuredProxyPullConsumerOperations;
import org.omg.CosNotifyChannelAdmin.StructuredProxyPullConsumerPOATie;
import org.omg.CosNotifyComm.NotifySubscribeHelper;
import org.omg.CosNotifyComm.NotifySubscribeOperations;
import org.omg.CosNotifyComm.StructuredPullSupplier;
import org.omg.PortableServer.Servant;

public class StructuredProxyPullConsumerImpl
extends AbstractProxyConsumer
implements StructuredProxyPullConsumerOperations,
TimerEventSupplier {
    protected Sync pullSync_ = new Semaphore(1L);
    protected long pollInterval_;
    protected boolean active_ = true;
    private StructuredPullSupplier pullSupplier_;
    private NotifySubscribeOperations subscriptionListener_;
    private java.lang.Object taskId_;
    private Runnable runQueueThis_;
    private final TaskProcessor engine_;

    private final void configurePollIntervall() {
        this.pollInterval_ = 1000L;
        if (Environment.getProperty("jacorb.notification.supplier.poll_intervall") != null) {
            try {
                this.pollInterval_ = Long.parseLong(Environment.getProperty("jacorb.notification.supplier.poll_intervall"));
            }
            catch (NumberFormatException numberFormatException) {
                this.logger_.error("Invalid Number Format for Property jacorb.notification.supplier.poll_intervall", numberFormatException);
            }
        }
    }

    public void disconnect_structured_pull_consumer() {
        this.dispose();
    }

    public synchronized void connect_structured_pull_supplier(StructuredPullSupplier structuredPullSupplier) throws AlreadyConnected {
        this.assertNotConnected();
        this.active_ = true;
        this.pullSupplier_ = structuredPullSupplier;
        this.connectClient(structuredPullSupplier);
        try {
            this.subscriptionListener_ = NotifySubscribeHelper.narrow(structuredPullSupplier);
        }
        catch (Throwable throwable) {
            this.logger_.info("disable subscription_change for StructuredPullSupplier");
        }
        this.startTask();
    }

    public synchronized void suspend_connection() throws NotConnected, ConnectionAlreadyInactive {
        this.assertConnected();
        if (!this.active_) {
            throw new ConnectionAlreadyInactive();
        }
        this.active_ = false;
        this.stopTask();
    }

    public synchronized void resume_connection() throws ConnectionAlreadyActive, NotConnected {
        this.assertConnected();
        if (this.active_) {
            throw new ConnectionAlreadyActive();
        }
        this.active_ = true;
        this.startTask();
    }

    public EventType[] obtain_subscription_types(ObtainInfoMode obtainInfoMode) {
        throw new NO_IMPLEMENT();
    }

    public void runPullEvent() throws Disconnected {
        if (!this.isConnected()) {
            return;
        }
        StructuredProxyPullConsumerImpl structuredProxyPullConsumerImpl = this;
        synchronized (structuredProxyPullConsumerImpl) {
            if (!this.active_) {
                return;
            }
        }
        try {
            this.runPullEventInternal();
        }
        catch (InterruptedException interruptedException) {
            this.logger_.error("pull interrupted", interruptedException);
        }
    }

    protected void runPullEventInternal() throws InterruptedException, Disconnected {
        BooleanHolder booleanHolder = new BooleanHolder();
        booleanHolder.value = false;
        StructuredEvent structuredEvent = null;
        try {
            this.pullSync_.acquire();
            structuredEvent = this.pullSupplier_.try_pull_structured_event(booleanHolder);
        }
        finally {
            java.lang.Object var4_3 = null;
            this.pullSync_.release();
        }
        if (booleanHolder.value) {
            Message message = this.messageFactory_.newMessage(structuredEvent, (AbstractProxyConsumerI)this);
            this.getTaskProcessor().processMessage(message);
        }
    }

    protected void disconnectClient() {
        this.stopTask();
        this.pullSupplier_.disconnect_structured_pull_supplier();
        this.pullSupplier_ = null;
    }

    protected void startTask() {
        if (this.taskId_ == null) {
            this.taskId_ = this.getTaskProcessor().executeTaskPeriodically(this.pollInterval_, this.runQueueThis_, true);
        }
    }

    protected void stopTask() {
        if (this.taskId_ != null) {
            this.getTaskProcessor().cancelTask(this.taskId_);
            this.taskId_ = null;
        }
    }

    public synchronized Servant getServant() {
        if (this.thisServant_ == null) {
            this.thisServant_ = new StructuredProxyPullConsumerPOATie(this);
        }
        return this.thisServant_;
    }

    public Object activate() {
        return ProxyConsumerHelper.narrow(this.getServant()._this_object(this.getORB()));
    }

    NotifySubscribeOperations getSubscriptionListener() {
        return this.subscriptionListener_;
    }

    static /* synthetic */ TaskProcessor access$0(StructuredProxyPullConsumerImpl structuredProxyPullConsumerImpl) {
        return structuredProxyPullConsumerImpl.engine_;
    }

    public StructuredProxyPullConsumerImpl(AbstractAdmin abstractAdmin, ChannelContext channelContext) {
        super(abstractAdmin, channelContext);
        this.configurePollIntervall();
        this.setProxyType(ProxyType.PULL_STRUCTURED);
        this.engine_ = channelContext.getTaskProcessor();
        this.runQueueThis_ = new Runnable(this){
            private final /* synthetic */ StructuredProxyPullConsumerImpl this$0;

            public final void run() {
                try {
                    StructuredProxyPullConsumerImpl.access$0(this.this$0).scheduleTimedPullTask(this.this$0);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            {
                this.this$0 = structuredProxyPullConsumerImpl;
                this.constructor$0(structuredProxyPullConsumerImpl);
            }

            private final void constructor$0(StructuredProxyPullConsumerImpl structuredProxyPullConsumerImpl) {
            }
        };
    }
}

