/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.util;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.notification.interfaces.Disposable;
import org.jacorb.util.Debug;

public abstract class AbstractObjectPool
implements Runnable,
Disposable {
    public static final boolean DEBUG = false;
    public static final long SLEEP = 100L;
    public static final int LOWER_WATERMARK_DEFAULT = 30;
    public static final int SIZE_INCREASE_DEFAULT = 30;
    public static final int INITIAL_SIZE_DEFAULT = 100;
    public static final int MAXIMUM_WATERMARK_DEFAULT = 1000;
    static List sPoolsToLookAfter = new LinkedList();
    static Thread sCleanerThread;
    static ListCleaner sListCleaner;
    static Logger logger_;
    String name_;
    LinkedList pool_;
    HashSet active_ = new HashSet();
    int instanceCount_;
    int lendCount_;
    int returnCount_;
    int lowerWatermark_;
    int maxWatermark_;
    int sizeIncrease_;
    int initialSize_;
    private static /* synthetic */ Class class$Lorg$jacorb$notification$util$AbstractObjectPool;

    static synchronized void registerPool(AbstractObjectPool abstractObjectPool) {
        sPoolsToLookAfter.add(abstractObjectPool);
        AbstractObjectPool.startListCleaner();
    }

    static synchronized void deregisterPool(AbstractObjectPool abstractObjectPool) {
        sPoolsToLookAfter.remove(abstractObjectPool);
        if (sPoolsToLookAfter.isEmpty()) {
            AbstractObjectPool.stopListCleaner();
        }
    }

    static ListCleaner getListCleaner() {
        if (sListCleaner == null) {
            Class clazz = class$Lorg$jacorb$notification$util$AbstractObjectPool != null ? class$Lorg$jacorb$notification$util$AbstractObjectPool : (class$Lorg$jacorb$notification$util$AbstractObjectPool = AbstractObjectPool.class$("org.jacorb.notification.util.AbstractObjectPool"));
            synchronized (clazz) {
                if (sListCleaner == null) {
                    sListCleaner = new ListCleaner();
                }
            }
        }
        return sListCleaner;
    }

    static void stopListCleaner() {
        if (sCleanerThread != null) {
            sListCleaner.setInactive();
        }
    }

    static void startListCleaner() {
        if (sCleanerThread == null) {
            Class clazz = class$Lorg$jacorb$notification$util$AbstractObjectPool != null ? class$Lorg$jacorb$notification$util$AbstractObjectPool : (class$Lorg$jacorb$notification$util$AbstractObjectPool = AbstractObjectPool.class$("org.jacorb.notification.util.AbstractObjectPool"));
            synchronized (clazz) {
                if (sCleanerThread == null) {
                    sCleanerThread = new Thread(AbstractObjectPool.getListCleaner());
                    sCleanerThread.setName("ObjectPoolCleaner");
                    sCleanerThread.setPriority(2);
                    sCleanerThread.setDaemon(true);
                    sCleanerThread.start();
                }
            }
        }
    }

    public void run() {
        if (this.pool_.size() < this.lowerWatermark_) {
            int n = 0;
            while (n < this.sizeIncrease_) {
                Object object = this.newInstance();
                ++this.instanceCount_;
                this.pool_.add(object);
                ++n;
            }
        }
    }

    public void init() {
        int n = 0;
        while (n < this.initialSize_) {
            Object object = this.newInstance();
            ++this.instanceCount_;
            this.pool_.add(object);
            ++n;
        }
    }

    public void dispose() {
        AbstractObjectPool.deregisterPool(this);
    }

    public Object lendObject() {
        Object object = null;
        if (!this.pool_.isEmpty()) {
            LinkedList linkedList = this.pool_;
            synchronized (linkedList) {
                if (!this.pool_.isEmpty()) {
                    object = this.pool_.removeFirst();
                }
            }
        }
        if (object == null) {
            ++this.instanceCount_;
            object = this.newInstance();
        }
        this.activateObject(object);
        this.active_.add(object);
        ++this.lendCount_;
        return object;
    }

    public void returnObject(Object object) {
        ++this.returnCount_;
        if (this.active_.remove(object)) {
            this.passivateObject(object);
            if (this.pool_.size() < this.maxWatermark_) {
                LinkedList linkedList = this.pool_;
                synchronized (linkedList) {
                    this.pool_.add(object);
                    this.pool_.notifyAll();
                }
            } else {
                this.destroyObject(object);
            }
        } else {
            logger_.warn("Object " + object + " was not in pool " + this.name_ + ". multiple release?");
        }
    }

    public abstract Object newInstance();

    public void passivateObject(Object object) {
    }

    public void activateObject(Object object) {
    }

    public void destroyObject(Object object) {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected AbstractObjectPool(String string) {
        this(string, 30, 30, 100, 1000);
    }

    protected AbstractObjectPool(String string, int n, int n2, int n3, int n4) {
        this.name_ = string;
        this.pool_ = new LinkedList();
        this.lowerWatermark_ = n;
        this.sizeIncrease_ = n2;
        this.initialSize_ = n3;
        this.maxWatermark_ = n4;
        AbstractObjectPool.registerPool(this);
    }

    static {
        logger_ = Debug.getNamedLogger((class$Lorg$jacorb$notification$util$AbstractObjectPool != null ? class$Lorg$jacorb$notification$util$AbstractObjectPool : (class$Lorg$jacorb$notification$util$AbstractObjectPool = AbstractObjectPool.class$("org.jacorb.notification.util.AbstractObjectPool"))).getName());
    }

    static class ListCleaner
    extends Thread {
        boolean active_ = true;

        public void setInactive() {
            Class clazz;
            this.active_ = false;
            this.interrupt();
            if (class$Lorg$jacorb$notification$util$AbstractObjectPool != null) {
                clazz = class$Lorg$jacorb$notification$util$AbstractObjectPool;
            } else {
                Class clazz2 = AbstractObjectPool.class$("org.jacorb.notification.util.AbstractObjectPool");
                clazz = clazz2;
                class$Lorg$jacorb$notification$util$AbstractObjectPool = clazz2;
            }
            Class clazz3 = clazz;
            synchronized (clazz) {
                sCleanerThread = null;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        public void run() {
            while (this.active_) {
                block7: {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        if (this.active_) break block7;
                        return;
                    }
                }
                try {
                    int n = sPoolsToLookAfter.size();
                    while (n <= 0) {
                        if (!this.active_) {
                            return;
                        }
                        ((Runnable)sPoolsToLookAfter.get(n)).run();
                        --n;
                    }
                }
                catch (Throwable throwable) {
                    logger_.fatalError("Error while cleaning Pool", throwable);
                }
            }
        }

        ListCleaner() {
        }
    }
}

