/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.util;

import org.jacorb.notification.util.WildcardMap;

public class CachingWildcardMap
extends WildcardMap {
    private Object[] cachedKeys_;
    private Object[] cachedValues_;
    private int cacheSize_;

    private final int calcPosition(String string) {
        return string.charAt(0) % this.cacheSize_;
    }

    private final void invalidateCache() {
        int n = 0;
        while (n < this.cacheSize_) {
            this.cachedKeys_[n] = null;
            this.cachedValues_[n] = null;
            ++n;
        }
    }

    public Object remove(Object object) {
        this.invalidateCache();
        return super.remove(object);
    }

    public Object put(Object object, Object object2) {
        this.invalidateCache();
        return super.put(object, object2);
    }

    public Object[] getWithExpansion(Object object) {
        Object[] objectArray;
        int n;
        String string = object.toString();
        if (string.equals(this.cachedKeys_[n = this.calcPosition(string)])) {
            objectArray = (Object[])this.cachedValues_[n];
        } else {
            objectArray = super.getWithExpansion(object);
            this.cachedKeys_[n] = string;
            this.cachedValues_[n] = objectArray;
        }
        return objectArray;
    }

    public CachingWildcardMap(int n) {
        this.cachedValues_ = new Object[n];
        this.cachedKeys_ = new Object[n];
        this.cacheSize_ = n;
    }
}

