/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.util;

import java.util.ArrayList;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.notification.util.PatternWrapper;
import org.jacorb.notification.util.WCEntry;
import org.jacorb.notification.util.WildcardMap;
import org.jacorb.util.Debug;

class EntryList {
    static Logger logger_ = Debug.getNamedLogger((class$Lorg$jacorb$notification$util$EntryList != null ? class$Lorg$jacorb$notification$util$EntryList : (class$Lorg$jacorb$notification$util$EntryList = EntryList.class$("org.jacorb.notification.util.EntryList"))).getName());
    static int DEFAULT_INITIAL_SIZE = 2;
    PatternWrapper myPattern_;
    char[] key_;
    int start_;
    int end_;
    int depth_;
    int splitted = 0;
    WCEntry myEntry_;
    EntryList[] entries_;
    private static /* synthetic */ Class class$Lorg$jacorb$notification$util$EntryList;

    boolean hasEntry() {
        return this.myEntry_ != null;
    }

    void clear() {
        this.entries_ = new EntryList[DEFAULT_INITIAL_SIZE];
    }

    Object put(WCEntry wCEntry) {
        char c = wCEntry.key_[0];
        this.ensureIndexIsAvailable(c);
        int n = this.computeHashIndex(c);
        if (this.entries_[n] == null) {
            this.entries_[n] = new EntryList(wCEntry.key_, 0, wCEntry.key_.length, 0, wCEntry);
            return null;
        }
        return this.entries_[n].put(wCEntry.key_, 0, wCEntry.key_.length, 0, wCEntry, false);
    }

    Object put(char[] cArray, int n, int n2, int n3, WCEntry wCEntry, boolean bl) {
        if (logger_.isDebugEnabled()) {
            logger_.debug("put(" + new String(cArray, n, n2 - n) + ", " + n3 + ", " + wCEntry + ")");
        }
        int n4 = n2 - n;
        int n5 = this.end_ - this.start_;
        int n6 = this.findCommonPrefix(cArray, n, n2);
        if (logger_.isDebugEnabled()) {
            logger_.debug("common Prefix Length: " + n6);
            logger_.debug("common Prefix is: " + new String(cArray, n, n6));
        }
        if (n6 == n4) {
            logger_.debug("prefixLength == insertKeyLength");
            if (this.endsWithStar()) {
                EntryList.splitEntryList(this, n6);
            }
            Object object = null;
            if (this.myEntry_ != null) {
                object = this.myEntry_.getValue();
            }
            this.myEntry_ = wCEntry;
            return object;
        }
        if (n6 < n5) {
            EntryList.splitEntryList(this, n6);
            boolean bl2 = false;
            if (this.endsWithStar()) {
                bl2 = true;
            }
            this.put(cArray, n, n2, n3 + n6, wCEntry, bl2);
        } else {
            char c = cArray[n + n6];
            this.ensureIndexIsAvailable(c);
            int n7 = this.computeHashIndex(c);
            if (this.entries_[n7] == null) {
                this.entries_[n7] = new EntryList(cArray, n + n6, n2, this.depth_ + n6, wCEntry);
                if (bl) {
                    this.entries_[n7].addLeadingStar();
                }
            } else {
                this.entries_[n7].put(cArray, n + n6, n2, n3 + n6, wCEntry, false);
            }
        }
        return null;
    }

    Object getSingle(char[] cArray, int n, int n2) {
        Object var4_4 = null;
        EntryList entryList = this.lookup(cArray[n]);
        int n3 = n;
        while (entryList != null) {
            int n4 = entryList.end_ - entryList.start_;
            int n5 = n2 - n3;
            int n6 = entryList.compare(cArray, n + entryList.depth_, n + entryList.depth_ + n5, false);
            if (n6 == n5) {
                return entryList.myEntry_.getValue();
            }
            if (n6 <= 0) continue;
            char c = cArray[n + entryList.depth_ + n6];
            int n7 = entryList.depth_;
            if ((entryList = entryList.lookup(c)) == null) continue;
            n3 += entryList.depth_ - n7;
        }
        return null;
    }

    boolean endsWithStar() {
        return this.key_[this.end_ - 1] == '*';
    }

    Object[] getMultiple(char[] cArray, int n, int n2) {
        ArrayList<Cursor> arrayList = new ArrayList<Cursor>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        EntryList entryList = this.lookup(cArray[n]);
        if (entryList != null) {
            if (logger_.isDebugEnabled()) {
                logger_.debug("outgoing edge with label: '" + cArray[n] + "'");
            }
            arrayList.add(new Cursor(n, entryList));
        }
        if ((entryList = this.lookup('*')) != null) {
            logger_.debug("outgoing edge with label: '*'");
            Cursor cursor = new Cursor(n, entryList);
            arrayList.add(cursor);
        }
        while (!arrayList.isEmpty()) {
            int n3;
            Cursor cursor = (Cursor)arrayList.get(0);
            int n4 = cursor.list_.end_ - cursor.list_.start_;
            int n5 = n2 - cursor.cursor_;
            int n6 = cursor.list_.compare(cArray, n + cursor.list_.depth_, n + cursor.list_.depth_ + n5, true);
            if (logger_.isDebugEnabled()) {
                logger_.debug("could match " + n6 + " chars");
            }
            if (n6 >= n5) {
                logger_.debug("matched >= remainingKey");
                if (cursor.list_.hasEntry()) {
                    arrayList2.add(cursor.list_.myEntry_.getValue());
                }
                if (n5 > 0 && cursor.list_.endsWithStar()) {
                    logger_.debug("ends with *");
                    n3 = 0;
                    while (n3 < cursor.list_.entries_.length) {
                        if (cursor.list_.entries_[n3] != null) {
                            arrayList.add(new Cursor(cursor.list_.depth_ + 1, cursor.list_.entries_[n3]));
                        }
                        ++n3;
                    }
                }
                if (cursor.list_.lookup('*') != null) {
                    logger_.debug("lookup(*) != null");
                    cursor.list_ = cursor.list_.lookup('*');
                    cursor.cursor_ += n6;
                    continue;
                }
                logger_.debug("remove cursor");
                arrayList.remove(0);
                continue;
            }
            if (n6 > 0) {
                n3 = cArray[n + cursor.list_.depth_ + n6];
                int n7 = cursor.list_.depth_;
                if (cursor.list_.lookup('*') != null) {
                    EntryList entryList2 = cursor.list_.lookup('*');
                    arrayList.add(new Cursor(cursor.cursor_ + entryList2.depth_ - n7, entryList2));
                }
                if ((cursor.list_ = cursor.list_.lookup((char)n3)) != null) {
                    cursor.cursor_ += cursor.list_.depth_ - n7;
                    continue;
                }
                arrayList.remove(0);
                continue;
            }
            arrayList.remove(0);
        }
        return arrayList2.toArray();
    }

    Object remove(char[] cArray, int n, int n2) {
        return EntryList.remove(this, cArray, n, n2);
    }

    static Object remove(EntryList entryList, char[] cArray, int n, int n2) {
        int n3;
        char c;
        int n4 = n;
        EntryList entryList2 = entryList;
        do {
            if ((n4 += (n3 = EntryList.findCommonPrefix(cArray, n4, n2, entryList2.key_, entryList2.start_, entryList2.end_))) != n2) continue;
            Object object = null;
            if (entryList2.myEntry_ != null) {
                object = entryList2.myEntry_.getValue();
                entryList2.myEntry_ = null;
            }
            return object;
        } while ((entryList2 = entryList2.lookup(c = cArray[n + n3])) != null);
        return null;
    }

    void addLeadingStar() {
        if (logger_.isDebugEnabled()) {
            logger_.debug("old Key: " + new String(this.key_, this.start_, this.end_ - this.start_));
        }
        int n = this.end_ - this.start_ + 1;
        char[] cArray = new char[n];
        System.arraycopy(this.key_, this.start_, cArray, 1, this.end_ - this.start_);
        cArray[0] = 42;
        if (logger_.isDebugEnabled()) {
            logger_.debug("new Pattern: " + new String(cArray, 0, n));
        }
        this.initPattern(cArray, 0, n);
    }

    private final void initPattern() {
        this.initPattern(this.key_, this.start_, this.end_);
    }

    private final void initPattern(char[] cArray, int n, int n2) {
        this.myPattern_ = null;
        int n3 = WildcardMap.countStarsInKey(cArray, n, n2);
        if (n3 > 0) {
            char[] cArray2 = new char[n2 - n + n3 + 1];
            cArray2[0] = 94;
            int n4 = 0;
            int n5 = 1;
            while (n4 < n2 - n) {
                char c;
                cArray2[n4 + n5] = c = cArray[n + n4];
                if (cArray2[n4 + n5] == '*') {
                    cArray2[n4 + n5] = 46;
                    cArray2[n4 + n5 + 1] = 42;
                    ++n5;
                }
                ++n4;
            }
            String string = new String(cArray2, 0, n2 - n + n3 + 1);
            this.myPattern_ = PatternWrapper.init(string);
        }
    }

    private final char key() {
        return this.key_[this.start_];
    }

    private final int keyLength() {
        return this.end_ - this.start_;
    }

    private final EntryList lookup(char c) {
        int n = this.computeHashIndex(c);
        if (this.entries_[n] != null && this.entries_[n].key() == c) {
            return this.entries_[n];
        }
        return null;
    }

    private final void ensureIndexIsAvailable(char c) {
        int n = this.computeHashIndex(c);
        while (this.entries_[n] != null && this.entries_[n].key() != c) {
            this.doubleCapacity();
            n = this.computeHashIndex(c);
        }
        return;
    }

    private final void doubleCapacity() {
        int n = this.entries_.length * 2;
        EntryList[] entryListArray = new EntryList[n];
        int n2 = 0;
        while (n2 < this.entries_.length) {
            if (this.entries_[n2] != null) {
                int n3 = EntryList.computeHashIndex(this.entries_[n2].key(), n);
                entryListArray[n3] = this.entries_[n2];
            }
            ++n2;
        }
        this.entries_ = entryListArray;
    }

    private final int compare(char[] cArray, int n, int n2, boolean bl) {
        if (bl && this.myPattern_ != null) {
            return EntryList.compareKeyToPattern(cArray, n, n2, this.myPattern_);
        }
        return EntryList.compareKeyToKey(cArray, n, n2, this.key_, this.start_, this.end_);
    }

    private final int findCommonPrefix(char[] cArray, int n, int n2) {
        return EntryList.findCommonPrefix(cArray, n, n2, this.key_, this.start_, this.end_);
    }

    private final void printToStringBuffer(StringBuffer stringBuffer, String string) {
        if (this.key_ != null) {
            stringBuffer.append(" --");
            stringBuffer.append(this.key());
            stringBuffer.append("-->\n");
            stringBuffer.append(string);
            stringBuffer.append("depth: ");
            stringBuffer.append(this.depth_);
            stringBuffer.append("\n");
            stringBuffer.append(string);
            stringBuffer.append("key: ");
            stringBuffer.append(new String(this.key_, this.start_, this.end_ - this.start_));
            stringBuffer.append("\n");
        }
        if (this.myEntry_ != null) {
            stringBuffer.append(string + this.myEntry_);
            stringBuffer.append("\n");
        }
        int n = 0;
        while (n < this.entries_.length) {
            stringBuffer.append(string + n);
            stringBuffer.append(":");
            if (this.entries_[n] == null) {
                stringBuffer.append("empty");
            } else {
                this.entries_[n].printToStringBuffer(stringBuffer, string + "   ");
            }
            stringBuffer.append("\n");
            ++n;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        this.printToStringBuffer(stringBuffer, "");
        return stringBuffer.toString();
    }

    private static final void splitEntryList(EntryList entryList, int n) {
        EntryList entryList2 = new EntryList(entryList.key_, entryList.start_ + n, entryList.end_, entryList.depth_ + n, entryList.myEntry_, entryList.entries_.length);
        System.arraycopy(entryList.entries_, 0, entryList2.entries_, 0, entryList.entries_.length);
        entryList.entries_ = new EntryList[DEFAULT_INITIAL_SIZE];
        char c = entryList.key_[entryList.start_ + n];
        int n2 = EntryList.computeHashIndex(c, entryList.entries_.length);
        entryList.entries_[n2] = entryList2;
        entryList.myEntry_ = null;
        ++entryList.splitted;
        entryList.end_ = entryList.start_ + n;
        if (entryList.endsWithStar()) {
            if (logger_.isDebugEnabled()) {
                logger_.debug("ends with star: " + entryList.endsWithStar());
            }
            entryList2.addLeadingStar();
        }
        entryList.initPattern();
    }

    private static final int computeHashIndex(char c, int n) {
        return c % n;
    }

    private final int computeHashIndex(char c) {
        return EntryList.computeHashIndex(c, this.entries_.length);
    }

    static int compareKeyToKey(char[] cArray, int n, int n2, char[] cArray2, int n3, int n4) {
        int n5;
        int n6;
        if (logger_.isDebugEnabled()) {
            logger_.debug("compare(" + new String(cArray, n, n2 - n) + " == " + new String(cArray2, n3, n4 - n3) + ")");
        }
        int n7 = (n6 = n2 - n) > (n5 = n4 - n3) ? n5 : n6;
        int n8 = 0;
        while (n8 < n7) {
            if (cArray[n + n8] != cArray2[n3 + n8]) {
                return n8;
            }
            ++n8;
        }
        return n8;
    }

    static int compareKeyToPattern(char[] cArray, int n, int n2, PatternWrapper patternWrapper) {
        if (logger_.isDebugEnabled()) {
            logger_.debug("compare '" + new String(cArray, n, n2 - n) + "' == '" + patternWrapper + "'");
        }
        String string = new String(cArray, n, n2 - n);
        return patternWrapper.match(string);
    }

    private static final int findCommonPrefix(char[] cArray, int n, int n2, char[] cArray2, int n3, int n4) {
        int n5 = 0;
        int n6 = n2 - n;
        int n7 = n4 - n3;
        int n8 = n6 >= n7 ? n7 : n6;
        while (n5 < n8 && cArray[n] == cArray2[n3]) {
            ++n;
            ++n3;
            ++n5;
        }
        return n5;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    EntryList() {
        this(null, 0, 0, 0, null, DEFAULT_INITIAL_SIZE);
    }

    EntryList(int n) {
        this(null, 0, 0, 0, null, n);
    }

    EntryList(char[] cArray) {
        this(cArray, 0, 0, 0, null, DEFAULT_INITIAL_SIZE);
    }

    EntryList(char[] cArray, int n, int n2, int n3) {
        this(cArray, n, n2, n3, null, DEFAULT_INITIAL_SIZE);
    }

    EntryList(char[] cArray, int n, int n2, int n3, WCEntry wCEntry) {
        this(cArray, n, n2, n3, wCEntry, DEFAULT_INITIAL_SIZE);
    }

    EntryList(char[] cArray, int n, int n2, int n3, WCEntry wCEntry, int n4) {
        this.myEntry_ = wCEntry;
        this.key_ = cArray;
        this.end_ = n2;
        this.start_ = n;
        this.depth_ = n3;
        this.entries_ = new EntryList[n4];
        this.initPattern(this.key_, this.start_, this.end_);
    }

    private static class Cursor {
        int cursor_;
        EntryList list_;

        public String toString() {
            String string = new String(this.list_.key_, this.cursor_, this.list_.end_ - this.cursor_);
            return "Cursor: " + string;
        }

        Cursor(int n, EntryList entryList) {
            this.cursor_ = n;
            this.list_ = entryList;
        }
    }
}

