/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.util;

import org.apache.avalon.framework.logger.Logger;
import org.jacorb.util.Debug;
import org.jacorb.util.Environment;

public abstract class PatternWrapper {
    static final RuntimeException REGEXP_NOT_AVAILABLE = new RuntimeException("Neither java.util.regex.Pattern nor gnu.regexp available. The package java.util.regex is part of the JDK since v1.4 if you are running an older JDK you'll have to install gnu.regexp to run this NotificationService. Please refer to the documentation for details.");
    static Logger sLogger_ = Debug.getNamedLogger((class$Lorg$jacorb$notification$util$PatternWrapper != null ? class$Lorg$jacorb$notification$util$PatternWrapper : (class$Lorg$jacorb$notification$util$PatternWrapper = PatternWrapper.class$("org.jacorb.notification.util.PatternWrapper"))).getName());
    static boolean sGnuRegexpAvailable = false;
    static Class sDefaultInstance;
    private static /* synthetic */ Class class$Lorg$jacorb$notification$util$PatternWrapper;

    static PatternWrapper init(String string) {
        try {
            PatternWrapper patternWrapper = (PatternWrapper)sDefaultInstance.newInstance();
            patternWrapper.compile(string);
            return patternWrapper;
        }
        catch (Exception exception) {
            if (sDefaultInstance == null) {
                throw REGEXP_NOT_AVAILABLE;
            }
            sLogger_.error("Init of PatternWrapper failed: ", exception);
            throw new RuntimeException(exception.getMessage());
        }
    }

    public abstract void compile(String var1);

    public abstract int match(String var1);

    private static final boolean isClassAvailable(String string) {
        try {
            Environment.classForName(string);
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        if (PatternWrapper.isClassAvailable("java.util.regex.Pattern")) {
            try {
                sDefaultInstance = Environment.classForName("org.jacorb.notification.util.JDK14PatternWrapper");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new RuntimeException(classNotFoundException.getMessage());
            }
        } else if (PatternWrapper.isClassAvailable("gnu.regexp.RE")) {
            try {
                sDefaultInstance = Environment.classForName("org.jacorb.notification.util.GNUPatternWrapper");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new RuntimeException(classNotFoundException.getMessage());
            }
        } else {
            throw REGEXP_NOT_AVAILABLE;
        }
    }
}

