/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.util;

import EDU.oswego.cs.dl.util.concurrent.Channel;
import EDU.oswego.cs.dl.util.concurrent.DirectExecutor;
import EDU.oswego.cs.dl.util.concurrent.Executor;
import EDU.oswego.cs.dl.util.concurrent.LinkedQueue;
import EDU.oswego.cs.dl.util.concurrent.PooledExecutor;
import EDU.oswego.cs.dl.util.concurrent.ThreadFactory;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.notification.interfaces.Disposable;
import org.jacorb.util.Debug;

public class TaskExecutor
implements Executor,
Disposable {
    private static TaskExecutor DIRECT_EXECUTOR = new TaskExecutor("Direct", 0);
    private Logger logger_ = Debug.getNamedLogger(this.getClass().getName());
    private Executor executor_;
    private LinkedQueue channel_;

    public static TaskExecutor getDefaultExecutor() {
        return DIRECT_EXECUTOR;
    }

    public boolean isTaskQueued() {
        if (this.channel_ != null) {
            return !this.channel_.isEmpty();
        }
        return false;
    }

    public void dispose() {
        if (this.executor_ instanceof PooledExecutor) {
            ((PooledExecutor)this.executor_).shutdownNow();
            ((PooledExecutor)this.executor_).interruptAll();
        }
    }

    public void execute(Runnable runnable) throws InterruptedException {
        this.executor_.execute(runnable);
    }

    public TaskExecutor(String string, int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            this.executor_ = new DirectExecutor();
            if (this.logger_.isInfoEnabled()) {
                this.logger_.info("Created ThreadPool " + string + ": DirectExecutor");
            }
        } else {
            ThreadFactory threadFactory = new ThreadFactory(this, string){
                private int counter_;
                private final /* synthetic */ TaskExecutor this$0;
                private final /* synthetic */ String val$name;

                public final synchronized Thread newThread(Runnable runnable) {
                    Thread thread = new Thread(runnable);
                    thread.setDaemon(true);
                    thread.setName(this.val$name + "#" + this.counter_++);
                    return thread;
                }
                {
                    this.val$name = string;
                    this.this$0 = taskExecutor;
                    this.counter_ = 0;
                    this.constructor$0(taskExecutor);
                }

                private final void constructor$0(TaskExecutor taskExecutor) {
                }
            };
            this.channel_ = new LinkedQueue();
            PooledExecutor pooledExecutor = new PooledExecutor((Channel)this.channel_);
            pooledExecutor.setThreadFactory(threadFactory);
            pooledExecutor.setKeepAliveTime(-1L);
            pooledExecutor.createThreads(n);
            this.executor_ = pooledExecutor;
            if (this.logger_.isInfoEnabled()) {
                this.logger_.info("Created ThreadPool " + string + ": Threads=" + n);
            }
        }
    }
}

